/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FinalizationSupport {
    private static List references = new ArrayList(11);
    private static ReferenceQueue queue = new ReferenceQueue();

    public static FinalizableWeakReference addReference(Object referent) {
        return FinalizationSupport.addReference(referent, new Finalizable[0]);
    }

    public static FinalizableWeakReference addReference(Object referent, Finalizable[] finalizables) {
        FinalizableWeakReference reference = new FinalizableWeakReference(referent, finalizables, queue);
        List list = references;
        synchronized (list) {
            references.add(reference);
        }
        return reference;
    }

    public static void addFinalizable(Object referent, Finalizable finalizable) {
        FinalizableWeakReference ref = FinalizationSupport.getReference(referent);
        if (ref != null) {
            ref.addFinalizableToReference(finalizable);
        }
    }

    public static void doFinalization() {
        Reference ref = null;
        while ((ref = queue.poll()) != null) {
            ((FinalizableWeakReference)ref).doFinalization();
            List list = references;
            synchronized (list) {
                references.remove(ref);
            }
        }
    }

    private static FinalizableWeakReference getReference(Object referent) {
        FinalizableWeakReference ref = null;
        List list = references;
        synchronized (list) {
            Iterator it = references.iterator();
            while (it.hasNext()) {
                ref = (FinalizableWeakReference)it.next();
                if (referent.equals(ref.get())) break;
                ref = null;
            }
        }
        return ref;
    }

    private static class FinalizableWeakReference
    extends WeakReference {
        private List tobeFinalized = new ArrayList(2);

        public FinalizableWeakReference(Object referent, Finalizable[] finalizable, ReferenceQueue queue) {
            super(referent, queue);
            this.tobeFinalized.addAll(Arrays.asList(finalizable));
        }

        private void addFinalizableToReference(Finalizable finalizable) {
            this.tobeFinalized.add(finalizable);
        }

        private void doFinalization() {
            Iterator it = this.tobeFinalized.iterator();
            while (it.hasNext()) {
                ((Finalizable)it.next()).onFinalize();
            }
        }
    }

    public static interface Finalizable {
        public void onFinalize();
    }
}

