/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.soap.util;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.Text;

public final class SAAJUtils {
    private static SOAPFactory soapFactory;
    public static Name XSI_TYPE;

    public static final SOAPFactory getSOAPFactory() {
        return soapFactory;
    }

    public static final SOAPElement getFaultCodeElement(SOAPFault fault) {
        Iterator childElements = fault.getChildElements();
        while (childElements.hasNext()) {
            Object o = childElements.next();
            if (!(o instanceof SOAPElement)) continue;
            return (SOAPElement)o;
        }
        throw new RuntimeException("Fault code element not found in fault:" + fault);
    }

    public static final String getElementContent(SOAPElement element) {
        if (element == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator it = element.getChildElements();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Text)) break;
            Text text = (Text)o;
            result.append(text.getValue());
        }
        return result.toString();
    }

    public static final SOAPElement getChildElement(SOAPElement element, Name name) {
        if (element == null || name == null) {
            return null;
        }
        Iterator it = element.getChildElements(name);
        if (!it.hasNext()) {
            return null;
        }
        return (SOAPElement)it.next();
    }

    public static final QName stringToQName(SOAPElement element, String qName) {
        if (qName == null || qName.length() == 0) {
            return null;
        }
        if (qName.charAt(0) == '{') {
            return QName.valueOf(qName);
        }
        int p = qName.indexOf(58);
        String prefix = null;
        String localName = qName.substring(p + 1);
        if (p > 0) {
            prefix = qName.substring(0, p);
        }
        String namespaceURI = element.getNamespaceURI(prefix);
        if (prefix != null && prefix.length() > 0 && namespaceURI == null) {
            throw new RuntimeException("Unable to parse QName(" + qName + ") in element " + element.getElementName().getLocalName() + ". Unknown namespace for prefix: " + prefix);
        }
        return new QName(namespaceURI, localName);
    }

    public static final String qNameToString(SOAPElement element, QName qName) throws SOAPException {
        if (qName == null) {
            return null;
        }
        int i = 0;
        while (element.getNamespaceURI("f" + i) != null) {
            ++i;
        }
        String prefix = "f" + i;
        element.addNamespaceDeclaration(prefix, qName.getNamespaceURI());
        return prefix + ":" + qName.getLocalPart();
    }

    public static int removeAllChildren(SOAPElement nodeEl) {
        int result = 0;
        Iterator it = nodeEl.getChildElements();
        while (it.hasNext()) {
            ++result;
            Node n = (Node)it.next();
            n.detachNode();
            n.recycleNode();
        }
        return result;
    }

    public static QName getXSIType(SOAPElement firstChild) {
        String xsiTypeString = firstChild.getAttributeValue(XSI_TYPE);
        return SAAJUtils.stringToQName(firstChild, xsiTypeString);
    }

    static {
        try {
            soapFactory = SOAPFactory.newInstance();
            XSI_TYPE = soapFactory.createName("http://www.w3.org/2001/XMLSchema-instance", null, "type");
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }
}

