/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.soap;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.transport.InputMessage;
import org.systinet.wasp.soap.MimeHeadersSource;

public class MimeHeadersSourceImpl
implements MimeHeadersSource {
    private InputMessage message;
    private Map headers = new HashMap();
    private boolean headersRead;
    private String contentType;

    public void init(InputMessage message, boolean multipart) throws IOException {
        this.message = message;
        if (multipart) {
            Set headerNames = message.getHeaderNames();
            if (headerNames != null) {
                Iterator i = headerNames.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    this.headers.put(name.toLowerCase(), message.getStringHeader(name));
                }
            }
            this.contentType = message.getContentType();
            if (this.contentType == null) {
                this.contentType = "";
            }
            this.headers.put(MimeHeadersSource.CONTENT_TYPE_HEADER_LC, this.contentType);
            this.headersRead = true;
        } else {
            this.contentType = message.getContentType();
            this.headersRead = false;
        }
    }

    public String getMimeHeader(String name) throws IOException {
        if (this.headersRead) {
            return (String)this.headers.get(name.toLowerCase());
        }
        return this.message.getStringHeader(name);
    }

    public Set getHeaderNames() throws IOException {
        if (this.headersRead) {
            return this.headers.keySet();
        }
        return this.message.getHeaderNames();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void clear() {
        this.message = null;
        this.headers.clear();
    }
}

