/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.soap;

import com.systinet.wasp.soap.ProtocolDetector;
import java.io.IOException;
import java.util.HashMap;
import org.idoox.transport.InputMessage;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerWrapper;
import org.systinet.wasp.webservice.Current;

public class GETProtocolDetector
implements ProtocolDetector {
    private Tokenizer tokenizer;

    public boolean canHandle(Tokenizer tokenizer, InputMessage inputMessage) throws TokenizerException, IOException {
        if (Current.getCallContext() == null) {
            return false;
        }
        if ("httpget".equals(Current.getCallContext().getContextData().get("wasp.xml.protocol"))) {
            boolean fault = inputMessage.getStatusCode() == 500;
            this.tokenizer = fault ? new EnvBodyInsertingTokenizer(new FaultInsertingTokenizer(tokenizer)) : new EnvBodyInsertingTokenizer(tokenizer);
            return true;
        }
        return false;
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public static class FaultInsertingTokenizer
    extends TokenizerWrapper {
        private boolean faultInserted = false;
        private boolean faultCodeInserted = false;
        private boolean faultCodeContentInserted = false;
        private boolean faultStringInserted = false;
        private boolean faultStringContentInserted = false;
        private boolean detailInserted = false;
        private boolean endFault = false;
        private boolean endFaultCode = false;
        private boolean endFaultString = false;
        private boolean endDocument = false;
        private boolean skipNext = true;

        public FaultInsertingTokenizer(Tokenizer tokenizer) {
            super(tokenizer);
            Token token = new Token();
            token.type = 0;
            this.setCurrentToken(token);
        }

        public byte next() throws TokenizerException, IOException {
            byte next;
            if (!this.faultInserted) {
                this.faultInserted = true;
                Token token = new Token();
                token.type = (byte)2;
                token.localName = "Fault";
                token.prefix = "e";
                token.uri = "http://systinet.com/wasp/protocol/get";
                this.setCurrentToken(token);
                return token.type;
            }
            if (!this.faultCodeInserted) {
                this.faultCodeInserted = true;
                Token token = new Token();
                token.type = (byte)2;
                token.localName = "faultcode";
                token.uri = "";
                this.setCurrentToken(token);
                return token.type;
            }
            if (!this.faultCodeContentInserted) {
                this.faultCodeContentInserted = true;
                this.endFaultCode = true;
                this.setCurrentContent("e:Server");
                return 4;
            }
            if (this.endFaultCode) {
                this.endFaultCode = false;
                Token token = new Token();
                token.type = (byte)3;
                token.localName = "faultcode";
                token.uri = "";
                this.setCurrentToken(token);
                return token.type;
            }
            if (!this.faultStringInserted) {
                this.faultStringInserted = true;
                Token token = new Token();
                token.type = (byte)2;
                token.localName = "faultstring";
                token.uri = "";
                this.setCurrentToken(token);
                return token.type;
            }
            if (!this.faultStringContentInserted) {
                this.faultStringContentInserted = true;
                this.endFaultString = true;
                this.setCurrentContent("Server Error");
                return 4;
            }
            if (this.endFaultString) {
                this.endFaultString = false;
                Token token = new Token();
                token.type = (byte)3;
                token.localName = "faultstring";
                token.uri = "";
                this.setCurrentToken(token);
                return token.type;
            }
            if (!this.detailInserted) {
                this.detailInserted = true;
                Token token = new Token();
                token.type = (byte)2;
                token.localName = "detail";
                token.uri = "";
                this.setCurrentToken(token);
                return token.type;
            }
            if (this.endFault) {
                this.endFault = false;
                this.endDocument = true;
                Token token = new Token();
                token.type = (byte)3;
                token.localName = "Fault";
                token.prefix = "e";
                token.uri = "http://systinet.com/wasp/protocol/get";
                this.setCurrentToken(token);
                return token.type;
            }
            if (this.endDocument) {
                Token token = new Token();
                token.type = 1;
                this.setCurrentToken(token);
                return token.type;
            }
            if (this.skipNext) {
                this.skipNext = false;
                this.setCurrentState(null);
                next = this.getTokenizer().currentState();
            } else {
                next = super.next();
            }
            switch (next) {
                case 1: {
                    this.endFault = true;
                    Token token = new Token();
                    token.type = (byte)3;
                    token.localName = "detail";
                    token.uri = "";
                    this.setCurrentToken(token);
                    next = token.type;
                }
            }
            return next;
        }
    }

    public static class EnvBodyInsertingTokenizer
    extends TokenizerWrapper {
        private boolean envelopeInserted = false;
        private boolean bodyInserted = false;
        private boolean endEnvelope = false;
        private boolean endDocument = false;
        private boolean skipNext = true;

        public EnvBodyInsertingTokenizer(Tokenizer tokenizer) {
            super(tokenizer);
            Token token = new Token();
            token.type = 0;
            this.setCurrentToken(token);
        }

        public byte next() throws TokenizerException, IOException {
            byte next;
            if (!this.envelopeInserted) {
                this.envelopeInserted = true;
                Token token = new Token();
                token.type = (byte)2;
                token.localName = "Envelope";
                token.prefix = "e";
                token.uri = "http://systinet.com/wasp/protocol/get";
                HashMap<String, String> prefixMap = new HashMap<String, String>();
                prefixMap.put("e", "http://systinet.com/wasp/protocol/get");
                this.setCurrentToken(token, prefixMap, new String[]{"e"});
                return token.type;
            }
            if (!this.bodyInserted) {
                this.bodyInserted = true;
                Token token = new Token();
                token.type = (byte)2;
                token.localName = "Body";
                token.prefix = "e";
                token.uri = "http://systinet.com/wasp/protocol/get";
                this.setCurrentToken(token);
                return token.type;
            }
            if (this.endEnvelope) {
                this.endEnvelope = false;
                this.endDocument = true;
                Token token = new Token();
                token.type = (byte)3;
                token.localName = "Envelope";
                token.prefix = "e";
                token.uri = "http://systinet.com/wasp/protocol/get";
                this.setCurrentToken(token);
                return token.type;
            }
            if (this.endDocument) {
                this.endDocument = false;
                Token token = new Token();
                token.type = 1;
                this.setCurrentToken(token);
                return token.type;
            }
            if (this.skipNext) {
                this.skipNext = false;
                this.setCurrentState(null);
                next = this.getTokenizer().currentState();
            } else {
                next = super.next();
            }
            switch (next) {
                case 1: {
                    this.endEnvelope = true;
                    Token token = new Token();
                    token.type = (byte)3;
                    token.localName = "Body";
                    token.prefix = "e";
                    token.uri = "http://systinet.com/wasp/protocol/get";
                    this.setCurrentToken(token);
                    next = token.type;
                    break;
                }
            }
            return next;
        }
    }
}

