/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.soap;

import com.idoox.transport.util.Headers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;
import org.idoox.transport.RawInputMessage;

public class GETInputMessageWrapper
extends InputMessageWrapper {
    private int originalStatus;

    public GETInputMessageWrapper(InputMessage message) throws IOException {
        super(message);
        this.originalStatus = message.getStatusCode();
        this.init(message);
    }

    private void init(InputMessage message) throws IOException {
        String multipartType = message.getMultipartType();
        if (multipartType != null) {
            HashMap<String, String> mainHeaders = new HashMap<String, String>();
            Set header = message.getHeaderNames();
            Iterator iterator = header.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String value = message.getStringHeader(name);
                mainHeaders.put(name.toLowerCase(), value);
            }
            message.nextPart();
            String contentType = message.getContentType();
            if (contentType.startsWith("text/xml")) {
                this.setWrappedMessage(new FirstNextSkippingInputMessageWrapper(mainHeaders, multipartType, message));
            } else {
                this.setWrappedMessage(new PushXmlPartInputMessageWrapper(mainHeaders, multipartType, new FakeXmlPartInputMessage(new ByteArrayInputStream(new byte[0])), message));
            }
        } else {
            String contentType = message.getContentType();
            if (contentType != null) {
                if (contentType.startsWith("text/xml")) {
                    this.setWrappedMessage(message);
                } else {
                    this.setWrappedMessage(new MultipartInputMessageWrapper(new FakeXmlPartInputMessage(new ByteArrayInputStream(new byte[0])), message));
                }
            } else {
                this.setWrappedMessage(new FakeXmlPartInputMessage(new ByteArrayInputStream(new byte[0])));
            }
        }
    }

    private class PushXmlPartInputMessageWrapper
    extends FirstNextSkippingInputMessageWrapper {
        InputMessage originalMultipartMessage;

        public PushXmlPartInputMessageWrapper(Map mainHeaders, String multipartType, InputMessage xmlPart, InputMessage originalMultipartMessage) {
            super(mainHeaders, multipartType, xmlPart);
            this.originalMultipartMessage = originalMultipartMessage;
        }

        public boolean nextPart() throws IOException {
            if (this.actualPart == 0) {
                ++this.actualPart;
                return true;
            }
            if (this.actualPart == 1) {
                ++this.actualPart;
                this.setWrappedMessage(this.originalMultipartMessage);
                return true;
            }
            return super.nextPart();
        }
    }

    private class FirstNextSkippingInputMessageWrapper
    extends InputMessageWrapper {
        protected Headers headers;
        protected String multipartType;
        protected int actualPart = 0;

        public FirstNextSkippingInputMessageWrapper(Map mainHeaders, String multipartType, InputMessage message) {
            super(message);
            this.headers = new Headers(mainHeaders);
            this.multipartType = multipartType;
        }

        public Set getHeaderNames() throws IOException {
            if (this.actualPart == 0) {
                return this.headers.getNames();
            }
            return super.getHeaderNames();
        }

        public String getStringHeader(String name) throws IOException {
            if (this.actualPart == 0) {
                return this.headers.get(name);
            }
            return super.getStringHeader(name);
        }

        public int getIntHeader(String name) throws IOException {
            String value = this.getStringHeader(name);
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }

        public long getDateHeader(String name) throws IOException {
            return Headers.parseDate(this.getStringHeader(name));
        }

        public String getContentType() throws IOException {
            return this.getStringHeader("Content-type");
        }

        public String getMultipartType() throws IOException {
            return this.multipartType;
        }

        public boolean nextPart() throws IOException {
            if (this.actualPart == 0) {
                ++this.actualPart;
                return true;
            }
            return super.nextPart();
        }
    }

    private class MultipartInputMessageWrapper
    extends InputMessageWrapper {
        private InputMessage incomingMessage;
        private int actualPart = 0;

        public MultipartInputMessageWrapper(InputMessage xmlPart, InputMessage incomingMessage) {
            super(xmlPart);
            this.incomingMessage = incomingMessage;
        }

        public String getMultipartType() throws IOException {
            return "multipart/related";
        }

        public int getStatusCode() throws IOException {
            if (this.actualPart == 0) {
                return GETInputMessageWrapper.this.originalStatus;
            }
            return super.getStatusCode();
        }

        public Set getHeaderNames() throws IOException {
            if (this.actualPart == 0) {
                HashSet<String> headers = new HashSet<String>();
                headers.add("Content-type");
                return headers;
            }
            return super.getHeaderNames();
        }

        public String getStringHeader(String name) throws IOException {
            if (this.actualPart == 0) {
                if ("content-type".equalsIgnoreCase(name)) {
                    return "multipart/related";
                }
            } else {
                return super.getStringHeader(name);
            }
            return null;
        }

        public String getContentType() throws IOException {
            return this.getStringHeader("Content-type");
        }

        public boolean nextPart() throws IOException {
            ++this.actualPart;
            if (this.actualPart == 1) {
                return true;
            }
            if (this.actualPart == 2) {
                this.setWrappedMessage(this.incomingMessage);
                return true;
            }
            return false;
        }
    }

    private class FakeXmlPartInputMessage
    extends RawInputMessage {
        public FakeXmlPartInputMessage(InputStream stream) {
            super(stream);
        }

        public int getStatusCode() throws IOException {
            return GETInputMessageWrapper.this.originalStatus;
        }

        public Set getHeaderNames() throws IOException {
            HashSet<String> headers = new HashSet<String>();
            headers.add("content-type");
            return headers;
        }

        public String getStringHeader(String name) throws IOException {
            if ("content-type".equalsIgnoreCase(name)) {
                return "text/xml";
            }
            return null;
        }
    }
}

