/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.sequence;

import com.idoox.debug.Category;
import com.idoox.util.UUID;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.systinet.msgstore.MsgSequence;
import com.systinet.msgstore.MsgStoreException;
import com.systinet.msgstore.MsgStoreTx;
import com.systinet.wasp.sequence.SequenceImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.idoox.config.Configurable;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.InstanceNotFoundException;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.ISequenceRegistry;
import org.systinet.wasp.sequence.Provider;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.sequence.SequenceListener;
import org.systinet.wasp.webservice.IServiceEndpointListener;
import org.systinet.wasp.webservice.Processing;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpoint;

public class SequenceRegistryImpl
implements Module,
ISequenceRegistry,
IServiceEndpointListener {
    protected static final Category log = Category.getCategory((class$com$systinet$wasp$sequence$SequenceRegistryImpl == null ? (class$com$systinet$wasp$sequence$SequenceRegistryImpl = SequenceRegistryImpl.class$("com.systinet.wasp.sequence.SequenceRegistryImpl")) : class$com$systinet$wasp$sequence$SequenceRegistryImpl).getName());
    static final int OUTPUT = 0;
    static final int INPUT = 1;
    Map[] idToSequences = new Map[]{new HashMap(), new HashMap()};
    Map[] processingToSequences = new Map[]{new HashMap(), new HashMap()};
    Object[] locks = new Object[]{this.idToSequences[0], this.idToSequences[0]};
    Map providers = new HashMap();
    Map sequenceListeners = new WeakHashMap();
    MsgStoreTx msgStore;
    private boolean msgStoreObtained = false;
    Timer timer;
    Map expirationTasks = new HashMap();
    boolean lazyEndpointInitDone = false;
    private static final ISequence[] NO_ISEQUENCE = new ISequence[0];
    static /* synthetic */ Class class$com$systinet$wasp$sequence$SequenceRegistryImpl;

    public void load(Configurable config) throws WaspInternalException {
        InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.sequence.ISequenceRegistry", this);
    }

    public void init() throws WaspInternalException {
        this.timer = (Timer)Context.getInstance("java.util.Timer");
        Registry.addListener(this);
    }

    public void destroy() {
        Registry.removeListener(this);
        int j = 0;
        while (j < this.idToSequences.length) {
            Object object = this.locks[j];
            synchronized (object) {
                ArrayList sequencesToDestroy = new ArrayList(this.idToSequences[j].values());
                Iterator i = sequencesToDestroy.iterator();
                while (i.hasNext()) {
                    ((ISequence)i.next()).destroy();
                }
            }
            ++j;
        }
        this.providers.clear();
        this.msgStoreObtained = false;
    }

    public ISequence createSequence(String prefix, boolean generateSuffix, Processing processing, boolean output) {
        String generatedID;
        ISequence existingSequence;
        if (this.providers.size() == 0) {
            throw new IllegalStateException("No Sequence API provider installed, can not create sequence!");
        }
        if (!generateSuffix && (existingSequence = this.getSequence(prefix, false, processing, output)) != null) {
            throw new IllegalStateException("Can not create sequence which already exists (id = " + existingSequence.getID() + ")");
        }
        this.obtainMsgStoreImplementation();
        if (generateSuffix) {
            String suffix = UUID.uuidgen();
            generatedID = prefix == null ? suffix : prefix + suffix;
        } else {
            generatedID = prefix;
        }
        SequenceImpl sequence = new SequenceImpl(generatedID, processing, output, this, this.msgStore);
        Object object = sequence.getListenersLock();
        synchronized (object) {
            this.registerSequence(sequence, processing, output);
            Map map = this.sequenceListeners;
            synchronized (map) {
                List listeners = this.getListenersForProcessing(processing);
                if (listeners != null) {
                    Iterator i = listeners.iterator();
                    while (i.hasNext()) {
                        ((SequenceListener)i.next()).onCreate(sequence);
                    }
                }
            }
        }
        sequence.setActive(true);
        return sequence;
    }

    public ISequence loadSequence(String id, boolean matchPrefix, Processing processing, boolean output) throws SequenceException {
        if (this.providers.size() == 0) {
            throw new IllegalStateException("No Sequence API provider installed, can not load sequence!");
        }
        this.obtainMsgStoreImplementation();
        if (this.msgStore == null) {
            return null;
        }
        this.lazyEndpointInit();
        ISequence loadedSequence = null;
        if (id != null) {
            id = SequenceImpl.createPersistentNamePrefix(processing, output) + id;
            if (matchPrefix) {
                MsgSequence[] sequences;
                try {
                    sequences = this.msgStore.findSequences(id);
                }
                catch (MsgStoreException e) {
                    throw new RuntimeWrappedException("Error loading persistent " + (output ? "out" : "in") + "put sequence (prefix = " + id + ")", e);
                }
                int i = 0;
                while (i < sequences.length) {
                    ISequence sequence = this.loadOneSequence(sequences[i].getName(), processing, output);
                    if (!(sequence == null || loadedSequence != null || output && sequence.getState() != Sequence.State.OPEN && sequence.getState() != Sequence.State.DELIVERED)) {
                        loadedSequence = sequence;
                    }
                    ++i;
                }
            } else {
                ISequence sequence = this.loadOneSequence(id, processing, output);
                if (!(sequence == null || output && sequence.getState() != Sequence.State.OPEN && sequence.getState() != Sequence.State.DELIVERED)) {
                    loadedSequence = sequence;
                }
            }
        }
        return loadedSequence;
    }

    public ISequence getSequence(String id, boolean matchPrefix, Processing processing, boolean output) {
        Object object;
        int direction;
        this.lazyEndpointInit();
        ISequence sequence = null;
        int n = direction = output ? 0 : 1;
        if (!matchPrefix) {
            object = this.locks[direction];
            synchronized (object) {
                sequence = (ISequence)this.idToSequences[direction].get(id);
            }
        }
        object = this.locks[direction];
        synchronized (object) {
            List sequences = (List)this.processingToSequences[direction].get(processing);
            if (sequences != null) {
                Iterator i = sequences.iterator();
                while (i.hasNext()) {
                    ISequence s = (ISequence)i.next();
                    if (!s.getID().startsWith(id)) continue;
                    sequence = s;
                    break;
                }
            }
        }
        if (sequence != null) {
            object = ((SequenceImpl)sequence).getListenersLock();
            synchronized (object) {
            }
        }
        return sequence;
    }

    public ISequence[] loadOutputSequences(String prefix, Processing processing) throws SequenceException {
        this.lazyEndpointInit();
        return this.loadSequences(prefix, processing, true);
    }

    public ISequence[] getOutputSequences(String prefix, Processing processing) {
        this.lazyEndpointInit();
        return this.getSequences(prefix, processing, true);
    }

    public void addProvider(String providerName, Provider listener) {
        this.providers.put(providerName, listener);
        this.lazyEndpointInit();
    }

    public void removeProvider(String providerName) {
        this.providers.remove(providerName);
    }

    public void addSequenceListener(SequenceListener listener, Processing processing) {
        Map map = this.sequenceListeners;
        synchronized (map) {
            SequenceRegistryImpl.addToMapOfListsOnce(processing, listener, this.sequenceListeners);
        }
    }

    public void removeSequenceListener(SequenceListener listener, Processing processing) {
        Map map = this.sequenceListeners;
        synchronized (map) {
            List listeners = (List)this.sequenceListeners.get(processing);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.sequenceListeners.remove(processing);
                }
            }
        }
    }

    public void onPublish(ServiceEndpoint serviceEndpoint) throws PublishException {
    }

    public void onPublishDone(ServiceEndpoint serviceEndpoint) {
        SequenceRegistryImpl sequenceRegistryImpl = this;
        synchronized (sequenceRegistryImpl) {
            if (!this.lazyEndpointInitDone) {
                return;
            }
        }
        try {
            this.loadSequences("", serviceEndpoint, false);
            this.loadSequences("", serviceEndpoint, true);
        }
        catch (RuntimeException e) {
            log.error("Error loading persistent sequences for service endpoint on path " + serviceEndpoint.getPath(), e);
        }
    }

    public void onUnpublish(ServiceEndpoint serviceEndpoint) throws PublishException {
        int direction = 0;
        while (direction < 2) {
            ISequence[] sequences = this.getSequences(null, serviceEndpoint, direction != 0);
            int i = 0;
            while (i < sequences.length) {
                sequences[i].destroy();
                ++i;
            }
            ++direction;
        }
    }

    void onActivation(ISequence sequence) {
        int direction = sequence.isOutput() ? 0 : 1;
        Object object = this.locks[direction];
        synchronized (object) {
            Processing processing = sequence.getProcessing();
            List sequences = (List)this.processingToSequences[direction].get(processing);
            Iterator i = sequences.iterator();
            while (i.hasNext()) {
                Sequence s = (Sequence)i.next();
                if (s == sequence) continue;
                s.setActive(false);
            }
        }
    }

    public void onStore(ISequence sequence) {
        Provider provider = (Provider)this.providers.get(sequence.getProviderName());
        if (provider != null) {
            provider.onStore(sequence);
        }
    }

    void onDestroy(ISequence sequence) {
        TimerTask expirationTask;
        Provider provider = (Provider)this.providers.get(sequence.getProviderName());
        if (provider != null) {
            provider.onDestroy(sequence);
        }
        if ((expirationTask = (TimerTask)this.expirationTasks.remove(this)) != null) {
            expirationTask.cancel();
        }
        int direction = sequence.isOutput() ? 0 : 1;
        Object object = this.locks[direction];
        synchronized (object) {
            ((List)this.processingToSequences[direction].get(sequence.getProcessing())).remove(sequence);
            this.idToSequences[direction].remove(sequence.getID());
        }
    }

    void onMessageConfirmation(ISequence sequence, long messageNumber) {
        Provider provider = (Provider)this.providers.get(sequence.getProviderName());
        if (provider != null) {
            provider.onMessageConfirmation(sequence, messageNumber);
        }
    }

    void onSetState(ISequence sequence, Sequence.State previousState, SequenceException exception) {
        Map map = this.sequenceListeners;
        synchronized (map) {
            List listeners = this.getListenersForProcessing(sequence.getProcessing());
            if (listeners != null) {
                int stateValue = sequence.getState().getValue();
                Iterator i = listeners.iterator();
                block8: while (i.hasNext()) {
                    SequenceListener sequenceListener = (SequenceListener)i.next();
                    switch (stateValue) {
                        case 3: {
                            sequenceListener.onBroken(exception, previousState);
                            break;
                        }
                        case 2: {
                            sequenceListener.onComplete(sequence, previousState);
                            break;
                        }
                        case 1: {
                            sequenceListener.onDelivered(sequence, previousState);
                            break;
                        }
                        default: {
                            break block8;
                        }
                    }
                }
            }
        }
    }

    private List getListenersForProcessing(Processing processing) {
        ServiceEndpointImpl se;
        if (processing != null && processing instanceof ServiceEndpointImpl && (se = (ServiceEndpointImpl)processing).getType() == 1) {
            processing = (ServiceClient)se.getContext().getContextData().get("async.client");
        }
        return (List)this.sequenceListeners.get(processing);
    }

    void onSetExpires(ISequence sequence) {
        Date date = sequence.getExpires();
        TimerTask task = (TimerTask)this.expirationTasks.remove(sequence);
        if (task != null) {
            task.cancel();
        }
        if (date != null) {
            task = new SequenceExpirationTask(sequence);
            this.expirationTasks.put(sequence, task);
            this.timer.schedule(task, date);
        }
    }

    Provider getProvider(String providerName) {
        return (Provider)this.providers.get(providerName);
    }

    private ISequence[] loadSequences(String prefix, Processing processing, boolean output) {
        MsgSequence[] sequences;
        this.obtainMsgStoreImplementation();
        if (this.msgStore == null) {
            return null;
        }
        try {
            sequences = this.msgStore.findSequences(SequenceImpl.createPersistentNamePrefix(processing, output) + prefix);
        }
        catch (MsgStoreException e) {
            throw new RuntimeWrappedException("Error loading " + (output ? "out" : "in") + "put sequences (prefix = " + prefix + ")", e);
        }
        if (sequences.length == 0) {
            return NO_ISEQUENCE;
        }
        ArrayList<ISequence> loadedSequences = new ArrayList<ISequence>(sequences.length);
        int i = 0;
        while (i < sequences.length) {
            ISequence sequence = this.loadOneSequence(sequences[i].getName(), processing, output);
            if (sequence != null && (sequence.getState() == Sequence.State.OPEN || sequence.getState() == Sequence.State.DELIVERED)) {
                loadedSequences.add(sequence);
            }
            ++i;
        }
        return loadedSequences.toArray(NO_ISEQUENCE);
    }

    private ISequence loadOneSequence(String persistentName, Processing processing, boolean output) {
        SequenceImpl sequence = new SequenceImpl(null, processing, output, this, this.msgStore);
        if (!sequence.load(persistentName)) {
            return null;
        }
        this.registerSequence(sequence, processing, output);
        Provider provider = this.getProvider(sequence.getProviderName());
        if (provider != null) {
            provider.onLoad(sequence);
        }
        this.onSetExpires(sequence);
        return sequence;
    }

    private void registerSequence(SequenceImpl sequence, Processing processing, boolean output) {
        int direction = output ? 0 : 1;
        Object object = this.locks[direction];
        synchronized (object) {
            SequenceRegistryImpl.addToMapOfLists(processing, sequence, this.processingToSequences[direction]);
            this.idToSequences[direction].put(sequence.getID(), sequence);
        }
    }

    private static void addToMapOfLists(Object key, Object value, Map map) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            map.put(key, list);
        }
        list.add(value);
    }

    private static void addToMapOfListsOnce(Object key, Object value, Map map) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            map.put(key, list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    private ISequence[] getSequences(String prefix, Processing processing, boolean output) {
        ArrayList sequences;
        int direction = output ? 0 : 1;
        Object object = this.locks[direction];
        synchronized (object) {
            sequences = (ArrayList)this.processingToSequences[direction].get(processing);
        }
        if (sequences == null || sequences.size() == 0) {
            return NO_ISEQUENCE;
        }
        if (prefix == null) {
            return sequences.toArray(NO_ISEQUENCE);
        }
        ArrayList<Sequence> matchingSequences = new ArrayList<Sequence>(sequences.size());
        Iterator i = ((AbstractList)sequences).iterator();
        while (i.hasNext()) {
            Sequence sequence = (Sequence)i.next();
            if (!sequence.getID().startsWith(prefix)) continue;
            matchingSequences.add(sequence);
        }
        return matchingSequences.toArray(NO_ISEQUENCE);
    }

    private void obtainMsgStoreImplementation() {
        if (!this.msgStoreObtained) {
            try {
                this.msgStore = (MsgStoreTx)Context.getInstance("msg.store");
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
            this.msgStoreObtained = true;
        }
    }

    private synchronized void lazyEndpointInit() {
        if (!this.lazyEndpointInitDone) {
            this.lazyEndpointInitDone = true;
            ServiceEndpoint[] endpoints = Registry.getServiceEndpoints();
            int i = 0;
            while (i < endpoints.length) {
                this.onPublishDone(endpoints[i]);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SequenceExpirationTask
    extends TimerTask {
        ISequence sequence;

        public SequenceExpirationTask(ISequence sequence) {
            this.sequence = sequence;
        }

        public void run() {
            try {
                this.sequence.expire();
            }
            catch (Exception e) {
                log.error("Error expiring sequence", e);
            }
        }
    }
}

