/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.sequence;

import com.idoox.debug.Category;
import com.systinet.msgstore.MsgRecord;
import com.systinet.msgstore.MsgRecordTx;
import com.systinet.msgstore.MsgSequenceTx;
import com.systinet.msgstore.MsgSerializer;
import com.systinet.msgstore.MsgStoreException;
import com.systinet.msgstore.MsgStoreTransaction;
import com.systinet.msgstore.MsgStoreTx;
import com.systinet.wasp.sequence.SequenceRegistryImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.idoox.util.LongSet;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.Provider;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Processing;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointReference;

public class SequenceImpl
extends ISequence {
    protected static final Category log = Category.getCategory((class$com$systinet$wasp$sequence$SequenceImpl == null ? (class$com$systinet$wasp$sequence$SequenceImpl = SequenceImpl.class$("com.systinet.wasp.sequence.SequenceImpl")) : class$com$systinet$wasp$sequence$SequenceImpl).getName());
    static final int UNKNOWN = -1;
    private String providerName;
    private Processing processing;
    private Serializable providerData;
    private Sequence.State state;
    private String id;
    private boolean active = false;
    private boolean expired = false;
    private Date expires = null;
    private long length = -1L;
    private long currentLength = 0L;
    private InheritableThreadLocal currentMessageNumber = new InheritableThreadLocal();
    private boolean lastMessage;
    private long lastDeliveredrMessageNumber = 0L;
    private Map undeliveredMessageRecords;
    private LongSet deliveredMessageNumbers;
    private LongSet allMessageNumbers;
    SequenceRegistryImpl registry;
    boolean output = false;
    private boolean explicitConfirmation = false;
    private boolean persistent;
    private MsgStoreTx msgStore;
    private MsgSequenceTx msgSequence;
    private Object transactionLock = new Object();
    private MsgStoreTransaction currentTransaction;
    private List messageRecordsToStore = new ArrayList(16);
    static final String OUT_PREFIX = "-O-";
    static final String IN_PREFIX = "-I-";
    static /* synthetic */ Class class$com$systinet$wasp$sequence$SequenceImpl;

    public SequenceImpl(String id, Processing processing, boolean output, SequenceRegistryImpl registry, MsgStoreTx msgStore) {
        this.processing = processing;
        this.output = output;
        this.registry = registry;
        this.undeliveredMessageRecords = new HashMap();
        this.deliveredMessageNumbers = new LongSet();
        this.allMessageNumbers = new LongSet();
        this.msgStore = msgStore;
        this.id = id;
        this.state = output ? Sequence.State.DELIVERED : Sequence.State.OPEN;
        this.persistent = msgStore != null;
    }

    public boolean load(String persistentName) {
        block7: {
            SequenceMsgSerializer msgSerializer = new SequenceMsgSerializer();
            try {
                this.msgSequence = (MsgSequenceTx)this.msgStore.getSequence(persistentName, msgSerializer);
                if (this.msgSequence != null) {
                    msgSerializer.setSequence(this);
                    Serializable sequenceState = (Serializable)this.msgSequence.loadData();
                    this.restoreState(sequenceState);
                    if (this.providerName != null) {
                        Provider provider = this.registry.getProvider(this.providerName);
                        if (provider == null) {
                            throw new RuntimeException("Trying to load sequence for non-existent provider " + this.providerName + " (persistent name = " + persistentName + ")");
                        }
                        msgSerializer.setProvider(provider);
                        Iterator i = this.msgSequence.getMessages();
                        while (i.hasNext()) {
                            MsgRecordTx msgRecord = (MsgRecordTx)i.next();
                            MessageRecordImpl messageRecord = (MessageRecordImpl)msgRecord.loadData();
                            messageRecord.metadata = (Metadata)msgRecord.loadMetadata();
                            this.addMessageRecord(messageRecord);
                        }
                        break block7;
                    }
                    throw new RuntimeException("Can not load sequence with unknown provider name (persistent name = " + persistentName + ")");
                }
                return false;
            }
            catch (MsgStoreException e) {
                throw new RuntimeWrappedException("Error loading sequence with persistent name " + persistentName, e);
            }
            catch (IOException e) {
                throw new RuntimeWrappedException("Error loading sequence with persistent name " + persistentName, e);
            }
        }
        return true;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public Serializable getProviderData() {
        return this.providerData;
    }

    public void setProviderData(Serializable providerData) {
        this.providerData = providerData;
    }

    public long getLastDeliveredMessageNumber() {
        return this.lastDeliveredrMessageNumber;
    }

    public void setLastDeliveredMessageNumber(long messageNumber) {
        this.lastDeliveredrMessageNumber = messageNumber;
    }

    public ISequence.MessageRecord createMessageRecord() {
        return new MessageRecordImpl();
    }

    public void addMessageRecord(ISequence.MessageRecord messageRecord) {
        long messageNumber = messageRecord.getMessageNumber();
        SequenceImpl sequenceImpl = this;
        synchronized (sequenceImpl) {
            if (messageNumber > this.currentLength) {
                this.currentLength = messageNumber;
            }
            this.allMessageNumbers.add(messageNumber);
            if (messageRecord.isDelivered()) {
                this.deliveredMessageNumbers.add(messageNumber);
            } else {
                this.undeliveredMessageRecords.put(new Long(messageNumber), messageRecord);
            }
        }
    }

    public Iterator getUndeliveredMessageRecords() {
        return this.undeliveredMessageRecords.values().iterator();
    }

    public LongSet getMessageNumbers() {
        return this.allMessageNumbers;
    }

    public Sequence.State getState() {
        return this.state;
    }

    public void setState(Sequence.State state) {
        this.setState(state, null);
    }

    private void setState(Sequence.State state, SequenceException exception) {
        SequenceImpl sequenceImpl = this;
        synchronized (sequenceImpl) {
            if (state != this.state) {
                Sequence.State previousState = this.state;
                this.state = state;
                switch (state.getValue()) {
                    case 2: {
                        if (this.persistent) {
                            try {
                                if (this.undeliveredMessageRecords.size() != 0) {
                                    throw new IllegalStateException("Sequence with " + this.undeliveredMessageRecords.size() + " undelivered messages can not get to COMPLETE state!");
                                }
                                Iterator iterator = this.undeliveredMessageRecords.values().iterator();
                                while (iterator.hasNext()) {
                                    MsgRecordTx msgRecord = ((MessageRecordImpl)iterator.next()).msgRecord;
                                    if (msgRecord == null) continue;
                                    msgRecord.destroyTx(this.currentTransaction);
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeWrappedException("Error removing persistent message records from complete sequence " + this, e);
                            }
                        }
                        this.undeliveredMessageRecords.clear();
                    }
                }
                this.registry.onSetState(this, previousState, exception);
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void setActive(boolean active) {
        Map contextData;
        if (active) {
            this.registry.onActivation(this);
        }
        this.active = active;
        if (this.processing instanceof ServiceClient) {
            contextData = ((ServiceClient)this.processing).getContext().getContextData();
        } else {
            CallContext callContext = Current.getCallContext();
            if (callContext == null) {
                return;
            }
            contextData = callContext.getContextData();
        }
        if (this.output) {
            ISequence.setActiveOutputSequence(active ? this : null, contextData);
        } else if (active) {
            contextData.put("sequence.input", this);
        } else {
            contextData.remove("sequence.input");
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        if (this.persistent != persistent) {
            this.persistent = persistent;
            if (persistent) {
                if (this.msgStore == null) {
                    throw new RuntimeException("Persistent store unavailable, can not use persistent sequences!");
                }
            } else {
                this.removeFromMsgStore();
            }
        }
    }

    public void abort() {
        SequenceException exception = new SequenceException("Sequence aborted.", (Sequence)this);
        this.abort(exception);
    }

    public void abort(SequenceException exception) {
        this.setState(Sequence.State.BROKEN, exception);
    }

    public void destroy() {
        SequenceImpl sequenceImpl = this;
        synchronized (sequenceImpl) {
            if (this.getState() != Sequence.State.DESTROYED) {
                this.registry.onDestroy(this);
                this.setActive(false);
                this.setState(Sequence.State.DESTROYED);
            }
        }
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        if (this.expired) {
            throw new IllegalStateException("Can not change expiration date on already expired sequence!");
        }
        if (this.state == Sequence.State.BROKEN || this.state == Sequence.State.DESTROYED) {
            throw new IllegalStateException("Can not change expiration date on " + this.state + " sequence!");
        }
        this.expires = expires;
        this.registry.onSetExpires(this);
    }

    public void expire() {
        SequenceImpl sequenceImpl = this;
        synchronized (sequenceImpl) {
            this.expired = true;
            if (this.state == Sequence.State.OPEN || this.state == Sequence.State.DELIVERED) {
                this.abort(new SequenceException("Sequence expired in " + this.state + " state.", (Sequence)this));
            }
            this.removeFromMsgStore();
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public long getLength() {
        return this.length;
    }

    public long getCurrentLength() {
        return this.currentLength;
    }

    public void setLength(long length) {
        if (this.length != -1L && this.length != length) {
            throw new IllegalStateException("Can not change sequence length from " + this.length + " to " + length);
        }
        this.length = length;
    }

    public void setLastMessage() {
        this.lastMessage = true;
    }

    public boolean isLastMessage() {
        return this.lastMessage;
    }

    public Sequence.MessageState getMessageState(long messageNumber) {
        if (this.state == Sequence.State.COMPLETE) {
            return messageNumber >= 1L && messageNumber <= this.length ? Sequence.MessageState.DELIVERED : Sequence.MessageState.NOT_PRESENT;
        }
        if (this.deliveredMessageNumbers.contains(messageNumber)) {
            return Sequence.MessageState.DELIVERED;
        }
        if (this.undeliveredMessageRecords.containsKey(new Long(messageNumber))) {
            return Sequence.MessageState.NOT_DELIVERED;
        }
        return Sequence.MessageState.NOT_PRESENT;
    }

    private ISequence.MessageRecord getMessageRecord(long messageNumber) {
        SequenceImpl sequenceImpl = this;
        synchronized (sequenceImpl) {
            ISequence.MessageRecord messageRecord = (ISequence.MessageRecord)this.undeliveredMessageRecords.get(new Long(messageNumber));
            return messageRecord;
        }
    }

    public boolean isOutput() {
        return this.output;
    }

    public long getCurrentMessageNumber() {
        Long value = (Long)this.currentMessageNumber.get();
        return value == null ? -1L : value;
    }

    public void setCurrentMessageNumber(long currentMessageNumber) {
        Long value = (Long)this.currentMessageNumber.get();
        if (value == null || value != currentMessageNumber) {
            this.currentMessageNumber.set(new Long(currentMessageNumber));
        }
    }

    public void setExplicitConfirmation(boolean explicitConfirmation) {
        if (this.output && explicitConfirmation) {
            throw new IllegalStateException("Can not enable explicit confirmation on output sequence!");
        }
        this.explicitConfirmation = explicitConfirmation;
    }

    public boolean isExplicitConfirmation() {
        return this.explicitConfirmation;
    }

    public void confirmMessage(long messageNumber) throws IllegalStateException {
        if (this.output) {
            throw new IllegalStateException("Can not confirm message in output sequence!");
        }
        SequenceImpl sequenceImpl = this;
        synchronized (sequenceImpl) {
            if (this.state == Sequence.State.COMPLETE) {
                if (this.getMessageState(messageNumber) != Sequence.MessageState.NOT_PRESENT) {
                    return;
                }
            } else {
                ISequence.MessageRecord messageRecord = this.getMessageRecord(messageNumber);
                if (messageRecord != null) {
                    if (!messageRecord.isDelivered()) {
                        messageRecord.setDelivered(true);
                        boolean delivered = false;
                        if (this.state != Sequence.State.COMPLETE && this.state != Sequence.State.BROKEN && this.undeliveredMessageRecords.size() == 0) {
                            delivered = true;
                        }
                        this.registry.onMessageConfirmation(this, messageNumber);
                        if (delivered) {
                            if (this.length == -1L) {
                                this.setState(Sequence.State.DELIVERED);
                            } else {
                                this.setState(Sequence.State.COMPLETE);
                            }
                        }
                    }
                    return;
                }
            }
        }
        throw new IllegalStateException("Message not present! (" + this + ", messageNumber " + messageNumber + ")");
    }

    public void confirmCurrentMessage() throws IllegalStateException {
        this.confirmMessage(this.getCurrentMessageNumber());
    }

    public void beginTransaction() {
        if (this.persistent) {
            Object object = this.transactionLock;
            synchronized (object) {
                if (this.currentTransaction != null) {
                    this.currentTransaction = null;
                    throw new RuntimeException("Can not begin new transaction until current transaction is not commited or rolled back (Thread.currentThread()=" + Thread.currentThread() + ")! " + this);
                }
                this.currentTransaction = this.msgStore.beginTransaction();
            }
        }
    }

    public void store() {
        if (this.persistent) {
            Sequence.State state = this.getState();
            if (!this.isExpired() && state != Sequence.State.BROKEN && state != Sequence.State.DESTROYED) {
                this.registry.onStore(this);
                this.createMsgSequence();
                Object object = this.transactionLock;
                synchronized (object) {
                    try {
                        this.msgSequence.storeDataTx(this.getStateToStore(), this.currentTransaction);
                    }
                    catch (IOException e) {
                        throw new RuntimeWrappedException("Error storing sequence " + this, e);
                    }
                }
            }
            this.removeFromMsgStore();
        }
    }

    public void commitTransaction() {
        if (this.persistent) {
            Object object = this.transactionLock;
            synchronized (object) {
                Iterator i = this.messageRecordsToStore.iterator();
                while (i.hasNext()) {
                    ((MessageRecordImpl)i.next()).storeNow();
                }
                this.messageRecordsToStore.clear();
                try {
                    this.msgStore.commitTransaction(this.currentTransaction);
                }
                catch (IOException e) {
                    throw new RuntimeWrappedException("Could not commit transaction pending on sequence " + this, e);
                }
                this.currentTransaction = null;
            }
        }
    }

    public void rollbackTransaction() {
        if (this.persistent) {
            Object object = this.transactionLock;
            synchronized (object) {
                try {
                    this.msgStore.rollbackTransaction(this.currentTransaction);
                }
                catch (IOException e) {
                    throw new RuntimeWrappedException("Could not rollback transaction pending on sequence " + this, e);
                }
                this.currentTransaction = null;
            }
        }
    }

    private String getPersistentName() {
        return SequenceImpl.createPersistentNamePrefix(this.processing, this.output) + this.id;
    }

    static String createPersistentNamePrefix(Processing processing, boolean output) {
        String prefix = processing instanceof ServiceEndpoint ? new ServiceEndpointReference((ServiceEndpoint)processing).toString() : "(client)";
        return prefix + (output ? OUT_PREFIX : IN_PREFIX);
    }

    public String toString() {
        Long msgNumber;
        StringBuffer sb = new StringBuffer();
        sb.append(this.output ? "output" : "input");
        sb.append(" sequence(id=\"");
        sb.append(this.id);
        sb.append("\",provider=\"");
        sb.append(this.providerName == null ? "<unknown>" : this.providerName);
        sb.append("\",processing=\"");
        if (this.processing instanceof ServiceClient) {
            sb.append("client:WSDL=\"");
            sb.append(((ServiceClient)this.processing).getWSDLLocation());
            sb.append("\"");
        } else if (this.processing instanceof ServiceEndpoint) {
            sb.append("endpoint:path=\"");
            sb.append(((ServiceEndpoint)this.processing).getPath());
            sb.append("\"");
        } else {
            sb.append("<unknown>");
        }
        sb.append("\",state=");
        sb.append(this.state.toString());
        sb.append(',');
        if (!this.active) {
            sb.append("in");
        }
        sb.append("active,");
        if (this.persistent) {
            sb.append("persistent,");
        }
        if (this.expired) {
            sb.append("expired,");
        }
        if (this.expires != null) {
            sb.append("expires=");
            sb.append(this.expires);
            sb.append(',');
        }
        if ((msgNumber = (Long)this.currentMessageNumber.get()) != null) {
            sb.append("currentMessageNumber=");
            sb.append(msgNumber);
            sb.append(',');
        }
        sb.append("length=");
        sb.append(this.length == -1L ? "<unknown>" : Long.toString(this.length));
        if (this.explicitConfirmation) {
            sb.append(",explicit confirmation on");
        }
        sb.append(')');
        return sb.toString();
    }

    Object getListenersLock() {
        return this.messageRecordsToStore;
    }

    private Serializable getStateToStore() {
        PersistentSequenceData d = new PersistentSequenceData();
        d.id = this.id;
        d.state = this.state.getValue();
        d.output = this.output;
        d.expires = this.expires;
        d.expired = this.expired;
        d.length = this.length;
        d.currentLength = this.currentLength;
        d.lastDeliveredrMessageNumber = this.lastDeliveredrMessageNumber;
        d.explicitConfirmation = this.explicitConfirmation;
        d.deliveredMessageNumbers = this.deliveredMessageNumbers;
        d.providerName = this.providerName;
        d.providerData = this.providerData;
        return d;
    }

    private void restoreState(Serializable restoredState) {
        PersistentSequenceData d = (PersistentSequenceData)restoredState;
        this.id = d.id;
        this.state = Sequence.State.fromValue(d.state);
        this.output = d.output;
        this.expires = d.expires;
        this.expired = d.expired;
        this.length = d.length;
        this.currentLength = d.currentLength;
        this.lastDeliveredrMessageNumber = d.lastDeliveredrMessageNumber;
        this.explicitConfirmation = d.explicitConfirmation;
        this.deliveredMessageNumbers = d.deliveredMessageNumbers;
        this.allMessageNumbers = new LongSet(d.deliveredMessageNumbers);
        this.providerName = d.providerName;
        this.providerData = d.providerData;
        this.persistent = true;
    }

    private void createMsgSequence() {
        Object object = this.transactionLock;
        synchronized (object) {
            if (this.msgSequence == null) {
                try {
                    Provider provider = this.registry.getProvider(this.providerName);
                    if (provider == null) {
                        throw new RuntimeException("Can not store sequence untouched by Sequence API provider! " + this);
                    }
                    this.msgSequence = this.msgStore.createSequenceTx(this.getPersistentName(), new SequenceMsgSerializer(provider, this), this.currentTransaction);
                }
                catch (MsgStoreException e) {
                    throw new RuntimeWrappedException("Error creating persistent sequence for sequence " + this, e);
                }
            }
        }
    }

    private void removeFromMsgStore() {
        if (this.msgStore != null) {
            String persistentName = this.getPersistentName();
            if (this.msgSequence != null) {
                try {
                    this.msgStore.destroySequence(persistentName);
                    this.msgSequence = null;
                }
                catch (MsgStoreException e) {
                    throw new RuntimeWrappedException("Error removing sequence from persistent store " + this, e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MessageRecordImpl
    implements ISequence.MessageRecord {
        private transient Metadata metadata = new Metadata();
        private long messageNumber;
        private Object providerData;
        private MsgRecordTx msgRecord;

        public MessageRecordImpl() {
        }

        public MessageRecordImpl(long messageNumber, boolean delivered, Serializable providerMetadata, Object providerData) {
            this.metadata.delivered = delivered;
            this.metadata.providerMetadata = providerMetadata;
            this.messageNumber = messageNumber;
            this.providerData = providerData;
        }

        public long getMessageNumber() {
            return this.messageNumber;
        }

        public void setMessageNumber(long messageNumber) {
            this.messageNumber = messageNumber;
        }

        public boolean isDelivered() {
            return this.metadata.delivered;
        }

        public void setDelivered(boolean delivered) {
            if (this.metadata.delivered != delivered) {
                this.metadata.delivered = delivered;
                if (delivered) {
                    Object object = SequenceImpl.this.transactionLock;
                    synchronized (object) {
                        SequenceImpl sequenceImpl = SequenceImpl.this;
                        synchronized (sequenceImpl) {
                            SequenceImpl.this.undeliveredMessageRecords.remove(new Long(this.messageNumber));
                            SequenceImpl.this.messageRecordsToStore.remove(this);
                            SequenceImpl.this.deliveredMessageNumbers.add(this.messageNumber);
                        }
                        try {
                            if (this.msgRecord != null) {
                                this.msgRecord.destroyTx(SequenceImpl.this.currentTransaction);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeWrappedException("Error removing persistent message record from sequence " + SequenceImpl.this, e);
                        }
                    }
                }
                throw new IllegalStateException("Delivered message can not get to undelivered state!");
            }
        }

        public Serializable getProviderMetadata() {
            return this.metadata.providerMetadata;
        }

        public void setProviderMetadata(Serializable providerMetadata) {
            this.metadata.providerMetadata = providerMetadata;
        }

        public Object getProviderData() {
            return this.providerData;
        }

        public void setProviderData(Object providerData) {
            this.providerData = providerData;
        }

        public void store() {
            if (SequenceImpl.this.persistent) {
                Object object = SequenceImpl.this.transactionLock;
                synchronized (object) {
                    SequenceImpl.this.messageRecordsToStore.add(this);
                }
            }
        }

        private void storeNow() {
            SequenceImpl.this.createMsgSequence();
            try {
                if (this.msgRecord == null) {
                    this.msgRecord = SequenceImpl.this.msgSequence.createMessageRecordTx(SequenceImpl.this.currentTransaction);
                    this.msgRecord.storeDataTx(this, SequenceImpl.this.currentTransaction);
                }
                this.msgRecord.storeMetadataTx(this.metadata, SequenceImpl.this.currentTransaction);
            }
            catch (MsgStoreException e) {
                throw new RuntimeWrappedException("Error storing message record #" + this.messageNumber + " of sequence " + SequenceImpl.this, e);
            }
            catch (IOException e) {
                throw new RuntimeWrappedException("Error storing message record #" + this.messageNumber + " of sequence " + SequenceImpl.this, e);
            }
        }

        private void setMsgRecord(MsgRecordTx msgRecord) {
            this.msgRecord = msgRecord;
        }
    }

    private static class Metadata
    implements Serializable {
        private boolean delivered;
        private Serializable providerMetadata;

        private Metadata() {
        }
    }

    public static class SequenceMsgSerializer
    implements MsgSerializer {
        private Provider provider;
        private ISequence sequence;

        public SequenceMsgSerializer() {
        }

        public SequenceMsgSerializer(Provider provider, ISequence sequence) {
            this.provider = provider;
            this.sequence = sequence;
        }

        public void setProvider(Provider provider) {
            this.provider = provider;
        }

        public void setSequence(ISequence sequence) {
            this.sequence = sequence;
        }

        public void store(MsgRecord msgRecord, Object msg, OutputStream outputStream) throws IOException {
            MessageRecordImpl messageRecord = (MessageRecordImpl)msg;
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeLong(messageRecord.getMessageNumber());
            if (this.provider != null) {
                this.provider.storeMessageProviderData(messageRecord.getProviderData(), out);
            }
            out.flush();
            out.close();
        }

        public Object load(MsgRecord msgRecord, InputStream inputStream) throws IOException {
            DataInputStream in = new DataInputStream(inputStream);
            MessageRecordImpl messageRecord = (MessageRecordImpl)this.sequence.createMessageRecord();
            messageRecord.setMsgRecord((MsgRecordTx)msgRecord);
            messageRecord.setMessageNumber(in.readLong());
            if (this.provider != null) {
                messageRecord.setProviderData(this.provider.loadMessageProviderData(in));
            }
            inputStream.close();
            return messageRecord;
        }
    }

    public static class PersistentSequenceData
    implements Serializable {
        private static final long serialVersionUID = 396248573112499033L;
        public String id;
        public int state;
        public boolean output;
        public Date expires;
        public boolean expired;
        public long length;
        public long currentLength;
        public long lastDeliveredrMessageNumber;
        public boolean explicitConfirmation;
        public LongSet deliveredMessageNumbers;
        public String providerName;
        private Serializable providerData;

        private PersistentSequenceData() {
        }
    }
}

