/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc.handler;

import com.idoox.debug.Category;
import com.systinet.wasp.rpc.handler.WaspHandlerInfoImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import org.idoox.wasp.Context;
import org.systinet.wasp.handler.HandlerChainFactory;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.handler.WaspHandlerInfo;

public class HandlerChainRepresentationImpl
implements HandlerRepository.HandlerChainRepresentation,
PropertyChangeListener {
    private static final Category cat = Category.getCategory("com.systinet.wasp.rpc.handler.HandlerChainRepresentationImpl");
    private Map clazzTohandlerInstance = new HashMap(11, 0.75f);
    private Map directionToHandlerChain = new HashMap(11, 0.75f);
    private List handlerInfos = new ArrayList();
    private boolean registered = false;
    private HandlerRepository handlerRep = (HandlerRepository)Context.getInstance("wasp.core.jaxrpc_handler_repository");

    public void registerHandlers(List handlers) {
        this.handlerInfos.addAll(handlers);
        this.addPropertyRegistration(handlers);
        this.registryRecordChanged();
    }

    private void registryRecordChanged() {
        Map map = this.directionToHandlerChain;
        synchronized (map) {
            this.directionToHandlerChain.clear();
        }
    }

    public HandlerChain getHandlerChain(int direction) {
        return (HandlerChain)this.directionToHandlerChain.get(new Integer(direction));
    }

    private HandlerChain buildChain(int direction, List defaultHandlerInfos, int processingType) {
        HashMap<String, Integer> iNameToInPosition = new HashMap<String, Integer>();
        HashMap<String, Integer> iNameToOutPosition = new HashMap<String, Integer>();
        HashMap<String, Integer> iNameToFaultPosition = new HashMap<String, Integer>();
        ArrayList handlerInfos = new ArrayList();
        handlerInfos.addAll(defaultHandlerInfos);
        handlerInfos.addAll(this.handlerInfos);
        ArrayList<String> currentPositionToRealPosition = new ArrayList<String>();
        ArrayList<WaspHandlerInfo> resultHandlerInfos = new ArrayList<WaspHandlerInfo>();
        int inPosition = -1;
        int outPosition = -1;
        int faultPosition = -1;
        Iterator it = handlerInfos.iterator();
        while (it.hasNext()) {
            WaspHandlerInfo handlerInfo = (WaspHandlerInfo)it.next();
            if ((handlerInfo.getDirection() & direction) == direction) {
                resultHandlerInfos.add(handlerInfo);
                currentPositionToRealPosition.add(((WaspHandlerInfoImpl)handlerInfo).getInstanceName());
            }
            if ((handlerInfo.getDirection() & 1) == 1) {
                iNameToInPosition.put(((WaspHandlerInfoImpl)handlerInfo).getInstanceName(), new Integer(++inPosition));
            }
            if ((handlerInfo.getDirection() & 2) == 2) {
                iNameToOutPosition.put(((WaspHandlerInfoImpl)handlerInfo).getInstanceName(), new Integer(++outPosition));
            }
            if ((handlerInfo.getDirection() & 0xC) != 12) continue;
            iNameToFaultPosition.put(((WaspHandlerInfoImpl)handlerInfo).getInstanceName(), new Integer(++faultPosition));
        }
        HandlerRepository.DirectionPositionEntry[] directionPostitions = new HandlerRepository.DirectionPositionEntry[resultHandlerInfos.size()];
        int k = 0;
        Iterator j = resultHandlerInfos.iterator();
        while (j.hasNext()) {
            WaspHandlerInfoImpl hInfo = (WaspHandlerInfoImpl)j.next();
            Integer inPositionI = (Integer)iNameToInPosition.get(hInfo.getInstanceName());
            Integer outPositionI = (Integer)iNameToOutPosition.get(hInfo.getInstanceName());
            Integer faultPositionI = (Integer)iNameToFaultPosition.get(hInfo.getInstanceName());
            if (inPositionI != null) {
                inPosition = inPositionI;
            }
            if (outPositionI != null) {
                outPosition = outPositionI;
            }
            if (faultPositionI != null) {
                faultPosition = faultPositionI;
            }
            directionPostitions[k++] = new HandlerRepository.DirectionPositionEntry(outPosition, inPosition, faultPosition);
        }
        HandlerChain chain = HandlerChainFactory.newInstance(resultHandlerInfos, currentPositionToRealPosition, this.clazzTohandlerInstance, processingType, directionPostitions);
        return chain;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator chainIT = this.handlerInfos.iterator();
        while (chainIT.hasNext()) {
            sb.append(chainIT.next());
        }
        return sb.toString();
    }

    public int getHandlersCount() {
        return this.handlerInfos.size();
    }

    public WaspHandlerInfo getHandler(int position) {
        return (WaspHandlerInfo)this.handlerInfos.get(position);
    }

    public HandlerChain getHandlerChain(int direction, int processingType) {
        HandlerChain handlerChain;
        Map map = this.directionToHandlerChain;
        synchronized (map) {
            handlerChain = this.getHandlerChain(direction);
            if (handlerChain == null) {
                HandlerRepository.HandlerChainRepresentation defaultEntry = processingType == 1 ? this.handlerRep.getHandlerChain("DefaultClientHandlers") : this.handlerRep.getHandlerChain("DefaultServerHandlers");
                handlerChain = this.buildChain(direction, defaultEntry.getHandlers(), processingType);
                this.directionToHandlerChain.put(new Integer(direction), handlerChain);
            }
        }
        return handlerChain;
    }

    public int registerHandler(WaspHandlerInfo handler) {
        return this.registerHandler(handler, -1);
    }

    public int registerHandler(WaspHandlerInfo handler, int position) {
        return this.registerHandler(handler, ((WaspHandlerInfoImpl)handler).getHandlerInstance(), position);
    }

    public int registerHandler(WaspHandlerInfo info, Handler handler, int position) {
        if (position == -1) {
            this.handlerInfos.add(info);
        } else {
            this.handlerInfos.add(position, info);
        }
        ((WaspHandlerInfoImpl)info).addPropertyChangeListener(this);
        ((WaspHandlerInfoImpl)info).setHandlerInstance(handler);
        this.registryRecordChanged();
        return this.handlerInfos.indexOf(info);
    }

    public int registerHandlerBC(WaspHandlerInfo handlerInfo, int position, boolean updateExisting) {
        if (handlerInfo.getDirection() == 12) {
            List list = this.handlerInfos;
            synchronized (list) {
                Iterator it = this.handlerInfos.iterator();
                while (it.hasNext()) {
                    WaspHandlerInfoImpl info = (WaspHandlerInfoImpl)it.next();
                    String instanceName = ((WaspHandlerInfoImpl)handlerInfo).getInstanceName();
                    if (instanceName == null || !instanceName.equals(info.getInstanceName()) || info.getDirection() != 12) continue;
                    int n = this.handlerInfos.indexOf(info);
                    return n;
                }
            }
        }
        return this.registerHandler(handlerInfo, position);
    }

    public void unregisterHandlerBC(String hpName, int direction) {
        List list = this.handlerInfos;
        synchronized (list) {
            Iterator it = this.handlerInfos.iterator();
            while (it.hasNext()) {
                WaspHandlerInfoImpl info = (WaspHandlerInfoImpl)it.next();
                if (!hpName.equals(info.getInstanceName()) || info.getDirection() != direction) continue;
                it.remove();
            }
        }
    }

    public boolean unregisterHandler(WaspHandlerInfo handler) {
        return this.unregisterHandlerInfo(handler);
    }

    boolean unregisterHandlerInfo(HandlerInfo handler) {
        this.registryRecordChanged();
        return this.handlerInfos.remove(handler);
    }

    public boolean removeHandler(int position) {
        WaspHandlerInfo handlerInfo = this.getHandler(position);
        this.registryRecordChanged();
        return this.handlerInfos.remove(handlerInfo);
    }

    public List getHandlerInfos() {
        return this.handlerInfos;
    }

    public List getHandlers() {
        return new HandlerInfoListWrapper(this);
    }

    public void setHandlers(List handlerInfos) {
        Iterator it = handlerInfos.iterator();
        while (it.hasNext()) {
            WaspHandlerInfo info = (WaspHandlerInfo)HandlerInfoListWrapper.createHandlerInfoToInternal(it.next());
            this.registerHandler(info);
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered() {
        this.registered = true;
    }

    private void releaseInstances() {
        Map map = this.clazzTohandlerInstance;
        synchronized (map) {
            Iterator it = this.clazzTohandlerInstance.keySet().iterator();
            while (it.hasNext()) {
                Handler handler = (Handler)this.clazzTohandlerInstance.get(it.next());
                handler.destroy();
            }
            this.clazzTohandlerInstance.clear();
        }
    }

    public void destroy() {
        this.releaseInstances();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.registryRecordChanged();
    }

    private void addPropertyRegistration(List handlerInfos) {
        Iterator it = handlerInfos.iterator();
        while (it.hasNext()) {
            ((WaspHandlerInfoImpl)it.next()).addPropertyChangeListener(this);
        }
    }

    public synchronized Object clone() {
        HandlerChainRepresentationImpl chain = new HandlerChainRepresentationImpl();
        chain.clazzTohandlerInstance.putAll(this.clazzTohandlerInstance);
        chain.handlerInfos.addAll(this.handlerInfos);
        Iterator it = chain.handlerInfos.iterator();
        while (it.hasNext()) {
            ((WaspHandlerInfoImpl)it.next()).addPropertyChangeListener(chain);
        }
        return chain;
    }

    private static class HandlerInfoListWrapper
    implements List {
        private HandlerChainRepresentationImpl observer;
        private HashMap handlerInfoToInternal = new HashMap(3, 0.75f);

        public HandlerInfoListWrapper(HandlerChainRepresentationImpl observer) {
            this.observer = observer;
        }

        public int size() {
            return this.observer.handlerInfos.size();
        }

        public boolean isEmpty() {
            return this.observer.handlerInfos.isEmpty();
        }

        public Iterator iterator() {
            return this.observer.handlerInfos.iterator();
        }

        public Object[] toArray() {
            return this.observer.handlerInfos.toArray();
        }

        public Object[] toArray(Object[] objects) {
            return this.observer.handlerInfos.toArray(objects);
        }

        public boolean add(Object o) {
            this.observer.registerHandler((WaspHandlerInfo)this.registerHandlerInfo(o));
            return true;
        }

        public boolean remove(Object o) {
            HashMap hashMap = this.handlerInfoToInternal;
            synchronized (hashMap) {
                Object toBeRemoved = this.handlerInfoToInternal.get(o);
                boolean bl = this.observer.unregisterHandlerInfo((HandlerInfo)toBeRemoved);
                return bl;
            }
        }

        public boolean contains(Object o) {
            return this.observer.handlerInfos.contains(o);
        }

        public boolean containsAll(Collection collection) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                boolean ret = this.observer.handlerInfos.contains(this.handlerInfoToInternal(it.next()));
                if (ret) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            HashMap hashMap = this.handlerInfoToInternal;
            synchronized (hashMap) {
                this.handlerInfoToInternal.clear();
            }
            this.observer.handlerInfos.clear();
        }

        public Object get(int i) {
            return this.observer.handlerInfos.get(i);
        }

        public Object set(int i, Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, Object o) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.observer.handlerInfos.indexOf(this.handlerInfoToInternal(o));
        }

        public int lastIndexOf(Object o) {
            return this.observer.handlerInfos.lastIndexOf(this.handlerInfoToInternal(o));
        }

        public ListIterator listIterator() {
            return this.observer.handlerInfos.listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.observer.handlerInfos.listIterator(i);
        }

        public List subList(int i, int i1) {
            return this.observer.handlerInfos.subList(i, i1);
        }

        private Object registerHandlerInfo(Object handlerInfo) {
            Object ret = HandlerInfoListWrapper.createHandlerInfoToInternal(handlerInfo);
            HashMap hashMap = this.handlerInfoToInternal;
            synchronized (hashMap) {
                this.handlerInfoToInternal.put(handlerInfo, ret);
            }
            return ret;
        }

        static Object createHandlerInfoToInternal(Object handlerInfo) {
            Object ret = handlerInfo;
            if (handlerInfo instanceof HandlerInfo) {
                ret = new WaspHandlerInfoImpl((HandlerInfo)handlerInfo);
            }
            return ret;
        }

        private Object handlerInfoToInternal(Object handlerInfo) {
            Object ret;
            HashMap hashMap = this.handlerInfoToInternal;
            synchronized (hashMap) {
                ret = this.handlerInfoToInternal.get(handlerInfo);
            }
            if (ret == null) {
                ret = handlerInfo;
            }
            return ret;
        }
    }
}

