/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc.handler;

import com.systinet.wasp.rpc.handler.ClientHandlerChainInvoker;
import com.systinet.wasp.rpc.handler.ServerHandlerChainInvoker;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.wasp.Context;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.webservice.Current;

public abstract class HandlerChainInvoker {
    protected HandlerRepository handlerRep = (HandlerRepository)Context.getInstance("wasp.core.jaxrpc_handler_repository");
    private static HandlerChainInvoker serverInstance = new ServerHandlerChainInvoker();
    private static HandlerChainInvoker clientInstance = new ClientHandlerChainInvoker();

    protected HandlerChainInvoker() {
    }

    public static HandlerChainInvoker getServerChainInvoker() {
        return serverInstance;
    }

    public static HandlerChainInvoker getClientChainInvoker() {
        return clientInstance;
    }

    public static HandlerChainInvoker getInstance() {
        if (Current.getProcessingType() == 1) {
            return HandlerChainInvoker.getClientChainInvoker();
        }
        return HandlerChainInvoker.getServerChainInvoker();
    }

    public abstract State processInput(SOAPMessageContext var1, String var2);

    public abstract State processOutput(SOAPMessageContext var1, String var2);

    public abstract State processFault(SOAPMessageContext var1, String var2);

    public abstract State processFault(SOAPMessageContext var1, String var2, int var3, int var4);

    public abstract State processInput(SOAPMessageContext var1, String var2, int var3, int var4);

    public abstract State processOutput(SOAPMessageContext var1, String var2, int var3, int var4);

    protected HandlerChain getHandlerChain(int direction, String processingID) {
        HandlerRepository.HandlerChainRepresentation handlerChain = this.handlerRep.getHandlerChain(processingID);
        return handlerChain.getHandlerChain(direction, this.getProcessingSide());
    }

    protected abstract int getProcessingSide();

    public static class State {
        public static final int STATUS_OK = 1;
        public static final int STATUS_STOP = 2;
        public static final int STATUS_FAULT = 3;
        public int statusCode;
        public Exception thrownException;

        public State(boolean processingResult) {
            this.statusCode = processingResult ? 1 : 2;
        }

        public State(Exception exception) {
            this.statusCode = 3;
            this.thrownException = exception;
        }
    }
}

