/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import com.idoox.util.ObjectPool;
import com.idoox.util.Pool;
import com.systinet.wasp.rpc.WaspCallImpl;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.systinet.wasp.rpc.IWaspCall;
import org.systinet.wasp.rpc.WaspCall;
import org.systinet.wasp.rpc.WaspCallFactory;
import org.systinet.wasp.webservice.ServiceClient;

public class WaspCallFactoryImpl
extends WaspCallFactory {
    Pool waspCallPool = new ObjectPool(new WaspCallFactoryInternal(), 10);
    Map methodInfoTowaspCallBuffer = Collections.synchronizedMap(new WeakHashMap());

    public WaspCall createWaspCall(ServiceClient serviceClient) {
        IWaspCall call = (IWaspCall)this.waspCallPool.get();
        call.setPool(this.waspCallPool);
        call.setRelease(true);
        call.init(serviceClient);
        return call;
    }

    public WaspCall createWaspCall(ServiceClient serviceClient, SOAPMethodInfo methodInfo) {
        CallBuffer callBuffer;
        IWaspCall call = null;
        if (this.methodInfoTowaspCallBuffer.containsKey(methodInfo) && (call = (callBuffer = (CallBuffer)this.methodInfoTowaspCallBuffer.get(methodInfo)).get()) != null) {
            call.setServiceCient(serviceClient);
        }
        if (call == null) {
            call = (IWaspCall)this.waspCallPool.get();
            call.init(serviceClient, methodInfo);
        }
        call.setRelease(false);
        call.setPool(new WaspCallPool(methodInfo));
        return call;
    }

    public WaspCall createWaspCall(ServiceClient serviceClient, QName operationName) {
        WaspCallImpl call = new WaspCallImpl();
        call.setPool(this.waspCallPool);
        call.setRelease(true);
        call.init(serviceClient, operationName);
        return call;
    }

    private static class CallBuffer {
        private IWaspCall[] calls = new IWaspCall[1];
        private int top = 0;

        private CallBuffer() {
        }

        public IWaspCall get() {
            IWaspCall[] iWaspCallArray = this.calls;
            synchronized (iWaspCallArray) {
                IWaspCall ret = null;
                if (this.top > 0) {
                    ret = this.calls[this.top--];
                }
                IWaspCall iWaspCall = ret;
                return iWaspCall;
            }
        }

        public void add(IWaspCall call) {
            IWaspCall[] iWaspCallArray = this.calls;
            synchronized (iWaspCallArray) {
                this.ensureCapacity(this.top + 1);
                this.calls[++this.top] = call;
            }
        }

        private void ensureCapacity(int len) {
            IWaspCall[] iWaspCallArray = this.calls;
            synchronized (iWaspCallArray) {
                if (len >= this.calls.length) {
                    IWaspCall[] newCalls = new IWaspCall[this.calls.length * 2];
                    System.arraycopy(this.calls, 0, newCalls, 0, this.calls.length);
                    this.calls = newCalls;
                }
            }
        }
    }

    private class WaspCallPool
    implements Pool {
        SOAPMethodInfo methodInfo;

        public WaspCallPool(SOAPMethodInfo methodInfo) {
            this.methodInfo = methodInfo;
        }

        public void init(Pool.Factory fact, int size) {
        }

        public Object get() {
            return WaspCallFactoryImpl.this.waspCallPool.get();
        }

        public void release(Object obj) {
            CallBuffer callBuffer = null;
            if (WaspCallFactoryImpl.this.methodInfoTowaspCallBuffer.containsKey(this.methodInfo)) {
                callBuffer = (CallBuffer)WaspCallFactoryImpl.this.methodInfoTowaspCallBuffer.get(this.methodInfo);
            } else {
                callBuffer = new CallBuffer();
                WaspCallFactoryImpl.this.methodInfoTowaspCallBuffer.put(this.methodInfo, callBuffer);
            }
            callBuffer.add((IWaspCall)obj);
        }
    }

    class WaspCallFactoryInternal
    implements Pool.Factory {
        WaspCallFactoryInternal() {
        }

        public Object getNewInstance() {
            return new WaspCallImpl();
        }
    }
}

