/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.idoox.xmlrpc.MessageProcessingException;

public class ExceptionDeserializerHelper {
    private static Comparator exactMatch = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            return 1;
        }
    };
    private static Comparator inheritanceMatch = new Comparator(){

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            if (c1.isAssignableFrom(c2)) {
                return 0;
            }
            return 1;
        }
    };

    public static Constructor getConstructor(Class targetClass) throws MessageProcessingException {
        Constructor<?>[] constructors = targetClass.getConstructors();
        if (constructors == null || constructors.length == 0) {
            constructors = targetClass.getDeclaredConstructors();
        }
        if (constructors == null || constructors.length == 0) {
            throw new MessageProcessingException("Unable to deserialize exception " + targetClass + ". No constructor found!");
        }
        if (constructors.length != 1) {
            return null;
        }
        return constructors[0];
    }

    public static Object constructException(Constructor constructor, List params, Class targetClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (constructor != null) {
            return constructor.newInstance(params.toArray());
        }
        Constructor[] constructors = targetClass.getConstructors();
        constructor = ExceptionDeserializerHelper.findConstructor(constructors, params, targetClass);
        if (constructor != null) {
            return constructor.newInstance(params.toArray());
        }
        constructors = targetClass.getDeclaredConstructors();
        constructor = ExceptionDeserializerHelper.findConstructor(constructors, params, targetClass);
        return constructor.newInstance(params.toArray());
    }

    private static Constructor findConstructor(Constructor[] constructors, List params, Class targetClass) {
        ArrayList<Constructor> result = new ArrayList<Constructor>(1);
        int i = 0;
        while (i < constructors.length) {
            Constructor constructor = constructors[i];
            Class[] parameterTypes = constructor.getParameterTypes();
            if (ExceptionDeserializerHelper.compareParameters(parameterTypes, params, exactMatch)) {
                result.add(constructor);
            }
            ++i;
        }
        if (result.size() == 0) {
            int i2 = 0;
            while (i2 < constructors.length) {
                Constructor constructor = constructors[i2];
                Class[] parameterTypes = constructor.getParameterTypes();
                if (ExceptionDeserializerHelper.compareParameters(parameterTypes, params, inheritanceMatch)) {
                    result.add(constructor);
                }
                ++i2;
            }
        }
        if (result.size() == 1) {
            return (Constructor)result.iterator().next();
        }
        throw new RuntimeException("Unable to construct exception class(" + targetClass.getName() + ") with parameters(" + params + "). Found constructors:" + result);
    }

    private static boolean compareParameters(Class[] parameterTypes, List params, Comparator cmp) {
        if (parameterTypes.length != params.size()) {
            return false;
        }
        Iterator it = params.iterator();
        int i = 0;
        while (i < parameterTypes.length) {
            Class<?> c;
            Class parameterType = parameterTypes[i];
            Object o = it.next();
            if (o != null && cmp.compare(parameterType, c = o.getClass()) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

