/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import com.idoox.debug.Category;
import com.idoox.wasp.Constants;
import com.idoox.wasp.serialization.JaxRPC;
import com.idoox.wasp.serialization.MultirefHandler;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import com.systinet.wasp.rpc.WaspCallImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.PostSerializationHandler;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.wasp.types.MessageAttachment;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.systinet.wasp.soap.util.LazyFillingTokenizer;
import org.w3c.dom.Element;

class ClientLazySerializationHelper
implements LazyFillingTokenizer.Filler {
    protected static final Category cat = Category.getCategory("com.systinet.wasp.rpc.ClientLazySerializationHelper");
    WaspCallImpl.MethodProperties methodProperties;
    WaspCallImpl.MethodInvocationState methodInvocationState;
    private String serializationID;
    private boolean doMultirefs = true;
    private String protocol;
    private SOAPMethodInfo methodInfo;
    private SerializationRepository serializationRepository = (SerializationRepository)Context.getInstance(class$org$idoox$wasp$serialization$SerializationRepository == null ? (class$org$idoox$wasp$serialization$SerializationRepository = ClientLazySerializationHelper.class$("org.idoox.wasp.serialization.SerializationRepository")) : class$org$idoox$wasp$serialization$SerializationRepository);
    private EncodingRepository encodingRepository = (EncodingRepository)Context.getInstance(class$com$idoox$xmlrpc$encoding$EncodingRepository == null ? (class$com$idoox$xmlrpc$encoding$EncodingRepository = ClientLazySerializationHelper.class$("com.idoox.xmlrpc.encoding.EncodingRepository")) : class$com$idoox$xmlrpc$encoding$EncodingRepository);
    Object[] params;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$SerializationRepository;
    static /* synthetic */ Class class$com$idoox$xmlrpc$encoding$EncodingRepository;
    static /* synthetic */ Class class$org$idoox$wasp$RequestMessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$types$RequestMessageAttachment;

    public ClientLazySerializationHelper(WaspCallImpl.MethodInvocationState mis, String serializationID, boolean doMultirefs, String protocol) {
        this.methodProperties = mis.method;
        this.params = mis.params;
        this.methodInvocationState = (WaspCallImpl.MethodInvocationState)mis.clone();
        this.serializationID = serializationID;
        this.doMultirefs = doMultirefs;
        this.protocol = protocol;
    }

    public void fillTokenWriter(TokenWriter writer) throws IOException, TokenizerException {
        SerializationContext ctx = this.serializationRepository.createSerializationContext(this.serializationID, this.methodProperties.encoding);
        this.methodInfo = this.methodProperties.weakMethodInfo.getMethodInfo();
        try {
            try {
                ctx.setSchema(this.methodProperties.schema, true);
                if (this.methodProperties.encoding != null) {
                    this.grabReferences(ctx);
                }
                this.writeRequest(ctx, writer);
                Iterator attachments = ctx.getAttachments();
                int part = 0;
                int size = this.methodInfo.parts.length;
                if (attachments != null) {
                    while (attachments.hasNext()) {
                        InputStream is;
                        MessageAttachment att = (MessageAttachment)attachments.next();
                        SOAPMethodInfo.PartInfo partInfo = null;
                        while (part < size) {
                            if (this.methodInfo.parts[part].isAttachment) {
                                partInfo = this.methodInfo.parts[part];
                                break;
                            }
                            ++part;
                        }
                        String contentType = att.getContentType();
                        if (contentType == null && partInfo != null) {
                            contentType = partInfo.mimeType;
                        }
                        if (contentType == null) {
                            contentType = "application/octet-stream";
                        }
                        if ((is = att.getData()) == null) {
                            if ((class$org$idoox$wasp$RequestMessageAttachment == null ? ClientLazySerializationHelper.class$("org.idoox.wasp.RequestMessageAttachment") : class$org$idoox$wasp$RequestMessageAttachment).isAssignableFrom(att.getClass()) || (class$org$idoox$wasp$types$RequestMessageAttachment == null ? ClientLazySerializationHelper.class$("org.idoox.wasp.types.RequestMessageAttachment") : class$org$idoox$wasp$types$RequestMessageAttachment).isAssignableFrom(att.getClass())) {
                                throw new IOException("RequestMessageAttachment must have seted data.");
                            }
                            is = new ByteArrayInputStream(new byte[0]);
                        }
                        AttachmentPart attachment = this.methodInvocationState.request.createAttachmentPart(is, contentType);
                        String aux = att.getContentId();
                        if (aux != null) {
                            attachment.setContentId(aux);
                        }
                        if ((aux = att.getContentLocation()) != null) {
                            attachment.setContentLocation(aux);
                        }
                        this.methodInvocationState.request.addAttachmentPart(attachment);
                    }
                }
                this.serializationRepository.releaseSerializationContext(ctx);
            }
            catch (Exception e) {
                throw new TokenizerException(e);
            }
            Object var13_13 = null;
            this.methodInfo = null;
            this.methodInvocationState = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.methodInfo = null;
            this.methodInvocationState = null;
            throw throwable;
        }
    }

    private void grabReferences(SerializationContext ctx) throws MessageCreatingException {
        if (this.params == null) {
            return;
        }
        if (this.doMultirefs) {
            ctx.clearMultirefs();
            int paramIdx = 0;
            int i = 0;
            while (i < this.methodInfo.parts.length) {
                if (this.methodInfo.parts[i].partType != 2) {
                    Object val = this.params[paramIdx];
                    if (this.params[paramIdx] != null && JaxRPC.isHolder(this.params[paramIdx])) {
                        val = JaxRPC.getHolderValue(this.params[paramIdx]);
                    }
                    if (!(val instanceof Element)) {
                        SchemaContext.State state = WaspSerializationHelper.init(ctx, this.methodInfo.parts[i], new QName(null, this.methodInfo.parts[i].partName), true);
                        SerializationHelper.grabReferences(val, ctx);
                        ctx.leave(state);
                    }
                    ++paramIdx;
                } else {
                    ++paramIdx;
                }
                ++i;
            }
        }
    }

    private void writeRequest(SerializationContext ctx, TokenWriter bodyWriter) throws MessageCreatingException, WSDLException, IOException, NoSuchEncodingException {
        Iterator i;
        boolean useEncoding;
        EncodingTokenWriter encodingWriter = null;
        if (this.methodProperties.encoding != null) {
            encodingWriter = "http://schemas.xmlsoap.org/soap/encoding/".equals(this.methodProperties.encoding) && this.methodProperties.schema.getNamespaces().contains("http://www.w3.org/1999/XMLSchema") ? this.encodingRepository.getEncodingTokenWriter("1999Enc", this.methodProperties.encoding) : this.encodingRepository.getEncodingTokenWriter(this.methodInvocationState.method.encodingId, this.methodProperties.encoding);
            encodingWriter.setTokenWriter(bodyWriter);
            useEncoding = true;
        } else {
            useEncoding = false;
        }
        if (this.methodInfo.rpcOperation) {
            if (useEncoding) {
                encodingWriter.writeStructureStart(new QName(this.methodInfo.requestName.getNamespaceURI(), this.methodInfo.requestName.getLocalPart()), Constants.nullQName, null, null);
            } else {
                bodyWriter.enter(this.methodInfo.requestName.getNamespaceURI(), this.methodInfo.requestName.getLocalPart());
            }
        }
        if (this.protocol.equals("soap12")) {
            ctx.setMultirefsInline(true);
        }
        if (this.methodInfo.rpcOperation || this.protocol.equals("httpget")) {
            if (useEncoding) {
                this.writeRPCParams(encodingWriter, ctx);
            } else {
                this.writeRPCParams(bodyWriter, ctx);
            }
        } else if (useEncoding) {
            this.writeDocumentParams(encodingWriter, ctx);
        } else {
            this.writeDocumentParams(bodyWriter, ctx);
        }
        if (this.methodInfo.rpcOperation) {
            if (useEncoding) {
                encodingWriter.writeStructureEnd();
            } else {
                bodyWriter.leave();
            }
        }
        if (this.doMultirefs && this.params != null && !ctx.isMultirefsInline()) {
            i = ((MultirefHandler)((Object)ctx)).getReferencesIterator();
            while (i.hasNext()) {
                ctx.setSerializingMultirefs(true);
                MultirefHandler.MultirefHolder holder = (MultirefHandler.MultirefHolder)i.next();
                if (holder.id == null) continue;
                try {
                    SchemaContext.State state = ctx.putMember(new Member(new QName(null, "reference"), holder.schemaType, true));
                    if (useEncoding) {
                        SerializationHelper.serialize(encodingWriter, holder.value, null, ctx);
                    } else {
                        SerializationHelper.serialize(bodyWriter, holder.value, ctx);
                    }
                    ctx.leave(state);
                }
                catch (Exception e) {
                    throw new WSDLException("OTHER_ERROR", "Exception in parsing types", e);
                }
            }
        }
        if (useEncoding) {
            encodingWriter.flush();
        } else {
            bodyWriter.flush();
        }
        i = ctx.getPostSerializationHandlers();
        while (i.hasNext()) {
            PostSerializationHandler h = (PostSerializationHandler)i.next();
            h.serializationFinished(ctx);
        }
        if (useEncoding) {
            this.encodingRepository.releaseEncodingTokenWriter(this.methodInvocationState.method.encodingId, this.methodProperties.encoding, encodingWriter);
        }
    }

    private void writeRPCParams(TokenWriter writer, SerializationContext ctx) throws MessageCreatingException {
        if (this.params == null) {
            return;
        }
        int paramIdx = 0;
        int i = 0;
        while (i < this.methodInfo.parts.length) {
            block7: {
                block6: {
                    if (this.methodInfo.parts[i].partType == 2) break block6;
                    Object value = this.params[paramIdx];
                    if (JaxRPC.isHolder(this.params[paramIdx])) {
                        value = JaxRPC.getHolderValue(this.params[paramIdx]);
                    }
                    if (value == null) break block7;
                    QName typeQName = this.methodInfo.parts[i].inSchemaType.getName();
                    WaspSerializationHelper.writeParam(writer, this.params[paramIdx], this.methodInfo.parts[i], ctx, typeQName, new QName(null, this.methodInfo.parts[i].partName), true);
                }
                ++paramIdx;
            }
            ++i;
        }
    }

    private void writeRPCParams(EncodingTokenWriter writer, SerializationContext ctx) throws MessageCreatingException {
        if (this.params == null) {
            return;
        }
        int paramIdx = 0;
        int i = 0;
        while (i < this.methodInfo.parts.length) {
            if (this.methodInfo.parts[i].partType != 2) {
                QName typeQName = this.methodInfo.parts[i].inSchemaType.getName();
                WaspSerializationHelper.writeParam(writer, this.params[paramIdx], this.methodInfo.parts[i], ctx, typeQName, new QName(null, this.methodInfo.parts[i].partName), true);
            }
            ++paramIdx;
            ++i;
        }
    }

    private void writeDocumentParams(TokenWriter writer, SerializationContext ctx) throws MessageCreatingException {
        if (this.methodInfo.inWrapperQName != null) {
            try {
                writer.enter(this.methodInfo.inWrapperQName.getNamespaceURI(), this.methodInfo.inWrapperQName.getLocalPart());
            }
            catch (Exception e) {
                throw new MessageCreatingException(e);
            }
        }
        if (this.params != null) {
            int paramIdx = 0;
            int i = 0;
            while (i < this.methodInfo.parts.length) {
                if (this.methodInfo.parts[i].partType != 2) {
                    if (this.methodInfo.parts[i].inSchemaElement == null) {
                        throw new UnsupportedOperationException("Unsupported serialization of  document/literal's parameter with xml schema <type>. Supported is only <element>");
                    }
                    QName elemQName = this.methodInfo.parts[i].inSchemaElement.getName();
                    QName typeQName = this.methodInfo.parts[i].inSchemaType.getName();
                    WaspSerializationHelper.writeParam(writer, this.params[paramIdx], this.methodInfo.parts[i], ctx, typeQName, new QName(elemQName.getNamespaceURI(), elemQName.getLocalPart()), true);
                }
                ++paramIdx;
                ++i;
            }
        }
        if (this.methodInfo.inWrapperQName != null) {
            try {
                writer.leave();
            }
            catch (Exception e) {
                throw new MessageCreatingException(e);
            }
        }
    }

    private void writeDocumentParams(EncodingTokenWriter writer, SerializationContext ctx) throws MessageCreatingException {
        if (this.params != null) {
            int paramIdx = 0;
            int i = 0;
            while (i < this.methodInfo.parts.length) {
                if (this.methodInfo.parts[i].partType != 2) {
                    if (this.methodInfo.parts[i].inSchemaElement == null) {
                        throw new UnsupportedOperationException("Unsupported serialization of  document/literal's parameter with xml schema <type>. Supported is only <element>");
                    }
                    QName elemQName = this.methodInfo.parts[i].inSchemaElement.getName();
                    QName typeQName = this.methodInfo.parts[i].inSchemaType.getName();
                    WaspSerializationHelper.writeParam(writer, this.params[paramIdx], this.methodInfo.parts[i], ctx, typeQName, new QName(elemQName.getNamespaceURI(), elemQName.getLocalPart()), true);
                }
                ++paramIdx;
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

