/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.monitoring.log4j;

import com.systinet.monitoring.LoggerListener;
import com.systinet.wasp.monitoring.config.Log4JAdapterConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.apache.log4j.FileAppender;
import org.apache.log4j.PropertyConfigurator;
import org.idoox.config.Configurable;
import org.systinet.monitoring.Event;
import org.systinet.wasp.Wasp;

public class Log4JAdapter
implements LoggerListener {
    private static Category cat = Category.getInstance((String)(class$com$systinet$wasp$monitoring$log4j$Log4JAdapter == null ? (class$com$systinet$wasp$monitoring$log4j$Log4JAdapter = Log4JAdapter.class$("com.systinet.wasp.monitoring.log4j.Log4JAdapter")) : class$com$systinet$wasp$monitoring$log4j$Log4JAdapter).getName());
    private String log4jInitFile;
    private String defaultCategory;
    private String defaultErrorCategory;
    private boolean writeStackTraces;
    private static long eventId = System.currentTimeMillis();
    static /* synthetic */ Class class$com$systinet$wasp$monitoring$log4j$Log4JAdapter;
    static /* synthetic */ Class class$org$apache$log4j$FileAppender;
    static /* synthetic */ Class class$com$systinet$wasp$monitoring$config$Log4JAdapterConfig;

    public void handle(Event event) {
        Category cat;
        Category catError = null;
        String categoryName = event.getCategoryName();
        String messageText = "<ID" + String.valueOf(eventId++) + "> " + event.getMessageText();
        Throwable throwable = event.getThrowable();
        if (throwable != null) {
            messageText = messageText + " - EXCEPTION: " + throwable.toString();
        }
        if (categoryName == null) {
            catError = this.defaultErrorCategory == null ? Category.getRoot() : Category.getInstance((String)this.defaultErrorCategory);
            cat = this.defaultCategory == null ? Category.getRoot() : Category.getInstance((String)this.defaultCategory);
        } else {
            cat = Category.getInstance((String)categoryName);
        }
        Throwable th = event.getThrowable();
        if (!this.writeStackTraces) {
            th = null;
        }
        switch (event.getSeverity()) {
            case 0: {
                return;
            }
            case 5000: {
                cat.debug((Object)messageText, th);
                return;
            }
            case 4000: {
                cat.info((Object)messageText, th);
                return;
            }
            case 3000: {
                if (catError != null) {
                    catError.warn((Object)messageText, throwable);
                }
                cat.warn((Object)messageText, th);
                return;
            }
            case 2000: {
                if (catError != null) {
                    catError.error((Object)messageText, throwable);
                }
                cat.error((Object)messageText, th);
                return;
            }
            case 1000: {
                if (catError != null) {
                    catError.fatal((Object)messageText, throwable);
                }
                cat.fatal((Object)messageText, th);
                return;
            }
        }
        cat.info((Object)messageText, th);
    }

    public String[] getLogFilePath(String loggerName) {
        if (loggerName == null) {
            return new String[0];
        }
        Category cat = Category.getInstance((String)loggerName);
        ArrayList<String> ret = new ArrayList<String>();
        Enumeration enumeration = cat.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Object o;
            if (!(class$org$apache$log4j$FileAppender == null ? Log4JAdapter.class$("org.apache.log4j.FileAppender") : class$org$apache$log4j$FileAppender).isAssignableFrom((o = enumeration.nextElement()).getClass())) continue;
            ret.add(((FileAppender)o).getFile());
        }
        return ret.toArray(new String[0]);
    }

    public void destroy() {
    }

    private void initLog4J() {
        if (this.log4jInitFile == null) {
            return;
        }
        String configLocation = Wasp.getWaspLocation();
        File configFile = null;
        File f = new File(this.log4jInitFile);
        if (f.isAbsolute()) {
            configFile = f;
        } else {
            File confBase = null;
            try {
                if (configLocation != null && configLocation.length() > 0) {
                    confBase = new File(new URL(configLocation).getFile());
                }
            }
            catch (MalformedURLException e) {
                cat.debug((Object)"error", (Throwable)e);
            }
            if (confBase != null && confBase.isDirectory()) {
                configFile = new File(confBase, this.log4jInitFile);
            }
        }
        if (configFile != null && configFile.exists()) {
            try {
                PropertyConfigurator.configure((URL)configFile.toURL());
            }
            catch (MalformedURLException e) {
                cat.error((Object)"Unable to initialize log4j.", (Throwable)e);
            }
        }
    }

    public void init(Object configurable) {
        Log4JAdapterConfig config = (Log4JAdapterConfig)((Configurable)configurable).narrow(class$com$systinet$wasp$monitoring$config$Log4JAdapterConfig == null ? (class$com$systinet$wasp$monitoring$config$Log4JAdapterConfig = Log4JAdapter.class$("com.systinet.wasp.monitoring.config.Log4JAdapterConfig")) : class$com$systinet$wasp$monitoring$config$Log4JAdapterConfig);
        this.log4jInitFile = config.getInitLog4jFromFile();
        this.initLog4J();
        this.defaultCategory = config.getDefaultCategoryName();
        this.defaultErrorCategory = config.getDefaultErrorCategoryName();
        this.writeStackTraces = config.isWriteStackTraces();
        String[] fileLogs = this.getLogFilePath(this.defaultCategory);
        int i = 0;
        while (i < fileLogs.length) {
            String fileLog = fileLogs[i];
            cat.info((Object)("Events Log File: " + fileLog));
            ++i;
        }
        String[] errorFileLogs = this.getLogFilePath(this.defaultErrorCategory);
        int i2 = 0;
        while (i2 < errorFileLogs.length) {
            String fileLog = errorFileLogs[i2];
            cat.info((Object)("Error Events Log File: " + fileLog));
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

