/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.monitoring;

import com.idoox.debug.CategoryListener;
import com.systinet.wasp.monitoring.events.LogEventServerLog;
import com.systinet.wasp.monitoring.events.LogEventUserLog;
import com.systinet.wasp.monitoring.events.WaspLogEvent;
import org.systinet.monitoring.EventManager;

public class FireEventLogListener
implements CategoryListener {
    int maxPriority = 3;

    public FireEventLogListener(int maxPriority) {
        this.maxPriority = maxPriority;
    }

    public FireEventLogListener() {
    }

    public void handle(boolean userEvent, int priority, String categoryName, String message, Throwable t) {
        if (priority > this.maxPriority) {
            return;
        }
        WaspLogEvent event = null;
        switch (priority) {
            case 1: {
                event = userEvent ? new LogEventUserLog(categoryName, 2000, message, t) : new LogEventServerLog(categoryName, 2000, message, t);
                EventManager.fireEvent(event);
                break;
            }
            case 3: {
                event = userEvent ? new LogEventUserLog(categoryName, 4000, message, t) : new LogEventServerLog(categoryName, 4000, message, t);
                EventManager.fireEvent(event);
                break;
            }
            case 4: {
                event = userEvent ? new LogEventUserLog(categoryName, 5000, message, t) : new LogEventServerLog(categoryName, 5000, message, t);
                EventManager.fireEvent(event);
                break;
            }
            case 2: {
                event = userEvent ? new LogEventUserLog(categoryName, 3000, message, t) : new LogEventServerLog(categoryName, 3000, message, t);
                EventManager.fireEvent(event);
                break;
            }
            case 0: {
                event = userEvent ? new LogEventUserLog(categoryName, 0, message, t) : new LogEventServerLog(categoryName, 0, message, t);
                EventManager.fireEvent(event);
            }
        }
    }

    public void handleLog(int priority, String categoryName, String message, Throwable t) {
        this.handle(false, priority, categoryName, message, t);
    }

    public int getMaxPriority() {
        return this.maxPriority;
    }

    public void setMaxPriority(int maxPriority) {
        this.maxPriority = maxPriority;
    }
}

