/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.errors;

import com.idoox.xml.LocationAwareXMLFilter;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorMsgHelper {
    public static String printSaxException(SAXException e) {
        if (e instanceof SAXParseException) {
            SAXParseException pe = (SAXParseException)e;
            return "Parse error " + ErrorMsgHelper.formatLocation(pe.getLineNumber(), pe.getColumnNumber()) + ": " + e.getMessage();
        }
        return "Parse error: " + e.getMessage();
    }

    public static String formatLocation(int line, int column) {
        return "at line " + line + ", column " + column;
    }

    public static String getNodeLocation(Node node, Map locations) {
        Object key;
        List nodeLocations;
        if (node != null && locations != null && (nodeLocations = (List)locations.get(key = LocationAwareXMLFilter.getKey(node.getNamespaceURI(), node.getLocalName(), node.getNodeName()))) != null) {
            if (nodeLocations.size() == 1) {
                Locator locator = (Locator)nodeLocations.get(0);
                if (locator != null) {
                    return ErrorMsgHelper.formatLocation(locator.getLineNumber(), locator.getColumnNumber());
                }
            } else {
                IndexHolder indexHolder;
                Element root = node.getOwnerDocument().getDocumentElement();
                if (ErrorMsgHelper.findElement(root, node, key, indexHolder = new IndexHolder(-1))) {
                    Locator locator = (Locator)nodeLocations.get(indexHolder.index);
                    if (locator != null) {
                        return ErrorMsgHelper.formatLocation(locator.getLineNumber(), locator.getColumnNumber());
                    }
                } else {
                    return "";
                }
            }
        }
        return "";
    }

    private static boolean findElement(Element element, Node node, Object key, IndexHolder indexHolder) {
        if (LocationAwareXMLFilter.getKey(element.getNamespaceURI(), element.getLocalName(), element.getNodeName()).equals(key)) {
            ++indexHolder.index;
            if (node == element) {
                return true;
            }
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && ErrorMsgHelper.findElement((Element)child, node, key, indexHolder)) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private static class IndexHolder {
        public int index;

        public IndexHolder(int index) {
            this.index = index;
        }
    }
}

