/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.dd.bc;

import com.systinet.wasp.dd.DeploymentDescriptorImpl;
import com.systinet.wasp.dd.ProcessingImpl;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.systinet.wasp.dd.Dependency;
import org.systinet.wasp.dd.DeploymentDescriptor;
import org.systinet.wasp.dd.DeploymentException;
import org.systinet.wasp.dd.DuplicatedNameException;
import org.systinet.wasp.dd.Processing;
import org.systinet.wasp.dd.Serialization;
import org.systinet.wasp.dd.TypeMapping;

public class DescriptorMigrator {
    public static String DEFAULT_WASP_SERIALIZATION_PACKAGE = "DefaultWASPSerialization";
    public static final String DEFAULT_WASP_SERIALIZATION_NS = "http://systinet.com/wasp";
    public static final String BASIC_SERIALIZATION = "BasicSerialization";
    public static final String DEFAULT_SERIALIZATION = "DefaultSerialization";
    public static final String MSMET_CONTAINERS_SERIALIZATION = "msNETContainersSerialization";
    public static final String APACHE_CONTAINERS_SERIALIZATION = "ApacheContainersSerialization";
    public static final String XML_MAPPING = "XmlMapping";
    public static final String MSNET_CONTAINERS_MAPPING = "msNETContainersMapping";
    public static final String MSNET_ARRAY_DESERIALIZER = "msNETArrayDeserializer";
    public static final String MSNET_ITERATOR_SERIALIZER = "msNETIteratorSerializer";
    public static final String MSNET_ENUMERATION_SERIALIZER = "msNETEnumerationSerializer";
    public static final String MSNET_HASHTABLE_SERIALIZER = "msNETHashtableSerializer";
    public static final String MSNET_TREEMAP_SERIALIZER = "msNETTreeMapSerializer";
    public static final String MSNET_SORTEDMAP_SERIALIZER = "msNETSortedMapSerializer";
    public static final String MSNET_HASHMAP_SERIALIZER = "msNETHashMapSerializer";
    public static final String MSNET_MAP_SERIALIZER = "msNETMapSerializer";
    public static final String MSNET_TREESET_SERIALIZER = "msNETTreeSetSerializer";
    public static final String MSNET_SORTEDSET_SERIALIZER = "msNETSortedSetSerializer";
    public static final String MSNET_HASHSET_SERIALIZER = "msNETHashSetSerializer";
    public static final String MSNET_SET_SERIALIZER = "msNETSetSerializer";
    public static final String MSNET_VECTOR_SERIALIZER = "msNETVectorSerializer";
    public static final String MSNET_LINKEDLIST_SERIALIZER = "msNETLinkedListSerializer";
    public static final String MSNET_ARRAYLIST_SERIALIZER = "msNETArrayListSerializer";
    public static final String MSNET_LIST_SERIALIZER = "msNETListSerializer";
    public static final String REQUEST_MESSAGEATACHMENT_SERIALIZER = "RequestMessageAttachmentSerializer";
    public static final String RESPONSE_MESSAGEATACHMENT_SERIALIZER = "ResponseMessageAttachmentSerializer";
    public static final String CLIENT_INTERREF_SERIALIZER = "ClientInterrefSerializer";
    public static final String XML_REFERENCE_SERIALIZER = "XMLReferenceSerializer";
    public static String BUILTIN_SERIALIZATION_PACKAGE = "builtin_serialization";
    public static final String BUILTIN_SERIALIZATION_NS = "http://systinet.com/wasp/app/builtin_serialization";
    public static final String BUILTIN_SERIALIZATION_VERSION = "1.0";
    public static final String ENCODED_SERIALIZATION = "EncodedSerialization";
    public static final String XML_SERIALIZATION = "XmlSerialization";
    public static final String APACHE_SERIALIZATION = "ApacheSerialization";
    public static final String BASIC_CONSTRUCT_SERIALIZER = "BasicConstructSerializer";
    public static final String REFLECTION_SERIALIZER = "ReflectionSerializer";
    public static final String XML_CONTAINERS_MAPPING = "XmlContainersMapping";
    public static final String CONTAINERS_MAPPING = "ContainersMapping";
    public static final String ARRAY_DESERIALIZER = "ArrayDeserializer";
    public static final String ITERATOR_SERIALIZER = "IteratorSerializer";
    public static final String ENUMERATION_SERIALIZER = "EnumerationSerializer";
    public static final String HASHTABLE_SERIALIZER = "HashtableSerializer";
    public static final String TREEMAP_SERIALIZER = "TreeMapSerializer";
    public static final String SORTEDMAP_SERIALIZER = "SortedMapSerializer";
    public static final String HASHMAP_SERIALIZER = "HashMapSerializer";
    public static final String MAP_SERIALIZER = "MapSerializer";
    public static final String TREESET_SERIALIZER = "TreeSetSerializer";
    public static final String SORTEDSET_SERIALIZER = "SortedSetSerializer";
    public static final String HASHSET_SERIALIZER = "HashSetSerializer";
    public static final String SET_SERIALIZER = "SetSerializer";
    public static final String VECTOR_SERIALIZER = "VectorSerializer";
    public static final String LINKEDLIST_SERIALIZER = "LinkedListSerializer";
    public static final String ARRAYLIST_SERIALIZER = "ArrayListSerializer";
    public static final String LIST_SERIALIZER = "ListSerializer";
    public static final String MESSAGEATACHMENT_SERIALIZER = "ResponseMessageAttachmentSerializer";
    public static final String INTERREF_SERIALIZER = "InterrefSerializer";
    public static final String XML_MESSAGEATACHMENT_DESERIALIZER = "XMLMessageAttachmentDeserializer";

    public static boolean migrate(DeploymentDescriptor dd) throws DeploymentException {
        if (dd == null) {
            return false;
        }
        if ("http://systinet.com/wasp/package/1.0".equals(dd.getNamespace()) && DescriptorMigrator.migrateDependency(dd)) {
            DescriptorMigrator.migrateSerializations(dd);
            DescriptorMigrator.migrateTypeMappings(dd);
            DescriptorMigrator.migrateProcessings(dd);
            return true;
        }
        return false;
    }

    private static boolean migrateDependency(DeploymentDescriptor dd) throws DeploymentException {
        Iterator dependencies = dd.getDependencies().iterator();
        Dependency dep = null;
        while (dependencies.hasNext()) {
            Dependency dependency = (Dependency)dependencies.next();
            if (!dependency.getReferredName().getLocalPart().equals(DEFAULT_WASP_SERIALIZATION_PACKAGE)) continue;
            dep = dependency;
        }
        if (dep != null) {
            ((DeploymentDescriptorImpl)dd).removeDependency(dep);
            try {
                dd.addDependency(new QName(BUILTIN_SERIALIZATION_NS, BUILTIN_SERIALIZATION_PACKAGE), BUILTIN_SERIALIZATION_VERSION);
            }
            catch (DuplicatedNameException e) {
                throw new DeploymentException("Cannot migrate package [" + dd.getTargetNamespace() + "][" + dd.getName() + "]", e);
            }
            return true;
        }
        return false;
    }

    private static void migrateProcessings(DeploymentDescriptor dd) {
        Iterator processings = dd.getProcessings().values().iterator();
        while (processings.hasNext()) {
            Processing processing = (Processing)processings.next();
            Iterator wholeMess = ((ProcessingImpl)processing).getWholeMess().iterator();
            ArrayList tmpMess = new ArrayList();
            boolean addEncodedSerialization = false;
            boolean addApacheSerialization = false;
            boolean addXmlSerialization = false;
            while (wholeMess.hasNext()) {
                Object o = wholeMess.next();
                if (o instanceof QName) {
                    if (((QName)o).getLocalPart().equals(BASIC_SERIALIZATION) || ((QName)o).getLocalPart().equals(DEFAULT_SERIALIZATION) || ((QName)o).getLocalPart().equals(MSMET_CONTAINERS_SERIALIZATION)) {
                        tmpMess.add(o);
                        addEncodedSerialization = true;
                    }
                    if (((QName)o).getLocalPart().equals(APACHE_CONTAINERS_SERIALIZATION)) {
                        tmpMess.add(o);
                        addApacheSerialization = true;
                    }
                    if (((QName)o).getLocalPart().equals(XML_SERIALIZATION)) {
                        tmpMess.add(o);
                        addXmlSerialization = true;
                    }
                }
                if (o instanceof Serialization) {
                    DescriptorMigrator.migrateSerialization((Serialization)o);
                }
                if (!(o instanceof TypeMapping)) continue;
                DescriptorMigrator.migrateTypeMapping((TypeMapping)o);
            }
            int i = 0;
            while (i < tmpMess.size()) {
                Object o = tmpMess.get(i);
                ((ProcessingImpl)processing).removeFromMess(o);
                ++i;
            }
            if (addEncodedSerialization) {
                ((ProcessingImpl)processing).addIntoMess(new QName(BUILTIN_SERIALIZATION_NS, ENCODED_SERIALIZATION));
            }
            if (addApacheSerialization) {
                ((ProcessingImpl)processing).addIntoMess(new QName(BUILTIN_SERIALIZATION_NS, APACHE_SERIALIZATION));
            }
            if (!addXmlSerialization) continue;
            ((ProcessingImpl)processing).addIntoMess(new QName(BUILTIN_SERIALIZATION_NS, XML_SERIALIZATION));
        }
    }

    private static void migrateSerializations(DeploymentDescriptor dd) {
        Iterator serializations = dd.getSerializations().values().iterator();
        while (serializations.hasNext()) {
            DescriptorMigrator.migrateSerialization((Serialization)serializations.next());
        }
    }

    private static void migrateSerialization(Serialization serialization) {
        QName[] followings;
        QName[] precedings = serialization.getPrecedingParts();
        if (precedings != null) {
            int i = 0;
            while (i < precedings.length) {
                QName preceding = precedings[i];
                if (preceding.getNamespaceURI().equals(DEFAULT_WASP_SERIALIZATION_NS)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, preceding.getLocalPart());
                }
                if (preceding.getLocalPart().equals(BASIC_SERIALIZATION)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, BASIC_CONSTRUCT_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(DEFAULT_SERIALIZATION)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, REFLECTION_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(APACHE_CONTAINERS_SERIALIZATION)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, APACHE_SERIALIZATION);
                }
                if (preceding.getLocalPart().equals(MSMET_CONTAINERS_SERIALIZATION)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, REFLECTION_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_ARRAY_DESERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, ARRAY_DESERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_ITERATOR_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, ITERATOR_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_ENUMERATION_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, ENUMERATION_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_HASHTABLE_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, HASHTABLE_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_TREEMAP_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, TREEMAP_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_SORTEDMAP_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, SORTEDMAP_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_HASHMAP_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, HASHMAP_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_MAP_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, MAP_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_TREESET_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, TREESET_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_SORTEDSET_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, SORTEDSET_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_HASHSET_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, HASHSET_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_SET_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, SET_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_VECTOR_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, VECTOR_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_LINKEDLIST_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, LINKEDLIST_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_ARRAYLIST_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, ARRAYLIST_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(MSNET_LIST_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, LIST_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(REQUEST_MESSAGEATACHMENT_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, "ResponseMessageAttachmentSerializer");
                }
                if (preceding.getLocalPart().equals("ResponseMessageAttachmentSerializer")) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, "ResponseMessageAttachmentSerializer");
                }
                if (preceding.getLocalPart().equals(CLIENT_INTERREF_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, INTERREF_SERIALIZER);
                }
                if (preceding.getLocalPart().equals(XML_REFERENCE_SERIALIZER)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, XML_MESSAGEATACHMENT_DESERIALIZER);
                }
                ++i;
            }
            serialization.setPrecedingParts(precedings);
        }
        if ((followings = serialization.getFollowingParts()) != null) {
            int i = 0;
            while (i < followings.length) {
                QName following = followings[i];
                if (following.getNamespaceURI().equals(DEFAULT_WASP_SERIALIZATION_NS)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, following.getLocalPart());
                }
                if (following.getLocalPart().equals(DEFAULT_SERIALIZATION)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, REFLECTION_SERIALIZER);
                }
                if (following.getLocalPart().equals(BASIC_SERIALIZATION)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, BASIC_CONSTRUCT_SERIALIZER);
                }
                if (following.getLocalPart().equals(APACHE_CONTAINERS_SERIALIZATION)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, APACHE_SERIALIZATION);
                }
                if (following.getLocalPart().equals(MSMET_CONTAINERS_SERIALIZATION)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, REFLECTION_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_ARRAY_DESERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, ARRAY_DESERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_ITERATOR_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, ITERATOR_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_ENUMERATION_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, ENUMERATION_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_HASHTABLE_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, HASHTABLE_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_TREEMAP_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, TREEMAP_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_SORTEDMAP_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, SORTEDMAP_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_HASHMAP_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, HASHMAP_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_MAP_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, MAP_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_TREESET_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, TREESET_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_SORTEDSET_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, SORTEDSET_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_HASHSET_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, HASHSET_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_SET_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, SET_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_VECTOR_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, VECTOR_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_LINKEDLIST_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, LINKEDLIST_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_ARRAYLIST_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, ARRAYLIST_SERIALIZER);
                }
                if (following.getLocalPart().equals(MSNET_LIST_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, LIST_SERIALIZER);
                }
                if (following.getLocalPart().equals(REQUEST_MESSAGEATACHMENT_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, "ResponseMessageAttachmentSerializer");
                }
                if (following.getLocalPart().equals("ResponseMessageAttachmentSerializer")) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, "ResponseMessageAttachmentSerializer");
                }
                if (following.getLocalPart().equals(CLIENT_INTERREF_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, INTERREF_SERIALIZER);
                }
                if (following.getLocalPart().equals(XML_REFERENCE_SERIALIZER)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, XML_MESSAGEATACHMENT_DESERIALIZER);
                }
                ++i;
            }
            serialization.setFollowingParts(followings);
        }
    }

    private static void migrateTypeMappings(DeploymentDescriptor dd) {
        Iterator typeMappings = dd.getTypeMappings().values().iterator();
        while (typeMappings.hasNext()) {
            DescriptorMigrator.migrateTypeMapping((TypeMapping)typeMappings.next());
        }
    }

    private static void migrateTypeMapping(TypeMapping typeMapping) {
        QName[] followings;
        QName[] precedings = typeMapping.getPrecedingParts();
        if (precedings != null) {
            int i = 0;
            while (i < precedings.length) {
                QName preceding = precedings[i];
                if (preceding.getNamespaceURI().equals(DEFAULT_WASP_SERIALIZATION_NS)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, preceding.getLocalPart());
                }
                if (preceding.getLocalPart().equals(XML_MAPPING)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, XML_CONTAINERS_MAPPING);
                }
                if (preceding.getLocalPart().equals(MSNET_CONTAINERS_MAPPING)) {
                    precedings[i] = new QName(BUILTIN_SERIALIZATION_NS, CONTAINERS_MAPPING);
                }
                ++i;
            }
            typeMapping.setPrecedingParts(precedings);
        }
        if ((followings = typeMapping.getFollowingParts()) != null) {
            int i = 0;
            while (i < followings.length) {
                QName following = followings[i];
                if (following.getNamespaceURI().equals(DEFAULT_WASP_SERIALIZATION_NS)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, following.getLocalPart());
                }
                if (following.getLocalPart().equals(XML_MAPPING)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, XML_CONTAINERS_MAPPING);
                }
                if (following.getLocalPart().equals(MSNET_CONTAINERS_MAPPING)) {
                    followings[i] = new QName(BUILTIN_SERIALIZATION_NS, CONTAINERS_MAPPING);
                }
                ++i;
            }
            typeMapping.setFollowingParts(followings);
        }
    }
}

