/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.dd;

import com.idoox.debug.Category;
import com.idoox.util.xml.DOMWriter;
import com.idoox.wasp.Constants;
import com.systinet.wasp.admin.PackageHelper;
import com.systinet.wasp.dd.AttributesImpl;
import com.systinet.wasp.dd.DeploymentPartImpl;
import com.systinet.wasp.dd.DescriptorHelper;
import com.systinet.wasp.dd.HandlerImpl;
import com.systinet.wasp.dd.HeaderProcessorImpl;
import com.systinet.wasp.dd.PolicyAssertionImpl;
import com.systinet.wasp.dd.ProcessingImpl;
import com.systinet.wasp.dd.xml.XMLUtils;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.systinet.wasp.dd.ConfigurablePart;
import org.systinet.wasp.dd.Configuration;
import org.systinet.wasp.dd.Dependency;
import org.systinet.wasp.dd.DeploymentDescriptor;
import org.systinet.wasp.dd.DeploymentException;
import org.systinet.wasp.dd.DeploymentPart;
import org.systinet.wasp.dd.ExtensiblePart;
import org.systinet.wasp.dd.FaultSerialization;
import org.systinet.wasp.dd.Handler;
import org.systinet.wasp.dd.Header;
import org.systinet.wasp.dd.HeaderProcessor;
import org.systinet.wasp.dd.Interceptor;
import org.systinet.wasp.dd.Listener;
import org.systinet.wasp.dd.Module;
import org.systinet.wasp.dd.Processing;
import org.systinet.wasp.dd.Schema;
import org.systinet.wasp.dd.Serialization;
import org.systinet.wasp.dd.ServiceClient;
import org.systinet.wasp.dd.ServiceEndpoint;
import org.systinet.wasp.dd.ServiceInstance;
import org.systinet.wasp.dd.Transport;
import org.systinet.wasp.dd.TypeMapping;
import org.systinet.wasp.webservice.PublishException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DescriptorConverter {
    private static final Category cat = Category.getCategory("com.systinet.wasp.dd.DescriptorConverter");
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_SERVICE = "service";
    public static final String ATTR_ADAPTOR = "adaptor";
    public static final String ATTR_CLASSREF = "classRef";
    public static final String ATTR_PROTOCOL = "protocol";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_FAULT_CODE = "faultCode";
    public static final String ATTR_FAULT_ACTOR = "faultActor";
    public static final String ATTR_FIRST_DETAIL_ELEMENT = "firstDetailElement";
    public static final String ATTR_IMPORT = "import";
    public static final String ATTR_FAULT_SERIALIZATION = "faultSerialization";
    public static final String ATTR_SERIALIZATION = "serialization";
    public static final String ATTR_INSTANCE = "instance";
    public static final String ATTR_IN = "in";
    public static final String ATTR_OUT = "out";
    public static final String ATTR_TRANSPORT_INTERCEPTORS = "transportInterceptors";
    public static final String ATTR_TRANSPORT_FAULT_SERIALIZATIONS = "transportFaultSerializations";
    public static final String ATTR_LOADER = "loader";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_SIGNATURE = "signature";
    public static final String ATTR_OPERATION_NAME = "operationName";
    public static final String ATTR_INPUT_NAME = "inputName";
    public static final String ATTR_OUTPUT_NAME = "outputName";
    public static final String ATTR_XMLNS = "xmlns";
    public static final String ATTR_CLASS_SPACE = "classSpace";
    public static final String ATTR_PARENT_CLASS_SPACE = "parentClassSpace";
    public static final String ATTR_HEADERS = "headers";
    public static final String ATTR_HANDLERS = "handlers";
    public static final String ATTR_NEEDS_BODY = "needsBody";
    public static final String ATTR_DD_ORDER = "ddOrder";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_AUTHOR = "author";
    public static final String ATTR_LIBRARY = "library";
    public static final String ATTR_HAS_CLIENT_PACKAGE = "hasClientPackage";
    public static final String ATTR_DEFAULT_TTL = "defaultTTL";
    public static final String ATTR_PRELOAD = "preload";
    public static final String ATTR_DEFAULT_SERVER = "defaultServer";
    public static final String ATTR_MAX_INSTANCES = "maxInstances";
    public static final String ATTR_AUTOMATICALLY_INSTANTIATED = "automaticallyInstantiated";
    public static final String ATTR_NAMESPACE_URI = "namespaceURI";
    public static final String ATTR_LOCATION_URL = "locationURL";
    public static final String ATTR_SCHEMA_LOCATION_URL = "schemaLocation";
    public static final String ATTR_LANGUAGE = "language";
    public static final String ATTR_MAPS_TO = "mapsTo";
    public static final String ATTR_ASYNC_PROTOCOL = "asyncProtocol";
    public static final String ATTR_ASYNC_TIMEOUT = "asyncTimeout";
    public static final String ATTR_REF = "ref";
    public static final String ATTR_DISABLED = "disabled";
    public static final String ATTR_ENCODING = "encoding";
    public static final String ATTR_USE = "use";
    public static final String ATTR_ENCODING_STYLE = "encodingStyle";
    public static final String ATTR_ELEMENT = "element";
    public static final String ATTR_LOCATION = "location";
    public static final String ATTR_DIRECTION = "direction";
    public static final String ATTR_NAMESPACE = "namespace";
    public static final String ATTR_INTERFACE = "interface";
    public static final String ATTR_SCHEME = "scheme";
    public static final String ATTR_SERVICE_URL = "serviceURL";
    public static final String ATTR_QNAME = "qname";
    public static final String ELEMENT_CLASS_SPACE = "classSpace";
    public static final String ELEMENT_PARENT_CLASS_SPACE = "parentClassSpace";
    public static final String ELEMENT_SERVICE_INSTANCE = "ServiceInstance";
    public static final String ELEMENT_SERVICE_BINDING = "ServiceBinding";
    public static final String ELEMENT_GET_SERVICE_BINDING = "GetServiceBinding";
    public static final String ELEMENT_SERIALIZER = "serializer";
    public static final String ELEMENT_DESERIALIZER = "deserializer";
    public static final String ELEMENT_FAULT_SERIALIZATION = "faultSerialization";
    public static final String ELEMENT_SERIALIZATION = "serialization";
    public static final String ELEMENT_FAULT_SERIALIZATION_INSTANCE = "faultSerializationInstance";
    public static final String ELEMENT_SERIALIZATION_INSTANCE = "serializationInstance";
    public static final String ELEMENT_SERIALIZED_CLASS = "serializedClass";
    public static final String ELEMENT_EXCEPTION = "exception";
    public static final String ELEMENT_FAULT = "fault";
    public static final String ELEMENT_IMPORT = "import";
    public static final String ELEMENT_WASP_CONFIG = "config";
    public static final String ELEMENT_INTERCEPTOR = "interceptor";
    public static final String ELEMENT_INTERCEPTOR_CHAIN = "InterceptorChain";
    public static final String ELEMENT_MODULE = "module";
    public static final String ELEMENT_TRANSPORT = "transport";
    public static final String ELEMENT_HEADERS = "Headers";
    public static final String ELEMENT_HANDLERS = "Handlers";
    public static final String ELEMENT_HEADER_INSTANCE = "HeaderInstance";
    public static final String ELEMENT_HANDLER_INSTANCE = "HandlerInstance";
    public static final String ELEMENT_HEADER = "header";
    public static final String ELEMENT_HANDLER = "handler";
    public static final String ELEMENT_IN = "in";
    public static final String ELEMENT_OUT = "out";
    public static final String ELEMENT_IN_FAULT = "inFault";
    public static final String ELEMENT_OUT_FAULT = "outFault";
    public static final String ELEMENT_INSTANCE = "instance";
    public static final String ELEMENT_UNDERSTANDS = "understandHeaders";
    public static final String ELEMENT_MESSAGE_HEADER = "messageHeader";
    public static final String ELEMENT_SERVICE_CONFIG = "ServiceConfig";
    public static final String ELEMENT_SERVICE_TYPE_CONFIG = "ServiceTypeConfig";
    public static final String ELEMENT_SCHEMA_PATH = "schemaPath";
    public static final String ELEMENT_ELEMENT = "element";
    public static final String ELEMENT_WSDL = "wsdl";
    public static final String ELEMENT_PACKAGE = "package";
    public static final String ELEMENT_DESCRIPTION = "description";
    public static final String ELEMENT_DEPENDENCY = "dependency";
    public static final String ELEMENT_SCHEMA = "schema";
    public static final String ELEMENT_MAPPING = "mapping";
    public static final String ELEMENT_TYPE = "type";
    public static final String ELEMENT_SCHEMA_REPOSITORY = "schemaRepository";
    public static final String ELEMENT_INITIATING_SECURITY_PROVIDER = "initiatingSecurityProvider";
    public static final String ELEMENT_ACCEPTING_SECURITY_PROVIDER = "acceptingSecurityProvider";
    public static final String ELEMENT_SECURITY_PROVIDER = "securityProvider";
    public static final String ELEMENT_LISTENER = "listener";
    public static final String ELEMENT_POLICY_ELEMENT = "policyAssertion";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_IN = "in";
    public static final String VALUE_OUT = "out";
    public static final String VALUE_FAULT = "fault";
    public static final String VALUE_INOUT = "inout";
    public static final String VALUE_SOAP12 = "soap12";
    public static final String VALUE_SOAP12_DEFAULT_FAULT_SERIALIZATION = "SOAP12SpecFaultsSerialization";
    public static final String VALUE_SCHEMATA_SUFFIX = "Schemata";
    public static final String VALUE_DEFAULT_PROCESSING_SUFFIX = "DefaultProcessing";
    public static final String DEFAULT_SERIALIZATION = "[system][http://systinet.com/wasp/app/builtin_serialization][ApacheSerialization]";
    public static final String DEFAULT_FAULT_SERIALIZATION = "defaultFaultSerialization";
    public static final String DEFAULT_SOAP12SPEC_FAULTS_SERIALIZATION = "SOAP12SpecFaultsSerialization";
    public static final String SERVER_TRANSPORT_INTERCEPTORS = "serverTransportInterceptors";
    public static final String CLIENT_TRANSPORT_INTERCEPTORS = "clientTransportInterceptors";
    public static final String CLASS_SPACE = "root.services";
    public static final String ADAPTOR_JAVA = "JavaAdaptor";
    public static final String ADAPTOR_XML = "XmlAdaptor";
    public static final String ADAPTOR_RAW = "RawAdaptor";
    private static int counter;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$ServiceEndpointListener;

    public static void ddToConfig(DeploymentDescriptor dd, OutputStream configXml, String context, String systemContext, ClassLoader classLoader, boolean disabled) throws IOException, DeploymentException, PublishException {
        try {
            counter = 0;
            String namespace = dd.getTargetNamespace();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(ELEMENT_WASP_CONFIG);
            root.setAttribute(ATTR_NAME, DescriptorConverter.encodeName(context, namespace, dd.getName()));
            doc.appendChild(root);
            String classSpaceName = DescriptorConverter.classSpaceToDOM(context, dd, root, doc);
            DescriptorConverter.addNamespaces(dd, root);
            Iterator it = dd.getInterceptors().values().iterator();
            while (it.hasNext()) {
                DescriptorConverter.interceptorToDOM((Interceptor)it.next(), context, namespace, doc, dd, classSpaceName);
            }
            Iterator it2 = dd.getListeners().values().iterator();
            while (it2.hasNext()) {
                DescriptorConverter.listenerToDOM((Listener)it2.next(), context, namespace, doc, dd, classSpaceName);
            }
            Iterator it3 = dd.getPolicyAssertions().values().iterator();
            while (it3.hasNext()) {
                DescriptorConverter.policyAssertionToDOM((PolicyAssertionImpl)it3.next(), doc, classSpaceName);
            }
            Iterator it4 = dd.getSerializations().values().iterator();
            while (it4.hasNext()) {
                DescriptorConverter.serializationToDOM((Serialization)it4.next(), context, doc, dd, classSpaceName, true);
            }
            Iterator it5 = dd.getServiceInstances().values().iterator();
            while (it5.hasNext()) {
                DescriptorConverter.serviceInstanceToDOM((ServiceInstance)it5.next(), context, disabled, doc, classSpaceName);
            }
            Iterator it6 = dd.getServiceEndpoints().values().iterator();
            while (it6.hasNext()) {
                DescriptorConverter.serviceEndpointToDOM((ServiceEndpoint)it6.next(), context, systemContext, namespace, doc, dd, classSpaceName, classLoader);
            }
            Iterator it7 = dd.getServiceClients().iterator();
            while (it7.hasNext()) {
                DescriptorConverter.serviceClientToDOM((ServiceClient)it7.next(), context, namespace, doc, dd, classSpaceName);
            }
            Iterator it8 = dd.getFaultSerializations().values().iterator();
            while (it8.hasNext()) {
                DescriptorConverter.faultSerializationToDOM((FaultSerialization)it8.next(), context, namespace, doc, dd, classSpaceName);
            }
            DescriptorConverter.modulesToDOM(dd.getModules(), context, namespace, doc, classSpaceName);
            DescriptorConverter.transportsToDOM(dd.getTransports(), context, namespace, doc, classSpaceName);
            HashSet<Processing> localUnusedProcessings = new HashSet<Processing>();
            Iterator processings = dd.getProcessings().values().iterator();
            while (processings.hasNext()) {
                Processing processing = (Processing)processings.next();
                if (!DescriptorConverter.isLocal(processing, namespace)) continue;
                localUnusedProcessings.add(processing);
            }
            Iterator services = dd.getServiceEndpoints().values().iterator();
            while (services.hasNext()) {
                localUnusedProcessings.remove(((ServiceEndpoint)services.next()).getProcessing());
            }
            Iterator serviceClients = dd.getServiceClients().iterator();
            while (serviceClients.hasNext()) {
                localUnusedProcessings.remove(((ServiceClient)serviceClients.next()).getProcessing());
            }
            Iterator processings2 = dd.getProcessings().values().iterator();
            while (processings2.hasNext()) {
                Processing processing = (Processing)processings2.next();
                if (!localUnusedProcessings.contains(processing)) continue;
                DescriptorConverter.processingToDOM(processing, null, context, namespace, doc, dd, classSpaceName, true);
            }
            DescriptorConverter.addExtension(dd, root, doc);
            DescriptorConverter.addConfiguration(dd, root, doc);
            DOMWriter.serialize(doc, configXml, Constants.UTF_8, true);
        }
        catch (ParserConfigurationException e) {
            throw new DeploymentException(e);
        }
    }

    private static String generateName(String context, String namespace, String prefix) {
        return DescriptorConverter.encodeName(prefix, context, namespace, Integer.toString(++counter));
    }

    public static String encodeName(String context, QName qname) {
        return DescriptorConverter.encodeName(null, context, qname.getNamespaceURI(), qname.getLocalPart());
    }

    private static String encodeNameQuote(String name) {
        if (name == null) {
            return "]I";
        }
        if (name.equals("")) {
            return "]{";
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == ']') {
                result.append("]|");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String encodeName(String context, String targetNamespace, String name) {
        return DescriptorConverter.encodeName(null, context, targetNamespace, name);
    }

    private static String encodeName(String prefix, String context, String targetNamespace, String name) {
        if (context == null && targetNamespace == null) {
            return name;
        }
        return "[" + (prefix == null ? "" : DescriptorConverter.encodeNameQuote(prefix) + "](") + DescriptorConverter.encodeNameQuote(context) + "][" + DescriptorConverter.encodeNameQuote(targetNamespace) + "][" + DescriptorConverter.encodeNameQuote(name) + "]";
    }

    public static void decodeName(String name, NameHolder holder) {
        if (holder == null) {
            return;
        }
        holder.targetNamespace = null;
        holder.name = null;
        holder.context = null;
        if (name == null || name.equals("")) {
            holder.name = name;
            return;
        }
        boolean unwraped = false;
        if (name.charAt(0) != '[' || name.charAt(name.length() - 1) != ']') {
            holder.name = name;
            return;
        }
        name = name.substring(1, name.length() - 1);
        unwraped = true;
        StringTokenizer stringTokenizer = new StringTokenizer(name, "]", false);
        StringBuffer sb = new StringBuffer();
        int type = 1;
        String token = null;
        int tokenType = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (token == null) {
                token = stringTokenizer.nextToken();
                if (name.charAt(0) != ']') {
                    sb.append(token);
                    continue;
                }
            } else {
                token = stringTokenizer.nextToken();
            }
            if (token.length() <= 0) continue;
            switch (token.charAt(0)) {
                case '(': {
                    tokenType = 0;
                    sb = new StringBuffer();
                    sb.append(token.substring(1));
                    break;
                }
                case '|': {
                    sb.append("]" + token.substring(1));
                    break;
                }
                case '{': {
                    tokenType = 1;
                    break;
                }
                case 'I': {
                    tokenType = 2;
                    break;
                }
                case ']': {
                    break;
                }
                case '[': {
                    block8 : switch (type) {
                        case 1: {
                            switch (tokenType) {
                                case 0: {
                                    holder.context = sb.toString();
                                    break;
                                }
                                case 1: {
                                    holder.context = "";
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (tokenType) {
                                case 0: {
                                    holder.targetNamespace = sb.toString();
                                    break block8;
                                }
                                case 1: {
                                    holder.targetNamespace = "";
                                }
                            }
                        }
                    }
                    sb = new StringBuffer();
                    sb.append(token.substring(1));
                    ++type;
                    tokenType = 0;
                    break;
                }
                default: {
                    sb.append(token);
                }
            }
        }
        if (type == 1 || type == 3) {
            if (tokenType != 2) {
                holder.name = unwraped && type == 1 ? "[" + sb.toString() + "]" : sb.toString();
            }
        } else {
            holder.context = null;
            holder.targetNamespace = null;
            holder.name = null;
        }
    }

    public static String ddEndpointToConfigEndpoint(String context, String path) {
        if (context.length() == 0 && path.charAt(0) != '/') {
            return context + path;
        }
        if (context.length() == 0 || context.charAt(0) != '/') {
            context = "/" + context;
        }
        if (context.charAt(context.length() - 1) == '/') {
            if (path.charAt(0) == '/') {
                return context + path.substring(1);
            }
            return context + path;
        }
        if (path.charAt(0) == '/') {
            return context + path;
        }
        return context + "/" + path;
    }

    private static void serviceInstanceToDOM(ServiceInstance sI, String context, boolean disabled, Document doc, String classSpaceName) {
        Element root = doc.getDocumentElement();
        String name = DescriptorConverter.encodeName(context, sI.getName());
        Element el = doc.createElement(ELEMENT_SERVICE_INSTANCE);
        el.setAttribute(ATTR_NAME, name);
        String implClassName = sI.getImplementationClass();
        el.setAttribute(ATTR_CLASS, implClassName);
        el.setAttribute("classSpace", classSpaceName);
        if (disabled) {
            el.setAttribute(ATTR_DISABLED, VALUE_TRUE);
        }
        root.appendChild(el);
        if (sI.getAttributes() != null) {
            Element e = ((AttributesImpl)sI.getAttributes()).getElement();
            el.appendChild(XMLUtils.cloneElement(e, doc));
        }
        DescriptorConverter.addNamespaces(sI, el);
        DescriptorConverter.addExtension(sI, el, doc);
        DescriptorConverter.addConfiguration(sI, el, doc);
    }

    private static void serviceEndpointToDOM(ServiceEndpoint s, String context, String systemContext, String namespace, Document doc, DeploymentDescriptor localDD, String classSpaceName, ClassLoader classLoader) throws DeploymentException, PublishException {
        String adaptor = null;
        if (s.getServiceInstance() != null) {
            Processing p;
            List acceptProviders;
            Integer maxInstances;
            String version;
            Element root = doc.getDocumentElement();
            ServiceInstance serviceInstance = s.getServiceInstance();
            boolean endpointListenerAutoPreload = false;
            switch (s.getServiceType()) {
                case 0: {
                    adaptor = ADAPTOR_JAVA;
                    break;
                }
                case 1: {
                    adaptor = ADAPTOR_XML;
                    break;
                }
                case 2: {
                    adaptor = ADAPTOR_RAW;
                    break;
                }
                default: {
                    adaptor = ADAPTOR_JAVA;
                    if (classLoader == null) break;
                    String ifaceName = s.getInterface();
                    if (ifaceName == null) {
                        ifaceName = s.getServiceInstance().getImplementationClass();
                    }
                    if (ifaceName == null) break;
                    try {
                        Class<?> iface = classLoader.loadClass(ifaceName);
                        switch (ServiceEndpointImpl.resolveServiceType(iface)) {
                            case 1: {
                                adaptor = ADAPTOR_XML;
                                break;
                            }
                            case 2: {
                                adaptor = ADAPTOR_RAW;
                            }
                        }
                        if (!(class$org$systinet$wasp$webservice$ServiceEndpointListener == null ? (class$org$systinet$wasp$webservice$ServiceEndpointListener = DescriptorConverter.class$("org.systinet.wasp.webservice.ServiceEndpointListener")) : class$org$systinet$wasp$webservice$ServiceEndpointListener).isAssignableFrom(iface)) break;
                        endpointListenerAutoPreload = true;
                        break;
                    }
                    catch (ClassNotFoundException ignore) {
                        break;
                    }
                    catch (NoClassDefFoundError ignore) {
                        // empty catch block
                    }
                }
            }
            Element el = doc.createElement(ELEMENT_SERVICE_BINDING);
            String path = s.getPath();
            if (path.indexOf(35) != -1) {
                throw new DeploymentException("Service-endpoint path can not contain '#' character (error in path \"" + path + "\").");
            }
            String tmpContext = context;
            if (context.equals(systemContext)) {
                tmpContext = "";
            }
            String name = (version = s.getVersion()) == null ? path : (path.charAt(path.length() - 1) == '/' ? path + version + '/' : path + '/' + version);
            el.setAttribute(ATTR_NAME, DescriptorConverter.ddEndpointToConfigEndpoint(tmpContext, name));
            if (version != null) {
                el.setAttribute(ATTR_VERSION, version);
            }
            if (s.getXMLProtocol() != null && s.getXMLProtocol().length() != 0) {
                el.setAttribute(ATTR_PROTOCOL, s.getXMLProtocol());
            }
            el.setAttribute(ATTR_CLASSREF, DescriptorConverter.encodeName(context, serviceInstance.getName()));
            el.setAttribute(ATTR_ADAPTOR, adaptor);
            Integer defaultTTL = serviceInstance.getTTL();
            if (defaultTTL != null) {
                el.setAttribute(ATTR_DEFAULT_TTL, defaultTTL.toString());
            }
            if (serviceInstance.isPreload() || endpointListenerAutoPreload) {
                el.setAttribute(ATTR_PRELOAD, VALUE_TRUE);
            }
            if ((maxInstances = serviceInstance.getMaxInstances()) != null) {
                el.setAttribute(ATTR_MAX_INSTANCES, maxInstances.toString());
            }
            boolean autoInstantiated = serviceInstance.getInstantiationMethod() == 1;
            el.setAttribute(ATTR_AUTOMATICALLY_INSTANTIATED, autoInstantiated ? VALUE_TRUE : VALUE_FALSE);
            Element wsdl = doc.createElement(ELEMENT_WSDL);
            String piece = "";
            if (s.getWsdlURI() != null) {
                if (s.getWsdlURI().startsWith("WASP-INF/") || s.getWsdlURI().startsWith("WASP-INF/wsdl/")) {
                    StringTokenizer st = new StringTokenizer(s.getWsdlURI(), "/");
                    while (st.hasMoreTokens()) {
                        piece = st.nextToken();
                    }
                    piece = "WASP-INF/wsdl/" + piece;
                } else {
                    piece = "WASP-INF/wsdl/" + s.getWsdlURI();
                }
                wsdl.setAttribute(ATTR_FILE, piece);
            }
            if (s.getWsdlServiceQName() != null) {
                String ns = XMLUtils.findOrGenerateNamespaceAlias(wsdl, s.getWsdlServiceQName().getNamespaceURI(), "wsdlns");
                wsdl.setAttribute(ATTR_SERVICE, ns + ":" + s.getWsdlServiceQName().getLocalPart());
            }
            el.appendChild(wsdl);
            if (s.getAttributes() != null) {
                Element e = ((AttributesImpl)s.getAttributes()).getElement();
                el.appendChild(XMLUtils.cloneElement(e, doc));
            }
            if (s.getInterface() != null) {
                el.setAttribute(ATTR_INTERFACE, s.getInterface());
            }
            if (s.getURL() != null) {
                el.setAttribute(ATTR_SERVICE_URL, s.getURL());
            }
            if (s.getInitiatingSecurityProvider() != null && s.getInitiatingSecurityProvider().length() != 0) {
                Element initProvider = doc.createElement(ELEMENT_INITIATING_SECURITY_PROVIDER);
                initProvider.appendChild(doc.createTextNode(s.getInitiatingSecurityProvider()));
                el.appendChild(initProvider);
            }
            if ((acceptProviders = s.getAcceptingSecurityProviders()) != null) {
                Iterator iterator = acceptProviders.iterator();
                while (iterator.hasNext()) {
                    String acceptProvider = (String)iterator.next();
                    if (acceptProvider == null || acceptProvider.length() == 0) continue;
                    Element elAcceptProvider = doc.createElement(ELEMENT_ACCEPTING_SECURITY_PROVIDER);
                    elAcceptProvider.appendChild(doc.createTextNode(acceptProvider));
                    el.appendChild(elAcceptProvider);
                }
            }
            DescriptorConverter.processingToDOM(p, el, context, namespace, doc, localDD, classSpaceName, (p = s.getProcessing()) == null || DescriptorConverter.isLocal(p, namespace));
            DescriptorConverter.listenersToDOM(localDD.getListeners(), s.getListeners(), context, namespace, el, doc);
            DescriptorConverter.addSoap12Defaults(s.getXMLProtocol(), el);
            DescriptorConverter.addNamespaces(s, el);
            DescriptorConverter.addExtension(s, el, doc);
            DescriptorConverter.addConfiguration(s, el, doc);
            root.appendChild(el);
            if (adaptor == ADAPTOR_RAW) {
                root.appendChild(DescriptorConverter.cloneAndRename(doc, el, ELEMENT_GET_SERVICE_BINDING));
            }
        }
    }

    private static void addSoap12Defaults(String protocol, Element bindingElement) {
        if (VALUE_SOAP12.equals(protocol) && bindingElement.getAttribute("faultSerialization").length() == 0) {
            bindingElement.setAttribute("faultSerialization", "SOAP12SpecFaultsSerialization");
        }
    }

    private static Element cloneAndRename(Document doc, Element src, String newName) {
        Element dst = doc.createElement(newName);
        NamedNodeMap attributes = src.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            dst.setAttributeNode((Attr)attributes.item(i).cloneNode(true));
            ++i;
        }
        NodeList childNodes = src.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            dst.appendChild(childNodes.item(i2).cloneNode(true));
            ++i2;
        }
        return dst;
    }

    private static void serviceClientToDOM(ServiceClient cs, String context, String namespace, Document doc, DeploymentDescriptor deploymentDescriptor, String classSpaceName) throws PublishException {
        Processing p;
        Element el;
        Element root = doc.getDocumentElement();
        if (cs.getServicePortType() == null) {
            el = doc.createElement(ELEMENT_SERVICE_CONFIG);
            el.setAttribute(ATTR_NAME, cs.getServiceURL().toExternalForm());
        } else {
            el = doc.createElement(ELEMENT_SERVICE_TYPE_CONFIG);
            QName name = cs.getServicePortType();
            el.setAttribute(ATTR_NAME, name.getNamespaceURI() + ":" + name.getLocalPart());
        }
        root.appendChild(el);
        if (cs.getXMLProtocol() != null && cs.getXMLProtocol().length() != 0) {
            el.setAttribute(ATTR_PROTOCOL, cs.getXMLProtocol());
        }
        if (cs.getInitiatingSecurityProvider() != null && cs.getInitiatingSecurityProvider().length() != 0) {
            Element initProvider = doc.createElement(ELEMENT_SECURITY_PROVIDER);
            initProvider.appendChild(doc.createTextNode(cs.getInitiatingSecurityProvider()));
            el.appendChild(initProvider);
        }
        if (cs.getAsyncTransport() != null) {
            el.setAttribute(ATTR_ASYNC_PROTOCOL, cs.getAsyncTransport());
        }
        if (cs.getAsyncTimeout() != null) {
            el.setAttribute(ATTR_ASYNC_TIMEOUT, cs.getAsyncTimeout().toString());
        }
        DescriptorConverter.processingToDOM(p, el, context, namespace, doc, deploymentDescriptor, classSpaceName, (p = cs.getProcessing()) == null || DescriptorConverter.isLocal(p, namespace));
        DescriptorConverter.listenersToDOM(deploymentDescriptor.getListeners(), cs.getListeners(), context, namespace, el, doc);
        DescriptorConverter.addSoap12Defaults(cs.getXMLProtocol(), el);
        DescriptorConverter.addNamespaces(cs, el);
        DescriptorConverter.addExtension(cs, el, doc);
        DescriptorConverter.addConfiguration(cs, el, doc);
        if (cs.getAttributes() != null) {
            Element e = ((AttributesImpl)cs.getAttributes()).getElement();
            el.appendChild(XMLUtils.cloneElement(e, doc));
        }
    }

    private static void faultSerializationToChain(FaultSerialization fs, String context, String namespace, Document doc, Element chain, DeploymentDescriptor localDD, String classSpaceName) {
        if ("".equals(fs.getName().getLocalPart())) {
            chain.appendChild(DescriptorConverter.faultSerializationInstanceToDOM(fs, doc, classSpaceName));
        } else {
            String name = DescriptorConverter.faultSerializationToDOM(fs, context, namespace, doc, localDD, classSpaceName);
            Element elRef = doc.createElement("import");
            elRef.setAttribute(ATTR_REF, name);
            chain.appendChild(elRef);
        }
    }

    private static String faultSerializationToDOM(FaultSerialization fs, String context, String namespace, Document doc, DeploymentDescriptor localDD, String classSpaceName) {
        String iContext = DescriptorConverter.importedContext(fs, context, localDD);
        if (iContext != null) {
            return DescriptorConverter.encodeName(iContext, fs.getName());
        }
        Element root = doc.getDocumentElement();
        String name = fs.getName().getLocalPart().length() != 0 ? DescriptorConverter.encodeName(context, fs.getName()) : DescriptorConverter.generateName(context, namespace, "serialization");
        if (!DescriptorConverter.givenNameExists(doc, "faultSerialization", name)) {
            Element elFaultSerialization = doc.createElement("faultSerialization");
            elFaultSerialization.setAttribute(ATTR_NAME, name);
            elFaultSerialization.setAttribute("classSpace", classSpaceName);
            elFaultSerialization.appendChild(DescriptorConverter.faultSerializationInstanceToDOM(fs, doc, classSpaceName));
            root.appendChild(elFaultSerialization);
        }
        return name;
    }

    private static Element faultSerializationInstanceToDOM(FaultSerialization fs, Document doc, String classSpaceName) {
        Element el2;
        Element el1;
        Element el = doc.createElement(ELEMENT_FAULT_SERIALIZATION_INSTANCE);
        if (fs.getFaultCode() != null || fs.getFaultActor() != null || fs.getFaultDetail() != null) {
            el1 = doc.createElement(ELEMENT_DESERIALIZER);
            if (fs.getDeserializerClass() != null) {
                el1.setAttribute(ATTR_CLASS, fs.getDeserializerClass());
            }
            el.setAttribute("classSpace", classSpaceName);
            el.appendChild(el1);
            el2 = doc.createElement("fault");
            QName qName1 = fs.getFaultCode();
            QName qName2 = fs.getFaultDetail();
            if (qName1 != null && qName2 != null && qName1.getNamespaceURI().equals(qName2.getNamespaceURI())) {
                String ns2;
                String ns1 = ns2 = XMLUtils.findOrGenerateNamespaceAlias(el2, qName1.getNamespaceURI(), "typens");
            } else {
                if (qName1 != null) {
                    String ns1 = XMLUtils.findOrGenerateNamespaceAlias(el2, qName1.getNamespaceURI(), "typensC");
                    el2.setAttribute(ATTR_FAULT_CODE, ns1 + ":" + qName1.getLocalPart());
                }
                if (qName2 != null) {
                    String ns2 = XMLUtils.findOrGenerateNamespaceAlias(el2, qName2.getNamespaceURI(), "typensD");
                    el2.setAttribute(ATTR_FIRST_DETAIL_ELEMENT, ns2 + ":" + qName2.getLocalPart());
                }
            }
            if (fs.getFaultActor() != null) {
                el2.setAttribute(ATTR_FAULT_ACTOR, fs.getFaultActor());
            }
            el1.appendChild(el2);
        }
        if (fs.getSerializerClass() != null || fs.getSerializedExceptionClass() != null) {
            el1 = doc.createElement(ELEMENT_SERIALIZER);
            String name = fs.getSerializerClass();
            if (name != null) {
                el1.setAttribute(ATTR_CLASS, name);
            }
            el1.setAttribute("classSpace", classSpaceName);
            name = fs.getSerializedExceptionClass();
            if (name != null) {
                el2 = doc.createElement(ELEMENT_EXCEPTION);
                el2.setAttribute(ATTR_CLASS, name);
                el2.setAttribute("classSpace", classSpaceName);
                el1.appendChild(el2);
            }
            el.appendChild(el1);
        }
        DescriptorConverter.addNamespaces(fs, el);
        DescriptorConverter.addExtension(fs, el, doc);
        DescriptorConverter.addConfiguration(fs, el, doc);
        return el;
    }

    private static Element getExistingElement(Document doc, String elementType, String name) {
        NodeList nl = doc.getElementsByTagName(elementType);
        int i = 0;
        while (i < nl.getLength()) {
            Element subEl = (Element)nl.item(i);
            String attr = subEl.getAttribute(ATTR_NAME);
            if (name.equals(attr)) {
                return subEl;
            }
            ++i;
        }
        return null;
    }

    private static boolean givenNameExists(Document doc, String elementType, String name) {
        return DescriptorConverter.getExistingElement(doc, elementType, name) != null;
    }

    private static void interceptorToChain(Interceptor interceptor, String context, String namespace, Document doc, Element chain, DeploymentDescriptor localDD, String classSpaceName) {
        String name = DescriptorConverter.interceptorToDOM(interceptor, context, namespace, doc, localDD, classSpaceName);
        if (chain != null) {
            Element elInterceptor = doc.createElement(ELEMENT_INTERCEPTOR);
            if (interceptor.isProcessingInMessages()) {
                elInterceptor.setAttribute("in", VALUE_TRUE);
            }
            if (interceptor.isProcessingOutMessages()) {
                elInterceptor.setAttribute("out", VALUE_TRUE);
            }
            elInterceptor.setAttribute("instance", name);
            chain.appendChild(elInterceptor);
        }
    }

    private static String interceptorToDOM(Interceptor interceptor, String context, String namespace, Document doc, DeploymentDescriptor localDD, String classSpaceName) {
        Element root = doc.getDocumentElement();
        String iContext = DescriptorConverter.importedContext(interceptor, context, localDD);
        String name = interceptor.getName().getLocalPart().length() == 0 ? DescriptorConverter.generateName(context, namespace, ELEMENT_INTERCEPTOR) : (iContext == null ? DescriptorConverter.encodeName(context, interceptor.getName()) : DescriptorConverter.encodeName(iContext, interceptor.getName()));
        if (iContext == null && !DescriptorConverter.givenNameExists(doc, ELEMENT_INTERCEPTOR, name)) {
            Element elInterceptor = doc.createElement(ELEMENT_INTERCEPTOR);
            elInterceptor.setAttribute(ATTR_NAME, name);
            elInterceptor.setAttribute(ATTR_CLASS, interceptor.getImplementationClass());
            elInterceptor.setAttribute("classSpace", classSpaceName);
            DescriptorConverter.addNamespaces(interceptor, elInterceptor);
            DescriptorConverter.addExtension(interceptor, elInterceptor, doc);
            DescriptorConverter.addConfiguration(interceptor, elInterceptor, doc);
            root.appendChild(elInterceptor);
        }
        return name;
    }

    private static void modulesToDOM(Map map, String context, String namespace, Document doc, String classSpaceName) {
        Element root = doc.getDocumentElement();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Module module = (Module)it.next();
            if (!DescriptorConverter.isLocal(module, namespace)) continue;
            Element elModule = doc.createElement(ELEMENT_MODULE);
            elModule.setAttribute(ATTR_NAME, DescriptorConverter.encodeName(context, module.getName()));
            elModule.setAttribute(ATTR_LOADER, module.getImplementationClass());
            elModule.setAttribute("classSpace", classSpaceName);
            DescriptorConverter.addNamespaces(module, elModule);
            DescriptorConverter.addExtension(module, elModule, doc);
            DescriptorConverter.addConfiguration(module, elModule, doc);
            root.appendChild(elModule);
        }
    }

    private static void transportsToDOM(Map map, String context, String namespace, Document doc, String classSpaceName) {
        Element root = doc.getDocumentElement();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Transport transport = (Transport)it.next();
            if (!DescriptorConverter.isLocal(transport, namespace)) continue;
            Element elTransport = doc.createElement(ELEMENT_TRANSPORT);
            elTransport.setAttribute(ATTR_NAME, DescriptorConverter.encodeName(context, transport.getName()));
            elTransport.setAttribute(ATTR_SCHEME, transport.getScheme());
            elTransport.setAttribute(ATTR_CLASS, transport.getImplementationClass());
            elTransport.setAttribute("classSpace", classSpaceName);
            elTransport.setAttribute(ATTR_PRELOAD, transport.isPreload() ? VALUE_TRUE : VALUE_FALSE);
            elTransport.setAttribute(ATTR_DEFAULT_SERVER, transport.isDefaultServer() ? VALUE_TRUE : VALUE_FALSE);
            DescriptorConverter.addNamespaces(transport, elTransport);
            DescriptorConverter.addExtension(transport, elTransport, doc);
            DescriptorConverter.addConfiguration(transport, elTransport, doc);
            root.appendChild(elTransport);
        }
    }

    private static void addConfiguration(ConfigurablePart configurablePart, Element topElement, Document doc) {
        Configuration configuration = configurablePart.getConfiguration();
        if (configuration != null) {
            Iterator it = configuration.getConfigs().iterator();
            while (it.hasNext()) {
                Configuration.Config config = (Configuration.Config)it.next();
                Iterator itElement = config.getElements().iterator();
                while (itElement.hasNext()) {
                    Element element = (Element)itElement.next();
                    topElement.appendChild(doc.importNode(element, true));
                }
            }
        }
    }

    private static void addExtension(ExtensiblePart extenisiblePart, Element topElement, Document doc) {
        Iterator itElement = extenisiblePart.getElements().iterator();
        while (itElement.hasNext()) {
            Element element = (Element)itElement.next();
            topElement.appendChild(doc.importNode(element, true));
        }
    }

    private static void headerProcessorToChain(HeaderProcessor header, String context, String namespace, Document doc, Element chain, DeploymentDescriptor localDD, String classSpaceName, int headerProcessorOrder) {
        Element root = doc.getDocumentElement();
        String iContext = DescriptorConverter.importedContext(header, context, localDD);
        String name = header.getName().getLocalPart().length() == 0 ? DescriptorConverter.generateName(context, namespace, ELEMENT_HEADER_INSTANCE) : (iContext == null ? DescriptorConverter.encodeName(context, header.getName()) : DescriptorConverter.encodeName(iContext, header.getName()));
        if (iContext == null && !DescriptorConverter.givenNameExists(doc, ELEMENT_HEADER_INSTANCE, name)) {
            Element elHeader = doc.createElement(ELEMENT_HEADER_INSTANCE);
            elHeader.setAttribute(ATTR_NAME, name);
            elHeader.setAttribute(ATTR_CLASS, header.getImplementationClass());
            elHeader.setAttribute("classSpace", classSpaceName);
            elHeader.setAttribute(ATTR_NEEDS_BODY, header.isNeedsBody() ? VALUE_TRUE : VALUE_FALSE);
            elHeader.setAttribute(ATTR_DD_ORDER, String.valueOf(headerProcessorOrder));
            Iterator i = header.getHeaders().iterator();
            while (i.hasNext()) {
                elHeader.appendChild(DescriptorConverter.headerToDOM(doc, (Header)i.next()));
            }
            Iterator i2 = header.getSchemas().iterator();
            while (i2.hasNext()) {
                elHeader.appendChild(DescriptorConverter.headerSchemaToDOM(doc, (Schema)i2.next()));
            }
            root.appendChild(elHeader);
            DescriptorConverter.addNamespaces(header, elHeader);
            DescriptorConverter.addExtension(header, elHeader, doc);
            DescriptorConverter.addConfiguration(header, elHeader, doc);
        }
        if (header.isProcessingInMessages()) {
            DescriptorConverter.putHandlerToChain(chain, name, "in", doc);
        }
        if (header.isProcessingOutMessages()) {
            DescriptorConverter.putHandlerToChain(chain, name, "out", doc);
        }
        if (header.isProcessingInFaultMessages() || header.isProcessingOutFaultMessages()) {
            DescriptorConverter.putHandlerToChain(chain, name, "fault", doc);
        }
    }

    private static void handlerToChain(Handler handler, String context, String namespace, Document doc, Element chain, DeploymentDescriptor localDD, String classSpaceName, int headerProcessorOrder) {
        Element root = doc.getDocumentElement();
        String iContext = DescriptorConverter.importedContext(handler, context, localDD);
        String name = handler.getName().getLocalPart().length() == 0 ? DescriptorConverter.generateName(context, namespace, ELEMENT_HANDLER_INSTANCE) : (iContext == null ? DescriptorConverter.encodeName(context, handler.getName()) : DescriptorConverter.encodeName(iContext, handler.getName()));
        if (iContext == null && !DescriptorConverter.givenNameExists(doc, ELEMENT_HANDLER_INSTANCE, name)) {
            Element elHandler = doc.createElement(ELEMENT_HANDLER_INSTANCE);
            elHandler.setAttribute(ATTR_NAME, name);
            elHandler.setAttribute(ATTR_CLASS, handler.getImplementationClass());
            elHandler.setAttribute("classSpace", classSpaceName);
            String proc = "";
            if (handler.isProcessingInMessages()) {
                proc = proc + "in";
            }
            if (handler.isProcessingOutMessages()) {
                proc = proc + (proc.length() == 0 ? "out" : " out");
            }
            if (handler.isProcessingFaultMessages()) {
                proc = proc + (proc.length() == 0 ? "out" : " fault");
            }
            elHandler.setAttribute(ATTR_DIRECTION, proc);
            Iterator i = handler.getHeaders().iterator();
            while (i.hasNext()) {
                elHandler.appendChild(DescriptorConverter.headerToDOM(doc, (Header)i.next()));
            }
            Iterator i2 = handler.getSchemas().iterator();
            while (i2.hasNext()) {
                elHandler.appendChild(DescriptorConverter.headerSchemaToDOM(doc, (Schema)i2.next()));
            }
            root.appendChild(elHandler);
            DescriptorConverter.addNamespaces(handler, elHandler);
            DescriptorConverter.addExtension(handler, elHandler, doc);
        }
        if (handler.isProcessingInMessages()) {
            DescriptorConverter.putHandlerToChain(chain, name, "in", doc);
        }
        if (handler.isProcessingOutMessages()) {
            DescriptorConverter.putHandlerToChain(chain, name, "out", doc);
        }
        if (handler.isProcessingFaultMessages()) {
            DescriptorConverter.putHandlerToChain(chain, name, "fault", doc);
        }
    }

    private static Element headerToDOM(Document doc, Header header) {
        String ns;
        Element h = doc.createElement(ELEMENT_HEADER);
        if (header.getClazz() != null) {
            h.setAttribute(ATTR_CLASS, header.getClazz());
        }
        String dir = header.isIn() ? (header.isOut() ? VALUE_INOUT : "in") : (header.isOut() ? "out" : "");
        h.setAttribute(ATTR_DIRECTION, dir);
        if (header.getName() != null) {
            ns = XMLUtils.findOrGenerateNamespaceAlias(h, header.getName().getNamespaceURI(), "ns");
            h.setAttribute(ATTR_QNAME, ns + ":" + header.getName().getLocalPart());
        }
        if (header.getType() != null) {
            ns = XMLUtils.findOrGenerateNamespaceAlias(h, header.getType().getNamespaceURI(), "ns");
            h.setAttribute("type", ns + ":" + header.getType().getLocalPart());
        }
        return h;
    }

    private static void putHandlerToChain(Element chain, String name, String chainType, Document doc) {
        Element el;
        NodeList nl = chain.getElementsByTagName(chainType);
        if (nl.getLength() == 0) {
            el = doc.createElement(chainType);
            chain.appendChild(el);
        } else {
            el = (Element)nl.item(0);
        }
        Element instance = doc.createElement("instance");
        instance.appendChild(doc.createTextNode(name));
        el.appendChild(instance);
    }

    private static String importedContext(DeploymentPart part, String localContext, DeploymentDescriptor localDD) {
        DeploymentDescriptor partDD = part.getDeploymentDescriptor();
        return partDD == localDD ? null : PackageHelper.getContextFromLocation(localDD.getLocation(), localContext, partDD.getLocation());
    }

    private static boolean isLocal(DeploymentPart part, String namespace) {
        return namespace.equals(part.getDeploymentDescriptor().getTargetNamespace());
    }

    private static void processingToDOM(Processing p, Element elServiceBinding, String context, String namespace, Document doc, DeploymentDescriptor localDD, String classSpaceName, boolean localProcessing) throws PublishException {
        Iterator allInterceptors;
        int position;
        Iterator allFaultSerializations;
        Element root = doc.getDocumentElement();
        String pName = null;
        if (p == null) {
            p = new ProcessingImpl(localDD);
            pName = DescriptorConverter.encodeName(context, new QName(localDD.getTargetNamespace(), localDD.getName() + VALUE_DEFAULT_PROCESSING_SUFFIX));
        } else {
            pName = DescriptorConverter.encodeName(context, p.getName());
        }
        Iterator allSchemaProcessings = DescriptorHelper.getProcessedSchemaProcessings(p);
        Iterator allTypeMappings = DescriptorHelper.getProcessedTypeMappings(p);
        Iterator allSerializations = DescriptorHelper.getProcessedSerializations(p);
        if (allSerializations.hasNext() || allSchemaProcessings.hasNext() || allTypeMappings.hasNext()) {
            Serialization serialization = null;
            if (allSerializations.hasNext()) {
                serialization = (Serialization)allSerializations.next();
            }
            if (allSerializations.hasNext() || p.getSchemas().size() != 0 || allTypeMappings.hasNext()) {
                Element elSerialization = DescriptorConverter.getExistingElement(doc, "serialization", pName);
                if (elSerialization == null) {
                    elSerialization = doc.createElement("serialization");
                    elSerialization.setAttribute(ATTR_NAME, pName);
                    if (serialization != null) {
                        DescriptorConverter.serializationToChain(serialization, context, doc, elSerialization, localDD, classSpaceName);
                        while (allSerializations.hasNext()) {
                            DescriptorConverter.serializationToChain((Serialization)allSerializations.next(), context, doc, elSerialization, localDD, classSpaceName);
                        }
                    }
                    DescriptorConverter.schemataToChain(p, allSchemaProcessings, context, doc, elSerialization, localDD);
                    while (allTypeMappings.hasNext()) {
                        DescriptorConverter.typeMappingToDOM((TypeMapping)allTypeMappings.next(), elSerialization, doc);
                    }
                }
                if (elSerialization.getElementsByTagName("serialization").getLength() != 0 || elSerialization.getElementsByTagName("import").getLength() != 0) {
                    if (localProcessing) {
                        root.appendChild(elSerialization);
                    }
                    if (elServiceBinding != null) {
                        elServiceBinding.setAttribute("serialization", pName);
                    }
                }
            } else {
                String serializationName = DescriptorConverter.serializationToDOM(serialization, context, doc, localDD, classSpaceName, localProcessing);
                if (serializationName != null && elServiceBinding != null) {
                    elServiceBinding.setAttribute("serialization", serializationName);
                }
            }
        }
        if ((allFaultSerializations = DescriptorHelper.getProcessedFaultSerializations(p)).hasNext()) {
            FaultSerialization faultSerialization = (FaultSerialization)allFaultSerializations.next();
            Element elFaultSerialization = DescriptorConverter.getExistingElement(doc, "faultSerialization", pName);
            if (elFaultSerialization == null) {
                elFaultSerialization = doc.createElement("faultSerialization");
                elFaultSerialization.setAttribute(ATTR_NAME, pName);
                elFaultSerialization.setAttribute("classSpace", classSpaceName);
                DescriptorConverter.faultSerializationToChain(faultSerialization, context, namespace, doc, elFaultSerialization, localDD, classSpaceName);
                while (allFaultSerializations.hasNext()) {
                    DescriptorConverter.faultSerializationToChain((FaultSerialization)allFaultSerializations.next(), context, namespace, doc, elFaultSerialization, localDD, classSpaceName);
                }
            }
            if (elFaultSerialization.getElementsByTagName("faultSerialization").getLength() != 0 || elFaultSerialization.getElementsByTagName("import").getLength() != 0) {
                if (localProcessing) {
                    root.appendChild(elFaultSerialization);
                }
                if (elServiceBinding != null) {
                    elServiceBinding.setAttribute("faultSerialization", pName);
                }
            }
        }
        List handlers = DescriptorHelper.getProcessedHandlersAsList(p);
        List headers = DescriptorHelper.getProcessedHeaderProcessorsAsList(p);
        Object[] mixedArr = new Object[handlers.size() + headers.size()];
        Iterator it = handlers.iterator();
        while (it.hasNext()) {
            HandlerImpl handler = (HandlerImpl)it.next();
            position = handler.getPosition();
            mixedArr[position] = handler;
        }
        it = headers.iterator();
        while (it.hasNext()) {
            HeaderProcessorImpl hp = (HeaderProcessorImpl)it.next();
            position = hp.getPosition();
            mixedArr[position] = hp;
        }
        List<Object> mixedList = Arrays.asList(mixedArr);
        Iterator<Object> allHandlers = mixedList.iterator();
        if (allHandlers.hasNext()) {
            Element elHandlerChain = DescriptorConverter.getExistingElement(doc, ELEMENT_HANDLERS, pName);
            if (elHandlerChain == null) {
                elHandlerChain = doc.createElement(ELEMENT_HANDLERS);
                elHandlerChain.setAttribute(ATTR_NAME, pName);
            }
            int handlerOrder = 0;
            int headerProcessorOrder = 0;
            while (allHandlers.hasNext()) {
                Object handler = allHandlers.next();
                if (handler instanceof HandlerImpl) {
                    DescriptorConverter.handlerToChain((HandlerImpl)handler, context, namespace, doc, elHandlerChain, localDD, classSpaceName, handlerOrder);
                } else if (handler instanceof HeaderProcessor) {
                    DescriptorConverter.headerProcessorToChain((HeaderProcessor)handler, context, namespace, doc, elHandlerChain, localDD, classSpaceName, headerProcessorOrder);
                    ++headerProcessorOrder;
                }
                ++handlerOrder;
            }
            if (elHandlerChain.getElementsByTagName("instance").getLength() != 0) {
                if (localProcessing) {
                    root.appendChild(elHandlerChain);
                }
                if (elServiceBinding != null) {
                    elServiceBinding.setAttribute(ATTR_HANDLERS, pName);
                }
            }
        }
        if ((allInterceptors = DescriptorHelper.getProcessedInterceptors(p)).hasNext()) {
            Element elInterceptorChain = DescriptorConverter.getExistingElement(doc, ELEMENT_INTERCEPTOR_CHAIN, pName);
            if (elInterceptorChain == null) {
                elInterceptorChain = doc.createElement(ELEMENT_INTERCEPTOR_CHAIN);
                elInterceptorChain.setAttribute(ATTR_NAME, pName);
                elInterceptorChain.setAttribute(ATTR_CLASS, "com.idoox.wasp.interceptor.TransportInterceptorChainImpl");
                while (allInterceptors.hasNext()) {
                    DescriptorConverter.interceptorToChain((Interceptor)allInterceptors.next(), context, namespace, doc, elInterceptorChain, localDD, classSpaceName);
                }
            }
            if (elInterceptorChain.getElementsByTagName(ELEMENT_INTERCEPTOR).getLength() != 0) {
                if (localProcessing) {
                    root.appendChild(elInterceptorChain);
                }
                if (elServiceBinding != null) {
                    elServiceBinding.setAttribute(ATTR_TRANSPORT_INTERCEPTORS, pName);
                }
            }
        }
    }

    private static Element schemaToDOM(Document doc, Schema schema) {
        Element elSchema = doc.createElement(ELEMENT_SCHEMA);
        elSchema.setAttribute(ATTR_NAMESPACE_URI, schema.getNamespaceURI());
        elSchema.setAttribute(ATTR_LOCATION_URL, schema.getSchemaLocation());
        return elSchema;
    }

    private static Element headerSchemaToDOM(Document doc, Schema schema) {
        Element elSchema = doc.createElement(ELEMENT_SCHEMA);
        elSchema.setAttribute(ATTR_NAMESPACE_URI, schema.getNamespaceURI());
        elSchema.setAttribute(ATTR_SCHEMA_LOCATION_URL, schema.getSchemaLocation());
        return elSchema;
    }

    private static void typeMappingToDOM(TypeMapping typeMapping, Element elSerialization, Document doc) {
        HashMap nsURIMap = new HashMap();
        Iterator maps = typeMapping.getMaps().iterator();
        while (maps.hasNext()) {
            TypeMapping.TypeMap map = (TypeMapping.TypeMap)maps.next();
            String namespaceURI = map.getSchemaType().getNamespaceURI();
            if (nsURIMap.containsKey(namespaceURI)) {
                ((Vector)nsURIMap.get(namespaceURI)).add(map);
                continue;
            }
            Vector<TypeMapping.TypeMap> newList = new Vector<TypeMapping.TypeMap>();
            newList.add(map);
            nsURIMap.put(namespaceURI, newList);
        }
        Iterator groups = nsURIMap.values().iterator();
        while (groups.hasNext()) {
            Vector group = (Vector)groups.next();
            Element elSchema = doc.createElement(ELEMENT_SCHEMA);
            elSerialization.appendChild(elSchema);
            elSchema.setAttribute(ATTR_NAMESPACE_URI, ((TypeMapping.TypeMap)group.get(0)).getSchemaType().getNamespaceURI());
            Element elMapping = doc.createElement(ELEMENT_MAPPING);
            elSchema.appendChild(elMapping);
            String language = typeMapping.getLanguage();
            if (language != null) {
                elMapping.setAttribute(ATTR_LANGUAGE, language);
            }
            int i = 0;
            while (i < group.size()) {
                TypeMapping.TypeMap map = (TypeMapping.TypeMap)group.get(i);
                Element elType = doc.createElement("type");
                elMapping.appendChild(elType);
                elType.setAttribute(ATTR_NAME, map.getSchemaType().getLocalPart());
                elType.setAttribute(ATTR_MAPS_TO, map.getMapsTo());
                ++i;
            }
        }
    }

    private static void serializationToChain(Serialization serialization, String context, Document doc, Element chain, DeploymentDescriptor localDD, String classSpaceName) {
        if ("".equals(serialization.getName().getLocalPart())) {
            chain.appendChild(DescriptorConverter.serializationInstanceToDOM(serialization, doc, classSpaceName));
        } else {
            String name = DescriptorConverter.serializationToDOM(serialization, context, doc, localDD, classSpaceName, true);
            Element elRef = doc.createElement("import");
            elRef.setAttribute(ATTR_REF, name);
            chain.appendChild(elRef);
        }
    }

    private static void schemataToChain(Processing p, Iterator allSchemaProcessings, String context, Document doc, Element chain, DeploymentDescriptor localDD) {
        String pName;
        if (p.getSchemas().size() != 0) {
            Element elSerialization = doc.createElement("serialization");
            QName pQName = p.getName();
            pName = DescriptorConverter.encodeName(context, pQName.getNamespaceURI(), pQName.getLocalPart() + VALUE_SCHEMATA_SUFFIX);
            elSerialization.setAttribute(ATTR_NAME, pName);
            Iterator schemata = p.getSchemas().iterator();
            while (schemata.hasNext()) {
                elSerialization.appendChild(DescriptorConverter.schemaToDOM(doc, (Schema)schemata.next()));
            }
            doc.getDocumentElement().appendChild(elSerialization);
        }
        while (allSchemaProcessings.hasNext()) {
            Processing sp = (Processing)allSchemaProcessings.next();
            String iContext = DescriptorConverter.importedContext(sp, context, localDD);
            pName = iContext != null ? DescriptorConverter.encodeName(iContext, sp.getName().getNamespaceURI(), sp.getName().getLocalPart() + VALUE_SCHEMATA_SUFFIX) : DescriptorConverter.encodeName(context, sp.getName().getNamespaceURI(), sp.getName().getLocalPart() + VALUE_SCHEMATA_SUFFIX);
            Element elRef = doc.createElement("import");
            elRef.setAttribute(ATTR_REF, pName);
            chain.appendChild(elRef);
        }
    }

    private static String serializationToDOM(Serialization serialization, String context, Document doc, DeploymentDescriptor localDD, String classSpaceName, boolean localProcessing) {
        Element root = doc.getDocumentElement();
        String iContext = DescriptorConverter.importedContext(serialization, context, localDD);
        if (iContext != null) {
            return DescriptorConverter.encodeName(iContext, serialization.getName());
        }
        String name = serialization.getName().getLocalPart().length() != 0 ? DescriptorConverter.encodeName(context, serialization.getName()) : DescriptorConverter.encodeName(context, serialization.getName());
        if (localProcessing & !DescriptorConverter.givenNameExists(doc, "serialization", name)) {
            Element elSerialization = doc.createElement("serialization");
            elSerialization.setAttribute(ATTR_NAME, name);
            elSerialization.appendChild(DescriptorConverter.serializationInstanceToDOM(serialization, doc, classSpaceName));
            root.appendChild(elSerialization);
        }
        return name;
    }

    private static Element serializationInstanceToDOM(Serialization serialization, Document doc, String classSpaceName) {
        String className;
        Element elSerializationInstance = doc.createElement(ELEMENT_SERIALIZATION_INSTANCE);
        if (serialization.getSerializedType() != null && serialization.getSerializedType().getLocalPart().length() != 0) {
            Element elSchemaPath = doc.createElement(ELEMENT_SCHEMA_PATH);
            Element elElement = doc.createElement("element");
            QName qName = serialization.getSerializedType();
            String ns = XMLUtils.findOrGenerateNamespaceAlias(elElement, qName.getNamespaceURI(), "typens");
            elElement.setAttribute("type", ns + ":" + qName.getLocalPart());
            elSchemaPath.appendChild(elElement);
            elSerializationInstance.appendChild(elSchemaPath);
        }
        if ((className = serialization.getSerializerClass()) != null) {
            Element elSerializer = doc.createElement(ELEMENT_SERIALIZER);
            elSerializer.setAttribute(ATTR_CLASS, className);
            elSerializer.setAttribute("classSpace", classSpaceName);
            elSerializationInstance.appendChild(elSerializer);
        }
        if ((className = serialization.getDeserializerClass()) != null) {
            Element elDeserializer = doc.createElement(ELEMENT_DESERIALIZER);
            elDeserializer.setAttribute(ATTR_CLASS, className);
            elDeserializer.setAttribute("classSpace", classSpaceName);
            elSerializationInstance.appendChild(elDeserializer);
        }
        if ((className = serialization.getSerializedClass()) != null) {
            Element elSerializedClass = doc.createElement(ELEMENT_SERIALIZED_CLASS);
            elSerializedClass.setAttribute(ATTR_CLASS, className);
            elSerializedClass.setAttribute("classSpace", classSpaceName);
            elSerializationInstance.appendChild(elSerializedClass);
        }
        DescriptorConverter.addNamespaces(serialization, elSerializationInstance);
        DescriptorConverter.addExtension(serialization, elSerializationInstance, doc);
        DescriptorConverter.addConfiguration(serialization, elSerializationInstance, doc);
        return elSerializationInstance;
    }

    private static String classSpaceToDOM(String context, DeploymentDescriptor dd, Element topElement, Document doc) throws DeploymentException {
        String classSpaceName = DescriptorConverter.resolveClassSpaceName(context, dd);
        Element classSpace = doc.createElement("classSpace");
        classSpace.setAttribute(ATTR_NAME, classSpaceName);
        Iterator it = dd.getDependencies().iterator();
        int library = 0;
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            DeploymentDescriptor dependant = dep.getReferredDeploymentDescriptor();
            if (dependant == null || !dependant.isLibrary()) continue;
            ++library;
            String location = dependant.getLocation();
            if (location != null) {
                String dependantContext = PackageHelper.getContextFromLocation(dd.getLocation(), context, dependant.getLocation());
                String parentClassSpaceName = DescriptorConverter.resolveClassSpaceName(dependantContext, dependant);
                Element parentClassSpace = doc.createElement("parentClassSpace");
                parentClassSpace.appendChild(doc.createTextNode(parentClassSpaceName));
                classSpace.appendChild(parentClassSpace);
                continue;
            }
            throw new DeploymentException("Package " + dd.getTargetNamespace() + ":" + dd.getName() + " depends on library package " + dependant.getTargetNamespace() + ":" + dependant.getName() + " for which cannot be resolved class space");
        }
        if (library == 0) {
            Element parentClassSpace = doc.createElement("parentClassSpace");
            parentClassSpace.appendChild(doc.createTextNode(CLASS_SPACE));
            classSpace.appendChild(parentClassSpace);
        }
        topElement.appendChild(classSpace);
        return classSpaceName;
    }

    public static String resolveClassSpaceName(String context, DeploymentDescriptor dd) {
        String name = DescriptorConverter.encodeName(context, dd.getTargetNamespace(), dd.getName());
        return name;
    }

    public static void listenersToDOM(Map map, List listeners, String context, String namespace, Element topElement, Document doc) {
        int i = 0;
        while (i < listeners.size()) {
            QName qname = (QName)listeners.get(i);
            Listener listener = (Listener)map.get(qname.getLocalPart());
            if (listener != null && DescriptorConverter.isLocal(listener, namespace)) {
                Element elListener = doc.createElement(ELEMENT_LISTENER);
                elListener.setAttribute(ATTR_REF, DescriptorConverter.encodeName(context, listener.getName()));
                topElement.appendChild(elListener);
            }
            ++i;
        }
    }

    private static String listenerToDOM(Listener listener, String context, String namespace, Document doc, DeploymentDescriptor localDD, String classSpaceName) {
        Element root = doc.getDocumentElement();
        String iContext = DescriptorConverter.importedContext(listener, context, localDD);
        String name = listener.getName().getLocalPart().length() == 0 ? DescriptorConverter.generateName(context, namespace, ELEMENT_LISTENER) : (iContext == null ? DescriptorConverter.encodeName(context, listener.getName()) : DescriptorConverter.encodeName(iContext, listener.getName()));
        if (iContext == null && !DescriptorConverter.givenNameExists(doc, ELEMENT_LISTENER, name)) {
            Element elListener = doc.createElement(ELEMENT_LISTENER);
            elListener.setAttribute(ATTR_NAME, name);
            elListener.setAttribute(ATTR_CLASS, listener.getImplementationClass());
            elListener.setAttribute("classSpace", classSpaceName);
            DescriptorConverter.addNamespaces(listener, elListener);
            DescriptorConverter.addExtension(listener, elListener, doc);
            root.appendChild(elListener);
        }
        return name;
    }

    private static void policyAssertionToDOM(PolicyAssertionImpl assertion, Document doc, String classSpaceName) {
        Element root = doc.getDocumentElement();
        Element elAssertion = doc.createElement(ELEMENT_POLICY_ELEMENT);
        if (assertion.getName() != null) {
            String ns = XMLUtils.findOrGenerateNamespaceAlias(root, assertion.getName().getNamespaceURI(), "ns");
            elAssertion.setAttribute(ATTR_NAME, ns + ":" + assertion.getName().getLocalPart());
        }
        elAssertion.setAttribute(ATTR_CLASS, assertion.getClazz());
        elAssertion.setAttribute("classSpace", classSpaceName);
        root.appendChild(elAssertion);
    }

    private static void addNamespaces(DeploymentPart deploymentPart, Element e) {
        Iterator iterator = ((DeploymentPartImpl)deploymentPart).getNamespaces().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            e.setAttribute("xmlns:" + entry.getValue(), (String)entry.getKey());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NameHolder {
        public String context;
        public String targetNamespace;
        public String name;
    }
}

