/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.dd;

import com.idoox.debug.Category;
import com.idoox.xml.DocumentBuilderFactory;
import com.idoox.xml.LocationAwareDocumentBuilder;
import com.systinet.wasp.PreferencesConfig;
import com.systinet.wasp.dd.DependencyImpl;
import com.systinet.wasp.dd.DeploymentDescriptorImpl;
import com.systinet.wasp.dd.UriLoader;
import com.systinet.wasp.dd.xml.XMLUtils;
import com.systinet.wasp.errors.ErrorMsgHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.client.Endpoint;
import org.systinet.wasp.Wasp;
import org.systinet.wasp.dd.Builder;
import org.systinet.wasp.dd.Dependency;
import org.systinet.wasp.dd.DeploymentDescriptor;
import org.systinet.wasp.dd.DeploymentException;
import org.systinet.wasp.dd.Loader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BuilderImpl
extends Builder {
    private static final Category log = Category.getCategory("com.systinet.wasp.dd.BuilderImpl");
    private LocationAwareDocumentBuilder b;
    private Map schemas = new HashMap(3);
    private Vector loaders = new Vector();
    private DeploymentDescriptor parentDD = null;
    private Loader loader = null;
    private int resolvingMode;
    private DDCache parsedDescriptors = new DDCache();
    private Builder parrentBuilder = null;

    private BuilderImpl(BuilderFactoryImpl builderFactory) throws DeploymentException {
        try {
            DocumentBuilderFactory factory = (DocumentBuilderFactory)DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(builderFactory.isValidating());
            factory.setLocationAware(builderFactory.isLocationAware());
            this.schemas = new HashMap(builderFactory.getSchemas());
            String waspLocation = Wasp.getWaspLocation();
            if (waspLocation != null && !waspLocation.endsWith("/")) {
                waspLocation = waspLocation + "/";
            }
            ArrayList<String> list = new ArrayList<String>();
            Iterator iterator = this.schemas.values().iterator();
            while (iterator.hasNext()) {
                String schemaLocation = (String)iterator.next();
                URL url = null;
                try {
                    url = waspLocation != null ? new URL(new URL(waspLocation), schemaLocation) : new URL(schemaLocation);
                    InputStream in = null;
                    try {
                        in = url.openStream();
                        in.close();
                        if (url == null) continue;
                        list.add(url.toExternalForm());
                    }
                    catch (IOException e) {
                        log.error("Failed to read schema document: " + e.getMessage());
                    }
                }
                catch (MalformedURLException e) {
                    log.error("Invalid schema location: " + schemaLocation, e);
                }
            }
            if (list.size() > 0) {
                try {
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", list.toArray(new String[0]));
                }
                catch (IllegalArgumentException e) {
                    factory.setValidating(false);
                }
            } else {
                factory.setValidating(false);
            }
            this.b = (LocationAwareDocumentBuilder)factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DeploymentException(e);
        }
    }

    public DeploymentDescriptor create(String name, String targetNamespace, String version) {
        DeploymentDescriptorImpl dd = new DeploymentDescriptorImpl();
        dd.setName(name);
        dd.setTargetNamespace(targetNamespace);
        dd.setVersion(version);
        return dd;
    }

    public DeploymentDescriptor read(QName ddQName) throws DeploymentException {
        DeploymentDescriptor newDD = null;
        DDCache.Entry el = this.parsedDescriptors.getByQName(ddQName);
        if (el != null) {
            newDD = el.dd;
            if (el.finalized) {
                return newDD;
            }
        } else {
            Enumeration e = this.loaders.elements();
            while (e.hasMoreElements()) {
                this.loader = (Loader)e.nextElement();
                String uri = this.loader.resolve(this.parentDD, ddQName);
                if (uri == null) continue;
                InputStream is = this.loader.load(this.parentDD, uri);
                try {
                    newDD = this.createDDFromStream(uri, is);
                }
                catch (DeploymentException e1) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw e1;
                }
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                ((DeploymentDescriptorImpl)newDD).setCanSetLocation(false);
                this.parsedDescriptors.put(newDD);
                break;
            }
            if (newDD == null) {
                return null;
            }
        }
        this.resolveDepsAndFinalizeDescriptor(newDD);
        return newDD;
    }

    public DeploymentDescriptor read(String uri) throws DeploymentException {
        DeploymentDescriptor newDD = null;
        DDCache.Entry el = this.parsedDescriptors.getByUri(uri);
        if (el != null) {
            newDD = el.dd;
            if (el.finalized) {
                return newDD;
            }
        } else {
            try {
                if (this.parentDD != null && this.parentDD.getLocation() != null) {
                    uri = new Endpoint(new Endpoint(this.parentDD.getLocation()), uri).toExternalForm();
                }
                Enumeration e = this.loaders.elements();
                while (e.hasMoreElements()) {
                    this.loader = (Loader)e.nextElement();
                    String lUri = this.loader.resolve(this.parentDD, uri);
                    if (lUri == null) continue;
                    InputStream is = this.loader.load(this.parentDD, lUri);
                    try {
                        newDD = this.createDDFromStream(lUri, is);
                    }
                    catch (DeploymentException e1) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw e1;
                    }
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    newDD.setLocation(lUri);
                    ((DeploymentDescriptorImpl)newDD).setCanSetLocation(false);
                    this.parsedDescriptors.put(newDD);
                    break;
                }
            }
            catch (MalformedURLException e) {
                throw new DeploymentException(e);
            }
            if (newDD == null) {
                return null;
            }
        }
        this.resolveDepsAndFinalizeDescriptor(newDD);
        return newDD;
    }

    public DeploymentDescriptor read(String uri, InputStream stream) throws DeploymentException {
        DeploymentDescriptor newDD = null;
        newDD = this.createDDFromStream(uri, stream);
        newDD.setLocation(uri);
        ((DeploymentDescriptorImpl)newDD).setCanSetLocation(false);
        this.parsedDescriptors.put(newDD);
        this.resolveDepsAndFinalizeDescriptor(newDD);
        return newDD;
    }

    protected DeploymentDescriptor createDDFromStream(String ddUri, InputStream stream) throws DeploymentException {
        Document doc;
        DeploymentDescriptorImpl newDD = new DeploymentDescriptorImpl();
        HashMap locations = new HashMap();
        LocationAwareDocumentBuilder b = this.b;
        try {
            if (b.isValidating()) {
                javax.xml.parsers.DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(ddUri);
                Element element = document.getDocumentElement();
                String namespaceURI = element.getNamespaceURI();
                if (!this.schemas.containsKey(namespaceURI)) {
                    DocumentBuilderFactory f = (DocumentBuilderFactory)DocumentBuilderFactory.newInstance();
                    f.setNamespaceAware(b.isNamespaceAware());
                    f.setLocationAware(b.isLocationAware());
                    f.setValidating(false);
                    b = (LocationAwareDocumentBuilder)f.newDocumentBuilder();
                    doc = b.parse(new InputSource(stream), locations);
                } else {
                    InputSource is = new InputSource(stream);
                    is.setSystemId(ddUri);
                    doc = b.parse(is, locations);
                }
            } else {
                doc = b.parse(new InputSource(stream), locations);
            }
        }
        catch (SAXException e) {
            throw new DeploymentException(ErrorMsgHelper.printSaxException(e), e);
        }
        catch (IOException e) {
            throw new DeploymentException("I/O operation error: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        try {
            Endpoint e = new Endpoint(ddUri);
            newDD.setLocation(ddUri);
        }
        catch (MalformedURLException e) {
            newDD.setLocation("file:" + ddUri);
        }
        XMLUtils.parseNode(newDD, doc.getDocumentElement(), locations);
        return newDD;
    }

    protected void resolveDepsAndFinalizeDescriptor(DeploymentDescriptor dd) throws DeploymentException {
        List dependencies;
        if (this.getParentDD() == null) {
            this.setParentDD(dd);
        }
        QName ddQName = new QName(dd.getTargetNamespace(), dd.getName());
        if (this.resolvingMode != 0 && (dependencies = dd.getDependencies()).size() > 0) {
            Iterator it = dependencies.iterator();
            DeploymentDescriptor dd1 = null;
            while (it.hasNext()) {
                Dependency d = (Dependency)it.next();
                if (d.getRequiredVersion() == null) {
                    throw new DeploymentException(dd.getTargetNamespace() + ":" + dd.getName() + " -> dependency version is missing");
                }
                if (ddQName.equals(d.getReferredName())) {
                    throw new DeploymentException(dd.getTargetNamespace() + ":" + dd.getName() + " -> Current descriptor called in dependency at " + d.getReferredName().toString());
                }
                String depInfo = "";
                if (d.getLocation() != null) {
                    this.setParentDD(dd);
                    String uri = d.getLocation().toExternalForm();
                    depInfo = " (URI=\"" + uri + "\")";
                    dd1 = this.read(uri);
                    if (dd1 == null && this.parrentBuilder != null) {
                        dd1 = this.parrentBuilder.read(uri);
                    }
                } else if (d.getReferredName() != null) {
                    QName qName = d.getReferredName();
                    depInfo = " (QName=\"" + qName + "\")";
                    BuilderImpl builder = this;
                    while (builder != null) {
                        dd1 = builder.read(qName);
                        if (dd1 == null) {
                            builder = (BuilderImpl)builder.parrentBuilder;
                            continue;
                        }
                        break;
                    }
                } else {
                    throw new DeploymentException(dd.getTargetNamespace() + ":" + dd.getName() + " -> You must specify either ref or location to read the dependant.");
                }
                if (dd1 != null) {
                    if (d.getRequiredVersion().greaterOrEqualThan(dd1.getVersion())) {
                        if (d.getReferredName().equals(new QName(dd1.getTargetNamespace(), dd1.getName()))) {
                            ((DependencyImpl)d).setReferredDeploymentDescriptor(dd1);
                            continue;
                        }
                        if (this.resolvingMode == 2) continue;
                        throw new DeploymentException(dd.getTargetNamespace() + ":" + dd.getName() + " -> descriptor found with on this location with different name");
                    }
                    if (this.resolvingMode == 2) continue;
                    throw new DeploymentException(dd.getTargetNamespace() + ":" + dd.getName() + " -> descriptor found with lower version");
                }
                if (this.resolvingMode == 2) continue;
                throw new DeploymentException(dd.getTargetNamespace() + ":" + dd.getName() + " -> I couldn't find deployment descriptor" + depInfo + "of dependant package.");
            }
        }
        XMLUtils.finalizeDescriptor(dd, this.resolvingMode != 1);
        if (this.resolvingMode == 1) {
            DDCache.Entry el = this.parsedDescriptors.getByQName(ddQName);
            el.finalized = true;
        }
    }

    public void registerLoader(Loader loader) {
        if (loader != null && !this.loaders.contains(loader)) {
            this.loaders.insertElementAt(loader, 0);
        }
    }

    public void unregisterLoader(Loader loader) {
        this.loaders.remove(loader);
    }

    public int getResolvingMode() {
        return this.resolvingMode;
    }

    public void setResolvingMode(int resolvingMode) {
        this.resolvingMode = resolvingMode;
    }

    public void setParentDD(DeploymentDescriptor parent) {
        this.parentDD = parent;
    }

    public DeploymentDescriptor getParentDD() {
        return this.parentDD;
    }

    public LocationAwareDocumentBuilder getDocumentBuilder() {
        return this.b;
    }

    public void remove(QName qName) {
        this.parsedDescriptors.removeByQName(qName);
    }

    public void remove(String uri) {
        this.parsedDescriptors.removeByUri(uri);
    }

    public void setParrentBuilder(Builder parrentBuilder) {
        this.parrentBuilder = parrentBuilder;
    }

    public Builder getParrentBuilder() {
        return this.parrentBuilder;
    }

    public void resolveDependencies(DeploymentDescriptor dd) throws DeploymentException {
        this.parsedDescriptors.put(dd);
        this.resolveDepsAndFinalizeDescriptor(dd);
    }

    public class DDCache {
        private HashMap qNameMap = new HashMap();
        private HashMap uriMap = new HashMap();

        public Entry getByQName(QName qName) {
            return (Entry)this.qNameMap.get(qName);
        }

        public Entry getByUri(String uri) {
            return (Entry)this.uriMap.get(uri);
        }

        public void put(DeploymentDescriptor dd) {
            if (dd != null) {
                QName qName = new QName(dd.getTargetNamespace(), dd.getName());
                String uri = dd.getLocation();
                Entry newEntry = new Entry(dd, qName, uri, false);
                if (this.qNameMap.containsKey(qName)) {
                    Entry presentEntry;
                    newEntry.nextWithSameQName = presentEntry = (Entry)this.qNameMap.get(qName);
                    presentEntry.previousWithSameQName = newEntry;
                } else {
                    this.qNameMap.put(qName, newEntry);
                }
                this.uriMap.put(uri, newEntry);
            }
        }

        public void removeByQName(QName qName) {
            Entry cacheEntry = (Entry)this.qNameMap.get(qName);
            this.qNameMap.remove(qName);
            while (cacheEntry != null) {
                this.uriMap.remove(cacheEntry.uri);
                cacheEntry = cacheEntry.nextWithSameQName;
            }
        }

        public void removeByUri(String uri) {
            Entry cacheEntry = (Entry)this.uriMap.get(uri);
            if (cacheEntry != null) {
                this.uriMap.remove(uri);
                this.qNameMap.remove(cacheEntry.qName);
                if (cacheEntry.previousWithSameQName != null) {
                    cacheEntry.previousWithSameQName.nextWithSameQName = cacheEntry.nextWithSameQName;
                }
                if (cacheEntry.nextWithSameQName != null) {
                    cacheEntry.nextWithSameQName.previousWithSameQName = cacheEntry.previousWithSameQName;
                }
            }
        }

        public class Entry {
            public DeploymentDescriptor dd = null;
            public boolean finalized = false;
            public Entry nextWithSameQName = null;
            public Entry previousWithSameQName = null;
            public QName qName;
            public String uri;

            public Entry(DeploymentDescriptor dd, QName qName, String uri, boolean finalized) {
                this.dd = dd;
                this.qName = qName;
                this.uri = uri;
                this.finalized = finalized;
            }
        }
    }

    public static class BuilderFactoryImpl
    implements Builder.BuilderFactory {
        private boolean locationAware = false;
        private boolean validating = false;
        private Map schemas = new HashMap(3);
        static /* synthetic */ Class class$com$systinet$wasp$PreferencesConfig;

        public BuilderFactoryImpl() {
            this.loadDefaultParserSetting();
        }

        private void loadDefaultParserSetting() {
            PreferencesConfig.Schema[] schemas;
            Configurable configurable = Configurator.getConfigurable("preferences", "main");
            PreferencesConfig defaultConfig = (PreferencesConfig)configurable.narrow(class$com$systinet$wasp$PreferencesConfig == null ? (class$com$systinet$wasp$PreferencesConfig = BuilderFactoryImpl.class$("com.systinet.wasp.PreferencesConfig")) : class$com$systinet$wasp$PreferencesConfig);
            PreferencesConfig.DefaultParserSetting[] defaultParserSettings = defaultConfig.getDefaultParserSettings();
            if (defaultParserSettings != null) {
                int i = 0;
                while (i < defaultParserSettings.length) {
                    PreferencesConfig.DefaultParserSetting defaultParserSetting = defaultParserSettings[i];
                    if ("deploymentDescriptor".equals(defaultParserSetting.getName())) {
                        try {
                            this.locationAware = defaultParserSetting.isLocationAware();
                        }
                        catch (Exception e) {
                            this.locationAware = false;
                        }
                        try {
                            this.validating = defaultParserSetting.isValidating();
                        }
                        catch (Exception e) {
                            this.validating = false;
                        }
                    }
                    ++i;
                }
            }
            if ((schemas = defaultConfig.getSchemas()) != null) {
                int j = 0;
                while (j < schemas.length) {
                    PreferencesConfig.Schema schema = schemas[j];
                    this.schemas.put(schema.getNamespaceURI(), schema.getSchemaLocation());
                    ++j;
                }
            }
        }

        public Builder createBuilder() throws DeploymentException {
            BuilderImpl impl = new BuilderImpl(this);
            ((Builder)impl).registerLoader(new UriLoader());
            return impl;
        }

        public boolean isLocationAware() {
            return this.locationAware;
        }

        public void setLocationAware(boolean locationAware) {
            this.locationAware = locationAware;
        }

        public boolean isValidating() {
            return this.validating;
        }

        public void setValidating(boolean validating) {
            this.validating = validating;
        }

        public Map getSchemas() {
            return this.schemas;
        }

        public void setSchemas(Map schemas) {
            this.schemas = schemas;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

