/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.client;

import com.idoox.debug.Category;
import com.systinet.wasp.client.ClientAttachments;
import com.systinet.wasp.rpc.WaspCallImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;

public class GetClientAttachments
extends ClientAttachments {
    private static final Category dbg = Category.getCategory("com.systinet.wasp.client.GetClientAttachments");

    public GetClientAttachments(SOAPMessage message) {
        super(message);
    }

    protected void resolveAttachment(String id, String location) throws IOException {
        Iterator attachments = this.message.getAttachments();
        int counter = -1;
        while (attachments.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachments.next();
            if (!location.equals(String.valueOf(++counter))) continue;
            String pid = attachment.getContentId();
            String ploc = attachment.getContentLocation();
            WaspCallImpl.ClientMessageAttachment att = (WaspCallImpl.ClientMessageAttachment)this.locationToMessageAttachment.get(String.valueOf(counter));
            if (att == null) {
                dbg.error("Not referenced part with content location " + counter);
                continue;
            }
            String contentType = attachment.getContentType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            att.setContentType(contentType);
            att.setContentId(pid);
            att.setContentLocation(ploc != null ? ploc : location);
            InputStream is = null;
            try {
                Object input = attachment.getContent();
                is = input instanceof InputStream ? (InputStream)input : attachment.getDataHandler().getInputStream();
                is = new ClientAttachments.ClosingStream(is, this, pid, location);
                att.setData(is);
            }
            catch (Exception e) {
                throw new IOException("Exception while loading " + (id != null ? id : location) + "attachment: " + e);
            }
            return;
        }
        throw new IOException("Attachment Part  " + (id != null ? id : location) + " has not been found");
    }
}

