/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.client;

import com.idoox.debug.Category;
import com.systinet.wasp.rpc.WaspCallImpl;
import com.systinet.wasp.soap.StreamCloseListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import org.idoox.wasp.types.MessageAttachment;
import org.systinet.wasp.soap.WaspSOAPMessage;

public class ClientAttachments
implements StreamCloseListener {
    private static final Category dbg = Category.getCategory("com.systinet.wasp.client.ClientAttachments");
    protected Map idToMessageAttachment = new HashMap();
    protected Map locationToMessageAttachment = new HashMap();
    protected Map idToOpenedStreams = new HashMap();
    protected Map locationToOpenedStreams = new HashMap();
    protected WaspSOAPMessage message;

    public ClientAttachments(SOAPMessage message) {
        this.message = (WaspSOAPMessage)message;
    }

    public void registerAttachmentById(String cid, MessageAttachment attachment) {
        this.idToMessageAttachment.put(cid, attachment);
    }

    public void registerAttachmentByLocation(String location, MessageAttachment attachment) {
        this.locationToMessageAttachment.put(location, attachment);
    }

    public void fillAttachmentWithId(String id) throws IOException {
        this.resolveAttachment(id, null);
    }

    public void fillAttachmentWithLocation(String location) throws IOException {
        this.resolveAttachment(null, location);
    }

    protected void resolveAttachment(String id, String location) throws IOException {
        Iterator attachments = this.message.getAttachments();
        while (attachments.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachments.next();
            String pid = attachment.getContentId();
            String ploc = attachment.getContentLocation();
            if (pid != null && pid.startsWith("cid:")) {
                pid = pid.substring(4);
            }
            if ((id == null || !id.equals(pid)) && (location == null || !location.equals(ploc))) continue;
            WaspCallImpl.ClientMessageAttachment att = (WaspCallImpl.ClientMessageAttachment)this.idToMessageAttachment.get(pid);
            WaspCallImpl.ClientMessageAttachment latt = (WaspCallImpl.ClientMessageAttachment)this.locationToMessageAttachment.get(ploc);
            if (att != null) {
                if (latt != null && att != latt) {
                    throw new UnsupportedOperationException("Both Content-Location and Content-Id not supported now");
                }
            } else {
                att = latt;
            }
            if (att == null) {
                dbg.error("Not referenced part with content-id " + pid + ", content location " + ploc);
                continue;
            }
            String contentType = attachment.getContentType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            att.setContentType(contentType);
            att.setContentId(pid);
            att.setContentLocation(ploc);
            InputStream is = null;
            try {
                Object input = attachment.getContent();
                is = input instanceof InputStream ? (InputStream)input : attachment.getDataHandler().getInputStream();
                is = new ClosingStream(is, this, pid, ploc);
                att.setData(is);
            }
            catch (Exception e) {
                throw new IOException("Exception while loading " + (id != null ? id : location) + "attachment: " + e);
            }
            return;
        }
        throw new IOException("Attachment Part  " + (id != null ? id : location) + " has not been found");
    }

    public void newStream(String contentId, String contentLocation) {
        if (contentId != null) {
            Integer count;
            if (this.idToOpenedStreams.containsKey(contentId)) {
                count = (Integer)this.idToOpenedStreams.get(contentId);
                count = new Integer(count + 1);
            } else {
                count = new Integer(1);
            }
            this.idToOpenedStreams.put(contentId, count);
        } else if (contentLocation != null) {
            Integer count;
            if (this.locationToOpenedStreams.containsKey(contentLocation)) {
                count = (Integer)this.locationToOpenedStreams.get(contentLocation);
                count = new Integer(count + 1);
            } else {
                count = new Integer(1);
            }
            this.locationToOpenedStreams.put(contentLocation, count);
        }
    }

    public void streamClosed(String contentId, String contentLocation) {
        Integer count2;
        if (contentId != null) {
            Integer count2;
            if (this.idToOpenedStreams.containsKey(contentId) && (count2 = (Integer)this.idToOpenedStreams.get(contentId)) != null) {
                int c = count2 - 1;
                if (c == 0) {
                    this.idToOpenedStreams.remove(contentId);
                } else {
                    this.idToOpenedStreams.put(contentId, new Integer(c));
                }
            }
        } else if (contentLocation != null && this.locationToOpenedStreams.containsKey(contentLocation) && (count2 = (Integer)this.locationToOpenedStreams.get(contentLocation)) != null) {
            int c = count2 - 1;
            if (c == 0) {
                this.locationToOpenedStreams.remove(contentLocation);
            } else {
                this.locationToOpenedStreams.put(contentLocation, new Integer(c));
            }
        }
        if (this.idToOpenedStreams.size() == 0 && this.locationToOpenedStreams.size() == 0) {
            this.message.release();
        }
    }

    public static class ClosingStream
    extends FilterInputStream {
        StreamCloseListener listener;
        String contentId;
        String contentLocation;

        public ClosingStream(InputStream in, StreamCloseListener listener, String contentId, String contentLocation) {
            super(in);
            this.listener = listener;
            this.contentId = contentId;
            this.contentLocation = contentLocation;
            if (this.listener != null) {
                this.listener.newStream(this.contentId, this.contentLocation);
            }
        }

        public void close() throws IOException {
            if (this.listener != null) {
                this.listener.streamClosed(this.contentId, this.contentLocation);
            }
        }
    }
}

