/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.async;

import com.idoox.debug.Category;
import com.idoox.util.UUID;
import com.systinet.wasp.async.AsyncConversationImpl;
import com.systinet.wasp.async.AsyncRuntimeManager;
import com.systinet.wasp.async.ConversationState;
import com.systinet.wasp.webservice.ServiceClientImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.messaging.OnewayListener;
import javax.xml.soap.SOAPMessage;
import org.idoox.transport.InputMessage;
import org.idoox.transport.TransportStartException;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.rpc.handler.ServerBookmark;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Initializable;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceInstance;

public class AsyncCallbackService
implements OnewayListener,
Initializable {
    private static final Category cat = Category.getCategory("com.systinet.wasp.async.AsyncCallbackService");
    private Map corridToAsyncConversation = new HashMap(11, 0.75f);
    private Frontend frontend;
    private String serviceURL;
    private AsyncConversationListener asyncListener = new AsyncConversationListener();
    private AsyncRuntimeManager.CleaningThread cleaningThread = null;

    public void onMessage(String corrid, InputMessage message) {
        if (this.cleaningThread != null) {
            this.cleaningThread.refresh();
        }
        AsyncConversationImpl asyncConversation = null;
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(corrid);
        }
        if (asyncConversation != null && asyncConversation.isActive()) {
            Current.getCallContext().getContextData().put("lazy.input.processing", Boolean.TRUE);
            this.checkAndManageMessagePool(new TransportMessageReceipt(asyncConversation, message));
        } else {
            try {
                message.close();
            }
            catch (IOException e) {
                cat.error(e);
            }
        }
    }

    public void onMessage(SOAPMessage message) {
        if (this.cleaningThread != null) {
            this.cleaningThread.refresh();
        }
        String corrid = this.getReceivedCorrid();
        AsyncConversationImpl asyncConversation = null;
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(corrid);
        }
        if (asyncConversation != null && asyncConversation.isActive()) {
            Map contextData = Current.getCallContext().getContextData();
            contextData.put("lazy.input.processing", Boolean.TRUE);
            ISequence sequence = (ISequence)contextData.get("sequence.input");
            Long messageNumber = (Long)contextData.get("serverbookmark.message.number");
            ServerBookmark.MessageConfirmer messageConfirmer = (ServerBookmark.MessageConfirmer)Current.getCallContext().getContextData().get("serverbookmark.message.confirmer");
            this.checkAndManageMessagePool(new SaajMessageReceipt(asyncConversation, message, sequence, messageConfirmer, messageNumber));
        }
    }

    public void onMessage(OneWayResponseMessage message) {
        if (this.cleaningThread != null) {
            this.cleaningThread.refresh();
        }
        String correlationId = message.getCorrelationId();
        AsyncConversationImpl asyncConversation = null;
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(correlationId);
        }
        if (asyncConversation != null && asyncConversation.isActive()) {
            this.checkAndManageMessagePool(new OneWayResponseMessageReceip(message, asyncConversation));
        }
    }

    public AsyncCallbackService(Frontend frontend) {
        this.frontend = frontend;
    }

    private String registerAsyncConversation(AsyncConversationImpl asyncConversation, String corrID) {
        if (corrID == null && (corrID = asyncConversation.getCorrelationID()) == null) {
            corrID = this.generateCorrelationID();
            asyncConversation.setCorrelationID(corrID);
        }
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            this.corridToAsyncConversation.put(corrID, asyncConversation);
        }
        asyncConversation.addPropertyChangeListener(this.asyncListener);
        return corrID;
    }

    private String generateCorrelationID() {
        return "uuid:" + UUID.uuidgen();
    }

    private String getReceivedCorrid() {
        AddressingHeaders addr = (AddressingHeaders)Current.getCallContext().getContextData().get("addressing.input");
        return addr != null ? addr.getRelatedMessageID(AddressingHeaders.Relationship.RESPONSE) : null;
    }

    public Frontend getFrontend() {
        return this.frontend;
    }

    public void init(ServiceInstance serviceInstance) {
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public void setCleaningThread(AsyncRuntimeManager.CleaningThread cleaningThread) {
        this.cleaningThread = cleaningThread;
    }

    public void destroy() {
    }

    public void unpublishAsyncService() {
        Frontend frontend = this.frontend;
        synchronized (frontend) {
            Map map = this.corridToAsyncConversation;
            synchronized (map) {
                if (this.corridToAsyncConversation.size() == 0) {
                    this.frontend.unpublishAsyncService();
                }
            }
        }
    }

    private void checkAndManageMessagePool(Object obj) {
        Object receipt;
        if (obj instanceof SaajMessageReceipt) {
            receipt = (SaajMessageReceipt)obj;
            ((AsyncConversationImpl)((SaajMessageReceipt)receipt).asyncConversation).getCallContext().getContextData().put("sequence.input", ((SaajMessageReceipt)receipt).sequence);
            if (((SaajMessageReceipt)receipt).messageNumber != null) {
                ((SaajMessageReceipt)receipt).sequence.setCurrentMessageNumber(((SaajMessageReceipt)receipt).messageNumber);
            }
            if (((SaajMessageReceipt)receipt).messageConfirmer != null) {
                ((WaspInternalSOAPMessage)((SaajMessageReceipt)receipt).message).getAttributes().put("serverbookmark.message.confirmer", ((SaajMessageReceipt)receipt).messageConfirmer);
            }
            ((AsyncConversationImpl)((SaajMessageReceipt)receipt).asyncConversation).onMessage(((SaajMessageReceipt)receipt).message);
        } else if (obj instanceof TransportMessageReceipt) {
            receipt = (TransportMessageReceipt)obj;
            ((AsyncConversationImpl)((TransportMessageReceipt)receipt).asyncConversation).onMessage(((TransportMessageReceipt)receipt).message);
        } else {
            receipt = (OneWayResponseMessageReceip)obj;
            ((AsyncConversationImpl)((OneWayResponseMessageReceip)receipt).asyncConversation).onMessage(((OneWayResponseMessageReceip)receipt).message);
        }
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            Iterator it = this.corridToAsyncConversation.keySet().iterator();
            while (it.hasNext()) {
                String corrid = (String)it.next();
                AsyncConversationImpl asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(corrid);
                if (!asyncConversation.isTimeouted(System.currentTimeMillis())) continue;
                it.remove();
                asyncConversation.onTimeout();
            }
        }
    }

    public static class OneWayResponseMessage {
        private String correlationId;

        public OneWayResponseMessage(String correlationId) {
            this.correlationId = correlationId;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }
    }

    private class OneWayResponseMessageReceip {
        OneWayResponseMessage message;
        AsyncConversation asyncConversation;

        public OneWayResponseMessageReceip(OneWayResponseMessage message, AsyncConversation asyncConversation) {
            this.message = message;
            this.asyncConversation = asyncConversation;
        }
    }

    private class TransportMessageReceipt {
        AsyncConversation asyncConversation;
        InputMessage message;

        public TransportMessageReceipt(AsyncConversation asyncConversation, InputMessage message) {
            this.asyncConversation = asyncConversation;
            this.message = message;
        }
    }

    private class SaajMessageReceipt {
        AsyncConversation asyncConversation;
        SOAPMessage message;
        ISequence sequence;
        ServerBookmark.MessageConfirmer messageConfirmer;
        Long messageNumber;

        public SaajMessageReceipt(AsyncConversation asyncConversation, SOAPMessage message, ISequence sequence, ServerBookmark.MessageConfirmer messageConfirmer, Long messageNumber) {
            this.asyncConversation = asyncConversation;
            this.message = message;
            this.sequence = sequence;
            this.messageConfirmer = messageConfirmer;
            this.messageNumber = messageNumber;
        }
    }

    private class AsyncConversationListener
    implements PropertyChangeListener {
        private AsyncConversationListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (AsyncConversationImpl.PROPERTY_STATE.equals(evt.getPropertyName()) && (evt.getNewValue() == ConversationState.FINISHED || evt.getNewValue() == ConversationState.INTERRUPTED)) {
                Map map = AsyncCallbackService.this.corridToAsyncConversation;
                synchronized (map) {
                    AsyncConversationImpl async = (AsyncConversationImpl)evt.getSource();
                    AsyncCallbackService.this.corridToAsyncConversation.remove(async.getCorrelationID());
                }
            }
        }
    }

    public static class Frontend {
        private ServiceClient serviceClient;
        private AsyncCallbackService asyncService;

        public Frontend(ServiceClient client) {
            this.serviceClient = client;
        }

        public void oneWayAck(String correlationId) {
            this.asyncService.onMessage(new OneWayResponseMessage(correlationId));
        }

        public String addReceiver(AsyncConversationImpl asyncConversation, String corrid) throws LookupException, PublishException, TransportStartException, MalformedURLException, WaspInternalException {
            Frontend frontend = this;
            synchronized (frontend) {
                this.asyncService = ((ServiceClientImpl)this.serviceClient).publishAsyncEndpoint(true);
                corrid = this.asyncService.registerAsyncConversation(asyncConversation, corrid);
                asyncConversation.setReversePath(((ServiceClientImpl)this.serviceClient).getAsyncEndpointPath());
            }
            return corrid;
        }

        public void setAsyncService(AsyncCallbackService callbackService) {
            this.asyncService = callbackService;
        }

        public String getAsyncServiceURL() {
            Frontend frontend = this;
            synchronized (frontend) {
                String string = this.asyncService.getServiceURL();
                return string;
            }
        }

        public void unpublishAsyncService() {
            Frontend frontend = this;
            synchronized (frontend) {
                try {
                    if (this.asyncService != null && this.serviceClient != null && ((ServiceClientImpl)this.serviceClient).unpublishAsyncEndpoint()) {
                        this.asyncService = null;
                    }
                }
                catch (PublishException e) {
                    cat.warn(e);
                }
            }
        }
    }
}

