/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp;

import com.idoox.debug.Category;
import com.idoox.soap.EnvelopeCaching;
import com.idoox.transport.util.URLDecoder;
import com.idoox.util.ObjectPool;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceException;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.ModuleRepository;
import com.idoox.wasp.SOAPServiceInfoCache;
import com.idoox.wasp.tools.common.DefaultValuesHelper;
import com.systinet.wasp.PreferencesConfig;
import com.systinet.wasp.dd.BuilderImpl;
import com.systinet.wasp.dd.WriterImpl;
import com.systinet.wasp.monitoring.FireEventLogListener;
import com.systinet.wasp.monitoring.events.LogEventServerStop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.config.IConfigurator;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportRepository;
import org.idoox.transport.TransportStartException;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.config.TransportConfig;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.Wasp;
import org.idoox.wasp.WaspInternalException;
import org.idoox.xmlrpc.Constants;
import org.systinet.monitoring.EventManager;
import org.systinet.wasp.IWasp;
import org.systinet.wasp.Version;
import org.systinet.wasp.client.XMLInvocationHelper;

public class WaspImpl
implements IWasp {
    private static Category log = Category.getCategory("com.systinet.wasp.WaspImpl");
    private ClassSpace rootClassSpace;
    private Map initialArguments;
    private static String[] threadlocals = new String[]{"threadlocal:CallContext", "org.systinet.wasp.webservice.CallContext"};
    private static Thread hook = null;
    private static int serverCount = 0;
    private static Object lock = new Object();
    private static final String KEY_DEFAULT_ENCODING_STYLE = "wasp.default.encoding.style";
    private static final String KEY_DEFAULT_BINDING_STYLE = "wasp.default.binding.style";
    private static final String KEY_DEFAULT_ATTACHMENT_TYPE = "wasp.default.attachment.type";
    private static final String KEY_DEFAULT_XML_PROTOCOL = "wasp.default.xml.protocol";
    static /* synthetic */ Class class$org$idoox$transport$config$TransportConfig;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$ICurrent;
    static /* synthetic */ Class class$com$systinet$wasp$PreferencesConfig;

    public Transport startServer(String endpoint) throws TransportStartException, MalformedURLException {
        TransportRepository repository = WaspImpl.getTransportRepository();
        if (repository == null) {
            return null;
        }
        int colon = endpoint.indexOf(58);
        if (colon == -1) {
            Transport[] transports = repository.getTransportForScheme(endpoint);
            if (transports == null || transports.length == 0) {
                throw new TransportStartException("No '" + endpoint + "' transport found in the repository");
            }
            Transport transport = null;
            int i = 0;
            while (i < transports.length) {
                if ((transports[i].getType() & 1) != 0) {
                    if (transports[i].isStarted()) {
                        return transports[i];
                    }
                    if (transport == null) {
                        transport = transports[i];
                    }
                }
                ++i;
            }
            if (transport != null) {
                transport.start(null);
                return transport;
            }
            throw new TransportStartException("No '" + endpoint + "' SERVER found in the repository " + "(or it's not configured as server)");
        }
        String scheme = endpoint.substring(0, colon);
        Transport[] transports = repository.getTransportForScheme(scheme);
        if (transports == null || transports.length == 0) {
            throw new TransportStartException("No '" + scheme + "' transport found in the repository");
        }
        Endpoint eEndpoint = new Endpoint(endpoint);
        if (eEndpoint.getHost() != null) {
            try {
                if (InetAddress.getByName(eEndpoint.getHost()).equals(InetAddress.getByName("localhost"))) {
                    eEndpoint.setHost(InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName());
                }
            }
            catch (UnknownHostException e) {
                throw new TransportStartException(e);
            }
        }
        int i = 0;
        while (i < transports.length) {
            Endpoint[] serverEndpoints;
            if ((transports[i].getType() & 1) != 0 && (serverEndpoints = transports[i].getAbsolutePath("/")) != null) {
                int j = 0;
                while (j < serverEndpoints.length) {
                    if (serverEndpoints[j].equals(eEndpoint)) {
                        if (!transports[i].isStarted()) {
                            transports[i].start(null);
                        }
                        return transports[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        Configurable config = Configurator.newRuntimeConfigurable();
        TransportConfig transportConfig = (TransportConfig)config.narrow(class$org$idoox$transport$config$TransportConfig == null ? (class$org$idoox$transport$config$TransportConfig = WaspImpl.class$("org.idoox.transport.config.TransportConfig")) : class$org$idoox$transport$config$TransportConfig);
        transportConfig.setName(scheme + "_runtime" + ++serverCount);
        transportConfig.setScheme(scheme);
        transportConfig.setDefaultServer(false);
        transportConfig.setPreload(true);
        return this.startServer(config, eEndpoint);
    }

    public Transport startServer(String scheme, Configurable config) throws TransportStartException {
        TransportConfig transportConfig = (TransportConfig)config.narrow(class$org$idoox$transport$config$TransportConfig == null ? (class$org$idoox$transport$config$TransportConfig = WaspImpl.class$("org.idoox.transport.config.TransportConfig")) : class$org$idoox$transport$config$TransportConfig);
        if (scheme != null) {
            transportConfig.setScheme(scheme);
        }
        transportConfig.setName(scheme + "_runtime" + ++serverCount);
        transportConfig.setDefaultServer(false);
        transportConfig.setPreload(true);
        return this.startServer(config, null);
    }

    private Transport startServer(Configurable config, Endpoint endpoint) throws TransportStartException {
        TransportRepository repository = WaspImpl.getTransportRepository();
        if (repository == null) {
            return null;
        }
        try {
            Transport transport = repository.addServer(config, false);
            transport.start(endpoint);
            return transport;
        }
        catch (TransportStartException e) {
            TransportConfig transportConfig = (TransportConfig)config.narrow(class$org$idoox$transport$config$TransportConfig == null ? (class$org$idoox$transport$config$TransportConfig = WaspImpl.class$("org.idoox.transport.config.TransportConfig")) : class$org$idoox$transport$config$TransportConfig);
            repository.removeTransport(transportConfig.getName());
            throw e;
        }
    }

    public String getLocalPath(String endpoint) throws MalformedURLException {
        return WaspImpl.getTransportRepository().getLocalPath(new Endpoint(endpoint));
    }

    public String getAbsolutePath(String scheme, String path) throws MalformedURLException {
        Transport[] transports = WaspImpl.getTransportRepository().getTransportForScheme(scheme);
        if (transports == null) {
            return null;
        }
        int i = 0;
        while (i < transports.length) {
            Endpoint[] endpoints;
            if ((transports[i].getType() & 1) != 0 && transports[i].isStarted() && (endpoints = transports[i].getAbsolutePath(path)) != null && endpoints.length > 0) {
                int j = 0;
                while (j < endpoints.length) {
                    if (endpoints[j].getScheme().equals(scheme)) {
                        return endpoints[j].toExternalForm();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public String[] getAbsolutePath(String path) throws MalformedURLException {
        Endpoint[] endpoints = WaspImpl.getTransportRepository().getAbsolutePath(path);
        if (endpoints == null) {
            return null;
        }
        String[] ret = new String[endpoints.length];
        int i = 0;
        while (i < endpoints.length) {
            ret[i] = endpoints[i].toExternalForm();
            ++i;
        }
        return ret;
    }

    public String getWaspLocation() {
        Configurator cfr_ignored_0 = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        return Configurator.getWaspLocation();
    }

    public synchronized Map getInitialArguments() {
        return this.initialArguments;
    }

    public synchronized void boot(Map initialArguments, ClassLoader ifaceClassLoader, ClassLoader implClassLoader) throws WaspInternalException {
        this.initialArguments = initialArguments;
        String shook = (String)initialArguments.get("wasp.shutdownhook");
        if (shook.compareToIgnoreCase("true") == 0) {
            Object object = lock;
            synchronized (object) {
                if (hook == null) {
                    hook = new HookThread();
                    Runtime.getRuntime().addShutdownHook(hook);
                }
            }
        }
        try {
            String envelopeCaching;
            String location = (String)initialArguments.get("wasp.location");
            if (location == null || location.length() == 0) {
                File tempDir = NoWaspLocation.workaround(this.getClass().getClassLoader());
                if (tempDir == null || !tempDir.exists()) {
                    throw new WaspInternalException("Server can't be started without 'wasp.location' argument");
                }
                location = tempDir.getAbsolutePath();
            }
            File f = new File(location);
            initialArguments.put("wasp.location", f.getCanonicalPath());
            String configLocation = (String)initialArguments.get("wasp.config.location");
            if (configLocation != null && configLocation.length() == 0) {
                initialArguments.remove("wasp.config.location");
            }
            if ("false".equalsIgnoreCase(envelopeCaching = (String)initialArguments.get("wasp.soap.caching"))) {
                EnvelopeCaching.setEnabled(false);
            }
            Category.initialize(initialArguments);
            Category.addLogListener(new FireEventLogListener(3));
            log = Category.getCategory("com.systinet.wasp.WaspImpl");
            log.info("Starting " + Version.getVersion());
            InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.Wasp", this);
            try {
                Class<?> oldWaspClass = Class.forName("com.idoox.wasp.WaspImpl");
                if (oldWaspClass != null) {
                    Wasp oldWaspImpl = (Wasp)oldWaspClass.newInstance();
                    InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.Wasp", oldWaspImpl);
                }
            }
            catch (ClassNotFoundException e) {
                log.debug("Cannot load class com.idoox.wasp.WaspImpl, core_bc.jar probably not installed.");
            }
            catch (InstantiationException e) {
                log.error("Cannot instantiate class com.idoox.wasp.WaspImpl", e);
            }
            catch (Exception e) {
                log.error("Cannot load and instantiate class com.idoox.wasp.WaspImpl, core_bc.jar probably not installed.", e);
            }
            String configuratorClass = (String)initialArguments.get("wasp.configurator.class");
            if (configuratorClass == null) {
                throw new WaspInternalException("Configurator class is not specified");
            }
            IConfigurator iconfigurator = (IConfigurator)Class.forName(configuratorClass, true, implClassLoader).newInstance();
            Configurator configurator = new Configurator();
            InitialReferencesRegistrar.addInitialReference("org.idoox.config.IConfigurator", iconfigurator);
            InitialReferencesRegistrar.addInitialReference("org.idoox.config.Configurator", configurator);
            Configurator.init(initialArguments, false);
            this.readPreferencesFromConfig(initialArguments);
            InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.dd.BuilderFactory", new BuilderImpl.BuilderFactoryImpl());
            InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.dd.WriterFactory", new WriterImpl.WriterFactoryImpl());
            int i = 0;
            while (i < threadlocals.length) {
                if (!Context.isRegistered(threadlocals[i])) {
                    InheritableThreadLocal inst = new InheritableThreadLocal();
                    InitialReferencesRegistrar.addInitialReference(threadlocals[i], inst);
                }
                ++i;
            }
            this.rootClassSpace = ClassSpaceHelper.initializeClassSpaces(configurator, ifaceClassLoader, implClassLoader);
            new ModuleRepository().loadModules();
            log.info("Server is started");
        }
        catch (IOException e) {
            throw new WaspInternalException(e);
        }
        catch (ClassNotFoundException e) {
            throw new WaspInternalException(e);
        }
        catch (InstantiationException e) {
            throw new WaspInternalException(e);
        }
        catch (IllegalAccessException e) {
            throw new WaspInternalException(e);
        }
        catch (ClassSpaceException e) {
            throw new WaspInternalException(e);
        }
        catch (RuntimeWrappedException e) {
            throw new WaspInternalException(e.getException());
        }
    }

    public synchronized void shutdown() {
        Configurator configurator;
        EventManager.fireEvent(new LogEventServerStop());
        log.info("Stopping " + Version.getVersion());
        XMLInvocationHelper.close();
        ModuleRepository modules = (ModuleRepository)Context.getInstance("com.idoox.wasp.ModuleRepository");
        if (modules != null) {
            modules.destroyModules();
        }
        if (this.rootClassSpace != null) {
            ClassSpaceHelper.destroy();
            this.rootClassSpace = null;
        }
        if ((configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator")) != null) {
            Configurator.destroy();
        }
        Context.destroy();
        SOAPServiceInfoCache.destroy();
        DefaultValuesHelper.destroy();
        try {
            ((Module)Context.getInstance(class$org$systinet$wasp$webservice$ICurrent == null ? (class$org$systinet$wasp$webservice$ICurrent = WaspImpl.class$("org.systinet.wasp.webservice.ICurrent")) : class$org$systinet$wasp$webservice$ICurrent)).destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Context.destroy();
        Category.destroy();
        ObjectPool.destroyPools();
        NoWaspLocation.workaroundDestroy();
        log.info("Server is stopped");
    }

    private static TransportRepository getTransportRepository() {
        return (TransportRepository)Context.getInstance("org.idoox.transport.TransportRepository");
    }

    public String[] getDefaultXMLProtocols() {
        String[] val = (String[])this.initialArguments.get(KEY_DEFAULT_XML_PROTOCOL);
        return val;
    }

    public String getDefaultEncodingStyle() {
        String des = (String)this.initialArguments.get(KEY_DEFAULT_ENCODING_STYLE);
        return des;
    }

    public String getDefaultBindingStyle() {
        String dbs = (String)this.initialArguments.get(KEY_DEFAULT_BINDING_STYLE);
        return dbs;
    }

    public String getDefaultAttachmentType() {
        String dat = (String)this.initialArguments.get(KEY_DEFAULT_ATTACHMENT_TYPE);
        return dat;
    }

    private void readPreferencesFromConfig(Map arguments) throws WaspInternalException {
        String defaultAttachmentType;
        String constantAtt;
        String defaultBindingStyle;
        String constantBs;
        String defaultEncodingStyle;
        String constantEnc;
        Configurable configurable = Configurator.getConfigurable("preferences", "main");
        if (configurable == null) {
            throw new WaspInternalException("Cannot read preferences from configuration! See element <preferences name='main'>.");
        }
        PreferencesConfig defaultConfig = (PreferencesConfig)configurable.narrow(class$com$systinet$wasp$PreferencesConfig == null ? (class$com$systinet$wasp$PreferencesConfig = WaspImpl.class$("com.systinet.wasp.PreferencesConfig")) : class$com$systinet$wasp$PreferencesConfig);
        String defaultXMLProtocolString = defaultConfig.getDefaultXMLProtocol();
        String[] constantsXMLP = this.parseDefaultXMLProtocol(defaultXMLProtocolString);
        if (constantsXMLP != null) {
            arguments.put(KEY_DEFAULT_XML_PROTOCOL, constantsXMLP);
        }
        if ((constantEnc = this.parseDefaultEncodingStyle(defaultEncodingStyle = defaultConfig.getDefaultEncodingStyle(), (String[])arguments.get(KEY_DEFAULT_XML_PROTOCOL))) != null) {
            arguments.put(KEY_DEFAULT_ENCODING_STYLE, constantEnc);
        }
        if ((constantBs = this.parseDefaultBindingStyle(defaultBindingStyle = defaultConfig.getDefaultBindingStyle())) != null) {
            arguments.put(KEY_DEFAULT_BINDING_STYLE, constantBs);
        }
        if ((constantAtt = this.parseDefaultAttachmentType(defaultAttachmentType = defaultConfig.getDefaultAttachmentType())) != null) {
            arguments.put(KEY_DEFAULT_ATTACHMENT_TYPE, constantAtt);
        }
    }

    private String[] parseDefaultXMLProtocol(String defaultXMLProtocol) {
        if (defaultXMLProtocol == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>(3);
        StringTokenizer st = new StringTokenizer(defaultXMLProtocol, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("soap11".equals(token)) {
                al.add("soap11");
                continue;
            }
            if ("soap12".equals(token)) {
                al.add("soap12");
                continue;
            }
            if (!"httpget".equals(token)) continue;
            al.add("httpget");
        }
        if (al.size() == 0) {
            return null;
        }
        return al.toArray(new String[0]);
    }

    private String parseDefaultEncodingStyle(String s, String[] defaultProtocols) {
        if (s == null || "literal".equals(s) || "".equals(s)) {
            return null;
        }
        if ("http://schemas.xmlsoap.org/soap/encoding/".equals(s)) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        if (Constants.SOAP12_ENC_NS.equals(s)) {
            return Constants.SOAP12_ENC_NS;
        }
        if ("encoded".equals(s)) {
            if (defaultProtocols[0].equals("soap12")) {
                return Constants.SOAP12_ENC_NS;
            }
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return null;
    }

    private String parseDefaultBindingStyle(String s) {
        if ("rpc".equals(s)) {
            return "rpc";
        }
        if ("document".equals(s)) {
            return "document";
        }
        if ("wrapped".equals(s)) {
            return "wrapped";
        }
        return null;
    }

    private String parseDefaultAttachmentType(String s) {
        if ("dime".equals(s) || "application/dime".equals(s)) {
            return "application/dime";
        }
        if ("mime".equals(s) || "multipart/related".equals(s)) {
            return "multipart/related";
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NoWaspLocation {
        private static final Object LOCK = new Object();
        private static File tempDirectory = null;

        private NoWaspLocation() {
        }

        public static final File workaround(ClassLoader classLoader) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Method parameter can't be null!");
            }
            Object object = LOCK;
            synchronized (object) {
                if (tempDirectory != null) {
                    File file = tempDirectory;
                    return file;
                }
                File file = NoWaspLocation.generateNewWaspLocation(classLoader);
                return file;
            }
        }

        public static final void workaroundDestroy() {
            Object object = LOCK;
            synchronized (object) {
                NoWaspLocation.deleteDirectory(tempDirectory);
                tempDirectory = null;
            }
        }

        private static final void deleteDirectory(File dir) {
            try {
                if (dir != null && dir.exists()) {
                    File[] entries = dir.listFiles();
                    int i = 0;
                    while (i < entries.length) {
                        if (entries[i].isDirectory()) {
                            NoWaspLocation.deleteDirectory(entries[i]);
                            entries[i].delete();
                        } else {
                            entries[i].delete();
                        }
                        ++i;
                    }
                }
                dir.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static final File generateNewWaspLocation(ClassLoader classLoader) {
            try {
                Enumeration<URL> resource = classLoader.getResources("conf/clientconf.xml");
                if (resource == null || !resource.hasMoreElements()) {
                    return null;
                }
                return NoWaspLocation.copyResourceToSystemTemp(URLDecoder.decodeUrlWorkaround(resource.nextElement()));
            }
            catch (Throwable t) {
                return null;
            }
        }

        private static final File copyResourceToSystemTemp(URL resource) {
            File systemTempDir = null;
            boolean isDirectory = false;
            try {
                String dirOrJar = resource.getPath();
                systemTempDir = new File(System.getProperty("java.io.tmpdir", ""));
                if (!systemTempDir.exists()) {
                    return null;
                }
                if (!systemTempDir.canWrite()) {
                    return null;
                }
                if (!(systemTempDir = new File(systemTempDir, "wasp_client_" + System.currentTimeMillis())).mkdir()) {
                    return null;
                }
                isDirectory = true;
                if (dirOrJar.startsWith("file:")) {
                    int index = (dirOrJar = dirOrJar.substring("file:".length())).lastIndexOf(".jar");
                    if (index == -1) {
                        return null;
                    }
                    dirOrJar = dirOrJar.substring(0, index + ".jar".length());
                    isDirectory = false;
                } else {
                    dirOrJar = dirOrJar.substring(0, dirOrJar.length() - "conf/clientconf.xml".length());
                }
                File source = new File(dirOrJar);
                if (!source.exists()) {
                    return null;
                }
                if (isDirectory) {
                    DirectoryCopier.INSTANCE.copyDirectory(source, systemTempDir);
                } else {
                    ZipFileExtractor.INSTANCE.extractZipFile(source, systemTempDir);
                }
                tempDirectory = systemTempDir;
                return tempDirectory;
            }
            catch (Throwable t) {
                return null;
            }
        }

        private static final void copyStreamContent(OutputStream out, InputStream in) throws IOException {
            try {
                int BUFFER_SIZE = 2048;
                byte[] buffer = new byte[2048];
                int countOfReadBytes = 0;
                while (in.available() != 0 && countOfReadBytes != -1) {
                    countOfReadBytes = in.read(buffer, 0, 2048);
                    if (countOfReadBytes == -1) continue;
                    out.write(buffer, 0, countOfReadBytes);
                }
                out.flush();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                out.close();
                in.close();
                throw throwable;
            }
            out.close();
            in.close();
        }

        private static interface ZipFileExtractor {
            public static final ZipFileExtractor INSTANCE = new ZipFileExtractor(){

                public final void extractZipFile(File zipFile, File targetDirectory) throws IOException {
                    ZipFile file = new ZipFile(zipFile);
                    Enumeration<? extends ZipEntry> enums = file.entries();
                    while (enums.hasMoreElements()) {
                        ZipEntry entry = enums.nextElement();
                        if (entry.isDirectory()) {
                            File dirToCreate = new File(targetDirectory, entry.getName());
                            if (dirToCreate.exists() || dirToCreate.mkdir()) continue;
                            throw new IOException();
                        }
                        InputStream in = file.getInputStream(entry);
                        File fileToExtractTo = new File(targetDirectory, entry.getName());
                        if (!fileToExtractTo.exists() && !fileToExtractTo.createNewFile()) {
                            throw new IOException();
                        }
                        FileOutputStream out = new FileOutputStream(fileToExtractTo);
                        NoWaspLocation.access$200(out, in);
                    }
                }
            };

            public void extractZipFile(File var1, File var2) throws IOException;
        }

        private static interface DirectoryCopier {
            public static final DirectoryCopier INSTANCE = new DirectoryCopier(){

                public void copyDirectory(File sourceDir, File targetDir) throws IOException {
                    File[] entries = sourceDir.listFiles();
                    int i = 0;
                    while (i < entries.length) {
                        if (entries[i].isDirectory()) {
                            if (!new File(targetDir, entries[i].getName()).mkdir()) {
                                throw new IOException();
                            }
                            this.copyDirectory(entries[i], new File(targetDir, entries[i].getName()));
                        } else {
                            if (!new File(targetDir, entries[i].getName()).createNewFile()) {
                                throw new IOException();
                            }
                            FileInputStream is = new FileInputStream(entries[i]);
                            FileOutputStream os = new FileOutputStream(new File(targetDir, entries[i].getName()));
                            NoWaspLocation.copyStreamContent(os, is);
                        }
                        ++i;
                    }
                }
            };

            public void copyDirectory(File var1, File var2) throws IOException;
        }
    }

    private static class HookThread
    extends Thread {
        private HookThread() {
        }

        public void run() {
            Object object = lock;
            synchronized (object) {
                this.setName("Shutdown");
                org.systinet.wasp.Wasp.destroy();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

