/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp;

import com.idoox.debug.Category;
import com.idoox.soap.UnsupportedMediaTypeException;
import com.idoox.util.ThreadPool;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.Constants;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.ModuleRepository;
import com.idoox.wasp.ProtocolRepositoryImpl;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.wasp.server.AdaptorTemplate;
import com.idoox.wasp.server.CallMediator;
import com.idoox.wasp.server.DisabledServiceException;
import com.idoox.wasp.server.Dispatcher;
import com.idoox.wasp.server.ServiceConnector;
import com.idoox.wasp.server.ServiceManager;
import com.idoox.wasp.server.ServiceRegistry;
import com.idoox.wasp.server.WSContextImpl;
import com.idoox.wasp.server.WebServiceContextImpl;
import com.idoox.wasp.server.config.AdaptorTemplateConfig;
import com.idoox.wasp.server.config.CallMediatorConfig;
import com.idoox.wasp.server.config.GetServiceBindingConfig;
import com.idoox.wasp.server.config.ParameterHandler;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import com.idoox.wasp.server.config.ServiceInstanceConfig;
import com.idoox.wasp.server.config.ServiceManagerConfig;
import com.idoox.wasp.server.config.ServiceMediatorConfig;
import com.idoox.wasp.server.config.WSDLConfig;
import com.idoox.wasp.tools.common.util.ClassHelper;
import com.systinet.wasp.SystemHeadersAddingListener;
import com.systinet.wasp.rpc.handler.WaspHandlerInfoImpl;
import com.systinet.wasp.webservice.AttributesHelper;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.FinalizationSupport;
import com.systinet.wasp.webservice.InstanceNameGenerator;
import com.systinet.wasp.webservice.ListenerRepositoryImpl;
import com.systinet.wasp.webservice.PersistentConfigurationImpl;
import com.systinet.wasp.webservice.RegistryImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import com.systinet.wasp.webservice.ServiceInstanceImpl;
import com.systinet.wasp.webservice.Version;
import com.systinet.wasp.webservice.VersionCollection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.TransportRepository;
import org.idoox.transport.URI;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.server.ConnectionHandler;
import org.idoox.transport.server.ServerConnection;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.config.EndpointCreationListener;
import org.idoox.wasp.server.InvalidEndpointPathException;
import org.idoox.wasp.server.InvalidStateTransitionException;
import org.idoox.wasp.server.ServiceInstanceNotFoundException;
import org.idoox.wasp.server.ServiceMediator;
import org.idoox.wasp.server.TimeoutExpiredException;
import org.idoox.wasp.server.WSContext;
import org.idoox.wasp.tools.java2wsdl.Java2WSDL;
import org.idoox.wasp.tools.java2wsdl.Java2WSDLFactory;
import org.idoox.wasp.wsdl.WSDLRepository;
import org.idoox.webservice.server.Startable;
import org.idoox.webservice.server.WebServiceContext;
import org.idoox.xmlrpc.header.Header;
import org.idoox.xmlrpc.header.Schema;
import org.systinet.wasp.IServiceManager;
import org.systinet.wasp.ServiceManagerListener;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceEndpointListener;
import org.systinet.wasp.webservice.ServiceInstance;

public class ServiceManagerImpl
implements Startable,
Dispatcher,
Module,
IServiceManager {
    protected static final Category cat = Category.getCategory("com.systinet.wasp.ServiceManagerImpl");
    private ServiceManagerConfig config;
    protected Map connectors = new HashMap(47, 0.75f);
    protected Map wildConnectorsE = new HashMap(13);
    protected Map wildConnectorsB = new HashMap(13);
    protected Map getConnectors = new HashMap(13, 0.75f);
    protected Map wildGetConnectorsE = new HashMap(13);
    protected Map wildGetConnectorsB = new HashMap(13);
    protected Map definitions = new HashMap();
    private long defaultTTL = -1L;
    private Map adaptors = new HashMap(11, 0.75f);
    protected Map serviceInstances = new HashMap(47, 0.75f);
    private Map parameterHandlers = new HashMap(11, 0.75f);
    private Map serviceMediators = new HashMap(11, 0.75f);
    protected boolean stopped = false;
    private CallMediator[] callMediators;
    public static ThreadLocal faultGenerated = new InheritableThreadLocal();
    private static List serviceCreationListeners = new LinkedList();
    private List serviceManagerListeners = new LinkedList();
    private List serviceManagerListenersEnd = new LinkedList();
    private int serviceManagerListenerReaders;
    private static String[] threadlocals = new String[]{"threadlocal:WSContext", "threadlocal:WebServiceContext", "threadlocal:CallContext", "org.systinet.wasp.webservice.CallContext", "threadlocal:ServletData"};
    protected Map bindingsOfInstance = new HashMap();
    protected Map getBindingsOfInstance = new HashMap();
    protected static final byte[] closeLine;
    private static String serverGUID;
    protected Configurator configurator;
    private WSDLRepository wsdlRepository;
    protected TransportRepository transportRepository;
    protected SerializationRepositoryImpl serializationRepository;
    protected ProtocolRepositoryImpl protocolRepository;
    protected ListenerRepositoryImpl listenerRepository;
    private Map serviceInstanceToWebServiceContext = new HashMap();
    private Map serviceEndpointToWSContext = new HashMap();
    protected Map serviceInstanceToServiceEndpoints = new HashMap();
    protected Map instanceToName = new HashMap();
    public static String ENCODING_URI;
    public Map serviceInstanceToDestroyingThread = new HashMap();
    public Map serviceInstanceToInitializingThread = new HashMap();
    private boolean delayPreloading = true;
    private List connectorsToPreload = new ArrayList(32);
    private Timer contextTimer = null;
    private static HandlerRepository handlerRepo;
    public static final float NEWEST_VERSION = -1.0f;
    static /* synthetic */ Class class$org$idoox$wasp$Context;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$AdaptorTemplateConfig;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceInstanceConfig;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceMediatorConfig;
    static /* synthetic */ Class class$org$idoox$wasp$server$ServiceMediator;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceManagerConfig;
    static /* synthetic */ Class class$com$idoox$wasp$server$CallMediator;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceBindingConfig;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$RawService;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$GetServiceBindingConfig;
    static /* synthetic */ Class class$com$systinet$wasp$webservice$RegistryImpl;

    public void addServiceManagerListener(ServiceManagerListener sml) {
        this.addServiceManagerListener(sml, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addServiceManagerListener(ServiceManagerListener listener, boolean end) {
        List list = this.serviceManagerListeners;
        synchronized (list) {
            while (this.serviceManagerListenerReaders > 0) {
                try {
                    this.serviceManagerListeners.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (end) {
                this.serviceManagerListenersEnd.add(listener);
            } else {
                this.serviceManagerListeners.add(listener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeServiceManagerListener(ServiceManagerListener sml) {
        List list = this.serviceManagerListeners;
        synchronized (list) {
            while (this.serviceManagerListenerReaders > 0) {
                try {
                    this.serviceManagerListeners.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.serviceManagerListeners.contains(sml)) {
                this.serviceManagerListeners.remove(sml);
            } else {
                if (!this.serviceManagerListenersEnd.contains(sml)) return;
                this.serviceManagerListenersEnd.remove(sml);
            }
            return;
        }
    }

    public Object invokeListenersOnObtainImplamentation(String name, ClassLoader ccl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object implementation = null;
        List list = this.serviceManagerListeners;
        synchronized (list) {
            ++this.serviceManagerListenerReaders;
        }
        Iterator i = this.serviceManagerListeners.iterator();
        while (i.hasNext()) {
            ServiceManagerListener listener = (ServiceManagerListener)i.next();
            implementation = listener.onObtainImplamentation(name, ccl);
            if (implementation != null) break;
        }
        List list2 = this.serviceManagerListeners;
        synchronized (list2) {
            --this.serviceManagerListenerReaders;
            this.serviceManagerListeners.notifyAll();
        }
        if (implementation != null) {
            return implementation;
        }
        cat.error("There is no listener for " + name + " name");
        throw new InstantiationException("There is no listener for " + name + " name");
    }

    public Definition invokeListenersOnGenerateWSDL(ServiceManagerListener.WSDLGenerationEvent event) throws PublishException {
        List list = this.serviceManagerListeners;
        synchronized (list) {
            ++this.serviceManagerListenerReaders;
        }
        Iterator i = this.serviceManagerListeners.iterator();
        while (i.hasNext()) {
            ServiceManagerListener listener = (ServiceManagerListener)i.next();
            listener.onGenerateWSDL(event);
        }
        Iterator i2 = this.serviceManagerListenersEnd.iterator();
        while (i2.hasNext()) {
            ServiceManagerListener listener = (ServiceManagerListener)i2.next();
            listener.onGenerateWSDL(event);
        }
        List list2 = this.serviceManagerListeners;
        synchronized (list2) {
            --this.serviceManagerListenerReaders;
            this.serviceManagerListeners.notifyAll();
        }
        return event.getWSDL();
    }

    public void destroy() {
        Class clazz = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = ServiceManagerImpl.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
        synchronized (clazz) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            this.transportRepository.setHandler(null);
        }
        Iterator instances = this.serviceInstances.keySet().iterator();
        while (instances.hasNext()) {
            String name = (String)instances.next();
            ServiceInstanceImpl service = (ServiceInstanceImpl)this.serviceInstances.get(name);
            int state = service.getState();
            if (state == 1) continue;
            try {
                service.disable();
                state = service.getState();
                int i = 0;
                while (state != 1) {
                    Class clazz2 = class$org$idoox$wasp$Context == null ? ServiceManagerImpl.class$("org.idoox.wasp.Context") : class$org$idoox$wasp$Context;
                    synchronized (clazz2) {
                        (class$org$idoox$wasp$Context == null ? ServiceManagerImpl.class$("org.idoox.wasp.Context") : class$org$idoox$wasp$Context).wait(1000L);
                    }
                    if (i++ > 9) break;
                    state = service.getState();
                }
                if (service.getState() == 1) continue;
                service.kill();
                this.waitForState(name, 1, -1L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.destroyConnectors(this.connectors, "Destroying connector for path (POST): ");
        this.destroyConnectors(this.wildConnectorsB, "Destroying *connector for path (POST): ");
        this.destroyConnectors(this.wildConnectorsE, "Destroying connector* for path (POST): ");
        this.destroyConnectors(this.getConnectors, "Destroying connector for path (GET): ");
        this.destroyConnectors(this.wildGetConnectorsB, "Destroying *connector for path (GET): ");
        this.destroyConnectors(this.wildGetConnectorsE, "Destroying connector* for path (GET): ");
        Iterator adapts = this.adaptors.keySet().iterator();
        while (adapts.hasNext()) {
            Object key = adapts.next();
            AdaptorTemplate aTemplate = (AdaptorTemplate)this.adaptors.get(key);
            aTemplate.destroy();
        }
        this.adaptors.clear();
        if (this.callMediators != null) {
            int i = 0;
            while (i < this.callMediators.length) {
                this.callMediators[i].destroy();
                ++i;
            }
            this.callMediators = null;
        }
        this.serviceInstances.clear();
        this.contextTimer.cancel();
        this.connectorsToPreload.clear();
        this.delayPreloading = true;
    }

    private void destroyConnectors(Map connectors, String dbgMsg) {
        Iterator conns = connectors.keySet().iterator();
        while (conns.hasNext()) {
            Object key = conns.next();
            ServiceConnector connector = (ServiceConnector)connectors.get(key);
            if (connector == null) continue;
            connector.destroy();
        }
        connectors.clear();
    }

    public SOAPMessageContext dispatch(SOAPMessageContext messageContext, String path, HandlerRepository.DirectionPositionEntry position, boolean request, boolean isShort, boolean fault) {
        Class clazz = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = ServiceManagerImpl.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
        synchronized (clazz) {
            if (this.stopped) {
                SOAPMessageContext sOAPMessageContext = null;
                return sOAPMessageContext;
            }
        }
        ServiceConnector connector = this.getConnector(path);
        if (connector == null) {
            throw new RuntimeException("ServiceConncetor not found for path: " + path);
        }
        try {
            return this.dispatchRequest(messageContext, connector, position, request, isShort, fault);
        }
        catch (Throwable throwable) {
            throw new RuntimeWrappedException("Exception while invoking " + path + " service", throwable);
        }
    }

    public void dispatch(Connection connection) {
        Class clazz = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = ServiceManagerImpl.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
        synchronized (clazz) {
            if (this.stopped) {
                return;
            }
        }
        OutputMessage output = connection.getOutputMessage();
        try {
            ServiceConnector connector;
            String path;
            if (output != null) {
                output.setStringHeader("Server", org.systinet.wasp.Version.getVersion());
            }
            Class clazz2 = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = ServiceManagerImpl.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
            synchronized (clazz2) {
                if (this.stopped) {
                    if (output != null) {
                        output.setStatusCode(503);
                    } else {
                        cat.warn("Service unavailable");
                    }
                    return;
                }
            }
            faultGenerated.set(Boolean.FALSE);
            String selectValue = connection.getURI().getParameter("select");
            if (selectValue != null) {
                path = (String)this.parameterHandlers.get(selectValue);
                if (path == null) {
                    cat.info("Parameter handler for select value " + selectValue + " was not found");
                    if (output != null) {
                        output.setStatusCode(404);
                    }
                    return;
                }
            } else {
                path = connection.getURI().getPath();
            }
            if ((connector = this.getConnector(path)) == null) {
                if (output != null) {
                    output.setStatusCode(404);
                } else {
                    cat.error("Service on " + path + " has not been found");
                }
                return;
            }
            this.dispatchRequest(connection, connector);
        }
        catch (UnsupportedMediaTypeException e) {
            try {
                cat.error("Unsupported Media Type", e);
                String errorMessage = "<html><body><h1>415: Error:</h1><p>Entity of the request does not support media type '" + e.getUnsupportedMediaType() + "'.</p></body></html>";
                try {
                    output.setStatusCode(415);
                    output.setContentType("text/html; charset=utf-8");
                }
                catch (Exception e1) {
                    // empty catch block
                }
                output.write(errorMessage.getBytes("UTF-8"));
                output.close();
            }
            catch (IOException e1) {
                cat.error("Cannot write error message (Unsupported Media Type):", e1);
            }
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw new ThreadDeath();
            }
            cat.error("Throwable during dispatch", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SOAPMessageContext dispatchRequest(SOAPMessageContext messageContext, ServiceConnector connector, HandlerRepository.DirectionPositionEntry position, boolean request, boolean isShort, boolean fault) throws Throwable {
        ServiceInstanceImpl serviceInstanceImpl;
        SOAPMessageContext serviceState22;
        String path = connector.getName();
        ServiceInstanceImpl service = connector.getService();
        Thread.currentThread().setContextClassLoader(service.getImplementationObject().getClass().getClassLoader());
        ServiceInstanceImpl serviceInstanceImpl2 = service;
        synchronized (serviceInstanceImpl2) {
            int serviceState22 = service.getState();
            if (serviceState22 == 1 || serviceState22 == 32) {
                cat.info("Service for path " + path + " is disabled, refusing request");
                return null;
            }
            service.addRequest(path, Thread.currentThread());
            if (service.getState() == 4 || service.getState() == 2) {
                service.setState(8);
                service.notifyAll();
            }
        }
        try {
            serviceState22 = connector.dispatch(messageContext, position, request, isShort, fault);
            Object var14_14 = null;
            serviceInstanceImpl = service;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            ServiceInstanceImpl serviceInstanceImpl3 = service;
            synchronized (serviceInstanceImpl3) {
                service.removeRequest(path, Thread.currentThread());
                if (service.getRequestsCount() != 0) throw throwable;
                if (service.getState() != 8) throw throwable;
                service.setState(4);
                service.notifyAll();
                throw throwable;
            }
        }
        synchronized (serviceInstanceImpl) {
            service.removeRequest(path, Thread.currentThread());
            if (service.getRequestsCount() != 0) return serviceState22;
            if (service.getState() != 8) return serviceState22;
            service.setState(4);
            service.notifyAll();
            return serviceState22;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchRequest(Connection connection, ServiceConnector connector) throws Throwable {
        ServiceInstanceImpl serviceInstanceImpl;
        OutputMessage output = connection.getOutputMessage();
        String path = connector.getName();
        ServiceInstanceImpl service = connector.getService();
        int serviceState = service.getState();
        if (serviceState == 1 || serviceState == 32) {
            if (output != null) {
                output.setStatusCode(503);
                return;
            }
            cat.info("Service for path " + path + " is disabled, refusing request");
            return;
        }
        Thread.currentThread().setContextClassLoader(service.getImplementationObject().getClass().getClassLoader());
        ServiceInstanceImpl serviceInstanceImpl2 = service;
        synchronized (serviceInstanceImpl2) {
            service.addRequest(path, Thread.currentThread());
            if (service.getState() == 4 || service.getState() == 2) {
                service.setState(8);
                service.notifyAll();
            }
        }
        try {
            connector.dispatch(connection);
            Object var10_8 = null;
            serviceInstanceImpl = service;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            ServiceInstanceImpl serviceInstanceImpl3 = service;
            synchronized (serviceInstanceImpl3) {
                service.removeRequest(path, Thread.currentThread());
                if (service.getRequestsCount() != 0) throw throwable;
                if (service.getState() != 8) throw throwable;
                service.setState(4);
                service.notifyAll();
                throw throwable;
            }
        }
        synchronized (serviceInstanceImpl) {
            service.removeRequest(path, Thread.currentThread());
            if (service.getRequestsCount() != 0) return;
            if (service.getState() != 8) return;
            service.setState(4);
            service.notifyAll();
            return;
        }
    }

    public void start() {
        Class clazz = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = ServiceManagerImpl.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
        synchronized (clazz) {
            this.stopped = false;
        }
    }

    public void stop() {
        Class clazz = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = ServiceManagerImpl.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
        synchronized (clazz) {
            this.stopped = true;
        }
    }

    private AdaptorTemplate getAdaptorTemplate(String name) {
        AdaptorTemplate retval = null;
        AdaptorTemplateConfig config = null;
        boolean newTemplate = false;
        Map map = this.adaptors;
        synchronized (map) {
            retval = (AdaptorTemplate)this.adaptors.get(name);
            if (retval == null) {
                Configurable c = Configurator.getConfigurable("AdaptorTemplate", name);
                if (c == null) {
                    throw new RuntimeException("AdaptorTemplate for name: " + name + " not found");
                }
                config = (AdaptorTemplateConfig)c.narrow(class$com$idoox$wasp$server$config$AdaptorTemplateConfig == null ? (class$com$idoox$wasp$server$config$AdaptorTemplateConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.AdaptorTemplateConfig")) : class$com$idoox$wasp$server$config$AdaptorTemplateConfig);
                retval = new AdaptorTemplate();
                newTemplate = true;
                this.adaptors.put(name, retval);
            }
        }
        if (retval != null && config != null && newTemplate) {
            try {
                retval.init(config);
            }
            catch (Exception e) {
                throw new RuntimeWrappedException("Exception during initialization of " + name + " template", e);
            }
        }
        return retval;
    }

    public ServiceConnector getConnector(String path) {
        ServiceConnector connector = null;
        Map map = this.connectors;
        synchronized (map) {
            connector = (ServiceConnector)this.connectors.get(path);
        }
        if (connector != null) {
            return connector;
        }
        Map map2 = this.wildConnectorsB;
        synchronized (map2) {
            Iterator wildURIs = this.wildConnectorsB.entrySet().iterator();
            while (wildURIs.hasNext()) {
                Map.Entry entry = wildURIs.next();
                String wildURI = (String)entry.getKey();
                if (!path.endsWith(wildURI)) continue;
                ServiceConnector serviceConnector = (ServiceConnector)entry.getValue();
                return serviceConnector;
            }
        }
        Map map3 = this.wildConnectorsE;
        synchronized (map3) {
            Iterator wildURIs = this.wildConnectorsE.entrySet().iterator();
            while (wildURIs.hasNext()) {
                Map.Entry entry = wildURIs.next();
                String wildURI = (String)entry.getKey();
                if (!path.startsWith(wildURI)) continue;
                ServiceConnector serviceConnector = (ServiceConnector)entry.getValue();
                return serviceConnector;
            }
        }
        return connector;
    }

    public ServiceConnector getGetConnector(String path) {
        ServiceConnector connector = null;
        Map map = this.getConnectors;
        synchronized (map) {
            connector = (ServiceConnector)this.getConnectors.get(path);
        }
        if (connector != null) {
            return connector;
        }
        ServiceConnector prefixConnector = null;
        Map map2 = this.wildGetConnectorsE;
        synchronized (map2) {
            Iterator wildURIs = this.wildGetConnectorsE.entrySet().iterator();
            while (wildURIs.hasNext()) {
                Map.Entry entry = wildURIs.next();
                String wildURI = (String)entry.getKey();
                if (!path.startsWith(wildURI)) continue;
                prefixConnector = (ServiceConnector)entry.getValue();
                if (prefixConnector.getServiceEndpoint().getServiceType() != 2) break;
                ServiceConnector serviceConnector = prefixConnector;
                return serviceConnector;
            }
        }
        Map map3 = this.wildGetConnectorsB;
        synchronized (map3) {
            Iterator wildURIs = this.wildGetConnectorsB.entrySet().iterator();
            while (wildURIs.hasNext()) {
                Map.Entry entry = wildURIs.next();
                String wildURI = (String)entry.getKey();
                if (!path.endsWith(wildURI)) continue;
                ServiceConnector serviceConnector = (ServiceConnector)entry.getValue();
                return serviceConnector;
            }
        }
        return prefixConnector;
    }

    protected void initConnector(ServiceConnector connector, ServiceBindingConfig config, Configurable c, ServiceEndpoint serviceEndpoint) throws PublishException {
        long defTTL;
        String adaptorName = config.getAdaptor();
        try {
            defTTL = config.getDefaultTTL();
        }
        catch (Exception e) {
            defTTL = this.defaultTTL;
        }
        try {
            AdaptorTemplate adaptor = this.getAdaptorTemplate(adaptorName);
            String[] mediatorNames = config.getMediators();
            LinkedList<ServiceMediator> mediators = null;
            if (mediatorNames != null && mediatorNames.length > 0) {
                mediators = new LinkedList<ServiceMediator>();
                int i = 0;
                while (i < mediatorNames.length) {
                    ServiceMediator med = this.getServiceMediator(mediatorNames[i]);
                    if (med != null) {
                        mediators.add(med);
                    }
                    ++i;
                }
            }
            ServiceConnector serviceConnector = connector;
            synchronized (serviceConnector) {
                connector.init(serviceEndpoint, defTTL, adaptor, c, config, mediators, this);
                connector.notifyAll();
            }
        }
        catch (PublishException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PublishException("Exception during initialization service connector for: " + config.getName(), e);
        }
    }

    public ServiceInstanceImpl getServiceInstanceObject(String name) throws DisabledServiceException, ClassNotFoundException {
        return this.getServiceInstanceObject(name, null);
    }

    public ServiceInstanceImpl getServiceInstanceObject(String name, Configurable rtConf) throws DisabledServiceException, ClassNotFoundException {
        ServiceInstanceImpl serviceInstance;
        Map map = this.serviceInstances;
        synchronized (map) {
            serviceInstance = (ServiceInstanceImpl)this.serviceInstances.get(name);
            if (serviceInstance == null) {
                Configurable c = Configurator.getConfigurable("ServiceInstance", name);
                if (c == null) {
                    c = rtConf;
                }
                if (c == null) {
                    ServiceInstanceImpl serviceInstanceImpl = null;
                    return serviceInstanceImpl;
                }
                ServiceInstanceConfig config = (ServiceInstanceConfig)c.narrow(class$com$idoox$wasp$server$config$ServiceInstanceConfig == null ? (class$com$idoox$wasp$server$config$ServiceInstanceConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.ServiceInstanceConfig")) : class$com$idoox$wasp$server$config$ServiceInstanceConfig);
                String className = config.getClassName();
                if (className == null) {
                    cat.error("The class parameter must be specified for ServiceInstance " + name);
                    ServiceInstanceImpl serviceInstanceImpl = null;
                    return serviceInstanceImpl;
                }
                ClassSpace classSpace = null;
                String classSpaceName = config.getClassSpace();
                if (classSpaceName != null) {
                    try {
                        classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
                    }
                    catch (MalformedURLException e) {
                        cat.error("Exception during service instance creation", e);
                        ServiceInstanceImpl serviceInstanceImpl = null;
                        return serviceInstanceImpl;
                    }
                } else {
                    classSpace = ClassSpaceHelper.getWaspClassSpace();
                }
                serviceInstance = new ServiceInstanceImpl(null, c, name);
                serviceInstance.setClassSpace(classSpace);
                serviceInstance.setImplementationClassName(className);
                try {
                    AttributesHelper.parseAttributes(c, classSpace.getClassLoader(), serviceInstance.getAttributes());
                }
                catch (Exception e) {
                    cat.error("Exception during parsing attributes of service instance", e);
                }
                try {
                    if (config.getDisabled()) {
                        serviceInstance.setState(1);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                this.serviceInstances.put(name, serviceInstance);
                serviceInstance.setRegistered();
            }
        }
        return serviceInstance;
    }

    public ServiceMediator getServiceMediator(String name) {
        Map map = this.serviceMediators;
        synchronized (map) {
            ServiceMediator retval = (ServiceMediator)this.serviceMediators.get(name);
            if (retval == null) {
                Configurable c = Configurator.getConfigurable("ServiceMediator", name);
                if (c == null) {
                    ServiceMediator serviceMediator = null;
                    return serviceMediator;
                }
                try {
                    ServiceMediatorConfig config = (ServiceMediatorConfig)c.narrow(class$com$idoox$wasp$server$config$ServiceMediatorConfig == null ? (class$com$idoox$wasp$server$config$ServiceMediatorConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.ServiceMediatorConfig")) : class$com$idoox$wasp$server$config$ServiceMediatorConfig);
                    String className = config.getClassName();
                    if (className == null) {
                        cat.error("The class parameter must be specified for ServiceMediator " + name);
                        ServiceMediator serviceMediator = null;
                        return serviceMediator;
                    }
                    String classSpaceName = config.getClassSpaceName();
                    ClassSpace classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
                    retval = (ServiceMediator)classSpace.createInstance(class$org$idoox$wasp$server$ServiceMediator == null ? (class$org$idoox$wasp$server$ServiceMediator = ServiceManagerImpl.class$("org.idoox.wasp.server.ServiceMediator")) : class$org$idoox$wasp$server$ServiceMediator, className);
                    this.serviceMediators.put(name, retval);
                }
                catch (ClassCastException e) {
                    cat.error("Service mediator implementation " + name + " must implement org.idoox.wasp.server.ServiceMediator interface");
                    retval = null;
                }
                catch (Throwable e) {
                    cat.error("Exception during service mediator initialization", e);
                    retval = null;
                }
            }
            ServiceMediator serviceMediator = retval;
            return serviceMediator;
        }
    }

    public void load(Configurable serviceManagerConfig) {
        InitialReferencesRegistrar.addInitialReference("com.idoox.wasp.server.Dispatcher", this);
        InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.server.ServiceStateManager", new ServiceManager());
        InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.webservice.IRegistry", this);
        InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.webservice.ICurrent", new CurrentImpl());
        InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.webservice.IPersistentConfiguration", new PersistentConfigurationImpl());
        this.contextTimer = new Timer(true);
        InitialReferencesRegistrar.addInitialReference("java.util.Timer", this.contextTimer);
        this.configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        int i = 0;
        while (i < threadlocals.length) {
            if (!Context.isRegistered(threadlocals[i])) {
                InheritableThreadLocal inst = new InheritableThreadLocal();
                InitialReferencesRegistrar.addInitialReference(threadlocals[i], inst);
            }
            ++i;
        }
        this.config = (ServiceManagerConfig)serviceManagerConfig.narrow(class$com$idoox$wasp$server$config$ServiceManagerConfig == null ? (class$com$idoox$wasp$server$config$ServiceManagerConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.ServiceManagerConfig")) : class$com$idoox$wasp$server$config$ServiceManagerConfig);
        this.defaultTTL = this.config.getDefaultServiceTTL();
        long cleanSweepInterval = 60000L;
        try {
            cleanSweepInterval = this.config.getCleanerSweepInterval() * 1000L;
        }
        catch (Exception e) {
            // empty catch block
        }
        InstanceCleanerTask instanceCleanerTask = new InstanceCleanerTask();
        this.contextTimer.schedule((TimerTask)instanceCleanerTask, cleanSweepInterval, cleanSweepInterval);
        long referenceQueueCleanerInterval = 60000L;
        try {
            referenceQueueCleanerInterval = this.config.getReferenceQueueCleanerInterval() * 1000L;
        }
        catch (Exception e) {
            // empty catch block
        }
        ReferenceQueueCleaner referenceQueueCleaner = new ReferenceQueueCleaner();
        this.contextTimer.schedule((TimerTask)referenceQueueCleaner, referenceQueueCleanerInterval + 3000L, referenceQueueCleanerInterval);
        ParameterHandler[] handlers = this.config.getParameterHandlers();
        if (handlers != null && handlers.length > 0) {
            int i2 = 0;
            while (i2 < handlers.length) {
                String selectValue = handlers[i2].getSelectValue();
                String serviceBindingName = handlers[i2].getServiceBindingName();
                if (selectValue == null || serviceBindingName == null) {
                    cat.error("Both selectValue and serviceBindingName must be specified for parameter handler");
                } else {
                    this.parameterHandlers.put(selectValue, serviceBindingName);
                }
                ++i2;
            }
        }
        this.addServiceManagerListener(new ClassServiceManagerListener());
        ModuleRepository moduleRepository = (ModuleRepository)Context.getInstance("com.idoox.wasp.ModuleRepository");
        moduleRepository.setListener(new PreloadingListener());
    }

    public void init() {
        handlerRepo = (HandlerRepository)Context.getInstance("wasp.core.jaxrpc_handler_repository");
        this.addServiceManagerListener(new WsdlFromFileListener());
        this.addServiceManagerListener(new RuntimeRegisteredWSDLsListener());
        this.addServiceManagerListener(new ClassToWsdlListener());
        SystemHeadersAddingListener headersAddingListener = new SystemHeadersAddingListener();
        this.addServiceManagerListener(headersAddingListener, true);
        ((RegistryImpl)this).addListener(headersAddingListener, true);
        this.transportRepository = (TransportRepository)Context.getInstance("org.idoox.transport.TransportRepository");
        this.serializationRepository = (SerializationRepositoryImpl)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
        this.wsdlRepository = (WSDLRepository)Context.getInstance("org.idoox.wasp.wsdl.WSDLRepository");
        this.protocolRepository = (ProtocolRepositoryImpl)Context.getInstance("org.idoox.wasp.ProtocolRepository");
        this.listenerRepository = (ListenerRepositoryImpl)Context.getInstance("org.systinet.wasp.webservice.ListenerRepository");
        DispatcherConnHandler handler = new DispatcherConnHandler();
        CallMediatorConfig[] mediatorConfigs = this.config.getCallMediators();
        LinkedList<CallMediator> medList = new LinkedList<CallMediator>();
        if (mediatorConfigs != null && mediatorConfigs.length > 0) {
            int i = 0;
            while (i < mediatorConfigs.length) {
                String className = mediatorConfigs[i].getClassName();
                String classSpace = mediatorConfigs[i].getClassSpaceName();
                if (className == null || classSpace == null) {
                    cat.error("Missing class or classSpace parameters for call mediator");
                } else {
                    try {
                        ClassSpace adaptorClassSpace = ClassSpaceHelper.getClassSpace(classSpace);
                        CallMediator mediator = (CallMediator)adaptorClassSpace.createInstance(class$com$idoox$wasp$server$CallMediator == null ? ServiceManagerImpl.class$("com.idoox.wasp.server.CallMediator") : class$com$idoox$wasp$server$CallMediator, className);
                        mediator.init(Configurator.getConfigurable(mediatorConfigs[i]));
                        medList.add(mediator);
                    }
                    catch (ClassCastException e) {
                        cat.error("Call Mediator implementation " + className + " must implement com.idoox.wasp.server.CallMediator interface");
                    }
                    catch (Throwable e) {
                        cat.error("Unable to create call mediator " + className, e);
                    }
                }
                ++i;
            }
            if (medList.size() > 0) {
                this.callMediators = medList.toArray(new CallMediator[0]);
            }
        }
        cat.info("Loading services marked to be loaded on startup");
        Configurable[] services = Configurator.getTopEntries("ServiceBinding");
        int i = 0;
        while (i < services.length) {
            try {
                this.addServiceBinding(services[i]);
            }
            catch (Exception e) {
                cat.error("Exception during initializing service: ", e);
            }
            ++i;
        }
        services = Configurator.getTopEntries("GetServiceBinding");
        int i2 = 0;
        while (i2 < services.length) {
            try {
                this.addServiceBinding(services[i2]);
            }
            catch (Exception e) {
                cat.error("Exception during initializing GET service: ", e);
            }
            ++i2;
        }
        this.transportRepository.setHandler(handler);
    }

    public Set getManagedServices() {
        return Collections.unmodifiableSet(new HashSet(this.instanceToName.values()));
    }

    public int getServiceState(String serviceName) throws ServiceInstanceNotFoundException {
        ServiceInstanceImpl instance;
        Map map = this.serviceInstances;
        synchronized (map) {
            instance = (ServiceInstanceImpl)this.serviceInstances.get(serviceName);
        }
        if (instance == null) {
            throw new ServiceInstanceNotFoundException("Service instance not found:" + serviceName);
        }
        return instance.getState();
    }

    private void disable(ServiceInstanceImpl serviceInstance, boolean persistently) throws InvalidStateTransitionException {
        if (persistently) {
            this.setDisabledInConfig(serviceInstance.getName());
        }
        serviceInstance.disable();
    }

    public void disable(String serviceName) throws ServiceInstanceNotFoundException, InvalidStateTransitionException {
        this.disable(serviceName, true);
    }

    private void disable(String serviceName, boolean persistently) throws InvalidStateTransitionException {
        ServiceInstanceImpl serviceInstance;
        Map map = this.serviceInstances;
        synchronized (map) {
            serviceInstance = (ServiceInstanceImpl)this.serviceInstances.get(serviceName);
        }
        this.disable(serviceInstance, persistently);
        try {
            serviceInstance.waitForState(1);
        }
        catch (InterruptedException e) {
            cat.error("Waiting for disabling of service instance interrupted: " + serviceName);
        }
    }

    public void enable(String serviceName) throws ServiceInstanceNotFoundException, InvalidStateTransitionException {
        ServiceInstanceImpl serviceInstance;
        Map map = this.serviceInstances;
        synchronized (map) {
            serviceInstance = (ServiceInstanceImpl)this.serviceInstances.get(serviceName);
        }
        serviceInstance.enable();
        try {
            serviceInstance.waitForState(5);
        }
        catch (InterruptedException ignore) {
            cat.error("Waiting on initialization of service instance interrupted: " + serviceName);
            return;
        }
        if (serviceInstance.getState() != 1) {
            this.setEnabledInConfig(serviceName);
        }
    }

    protected void removeConnectors(ServiceEndpoint serviceEndoint) {
        String path = serviceEndoint.getPath();
        int pathLength = path.length();
        Version version = ((ServiceEndpointImpl)serviceEndoint).getParsedVersion();
        if (pathLength > 1 && path.charAt(0) == '*') {
            String purePath = path.substring(1);
            this.removeConnectorManageVersions(this.wildConnectorsB, purePath, version);
            this.removeConnectorManageVersions(this.wildGetConnectorsB, purePath, version);
        } else if (pathLength > 0 && path.charAt(pathLength - 1) == '*') {
            String purePath = path.substring(0, pathLength - 1);
            this.removeConnectorManageVersions(this.wildConnectorsE, purePath, version);
            this.removeConnectorManageVersions(this.wildGetConnectorsE, purePath, version);
        } else {
            this.removeConnectorManageVersions(this.connectors, path, version);
            this.removeConnectorManageVersions(this.getConnectors, path, version);
        }
    }

    public void removeConnectorManageVersions(Map map, String path, Version version) {
        ServiceConnector connector = null;
        Map map2 = map;
        synchronized (map2) {
            connector = (ServiceConnector)map.get(path);
            if (connector != null) {
                Version connectorVersion = ((ServiceEndpointImpl)connector.getServiceEndpoint()).getParsedVersion();
                VersionCollection olderVersions = connector.getOlderVersions();
                if (version == null || connectorVersion.equals(version)) {
                    if (olderVersions.size() > 0) {
                        ServiceConnector olderConnector = (ServiceConnector)olderVersions.removeNewest();
                        if (olderConnector != null) {
                            olderConnector.setOlderVersions(olderVersions);
                            map.put(path, olderConnector);
                        } else {
                            map.remove(path);
                        }
                    } else {
                        map.remove(path);
                    }
                } else {
                    connector = (ServiceConnector)olderVersions.removeSpecified(version);
                }
            }
        }
        if (connector != null) {
            connector.destroy();
        }
    }

    protected void putToConnectorMaps(ServiceConnector connector, boolean rawService) {
        ServiceEndpoint serviceEndpoint = connector.getServiceEndpoint();
        String path = serviceEndpoint.getPath();
        int pathLength = path.length();
        if (pathLength > 1 && path.charAt(0) == '*') {
            String purePath = path.substring(1);
            this.putConnectorToMapManageVersions(this.wildConnectorsB, purePath, connector);
            if (rawService) {
                this.putConnectorToMapManageVersions(this.wildGetConnectorsB, purePath, connector);
            }
        } else if (pathLength > 0 && path.charAt(pathLength - 1) == '*') {
            String purePath = path.substring(0, pathLength - 1);
            this.putConnectorToMapManageVersions(this.wildConnectorsE, purePath, connector);
            if (rawService) {
                this.putConnectorToMapManageVersions(this.wildGetConnectorsE, purePath, connector);
            }
        } else {
            this.putConnectorToMapManageVersions(this.connectors, path, connector);
            if (rawService) {
                this.putConnectorToMapManageVersions(this.getConnectors, path, connector);
            }
        }
    }

    private void putConnectorToMapManageVersions(Map map, String path, ServiceConnector connector) {
        Map map2 = map;
        synchronized (map2) {
            ServiceConnector existing = (ServiceConnector)map.get(path);
            if (existing == null) {
                map.put(path, connector);
            } else {
                Version existingVersion = ((ServiceEndpointImpl)existing.getServiceEndpoint()).getParsedVersion();
                Version connectorVersion = ((ServiceEndpointImpl)connector.getServiceEndpoint()).getParsedVersion();
                VersionCollection olderVersions = existing.getOlderVersions();
                int compare = connectorVersion.compareTo(existingVersion);
                if (compare > 0) {
                    olderVersions.add(existing, existingVersion);
                    connector.setOlderVersions(olderVersions);
                    map.put(path, connector);
                } else if (compare < 0) {
                    olderVersions.add(connector, connectorVersion);
                }
            }
        }
    }

    private void setEnabledInConfig(String serviceName) {
        Configurable c = Configurator.getConfigurable("ServiceInstance", serviceName);
        if (c != null) {
            ServiceInstanceConfig config = (ServiceInstanceConfig)c.narrow(class$com$idoox$wasp$server$config$ServiceInstanceConfig == null ? (class$com$idoox$wasp$server$config$ServiceInstanceConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.ServiceInstanceConfig")) : class$com$idoox$wasp$server$config$ServiceInstanceConfig);
            try {
                if (!config.getDisabled()) {
                    return;
                }
            }
            catch (Exception ignore) {
                return;
            }
            config.setDisabled(false);
        }
    }

    private void setDisabledInConfig(String serviceName) {
        Configurable c = Configurator.getConfigurable("ServiceInstance", serviceName);
        if (c != null) {
            ServiceInstanceConfig config = (ServiceInstanceConfig)c.narrow(class$com$idoox$wasp$server$config$ServiceInstanceConfig == null ? (class$com$idoox$wasp$server$config$ServiceInstanceConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.ServiceInstanceConfig")) : class$com$idoox$wasp$server$config$ServiceInstanceConfig);
            config.setDisabled(true);
        }
    }

    public ServiceInstance getServiceInstanceByName(String serviceName) throws ServiceInstanceNotFoundException {
        ServiceInstanceImpl serviceInstance;
        Map map = this.serviceInstances;
        synchronized (map) {
            serviceInstance = (ServiceInstanceImpl)this.serviceInstances.get(serviceName);
        }
        if (serviceInstance == null) {
            throw new ServiceInstanceNotFoundException("Cannot find service " + serviceName);
        }
        return serviceInstance;
    }

    public void waitForState(String serviceName, int states, long timeout) throws ServiceInstanceNotFoundException, TimeoutExpiredException, InterruptedException {
        ServiceInstanceImpl service;
        Map map = this.serviceInstances;
        synchronized (map) {
            service = (ServiceInstanceImpl)this.serviceInstances.get(serviceName);
        }
        if (service == null) {
            try {
                service = this.getServiceInstanceObject(serviceName);
            }
            catch (DisabledServiceException e) {
                throw new ServiceInstanceNotFoundException("Service " + serviceName + " is disabled");
            }
            catch (ClassNotFoundException e) {
                throw new ServiceInstanceNotFoundException("Service " + serviceName + " returned ClassNotFoundException during initialization.");
            }
        }
        if (service == null) {
            throw new ServiceInstanceNotFoundException("Service instance not registered");
        }
        this.waitForState(service, states, timeout);
    }

    public void waitForState(ServiceInstanceImpl service, int states, long timeout) throws TimeoutExpiredException, InterruptedException {
        if (timeout < -1L || timeout == 0L) {
            throw new IllegalArgumentException("Invalid timeout value");
        }
        ServiceInstanceImpl serviceInstanceImpl = service;
        synchronized (serviceInstanceImpl) {
            int currentState = service.getState();
            if ((currentState & states) == currentState) {
                return;
            }
            if (timeout == -1L) {
                currentState = service.getState();
                while ((currentState & states) != currentState) {
                    service.wait();
                    currentState = service.getState();
                }
                return;
            }
            long start = System.currentTimeMillis();
            long step = 50L;
            long waitTime = timeout;
            while (true) {
                if (waitTime <= 0L) {
                    throw new TimeoutExpiredException();
                }
                try {
                    Class clazz = class$org$idoox$wasp$Context == null ? ServiceManagerImpl.class$("org.idoox.wasp.Context") : class$org$idoox$wasp$Context;
                    synchronized (clazz) {
                        (class$org$idoox$wasp$Context == null ? ServiceManagerImpl.class$("org.idoox.wasp.Context") : class$org$idoox$wasp$Context).wait(step);
                    }
                    service.wait(step);
                }
                catch (InterruptedException ignore) {
                    continue;
                }
                currentState = service.getState();
                if ((currentState & states) == currentState) {
                    return;
                }
                long now = System.currentTimeMillis();
                waitTime = timeout - (now - start);
            }
        }
    }

    public void addServiceBinding(Configurable c) {
        if ("GetServiceBinding".equals(c.getType())) {
            this.addGetServiceBindingI(c);
        } else {
            this.addServiceBindingI(c);
        }
    }

    protected ServiceConnector addInitializedConnector(ServiceEndpoint serviceEndpoint, ServiceBindingConfig bindingConfig) throws PublishException {
        Configurable c = Configurator.getConfigurable(bindingConfig);
        String path = bindingConfig.getName();
        ServiceConnector connector = new ServiceConnector();
        this.initConnector(connector, bindingConfig, c, serviceEndpoint);
        return connector;
    }

    private ServiceConnector addInitializedGetConnector(ServiceEndpoint serviceEndpoint, GetServiceBindingConfig bindingConfig) throws PublishException {
        Configurable c = Configurator.getConfigurable(bindingConfig);
        String path = bindingConfig.getName();
        ServiceConnector connector = new ServiceConnector();
        this.initConnector(connector, bindingConfig, c, serviceEndpoint);
        return connector;
    }

    private void addServiceBindingI(Configurable c) {
        ServiceBindingConfig bindingConfig = (ServiceBindingConfig)c.narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$ServiceBindingConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.ServiceBindingConfig")) : class$com$idoox$wasp$server$config$ServiceBindingConfig);
        String path = bindingConfig.getName();
        String version = null;
        try {
            version = bindingConfig.getVersion();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (version != null) {
            try {
                path = path.substring(0, path.length() - version.length() - 1);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ServiceInstanceImpl serviceInstance = null;
        try {
            serviceInstance = this.getServiceInstanceObject(bindingConfig.getServiceClassRef(), null);
        }
        catch (DisabledServiceException ignore) {
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        try {
            serviceInstance.setTTL(bindingConfig.getDefaultTTL());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            if (bindingConfig.getMaxInstances() != null) {
                serviceInstance.setMaxInstances(bindingConfig.getMaxInstances());
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ServiceEndpoint serviceEndpoint = this.createPersistentServiceEndpoint(path, version, serviceInstance, bindingConfig);
        serviceEndpoint.setConfigurable(c);
        try {
            AttributesHelper.parseAttributes(c, serviceInstance.getClassSpace().getClassLoader(), serviceEndpoint.getAttributes());
        }
        catch (Exception ignore) {
            cat.error("Exception during parsing attributes of service endpoint " + serviceEndpoint.getPath(), ignore);
        }
        this.addServiceEndpointListeners(serviceEndpoint, bindingConfig);
        ((ServiceEndpointImpl)serviceEndpoint).setServiceBindingConfig(bindingConfig);
        ((ServiceEndpointImpl)serviceEndpoint).postRegistrate();
        ServiceConnector connector = null;
        try {
            connector = this.addInitializedConnector(serviceEndpoint, bindingConfig);
        }
        catch (PublishException e) {
            throw new RuntimeWrappedException(e);
        }
        boolean rawService = false;
        try {
            rawService = (class$org$systinet$wasp$webservice$RawService == null ? (class$org$systinet$wasp$webservice$RawService = ServiceManagerImpl.class$("org.systinet.wasp.webservice.RawService")) : class$org$systinet$wasp$webservice$RawService).isAssignableFrom(serviceEndpoint.getServiceInstance().getImplementationClass());
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoClassDefFoundError ignore) {
            // empty catch block
        }
        this.putToConnectorMaps(connector, rawService);
        Map map = this.bindingsOfInstance;
        synchronized (map) {
            HashSet<String> bindings = (HashSet<String>)this.bindingsOfInstance.get(bindingConfig.getServiceClassRef());
            if (bindings == null) {
                bindings = new HashSet<String>();
                this.bindingsOfInstance.put(bindingConfig.getServiceClassRef(), bindings);
            }
            bindings.add(bindingConfig.getName());
        }
        try {
            if (bindingConfig.getPreload()) {
                this.preload(connector);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ((RegistryImpl)this).invokeServiceEndpointListenersOnPublishDone(serviceEndpoint);
        ((ServiceEndpointImpl)serviceEndpoint).invokeListenersOnPublishDone();
    }

    private void addGetServiceBindingI(Configurable c) {
        GetServiceBindingConfig bindingConfig = (GetServiceBindingConfig)c.narrow(class$com$idoox$wasp$server$config$GetServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$GetServiceBindingConfig = ServiceManagerImpl.class$("com.idoox.wasp.server.config.GetServiceBindingConfig")) : class$com$idoox$wasp$server$config$GetServiceBindingConfig);
        String path = bindingConfig.getName();
        String version = null;
        try {
            version = bindingConfig.getVersion();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ServiceInstanceImpl serviceInstance = null;
        try {
            serviceInstance = this.getServiceInstanceObject(bindingConfig.getServiceClassRef(), null);
        }
        catch (DisabledServiceException ignore) {
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        try {
            serviceInstance.setTTL(bindingConfig.getDefaultTTL());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            if (bindingConfig.getMaxInstances() != null) {
                serviceInstance.setMaxInstances(bindingConfig.getMaxInstances());
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ServiceEndpoint serviceEndpoint = this.createPersistentServiceEndpoint(path, version, serviceInstance, bindingConfig);
        serviceEndpoint.setConfigurable(c);
        try {
            AttributesHelper.parseAttributes(c, serviceInstance.getClassSpace().getClassLoader(), serviceEndpoint.getAttributes());
        }
        catch (Exception ignore) {
            cat.error("Exception during parsing attributes of service endpoint " + serviceEndpoint.getPath(), ignore);
        }
        this.addServiceEndpointListeners(serviceEndpoint, bindingConfig);
        ServiceConnector connector = null;
        try {
            connector = this.addInitializedGetConnector(serviceEndpoint, bindingConfig);
        }
        catch (PublishException e) {
            throw new RuntimeWrappedException(e);
        }
        boolean rawService = false;
        try {
            rawService = (class$org$systinet$wasp$webservice$RawService == null ? (class$org$systinet$wasp$webservice$RawService = ServiceManagerImpl.class$("org.systinet.wasp.webservice.RawService")) : class$org$systinet$wasp$webservice$RawService).isAssignableFrom(serviceEndpoint.getServiceInstance().getImplementationClass());
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoClassDefFoundError ignore) {
            // empty catch block
        }
        this.putToConnectorMaps(connector, rawService);
        Map map = this.getBindingsOfInstance;
        synchronized (map) {
            HashSet<String> bindings = (HashSet<String>)this.getBindingsOfInstance.get(bindingConfig.getServiceClassRef());
            if (bindings == null) {
                bindings = new HashSet<String>();
                this.getBindingsOfInstance.put(bindingConfig.getServiceClassRef(), bindings);
            }
            bindings.add(bindingConfig.getName());
        }
        try {
            if (bindingConfig.getPreload()) {
                this.preload(connector);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    public void removeServiceBinding(String name) {
        this.removeServiceBinding(name, null);
    }

    public void removeServiceBinding(String name, String version) {
        if (name == null) {
            return;
        }
        try {
            Registry.unpublish(name, version);
        }
        catch (PublishException publishException) {
            // empty catch block
        }
    }

    public void addServiceInstance(Configurable c) {
        if (c == null) {
            return;
        }
    }

    public void removeServiceInstance(String name) {
        if (name == null) {
            return;
        }
        Map map = this.serviceInstances;
        synchronized (map) {
            if (this.serviceInstances.containsKey(name)) {
                ServiceInstanceImpl instance = (ServiceInstanceImpl)this.serviceInstances.get(name);
                this.serviceInstanceToWebServiceContext.remove(instance);
                Map map2 = this.bindingsOfInstance;
                synchronized (map2) {
                    this.bindingsOfInstance.remove(name);
                }
                Map map3 = this.getBindingsOfInstance;
                synchronized (map3) {
                    this.getBindingsOfInstance.remove(name);
                }
                ServiceInstance serviceInstance = (ServiceInstance)this.serviceInstances.remove(name);
                this.instanceToName.remove(name);
                Map map4 = this.serviceInstanceToServiceEndpoints;
                synchronized (map4) {
                    Set serviceEndpoints;
                    Set set = serviceEndpoints = (Set)this.serviceInstanceToServiceEndpoints.get(serviceInstance);
                    synchronized (set) {
                        Object[] allEndpoints = serviceEndpoints.toArray();
                        int i = 0;
                        while (i < allEndpoints.length) {
                            try {
                                Registry.unpublish((ServiceEndpoint)allEndpoints[i]);
                            }
                            catch (PublishException ignore) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                }
            }
        }
    }

    public CallMediator[] getCallMediators() {
        return this.callMediators;
    }

    private void handleGetRequest(Connection conn) {
        OutputMessage output = conn.getOutputMessage();
        try {
            ServiceConnector getConnector;
            if (output != null) {
                output.setStringHeader("Server", org.systinet.wasp.Version.getVersion());
            }
            URI uri = conn.getURI();
            String path = uri.getPath();
            if (uri.getParameterNames() != null && uri.getParameterNames().contains("debug")) {
                path = "/debug";
            }
            if ((getConnector = this.getGetConnector(path)) == null) {
                getConnector = this.getGetConnector("/wsdl");
            }
            if (getConnector != null) {
                this.dispatchRequest(conn, getConnector);
            }
        }
        catch (Throwable e) {
            cat.error("Throwable during GET dispatch", e);
            try {
                StringWriter swriter = new StringWriter();
                e.printStackTrace(new PrintWriter(swriter));
                String faultString = "Internal server error: \r\n" + swriter.toString();
                try {
                    output.setStatusCode(500);
                    output.setContentType("text/plain");
                }
                catch (Exception e1) {
                    // empty catch block
                }
                output.write(faultString.getBytes(Constants.UTF_8));
                output.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
    }

    private void handlePutOrDeleteRequest(Connection conn, String method) {
        OutputMessage output = conn.getOutputMessage();
        try {
            URI uri;
            String path;
            ServiceConnector getConnector;
            if (output != null) {
                output.setStringHeader("Server", org.systinet.wasp.Version.getVersion());
            }
            if ((getConnector = this.getGetConnector(path = (uri = conn.getURI()).getPath())) != null) {
                this.dispatchRequest(conn, getConnector);
            } else if (output != null) {
                output.setStatusCode(405);
                output.close();
            }
        }
        catch (Throwable e) {
            cat.error("Throwable during " + method + " dispatch", e);
            try {
                StringWriter swriter = new StringWriter();
                e.printStackTrace(new PrintWriter(swriter));
                String faultString = "Internal server error: \r\n" + swriter.toString();
                try {
                    output.setStatusCode(500);
                    output.setContentType("text/plain");
                }
                catch (Exception e1) {
                    // empty catch block
                }
                output.write(faultString.getBytes(Constants.UTF_8));
                output.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
    }

    public Definition getDefinition(ServiceEndpoint serviceEndpoint) throws WSDLException, PublishException, IOException, DisabledServiceException, ClassNotFoundException {
        ServiceConnector connector = this.getConnector(serviceEndpoint.getPath());
        if (connector != null) {
            if (connector.getServiceEndpoint() == serviceEndpoint) {
                return this.getDefinition(connector, null, false);
            }
            VersionCollection olderConnectors = connector.getOlderVersions();
            if (olderConnectors.size() > 0) {
                VersionCollection.Iterator connectors = olderConnectors.iterator();
                while (connectors.hasNext()) {
                    ServiceConnector olderConnector = (ServiceConnector)connectors.next();
                    if (olderConnector.getServiceEndpoint() != serviceEndpoint) continue;
                    return this.getDefinition(olderConnector, null, false);
                }
            }
        }
        return null;
    }

    public Definition getDefinition(String path, String serviceURI, boolean setURI) throws DisabledServiceException, ClassNotFoundException, PublishException, IOException, WSDLException {
        ServiceConnector connector = this.getConnector(path);
        return this.getDefinition(connector, serviceURI, setURI);
    }

    public Definition getDefinition(ServiceConnector connector, String serviceURI, boolean setURI) throws DisabledServiceException, ClassNotFoundException, PublishException, IOException, WSDLException {
        if (connector == null) {
            return null;
        }
        Map map = this.definitions;
        synchronized (map) {
            Definition definition;
            ServiceEndpoint serviceEndpoint = connector.getServiceEndpoint();
            Definition def = (Definition)this.definitions.get(serviceEndpoint);
            ServiceBindingConfig config = null;
            WSDLConfig wsdlConfig = null;
            if (def == null) {
                RuntimeListenerWSDLEvent event;
                ServiceInstanceImpl instance;
                ClassLoader classLoader;
                config = connector.getConfig();
                wsdlConfig = config.getWsdl();
                if (wsdlConfig == null) {
                    wsdlConfig = config.newWsdl();
                    config.setWsdl(wsdlConfig);
                }
                if ((classLoader = (instance = connector.getService()).getClassSpace() != null ? instance.getClassSpace().getClassLoader() : instance.getImplementationClass().getClassLoader()) == null) {
                    classLoader = ClassSpaceHelper.getWaspClassSpace().getClassLoader();
                }
                if ((def = this.invokeListenersOnGenerateWSDL(event = new RuntimeListenerWSDLEvent(connector, config, instance.getImplementationClassName(), null, classLoader))) == null) {
                    Definition definition2 = null;
                    return definition2;
                }
                this.definitions.put(serviceEndpoint, def);
            }
            if (setURI) {
                if (connector == null) {
                    definition = def;
                    return definition;
                }
                if (config == null) {
                    config = connector.getConfig();
                    wsdlConfig = config.getWsdl();
                }
                Service service = null;
                if (wsdlConfig != null && wsdlConfig.getService() != null) {
                    service = def.getService(wsdlConfig.getService());
                }
                if (service == null) {
                    Map services = def.getServices();
                    Iterator i = services.values().iterator();
                    if (i.hasNext()) {
                        service = (Service)i.next();
                    }
                    if (service != null) {
                        wsdlConfig.setService(service.getQName());
                    }
                }
                if (service != null) {
                    Map portsMap = service.getPorts();
                    Iterator it = portsMap.values().iterator();
                    while (it.hasNext()) {
                        Port port = (Port)it.next();
                        Iterator extElementI = port.getExtensibilityElements().iterator();
                        while (extElementI.hasNext()) {
                            ExtensibilityElement extE = (ExtensibilityElement)extElementI.next();
                            if (extE instanceof SOAPAddress) {
                                SOAPAddress soapAddress = (SOAPAddress)extE;
                                String overridingSOAPAddress = config.getServiceURL();
                                if (overridingSOAPAddress != null) {
                                    soapAddress.setLocationURI(overridingSOAPAddress);
                                } else {
                                    soapAddress.setLocationURI(serviceURI);
                                }
                            }
                            if (!(extE instanceof HTTPAddress)) continue;
                            HTTPAddress httpAddress = (HTTPAddress)extE;
                            String overridingHTTPAddress = config.getServiceURL();
                            if (overridingHTTPAddress != null) {
                                httpAddress.setLocationURI(overridingHTTPAddress);
                                continue;
                            }
                            httpAddress.setLocationURI(serviceURI);
                        }
                    }
                }
            }
            definition = def;
            return definition;
        }
    }

    public static String getServerGUID() {
        if (serverGUID == null) {
            Class clazz = class$com$systinet$wasp$webservice$RegistryImpl == null ? (class$com$systinet$wasp$webservice$RegistryImpl = ServiceManagerImpl.class$("com.systinet.wasp.webservice.RegistryImpl")) : class$com$systinet$wasp$webservice$RegistryImpl;
            synchronized (clazz) {
                if (serverGUID == null) {
                    try {
                        InetAddress iA = InetAddress.getLocalHost();
                        SimpleDateFormat dF = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
                        dF.setTimeZone(TimeZone.getTimeZone("GMT"));
                        serverGUID = iA.getHostName() + ":" + dF.format(new Date()) + " GMT:" + Long.toHexString(new Random().nextLong()).toUpperCase();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot create server GUID: " + e.getMessage() != null ? e.getMessage() : "");
                    }
                }
            }
        }
        return serverGUID;
    }

    public Object createDirectSmartStub(Class stubInterface, String serviceURL, String instanceId) throws MalformedURLException {
        if (serviceURL == null) {
            return null;
        }
        String localServiceURI = this.transportRepository.getLocalPath(new Endpoint(serviceURL));
        if (localServiceURI == null) {
            return null;
        }
        WSContext callerContext = WSContext.getInstance();
        ServiceConnector caller = null;
        if (callerContext != null) {
            caller = this.getConnector(callerContext.getPath());
        }
        if (caller == null) {
            return null;
        }
        ServiceConnector callee = this.getConnector(localServiceURI);
        if (callee == null) {
            return null;
        }
        return callee.createDirectSmartStub(caller, stubInterface, instanceId);
    }

    public void registerServiceCreationListener(EndpointCreationListener listener) {
        List list = serviceCreationListeners;
        synchronized (list) {
            serviceCreationListeners.add(listener);
        }
    }

    public void invokeServiceCreationListeners() {
        int i = 0;
        while (i < serviceCreationListeners.size()) {
            EndpointCreationListener listener = (EndpointCreationListener)serviceCreationListeners.get(i);
            listener.serviceCreated();
            ++i;
        }
    }

    public String[] getServiceInstanceNames() {
        return this.instanceToName.values().toArray(new String[0]);
    }

    public WebServiceContext addServiceInstance(Class serviceClass) {
        return this.addServiceInstanceHelper(null, serviceClass);
    }

    public WebServiceContext addServiceInstance(Object serviceObject) {
        return this.addServiceInstanceHelper(serviceObject, serviceObject.getClass());
    }

    private synchronized WebServiceContext addServiceInstanceHelper(Object obj, Class cls) {
        Object object = obj;
        try {
            if (object == null) {
                object = cls.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
        String name = InstanceNameGenerator.generateName(object);
        ServiceInstanceImpl newInst = new ServiceInstanceImpl(object, null, name);
        this.serviceInstances.put(name, newInst);
        newInst.setRegistered();
        return this.getWebServiceContext(name, newInst);
    }

    public void removeServiceInstance(WebServiceContext svc) {
        this.removeServiceInstance(svc.getServiceInstanceName());
    }

    public WSContext addServiceEndpoint(WebServiceContext svcInstance, String path) throws InvalidEndpointPathException {
        ServiceInstance serviceInstance = svcInstance.getServiceInstance();
        ServiceEndpoint serviceEndpoint = ServiceEndpoint.create(path, serviceInstance);
        try {
            Registry.publish(serviceEndpoint);
        }
        catch (PublishException e) {
            throw new InvalidEndpointPathException("Backward compatibility code: " + e.toString());
        }
        return this.createWSContext(serviceEndpoint);
    }

    public WSContext addServiceEndpoint(WebServiceContext svcInstance, String path, String wsdlURI, QName serviceQName) throws InvalidEndpointPathException, WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance("com.idoox.wsdl.factory.WSDLFactoryImpl");
        WSDLReader reader = wsdlFactory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        Definition def = serviceQName != null ? reader.readWSDL(serviceQName.getNamespaceURI(), wsdlURI) : reader.readWSDL(null, wsdlURI);
        return this.addServiceEndpoint(svcInstance, path, def, serviceQName);
    }

    public WSContext addServiceEndpoint(WebServiceContext svcInstance, String path, Definition wsdl, QName serviceQName) throws InvalidEndpointPathException {
        ServiceInstance serviceInstance = svcInstance.getServiceInstance();
        ServiceEndpoint serviceEndpoint = ServiceEndpoint.create(path, serviceInstance);
        serviceEndpoint.setWSDL(wsdl);
        serviceEndpoint.setWSDLServiceName(serviceQName);
        try {
            Registry.publish(serviceEndpoint);
        }
        catch (PublishException e) {
            throw new InvalidEndpointPathException("Backward compatibility code: " + e.toString());
        }
        return this.createWSContext(serviceEndpoint);
    }

    private ServiceEndpoint createPersistentServiceEndpoint(String path, String version, ServiceInstance serviceInstance, ServiceBindingConfig bindingConfig) {
        ServiceEndpointImpl endpoint = this.createServiceEndpoint(path, version, serviceInstance, bindingConfig);
        endpoint.setPersistent(true);
        return endpoint;
    }

    private ServiceEndpointImpl createServiceEndpoint(String path, String version, ServiceInstance serviceInstance, ServiceBindingConfig bindingConfig) {
        WSDLConfig wsdlConfig;
        if (serviceInstance == null) {
            // empty if block
        }
        ServiceEndpointImpl endpoint = new ServiceEndpointImpl(path, serviceInstance);
        endpoint.setVersion(version);
        this.mapServiceInstances(endpoint);
        if (bindingConfig != null && (wsdlConfig = bindingConfig.getWsdl()) != null) {
            endpoint.setWSDLServiceName(wsdlConfig.getService());
        }
        endpoint.setRegistered(true);
        return endpoint;
    }

    protected void mapServiceInstances(ServiceEndpoint se) {
        ServiceInstance serviceInstance = se.getServiceInstance();
        Map map = this.serviceInstances;
        synchronized (map) {
            HashSet<ServiceEndpoint> endpoints = (HashSet<ServiceEndpoint>)this.serviceInstanceToServiceEndpoints.get(serviceInstance);
            if (endpoints == null) {
                endpoints = new HashSet<ServiceEndpoint>();
                this.serviceInstanceToServiceEndpoints.put(serviceInstance, endpoints);
            }
            HashSet<ServiceEndpoint> hashSet = endpoints;
            synchronized (hashSet) {
                endpoints.add(se);
            }
        }
    }

    protected void addServiceEndpointListeners(ServiceEndpoint serviceEndpoint, ServiceBindingConfig bindingConfig) {
        ServiceBindingConfig.Listener[] listeners = bindingConfig.getListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                ServiceBindingConfig.Listener listener = listeners[i];
                String refName = listener.getRef();
                ServiceEndpointListener endpointListener = this.listenerRepository.getServiceEndpointListener(refName);
                if (endpointListener == null) {
                    throw new RuntimeException("Cannot add listener: " + refName + " for service endpoint: " + serviceEndpoint.getPath() + ". Listener doesn't exist.");
                }
                serviceEndpoint.addListener(endpointListener);
                ++i;
            }
        }
    }

    public void removeServiceEndpoint(WSContext serviceContext) {
        this.removeServiceBinding(serviceContext.getPath());
    }

    public WSContext addService(String path, Class serviceClass) throws InvalidEndpointPathException {
        WebServiceContext inst = this.addServiceInstance(serviceClass);
        WSContext retval = this.addServiceEndpoint(inst, path);
        try {
            ServiceInstanceImpl serviceInstance = (ServiceInstanceImpl)this.serviceInstances.get(inst.getServiceInstanceName());
            serviceInstance.enable();
            try {
                serviceInstance.waitForState(4);
            }
            catch (InterruptedException e) {
                cat.error("Waiting on initialization of service instance interrupted:" + path);
            }
        }
        catch (InvalidStateTransitionException ignore) {
            // empty catch block
        }
        return retval;
    }

    public WSContext addService(String path, Object svc) throws InvalidEndpointPathException {
        WebServiceContext inst = this.addServiceInstance(svc);
        WSContext retval = this.addServiceEndpoint(inst, path);
        try {
            ServiceInstanceImpl serviceInstance = (ServiceInstanceImpl)this.serviceInstances.get(inst.getServiceInstanceName());
            serviceInstance.enable();
            try {
                serviceInstance.waitForState(4);
            }
            catch (InterruptedException e) {
                cat.error("Waiting on initialization of service instance interrupted:" + path);
            }
        }
        catch (InvalidStateTransitionException ignore) {
            // empty catch block
        }
        return retval;
    }

    public WebServiceContext getServiceInstance(String serviceName) throws ServiceInstanceNotFoundException {
        ServiceInstanceImpl inst;
        try {
            inst = this.getServiceInstanceObject(serviceName);
        }
        catch (DisabledServiceException e) {
            throw new ServiceInstanceNotFoundException("Service " + serviceName + " is disabled");
        }
        catch (ClassNotFoundException e) {
            throw new ServiceInstanceNotFoundException("Service " + serviceName + " returned ClassNotFoundException during initialization.");
        }
        if (inst == null) {
            throw new ServiceInstanceNotFoundException("No such service name: " + serviceName);
        }
        return this.getWebServiceContext(serviceName, inst);
    }

    public WebServiceContext getWebServiceContext(String name, ServiceInstance serviceInstance) {
        WebServiceContextImpl retVal = (WebServiceContextImpl)this.serviceInstanceToWebServiceContext.get(serviceInstance);
        if (retVal == null) {
            retVal = new WebServiceContextImpl(name, serviceInstance.getContext());
            this.serviceInstanceToWebServiceContext.put(serviceInstance, retVal);
        }
        return retVal;
    }

    public WSContext getWSContext(ServiceEndpoint serviceEndpoint) {
        WSContextImpl retVal = (WSContextImpl)this.serviceEndpointToWSContext.get(serviceEndpoint);
        if (retVal == null) {
            retVal = new WSContextImpl(serviceEndpoint);
            this.serviceEndpointToWSContext.put(serviceEndpoint, retVal);
        }
        return retVal;
    }

    private WSContext createWSContext(ServiceEndpoint serviceEndpoint) {
        WSContextImpl retVal = new WSContextImpl(serviceEndpoint);
        this.serviceEndpointToWSContext.put(serviceEndpoint, retVal);
        return retVal;
    }

    public WSContext getServiceEndpoint(String path, TransportMethod transportMethod) throws InvalidEndpointPathException {
        ServiceConnector conn;
        ServiceConnector serviceConnector = transportMethod == TransportMethod.POST ? this.getConnector(path) : (conn = transportMethod == TransportMethod.GET ? this.getGetConnector(path) : null);
        if (conn == null) {
            throw new InvalidEndpointPathException("No such service path");
        }
        return this.getWSContext(Registry.getServiceEndpoint(path));
    }

    public String[] getServiceEndpointsPaths(WebServiceContext svc) {
        ServiceInstance serviceInstance = svc.getServiceInstance();
        ArrayList<String> result = new ArrayList<String>(20);
        Iterator i = ((Set)this.serviceInstanceToServiceEndpoints.get(serviceInstance)).iterator();
        while (i.hasNext()) {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)i.next();
            result.add(serviceEndpoint.getPath());
        }
        return result.toArray(new String[0]);
    }

    public WSContext[] getServiceEndpoints(WebServiceContext svc) {
        ServiceInstance serviceInstance = svc.getServiceInstance();
        ArrayList<WSContext> result = new ArrayList<WSContext>(20);
        Iterator i = ((Set)this.serviceInstanceToServiceEndpoints.get(serviceInstance)).iterator();
        while (i.hasNext()) {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)i.next();
            result.add(this.getWSContext(serviceEndpoint));
        }
        return result.toArray(new WSContext[0]);
    }

    public String[] getServiceEndpointsPaths(String name) throws ServiceInstanceNotFoundException {
        ServiceInstanceImpl serviceInstance = (ServiceInstanceImpl)this.serviceInstances.get(name);
        if (serviceInstance == null) {
            throw new ServiceInstanceNotFoundException("Service instance not found");
        }
        ArrayList<String> result = new ArrayList<String>(20);
        Iterator i = ((Set)this.serviceInstanceToServiceEndpoints.get(serviceInstance)).iterator();
        while (i.hasNext()) {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)i.next();
            result.add(serviceEndpoint.getPath());
        }
        return result.toArray(new String[0]);
    }

    public static void addChainHeaders(Java2WSDL java2WSDL, String name) {
        ArrayList handlerInfos = new ArrayList();
        HandlerRepository.HandlerChainRepresentation repre = handlerRepo.getHandlerChain(name);
        handlerInfos.addAll(repre.getHandlerInfos());
        repre = handlerRepo.getHandlerChain("DefaultServerHandlers");
        handlerInfos.addAll(repre.getHandlerInfos());
        Iterator it = handlerInfos.iterator();
        HashMap<QName, Header> headers = new HashMap<QName, Header>();
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        while (it.hasNext()) {
            WaspHandlerInfoImpl handlerInfo = (WaspHandlerInfoImpl)it.next();
            Header[] waspHeaders = handlerInfo.getWASPHeaders();
            int i = 0;
            while (i < waspHeaders.length) {
                boolean isOut;
                Header waspHeader = waspHeaders[i];
                boolean isIn = (waspHeader.getDirection() & 1) == 1;
                boolean bl = isOut = (waspHeader.getDirection() & 2) == 2;
                if ((isIn || isOut) && !headers.containsKey(waspHeader.getName())) {
                    headers.put(waspHeader.getName(), waspHeader);
                }
                ++i;
            }
            schemata.addAll(Arrays.asList(handlerInfo.getSchemas()));
        }
        java2WSDL.addHeaders(headers.values().toArray(new Header[0]), schemata.toArray(new Schema[0]));
    }

    private void preload(ServiceConnector connector) {
        List list = this.connectorsToPreload;
        synchronized (list) {
            if (this.delayPreloading) {
                this.connectorsToPreload.add(connector);
                return;
            }
        }
        this.preloadNow(connector);
    }

    private void preloadNow(ServiceConnector connector) {
        try {
            connector.getService().getImplementationObject();
        }
        catch (Exception e) {
            cat.error("Could not preload service for path " + connector.getName() + " because of:", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ENCODING_URI = "serviceManager.encoding_uri";
        try {
            closeLine = "==== CLOSE =====================================================================".getBytes(Constants.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private class PreloadingListener
    implements ModuleRepository.Listener {
        private PreloadingListener() {
        }

        public void onLoadModules() {
            List list = ServiceManagerImpl.this.connectorsToPreload;
            synchronized (list) {
                if (!ServiceManagerImpl.this.delayPreloading) {
                    return;
                }
                ServiceManagerImpl.this.delayPreloading = false;
            }
            Iterator iterator = ServiceManagerImpl.this.connectorsToPreload.iterator();
            while (iterator.hasNext()) {
                ServiceManagerImpl.this.preloadNow((ServiceConnector)iterator.next());
            }
            ServiceManagerImpl.this.connectorsToPreload.clear();
        }
    }

    static class PreloadingThreads
    extends ThreadPool {
        public PreloadingThreads() {
            super("PreloadingThreads", 0, 10, true);
        }

        protected void handle(Object object) {
            ServiceConnector connector = (ServiceConnector)object;
            try {
                connector.getService().getImplementationObject();
            }
            catch (Exception e) {
                cat.error("Could not preload service for path " + connector.getName() + " because of:", e);
            }
        }
    }

    protected class ClassToWsdlListener
    implements ServiceManagerListener {
        protected ClassToWsdlListener() {
        }

        public Object onObtainImplamentation(String name, ClassLoader contextClassLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            return null;
        }

        public void onGenerateWSDL(ServiceManagerListener.WSDLGenerationEvent event) throws PublishException {
            QName serviceName;
            if (event.getWSDL() != null) {
                return;
            }
            if (event.getServiceBindingConfig() == null) {
                return;
            }
            if (event.getServiceEndpointContext().getServiceEndpoint().getServiceType() != 0) {
                return;
            }
            String className = event.getServiceBindingConfig().getInterfaceName();
            if (className == null) {
                className = event.getInstanceName();
            }
            if (!this.isClassName(className)) {
                return;
            }
            Class<?> clazz = null;
            try {
                clazz = event.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new PublishException("Can't load service class", e);
            }
            ServiceEndpointImpl endpoint = (ServiceEndpointImpl)event.getServiceEndpointContext().getServiceEndpoint();
            Java2WSDL java2WSDL = Java2WSDLFactory.newJava2WSDL();
            int use = endpoint.getUse();
            int style = endpoint.getStyle();
            java2WSDL.setSOAPEncoding(use);
            java2WSDL.setBindingStyle(style);
            String protocol = event.getServiceBindingConfig().getProtocol();
            if (protocol != null) {
                if ("soap".equals(protocol) || "soap11".equals(protocol)) {
                    java2WSDL.setProtocol(305);
                } else if ("soap12".equals(protocol)) {
                    java2WSDL.setProtocol(306);
                }
            }
            String tns = null;
            WSDLConfig wsdlConfig = event.getServiceBindingConfig().getWsdl();
            if (wsdlConfig == null) {
                wsdlConfig = event.getServiceBindingConfig().newWsdl();
                event.getServiceBindingConfig().setWsdl(wsdlConfig);
            }
            if ((serviceName = wsdlConfig.getService()) == null) {
                serviceName = this.getServiceQName(clazz);
                wsdlConfig.setService(serviceName);
            }
            HashMap<String, Java2WSDL.ServiceDefinition> serviceMapping = new HashMap<String, Java2WSDL.ServiceDefinition>();
            tns = serviceName.getNamespaceURI();
            Java2WSDL.ServiceDefinition serviceDefinition = new Java2WSDL.ServiceDefinition();
            serviceDefinition.wsdlServiceName = serviceName.getLocalPart();
            serviceMapping.put(className, serviceDefinition);
            HashMap<String, String> tnsMapping = new HashMap<String, String>();
            tnsMapping.put(ClassHelper.getPackage(clazz), tns);
            java2WSDL.setPackageMapping(tnsMapping);
            java2WSDL.setServiceMapping(serviceMapping);
            String serializationID = ServiceManagerImpl.this.serializationRepository.createSerialization();
            java2WSDL.setSerializationID(serializationID);
            ServiceManagerImpl.addChainHeaders(java2WSDL, endpoint.getHandlersID());
            Definition def = java2WSDL.generateDefinition(clazz);
            event.setWSDL(def);
        }

        private QName getServiceQName(Class clazz) {
            return new QName(this.getTargetNameSpace(clazz), ClassHelper.getFlatName(clazz.getName()));
        }

        private String getTargetNameSpace(Class clazz) {
            String pkg = ClassHelper.getPackage(clazz.getName());
            return ClassHelper.getDefaultTargetNamespace(pkg);
        }

        private boolean isClassName(String name) {
            if (name == null) {
                return false;
            }
            return name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.indexOf(47) == -1 && name.indexOf(58) == -1;
        }
    }

    protected class RuntimeRegisteredWSDLsListener
    implements ServiceManagerListener {
        protected RuntimeRegisteredWSDLsListener() {
        }

        public Object onObtainImplamentation(String name, ClassLoader contextClassLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            return null;
        }

        public void onGenerateWSDL(ServiceManagerListener.WSDLGenerationEvent event) throws PublishException {
            if (event.getWSDL() != null) {
                return;
            }
            ServiceEndpointImpl endpoint = (ServiceEndpointImpl)event.getServiceEndpointContext().getServiceEndpoint();
            Definition wsdl = endpoint.getDefinition();
            if (wsdl != null) {
                event.setWSDL(wsdl);
            }
        }
    }

    protected class WsdlFromFileListener
    implements ServiceManagerListener {
        protected WsdlFromFileListener() {
        }

        public Object onObtainImplamentation(String name, ClassLoader contextClassLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            return null;
        }

        public void onGenerateWSDL(ServiceManagerListener.WSDLGenerationEvent event) throws PublishException {
            if (event.getWSDL() != null) {
                return;
            }
            if (event.getServiceBindingConfig() == null) {
                return;
            }
            Definition def = null;
            WSDLConfig wsdlConfig = event.getServiceBindingConfig().getWsdl();
            if (wsdlConfig == null) {
                return;
            }
            String file = wsdlConfig.getFile();
            if (file == null) {
                return;
            }
            String path = event.getServiceEndpointContext().getServiceEndpoint().getPath();
            if (path == null) {
                return;
            }
            ServiceConnector connector = (ServiceConnector)ServiceManagerImpl.this.connectors.get(path);
            if (connector == null) {
                return;
            }
            String url = connector.getRootPath() + file;
            try {
                def = ServiceManagerImpl.this.wsdlRepository.getDefinition(url);
            }
            catch (Exception e) {
                throw new PublishException("Can't read WSDL ", e);
            }
            event.setWSDL(def);
        }
    }

    protected static class ClassServiceManagerListener
    implements ServiceManagerListener {
        protected ClassServiceManagerListener() {
        }

        public void onGenerateWSDL(ServiceManagerListener.WSDLGenerationEvent event) throws PublishException {
        }

        public Object onObtainImplamentation(String name, ClassLoader ccl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            if (!this.isClassName(name)) {
                return null;
            }
            Class<?> clazz = ccl.loadClass(name);
            return clazz.newInstance();
        }

        private boolean isClassName(String name) {
            if (name == null) {
                return false;
            }
            return name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.indexOf(47) == -1 && name.indexOf(58) == -1;
        }
    }

    protected static class RuntimeListenerWSDLEvent
    implements ServiceManagerListener.WSDLGenerationEvent {
        ServiceBindingConfig config;
        String instanceName;
        Definition wsdl;
        ClassLoader classLoader;
        ServiceEndpointContext context;

        public RuntimeListenerWSDLEvent(ServiceConnector connector, ServiceBindingConfig config, String instanceName, Definition wsdl, ClassLoader classLoader) {
            this.config = config;
            this.instanceName = instanceName;
            this.wsdl = wsdl;
            this.classLoader = classLoader;
            this.context = connector.getServiceEndpoint().getContext();
        }

        public ServiceBindingConfig getServiceBindingConfig() {
            return this.config;
        }

        public void setServiceBindingConfig(ServiceBindingConfig config) {
            this.config = config;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String name) {
            this.instanceName = name;
        }

        public Definition getWSDL() {
            return this.wsdl;
        }

        public void setWSDL(Definition wsdl) {
            this.wsdl = wsdl;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public ServiceEndpointContext getServiceEndpointContext() {
            return this.context;
        }

        public void setServiceEndpointContext(ServiceEndpointContext context) {
            this.context = context;
        }
    }

    class InstanceCleanerTask
    extends TimerTask {
        InstanceCleanerTask() {
        }

        public void run() {
            this.expireServices(ServiceManagerImpl.this.connectors);
            this.expireServices(ServiceManagerImpl.this.wildConnectorsB);
            this.expireServices(ServiceManagerImpl.this.wildConnectorsE);
            this.expireServices(ServiceManagerImpl.this.getConnectors);
            this.expireServices(ServiceManagerImpl.this.wildGetConnectorsB);
            this.expireServices(ServiceManagerImpl.this.wildGetConnectorsE);
        }

        private void expireServices(Map connectors) {
            Map map = connectors;
            synchronized (map) {
                Iterator entries = connectors.entrySet().iterator();
                while (entries.hasNext()) {
                    ServiceRegistry registry;
                    ServiceConnector con = (ServiceConnector)entries.next().getValue();
                    if (con == null || (registry = con.getRegistry()) == null) continue;
                    registry.expireServices(System.currentTimeMillis() / 1000L);
                }
            }
        }
    }

    class ReferenceQueueCleaner
    extends TimerTask {
        ReferenceQueueCleaner() {
        }

        public void run() {
            FinalizationSupport.doFinalization();
        }
    }

    class DispatcherConnHandler
    implements ConnectionHandler {
        DispatcherConnHandler() {
        }

        public void handlePost(ServerConnection connection) {
            ServiceManagerImpl.this.dispatch(connection);
        }

        public void handleGet(ServerConnection connection) {
            ServiceManagerImpl.this.handleGetRequest(connection);
        }

        public void handlePut(ServerConnection connection) {
            ServiceManagerImpl.this.handlePutOrDeleteRequest(connection, "PUT");
        }

        public void handleDelete(ServerConnection connection) {
            ServiceManagerImpl.this.handlePutOrDeleteRequest(connection, "DELETE");
        }
    }
}

