/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.monitoring;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import org.systinet.monitoring.Event;

public class LogEvent
implements Event,
Serializable {
    protected String type;
    protected String subsystem;
    protected Object[] messageParameters;
    protected Throwable throwable;
    protected Map eventParameters;
    protected int severity;
    protected String message;
    protected String categoryName;
    protected String serverName;

    public LogEvent() {
    }

    public LogEvent(String eventType) {
        this.type = eventType;
    }

    public String getMessageText() {
        if (this.message != null && this.messageParameters != null) {
            return MessageFormat.format(this.message, this.messageParameters);
        }
        if (this.message != null) {
            return this.message;
        }
        return "";
    }

    public LogEvent(String type, String subsystem, Object[] messageParameters, Throwable throwable, Map eventParameters) {
        this(type);
        this.subsystem = subsystem;
        this.messageParameters = messageParameters;
        this.throwable = throwable;
        this.eventParameters = eventParameters;
        this.serverName = "";
    }

    public String getType() {
        return this.type;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public Object[] getMessageParameters() {
        return this.messageParameters;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Map getEventParameters() {
        return this.eventParameters;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public void setMessageParameters(Object[] messageParameters) {
        this.messageParameters = messageParameters;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setEventParameters(Map eventParameters) {
        this.eventParameters = eventParameters;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("[type=").append(this.type);
        sb.append(", message=").append(this.message);
        sb.append(", loggerName=").append(this.categoryName);
        sb.append(", serverName=").append(this.serverName);
        sb.append(", severity=").append(this.severity);
        sb.append(", messageParameters=").append(this.messageParameters);
        sb.append(", eventParameters=").append(this.eventParameters);
        sb.append("]");
        return sb.toString();
    }
}

