/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xmlrpc.header;

import com.idoox.debug.Category;
import com.idoox.util.CopyOnWriteHelper;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.xmlrpc.config.HPRepositoryConfig;
import com.idoox.xmlrpc.config.HeaderInstanceConfig;
import com.idoox.xmlrpc.config.HeadersConfig;
import com.idoox.xmlrpc.header.HPEntry;
import com.idoox.xmlrpc.header.HPInstance;
import com.idoox.xmlrpc.header.HeaderHelperImpl;
import com.idoox.xmlrpc.header.HeaderProcessorChain;
import com.idoox.xmlrpc.header.HeaderProcessorChainImpl;
import com.idoox.xmlrpc.header.HeaderProcessorRepository;
import com.systinet.wasp.webservice.InstanceNameGenerator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.xmlrpc.header.HeaderProcessor;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.handler.WaspHandlerInfo;

public class HeaderProcessorRepositoryImpl
implements HeaderProcessorRepository,
Module,
CopyOnWriteHelper.CopyingHandler {
    private static final Category dbg = Category.getCategory("com.idoox.xmlrpc.header.HeaderProcessorRepositoryImpl");
    private Map processingIDtoHPEntry = new HashMap(11, 0.75f);
    private static Map hpchainToprocessingID = new WeakHashMap(11, 0.75f);
    private static Map hpchainTodirection = new WeakHashMap(11, 0.75f);
    private HPEntry defaultHeaders;
    private Configurable defaultHeadersConfig;
    private Map instances = new HashMap(11, 0.75f);
    private Map understandedHeaders = new HashMap(11, 0.75f);
    private Map usedSchemas = new HashMap(11, 0.75f);
    private Configurator configurator;
    private static HandlerRepository handlerRepo;
    private Set creationStack = new HashSet(11, 0.75f);
    private static long entryCount;
    private static final String ENTRY_NAME_PREFIX = "@e";
    private static final String[] emptyStringArray;
    private final CopyOnWriteHelper COW = new CopyOnWriteHelper(this, "@");
    static /* synthetic */ Class class$com$idoox$xmlrpc$config$HPRepositoryConfig;
    static /* synthetic */ Class class$com$idoox$xmlrpc$config$HeadersConfig;
    static /* synthetic */ Class class$com$idoox$xmlrpc$config$HeaderInstanceConfig;
    static /* synthetic */ Class class$org$idoox$xmlrpc$header$HeaderProcessor;

    public void load(Configurable moduleConfig) {
        handlerRepo = null;
        InitialReferencesRegistrar.addInitialReference("com.idoox.xmlrpc.header.HeaderProcessorRepository", this);
        InitialReferencesRegistrar.addInitialReference("org.idoox.xmlrpc.header.HeaderHelper", new HeaderHelperImpl());
        this.configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        HPRepositoryConfig c = (HPRepositoryConfig)moduleConfig.narrow(class$com$idoox$xmlrpc$config$HPRepositoryConfig == null ? (class$com$idoox$xmlrpc$config$HPRepositoryConfig = HeaderProcessorRepositoryImpl.class$("com.idoox.xmlrpc.config.HPRepositoryConfig")) : class$com$idoox$xmlrpc$config$HPRepositoryConfig);
        String defaultHeadersName = c.getDefaultHeaders();
        if (defaultHeadersName != null) {
            this.defaultHeadersConfig = Configurator.getConfigurable("Headers", defaultHeadersName);
            if (this.defaultHeadersConfig == null) {
                dbg.info("Invalid name supplied for default header processors");
            } else {
                this.defaultHeaders = this.createHPEntry(this.defaultHeadersConfig);
                if (this.defaultHeaders == null) {
                    dbg.info("Cannot load default header processors");
                }
            }
        }
        Configurable[] configs = Configurator.getTopEntries("Headers");
        int i = 0;
        while (i < configs.length) {
            HPEntry entry;
            String name = configs[i].getName();
            if (!this.processingIDtoHPEntry.containsKey(name) && (entry = this.createHPEntry(configs[i])) == null) {
                dbg.info("Cannot load header processors configuration " + name);
            }
            ++i;
        }
    }

    public void init() {
    }

    public void destroy() {
        this.instances.clear();
        this.processingIDtoHPEntry.clear();
    }

    private HPEntry createHPEntry(Configurable c) {
        HeadersConfig config = (HeadersConfig)c.narrow(class$com$idoox$xmlrpc$config$HeadersConfig == null ? (class$com$idoox$xmlrpc$config$HeadersConfig = HeaderProcessorRepositoryImpl.class$("com.idoox.xmlrpc.config.HeadersConfig")) : class$com$idoox$xmlrpc$config$HeadersConfig);
        String name = config.getName();
        this.creationStack.add(name);
        HeadersConfig.Import[] imports = config.getImports();
        HPEntry[] im = new HPEntry[imports.length];
        int i = 0;
        while (i < imports.length) {
            String ref = imports[i].getRef();
            im[i] = (HPEntry)this.processingIDtoHPEntry.get(ref);
            if (im[i] == null) {
                if (this.creationStack.contains(ref)) {
                    dbg.info("Cyclic dependency detected during initialization of " + name);
                    break;
                }
                Configurable c0 = Configurator.getConfigurable("Headers", ref);
                if (c0 == null) {
                    dbg.info("Cannot create headers " + ref + " - configuration does not exist");
                    break;
                }
                im[i] = this.createHPEntry(c0);
                if (im[i] == null) break;
            }
            ++i;
        }
        this.creationStack.remove(name);
        if (i < imports.length) {
            return null;
        }
        HPEntry retval = new HPEntry();
        retval.name = name;
        i = 0;
        while (i < im.length) {
            retval.in.importChain(im[i].in);
            retval.defOut.importChain(im[i].defOut);
            retval.defInFault.importChain(im[i].defInFault);
            retval.defOutFault.importChain(im[i].defOutFault);
            ++i;
        }
        HeadersConfig.Headers hdrs = config.getInHeaders();
        if (hdrs != null && !this.fillChain(hdrs, retval.in, name)) {
            return null;
        }
        hdrs = config.getOutHeaders();
        if (hdrs != null && !this.fillChain(hdrs, retval.defOut, name)) {
            return null;
        }
        hdrs = config.getInFaultHeaders();
        if (hdrs != null && !this.fillChain(hdrs, retval.defInFault, name)) {
            return null;
        }
        hdrs = config.getOutFaultHeaders();
        if (hdrs != null && !this.fillChain(hdrs, retval.defOutFault, name)) {
            return null;
        }
        this.processingIDtoHPEntry.put(name, retval);
        return retval;
    }

    public String addHPInstance(HeaderProcessor instance) {
        String name = InstanceNameGenerator.generateName(instance);
        this.instances.put(name, instance);
        return name;
    }

    public void removeHPInstance(String name) {
        this.removeHeaderProcessor(name);
    }

    public String createHeaders() {
        String name;
        String string = ENTRY_NAME_PREFIX;
        synchronized (string) {
            name = ENTRY_NAME_PREFIX + entryCount++;
        }
        this.createHeaders(name);
        return name;
    }

    private void createHeaders(String name) {
        HPEntry fresh;
        if (this.defaultHeaders != null) {
            fresh = this.createHPEntry(this.defaultHeadersConfig);
        } else {
            fresh = new HPEntry();
            fresh.name = name;
            fresh.in = new HeaderProcessorChainImpl();
            fresh.defOut = new HeaderProcessorChainImpl();
            fresh.defInFault = new HeaderProcessorChainImpl();
            fresh.defOutFault = new HeaderProcessorChainImpl();
        }
        this.processingIDtoHPEntry.put(name, fresh);
        this.setupHandlerInfo(fresh, name);
    }

    private void setupHandlerInfo(HPEntry entry, String processingID) {
        hpchainToprocessingID.put(entry.in, processingID);
        hpchainToprocessingID.put(entry.defOut, processingID);
        hpchainToprocessingID.put(entry.defInFault, processingID);
        hpchainToprocessingID.put(entry.defOutFault, processingID);
        hpchainTodirection.put(entry.in, new Integer(1));
        hpchainTodirection.put(entry.defOut, new Integer(2));
        hpchainTodirection.put(entry.defInFault, new Integer(12));
        hpchainTodirection.put(entry.defOutFault, new Integer(12));
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, QName[] understoodHeaders, boolean needsBody) {
        HeaderProcessorChainImpl hpChain = (HeaderProcessorChainImpl)hpChainParam;
        HPInstance inst = new HPInstance();
        if (understoodHeaders == null) {
            understoodHeaders = new QName[]{};
        }
        inst.understandHeaders = understoodHeaders;
        inst.instance = this.getHPInstance(name);
        if (inst.instance == null) {
            throw new IllegalArgumentException("nonexistent header name");
        }
        inst.needsBody = needsBody;
        if (inst.needsBody) {
            ++hpChain.needsBodyCounter;
        }
        hpChain.processors.add(inst);
        hpChain.processorNames.add(name);
        this.addHPInstanceToHandlerChain(hpChain, inst, name);
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, QName[] understoodHeaders) {
        this.addHeaderProcessor(hpChainParam, name, understoodHeaders, false);
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, QName[] understoodHeaders, int position, boolean needsBody) {
        HeaderProcessorChainImpl hpChain = (HeaderProcessorChainImpl)hpChainParam;
        HPInstance inst = new HPInstance();
        if (understoodHeaders == null) {
            understoodHeaders = new QName[]{};
        }
        inst.understandHeaders = understoodHeaders;
        inst.instance = this.getHPInstance(name);
        if (inst.instance == null) {
            throw new IllegalArgumentException("nonexistent header name");
        }
        inst.needsBody = needsBody;
        if (inst.needsBody) {
            ++hpChain.needsBodyCounter;
        }
        hpChain.processors.add(position, inst);
        hpChain.processorNames.add(position, name);
        this.addHPInstanceToHandlerChain(hpChain, inst, name, position);
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, QName[] understoodHeaders, int position) {
        this.addHeaderProcessor(hpChainParam, name, understoodHeaders, position, false);
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, HPInstance.Header[] headers, HPInstance.Schema[] schemas, boolean needsBody) {
        HeaderProcessorChainImpl hpChain = (HeaderProcessorChainImpl)hpChainParam;
        HPInstance inst = new HPInstance();
        inst.understandHeaders = new QName[headers.length];
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                inst.addHeader(headers[i]);
                inst.understandHeaders[i] = headers[i].getName();
                ++i;
            }
        }
        if (schemas != null) {
            int i = 0;
            while (i < schemas.length) {
                inst.addSchema(schemas[i]);
                ++i;
            }
        }
        inst.instance = this.getHPInstance(name);
        inst.needsBody = needsBody;
        if (inst.needsBody) {
            ++hpChain.needsBodyCounter;
        }
        if (inst.instance == null) {
            throw new IllegalArgumentException("nonexistent header name");
        }
        hpChain.processors.add(inst);
        hpChain.processorNames.add(name);
        this.addHPInstanceToHandlerChain(hpChain, inst, name);
    }

    public void addHPInstanceToHandlerChain(HeaderProcessorChain hpChain, HPInstance instance, String name) {
        this.addHPInstanceToHandlerChain(hpChain, instance, name, -1);
    }

    public void addHPInstanceToHandlerChain(HeaderProcessorChain hpChain, HPInstance instance, String name, int position) {
        WaspHandlerInfo handlerInfo = HPInstance.toHandlerInfo(instance, name);
        int direction = (Integer)hpchainTodirection.get(hpChain);
        String processingID = (String)hpchainToprocessingID.get(hpChain);
        handlerInfo.setDirection(direction);
        HeaderProcessorRepositoryImpl.getHandlerRepo();
        HandlerRepository.HandlerChainRepresentation repre = handlerRepo.getHandlerChain(processingID);
        repre.registerHandlerBC(handlerInfo, position, true);
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, HPInstance.Header[] headers, HPInstance.Schema[] schemas) {
        this.addHeaderProcessor(hpChainParam, name, headers, schemas, false);
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, HPInstance.Header[] headers, HPInstance.Schema[] schemas, int position, boolean needsBody) {
        HeaderProcessorChainImpl hpChain = (HeaderProcessorChainImpl)hpChainParam;
        HPInstance inst = new HPInstance();
        inst.understandHeaders = new QName[headers.length];
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                inst.addHeader(headers[i]);
                inst.understandHeaders[i] = headers[i].getName();
                ++i;
            }
        }
        if (schemas != null) {
            int i = 0;
            while (i < schemas.length) {
                inst.addSchema(schemas[i]);
                ++i;
            }
        }
        inst.instance = this.getHPInstance(name);
        if (inst.instance == null) {
            throw new IllegalArgumentException("nonexistent header name");
        }
        inst.needsBody = needsBody;
        if (inst.needsBody) {
            ++hpChain.needsBodyCounter;
        }
        hpChain.processors.add(position, inst);
        hpChain.processorNames.add(position, name);
        this.addHPInstanceToHandlerChain(hpChain, inst, name, position);
    }

    public void addHeaderProcessor(HeaderProcessorChain hpChainParam, String name, HPInstance.Header[] headers, HPInstance.Schema[] schemas, int position) {
        this.addHeaderProcessor(hpChainParam, name, headers, schemas, position);
    }

    public static void removeHeaderProcessor(HeaderProcessorChain hpChainParam, String name) {
        HeaderProcessorChainImpl hpChain = (HeaderProcessorChainImpl)hpChainParam;
        int index = hpChain.processorNames.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException("header processor named \"" + name + "\" is not present in the chain");
        }
        HPInstance hpInstance = (HPInstance)hpChain.processors.get(index);
        hpChain.processors.remove(index);
        hpChain.processorNames.remove(index);
        if (hpInstance != null && hpInstance.needsBody && hpChain.needsBodyCounter > 0) {
            --hpChain.needsBodyCounter;
        }
        String processingID = (String)hpchainToprocessingID.get(hpChain);
        int direction = (Integer)hpchainTodirection.get(hpChain);
        HeaderProcessorRepositoryImpl.getHandlerRepo();
        HandlerRepository.HandlerChainRepresentation repre = handlerRepo.getHandlerChain(processingID);
        repre.unregisterHandlerBC(name, direction);
    }

    public static String[] getHeaderProcessors(HeaderProcessorChain hpChainParam) {
        HeaderProcessorChainImpl hpChain = (HeaderProcessorChainImpl)hpChainParam;
        return hpChain.processorNames.toArray(emptyStringArray);
    }

    HPInstance.Header[] getHPHeaders(String name) {
        Vector<HPInstance.Header> ret = new Vector<HPInstance.Header>();
        HPInstance.Header[] retval = (HPInstance.Header[])this.understandedHeaders.get(name);
        if (retval == null) {
            ClassSpace classSpace;
            Configurable c = Configurator.getConfigurable("HeaderInstance", name);
            if (c == null) {
                dbg.error("Cannot find configuration for HP instance " + name);
                return null;
            }
            HeaderInstanceConfig config = (HeaderInstanceConfig)c.narrow(class$com$idoox$xmlrpc$config$HeaderInstanceConfig == null ? (class$com$idoox$xmlrpc$config$HeaderInstanceConfig = HeaderProcessorRepositoryImpl.class$("com.idoox.xmlrpc.config.HeaderInstanceConfig")) : class$com$idoox$xmlrpc$config$HeaderInstanceConfig);
            String classSpaceName = config.getClassSpaceName();
            try {
                classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
            }
            catch (MalformedURLException e) {
                dbg.error("Cannot create class space for the HP instance " + name);
                return null;
            }
            HeaderInstanceConfig.Header[] headers = config.getHeaders();
            if (headers != null) {
                int i = 0;
                while (i < headers.length) {
                    try {
                        int direction = 3;
                        if (headers[i].getDirection() != null) {
                            if (headers[i].getDirection().equals("in")) {
                                direction = 1;
                            } else if (headers[i].getDirection().equals("out")) {
                                direction = 2;
                            }
                        }
                        Class<?> clazz = null;
                        if (headers[i].getClazz() != null) {
                            clazz = classSpace.getClassLoader().loadClass(headers[i].getClazz());
                        }
                        HPInstance.Header header = new HPInstance.Header(headers[i].getQname(), headers[i].getType(), clazz, direction);
                        ret.add(header);
                    }
                    catch (ClassNotFoundException e) {
                        dbg.error("Can't load class for header processor" + name);
                        return null;
                    }
                    ++i;
                }
                retval = new HPInstance.Header[ret.size()];
                retval = ret.toArray(retval);
                this.understandedHeaders.put(name, retval);
            }
        }
        return retval;
    }

    HPInstance.Schema[] getHPSchemas(String name) {
        Vector<HPInstance.Schema> ret = new Vector<HPInstance.Schema>();
        HPInstance.Schema[] retval = (HPInstance.Schema[])this.usedSchemas.get(name);
        if (retval == null) {
            ClassSpace classSpace;
            Configurable c = Configurator.getConfigurable("HeaderInstance", name);
            if (c == null) {
                dbg.error("Cannot find configuration for HP instance " + name);
                return null;
            }
            HeaderInstanceConfig config = (HeaderInstanceConfig)c.narrow(class$com$idoox$xmlrpc$config$HeaderInstanceConfig == null ? (class$com$idoox$xmlrpc$config$HeaderInstanceConfig = HeaderProcessorRepositoryImpl.class$("com.idoox.xmlrpc.config.HeaderInstanceConfig")) : class$com$idoox$xmlrpc$config$HeaderInstanceConfig);
            String classSpaceName = config.getClassSpaceName();
            try {
                classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
            }
            catch (MalformedURLException e) {
                dbg.error("Cannot create class space for the HP instance " + name);
                return null;
            }
            ClassLoader cl = classSpace.getClassLoader();
            HeaderInstanceConfig.Schema[] schemas = config.getSchemas();
            if (schemas != null) {
                int i = 0;
                while (i < schemas.length) {
                    String locationURL = schemas[i].getSchemaLocation();
                    Endpoint endpoint = null;
                    URL url = null;
                    try {
                        endpoint = new Endpoint(locationURL);
                    }
                    catch (MalformedURLException e) {
                        break;
                    }
                    if ("resource".equals(endpoint.getScheme())) {
                        String path = endpoint.getPath();
                        while (path.startsWith("/")) {
                            path = path.substring(1);
                        }
                        url = cl.getResource(path);
                    }
                    if (url == null) {
                        dbg.error("Cannot load schema: " + endpoint);
                        break;
                    }
                    HPInstance.Schema schema = new HPInstance.Schema(url.toExternalForm(), schemas[i].getNamespaceURI());
                    ret.add(schema);
                    ++i;
                }
                retval = new HPInstance.Schema[ret.size()];
                retval = ret.toArray(retval);
                this.usedSchemas.put(name, retval);
            }
        }
        return retval;
    }

    public HeaderProcessor getHPInstance(String name) {
        HeaderProcessor retval = (HeaderProcessor)this.instances.get(name);
        if (retval == null) {
            Configurable c = Configurator.getConfigurable("HeaderInstance", name);
            if (c == null) {
                dbg.error("Cannot find configuration for HP instance " + name);
                return null;
            }
            HeaderInstanceConfig config = (HeaderInstanceConfig)c.narrow(class$com$idoox$xmlrpc$config$HeaderInstanceConfig == null ? (class$com$idoox$xmlrpc$config$HeaderInstanceConfig = HeaderProcessorRepositoryImpl.class$("com.idoox.xmlrpc.config.HeaderInstanceConfig")) : class$com$idoox$xmlrpc$config$HeaderInstanceConfig);
            String className = config.getClassName();
            if (className == null) {
                dbg.error("Class name must be specified for HP instance " + name);
                return null;
            }
            String classSpaceName = config.getClassSpaceName();
            try {
                ClassSpace classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
                retval = (HeaderProcessor)classSpace.createInstance(class$org$idoox$xmlrpc$header$HeaderProcessor == null ? (class$org$idoox$xmlrpc$header$HeaderProcessor = HeaderProcessorRepositoryImpl.class$("org.idoox.xmlrpc.header.HeaderProcessor")) : class$org$idoox$xmlrpc$header$HeaderProcessor, className);
            }
            catch (MalformedURLException e) {
                dbg.error("Cannot create class space for the HP instance " + name);
                return null;
            }
            catch (ClassNotFoundException e) {
                dbg.error("Cannot find implementation class " + className + " for the HP instance " + name);
                return null;
            }
            catch (ClassCastException e) {
                dbg.error("The HP instance implementation for " + name + " must implement org.idoox.xmlrpc.header.HeaderProcessor interface");
                return null;
            }
            catch (InstantiationException e) {
                dbg.error("Cannot instanciate implementation class for HP instance " + name);
                return null;
            }
            catch (IllegalAccessException e) {
                dbg.error("Illegal access exception " + e.getMessage(), e);
                return null;
            }
            this.instances.put(name, retval);
        }
        return retval;
    }

    private boolean fillChain(HeadersConfig.Headers headers, HeaderProcessorChainImpl chain, String name) {
        HeadersConfig.Header[] hArr = headers.getHeaders();
        int i = 0;
        while (i < hArr.length) {
            String instanceName;
            HPInstance hp = new HPInstance();
            HeadersConfig.Header h = hArr[i];
            if (h.getUnderstandHeaders() != null) {
                HeadersConfig.MessageHeader[] mh = h.getUnderstandHeaders().getMessageHeaders();
                if (mh == null) {
                    dbg.info("Invalid understandHeaders configuration for '" + name + "'");
                    return false;
                }
                hp.understandHeaders = new QName[mh.length];
                int j = 0;
                while (j < mh.length) {
                    hp.understandHeaders[j] = mh[j].getName();
                    if (hp.understandHeaders[j] == null) {
                        dbg.info("Invalid understandHeader configuration for '" + name + "'");
                        return false;
                    }
                    ++j;
                }
            } else {
                hp.understandHeaders = new QName[0];
            }
            Boolean needsBody = h.getNeedsBody();
            if (needsBody != null && needsBody.booleanValue()) {
                ++chain.needsBodyCounter;
            }
            if ((instanceName = h.getInstance()) == null) {
                dbg.error("Instance name must be specified in '" + name + "' configuration");
                return false;
            }
            String sOrder = h.getDdOrder();
            int order = -1;
            if (sOrder != null) {
                try {
                    order = Integer.parseInt(sOrder);
                    hp.setDdOrder(order);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            hp.instance = this.getHPInstance(instanceName);
            HPInstance.Header[] hs = this.getHPHeaders(instanceName);
            HPInstance.Schema[] ss = this.getHPSchemas(instanceName);
            if (hs != null) {
                int it = 0;
                while (it < hs.length) {
                    hp.addHeader(hs[it]);
                    ++it;
                }
            }
            if (ss != null) {
                int it = 0;
                while (it < ss.length) {
                    hp.addSchema(ss[it]);
                    ++it;
                }
            }
            if (hp.instance == null) {
                return false;
            }
            chain.processors.add(hp);
            chain.processorNames.add(instanceName);
            ++i;
        }
        return true;
    }

    public HeaderProcessorChain getIncomingHeaderProcessors(String name) {
        HPEntry entry = (HPEntry)this.processingIDtoHPEntry.get(name = this.COW.resolveID(name, true));
        if (entry == null) {
            entry = this.createNewEntry(name);
        }
        return entry.in;
    }

    private HPEntry createNewEntry(String name) {
        this.createHeaders(name);
        return (HPEntry)this.processingIDtoHPEntry.get(name);
    }

    public HeaderProcessorChain getOutgoingHeaderProcessors(String name) {
        HPEntry entry = (HPEntry)this.processingIDtoHPEntry.get(name = this.COW.resolveID(name, true));
        if (entry == null) {
            entry = this.createNewEntry(name);
        }
        return entry.defOut;
    }

    public HeaderProcessorChain getInputFaultHeaderProcessors(String name) {
        HPEntry entry = (HPEntry)this.processingIDtoHPEntry.get(name = this.COW.resolveID(name, true));
        if (entry == null) {
            entry = this.createNewEntry(name);
        }
        return entry.defInFault;
    }

    public HeaderProcessorChain getOutputFaultHeaderProcessors(String name) {
        HPEntry entry = (HPEntry)this.processingIDtoHPEntry.get(name = this.COW.resolveID(name, true));
        if (entry == null) {
            entry = this.createNewEntry(name);
        }
        return entry.defOutFault;
    }

    public synchronized void addHeaderProcessorDeclaration(Configurable c) {
        HPEntry entry;
        if (c == null || !c.getType().equals("Headers")) {
            return;
        }
        String name = c.getName();
        if (!this.processingIDtoHPEntry.containsKey(name) && (entry = this.createHPEntry(c)) == null) {
            dbg.info("Cannot load header processors configuration " + name);
        }
    }

    public synchronized void removeHeaderProcessorDeclaration(String name) {
        if (name == null) {
            return;
        }
        this.COW.removeID(name);
        if (this.processingIDtoHPEntry.containsKey(name)) {
            this.processingIDtoHPEntry.remove(name);
        }
    }

    public void addHeaderProcessor(Configurable c) {
    }

    public void removeHeaderProcessor(String name) {
        if (name == null) {
            return;
        }
        if (this.instances.containsKey(name)) {
            this.instances.remove(name);
        }
    }

    public String cloneHeadersID(String id) {
        return this.COW.cloneID(id);
    }

    public void doCopy(String origID, String newID) {
        if (origID == null) {
            this.createHeaders(newID);
            return;
        }
        HPEntry orig = (HPEntry)this.processingIDtoHPEntry.get(origID);
        if (orig == null) {
            this.createHeaders(newID);
            return;
        }
        HPEntry fresh = new HPEntry();
        fresh.name = newID;
        fresh.in = new HeaderProcessorChainImpl(orig.in);
        fresh.defOut = new HeaderProcessorChainImpl(orig.defOut);
        fresh.defInFault = new HeaderProcessorChainImpl(orig.defInFault);
        fresh.defOutFault = new HeaderProcessorChainImpl(orig.defOutFault);
        this.processingIDtoHPEntry.put(newID, fresh);
        this.setupHandlerInfo(fresh, newID);
    }

    private static final void getHandlerRepo() {
        if (handlerRepo == null) {
            handlerRepo = (HandlerRepository)Context.getInstance("wasp.core.jaxrpc_handler_repository");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        entryCount = 0L;
        emptyStringArray = new String[0];
    }
}

