/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xmlrpc;

import com.idoox.util.ArrayListPool;
import com.idoox.util.ObjectPool;
import com.idoox.util.Pool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.idoox.transport.Connection;
import org.idoox.xmlrpc.Message;

public class CorrelatedMessagePool {
    private Map pool = new HashMap();
    private Map callbacks = new HashMap();

    public synchronized void putMessage(String corrID, Message msg, Connection connection, Map callContext) {
        Callback cbck = (Callback)this.callbacks.get(corrID);
        if (cbck != null) {
            cbck.onArrival(corrID, msg, connection, callContext, this);
            return;
        }
        ArrayList msgs = (ArrayList)this.pool.get(corrID);
        if (msgs == null) {
            msgs = ArrayListPool.getArrayList();
            this.pool.put(corrID, msgs);
        }
        PoolItem item = PoolItemPool.getPoolItem();
        item.msg = msg;
        item.connection = connection;
        item.callContext.putAll(callContext);
        msgs.add(item);
    }

    public synchronized PoolItem getMessage(String corrID) {
        ArrayList msgs = (ArrayList)this.pool.get(corrID);
        if (msgs == null) {
            return null;
        }
        PoolItem retval = (PoolItem)msgs.remove(0);
        if (msgs.isEmpty()) {
            this.pool.remove(corrID);
            ArrayListPool.releaseArrayList(msgs);
        }
        return retval;
    }

    public synchronized List getMessages(String corrID) {
        return (List)this.pool.remove(corrID);
    }

    public synchronized Callback register(Callback obj, String corrID) {
        return this.callbacks.put(corrID, obj);
    }

    public synchronized Callback unregister(String corrID) {
        return (Callback)this.callbacks.remove(corrID);
    }

    public static class PoolItem {
        public Message msg;
        public Connection connection;
        private Map callContext = new HashMap();

        public void fillCallContext(Map otherMap) {
            otherMap.putAll(this.callContext);
        }
    }

    private static abstract class PoolItemPool {
        static Pool pool = new ObjectPool();

        private PoolItemPool() {
        }

        public static PoolItem getPoolItem() {
            PoolItem retval = (PoolItem)pool.get();
            retval.callContext.clear();
            return retval;
        }

        public static void releasePoolItem(PoolItem list) {
            pool.release(list);
        }

        static {
            pool.init(new PoolItemFactory(), 40);
        }

        static class PoolItemFactory
        implements Pool.Factory {
            PoolItemFactory() {
            }

            public Object getNewInstance() {
                return new PoolItem();
            }
        }
    }

    public static interface Callback {
        public void onArrival(String var1, Message var2, Connection var3, Map var4, CorrelatedMessagePool var5);
    }
}

