/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.util;

import com.idoox.transport.util.URLDecoder;
import com.idoox.wsdl.util.WSDLUtil;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.Context;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.Extension;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.RepeatableSchemaConstruct;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SchemaFactory;
import org.idoox.xml.schema.SchemaHolder;
import org.idoox.xml.schema.SchemaParser;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class XMLSchemaUtil {
    public static final QName SOAPENC_ARRAY = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    public static final QName SOAPENC_ARRAYTYPE = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    public static final QName WSDL_ARRAYTYPE = new QName("http://schemas.xmlsoap.org/wsdl/", "arrayType");
    public static final QName ANYTYPE_2001 = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
    public static final SchemaConstruct[] EMPTY_SUBCONTRUCTS = new SchemaConstruct[0];
    static /* synthetic */ Class class$com$idoox$xml$schema$util$XMLSchemaUtil;

    public static SchemaParser parseTypes(Definition def, SchemaParser schemaParser) throws SchemaException {
        List containedSchemas = null;
        try {
            Map schemaLocationMap = schemaParser.getNamespaceLocationMap();
            String SCHEMA_2001_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/2001.xsd")).toExternalForm();
            String SCHEMA_2001_XSD_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/2001-xml.xsd")).toExternalForm();
            String SOAPENC_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/soapenc.xsd")).toExternalForm();
            String SOAPENV_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/soap.xsd")).toExternalForm();
            schemaLocationMap.put("http://www.w3.org/2001/XMLSchema", SCHEMA_2001_URI);
            schemaLocationMap.put("http://schemas.xmlsoap.org/soap/encoding/", SOAPENC_URI);
            schemaLocationMap.put("http://schemas.xmlsoap.org/soap/envelope/", SOAPENV_URI);
            schemaLocationMap.put("http://www.w3.org/XML/1998/namespace", SCHEMA_2001_XSD_URI);
            containedSchemas = WSDLUtil.flatGetSchemas(def);
            Iterator schemaIter = containedSchemas.iterator();
            while (schemaIter.hasNext()) {
                String schema_url = (String)schemaIter.next();
                Element el = (Element)schemaIter.next();
                if (schema_url == null) {
                    schema_url = "urn:unknown";
                }
                if (el != null) {
                    schemaParser.parse(el, new Endpoint(schema_url));
                    continue;
                }
                schemaParser.parse(new Endpoint(schema_url));
            }
        }
        catch (MalformedURLException e) {
            throw new SchemaException(e);
        }
        return schemaParser;
    }

    public static Schema parseTypes(Definition def, Map namespaceURIToLocation, boolean parseFacets) throws SchemaException {
        SchemaFactory factory = (SchemaFactory)Context.getInstance("org.idoox.xml.schema.SchemaFactory");
        SchemaParser parser = factory.newSchemaParser();
        List containedSchemas = null;
        try {
            HashMap<String, String> schemaLocationMap = new HashMap<String, String>();
            String SCHEMA_2001_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/2001.xsd")).toExternalForm();
            String SCHEMA_2001_XSD_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/2001-xml.xsd")).toExternalForm();
            String SOAPENC_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/soapenc.xsd")).toExternalForm();
            String SOAPENV_URI = URLDecoder.decodeUrlWorkaround((class$com$idoox$xml$schema$util$XMLSchemaUtil == null ? (class$com$idoox$xml$schema$util$XMLSchemaUtil = XMLSchemaUtil.class$("com.idoox.xml.schema.util.XMLSchemaUtil")) : class$com$idoox$xml$schema$util$XMLSchemaUtil).getClassLoader().getResource("com/idoox/xml/schema/known_schemas/soap.xsd")).toExternalForm();
            schemaLocationMap.put("http://www.w3.org/2001/XMLSchema", SCHEMA_2001_URI);
            schemaLocationMap.put("http://schemas.xmlsoap.org/soap/encoding/", SOAPENC_URI);
            schemaLocationMap.put("http://schemas.xmlsoap.org/soap/envelope/", SOAPENV_URI);
            schemaLocationMap.put("http://www.w3.org/XML/1998/namespace", SCHEMA_2001_XSD_URI);
            schemaLocationMap.putAll(namespaceURIToLocation);
            parser.setNamespaceLocationMap(schemaLocationMap);
            containedSchemas = WSDLUtil.flatGetSchemas(def);
            parser.setParsingFacets(parseFacets);
            Iterator schemaIter = containedSchemas.iterator();
            while (schemaIter.hasNext()) {
                String schema_url = (String)schemaIter.next();
                Element el = (Element)schemaIter.next();
                if (schema_url == null) {
                    schema_url = "urn:unknown";
                }
                if (el != null) {
                    parser.parse(el, new Endpoint(schema_url));
                    continue;
                }
                parser.parse(new Endpoint(schema_url));
            }
        }
        catch (MalformedURLException e) {
            throw new SchemaException(e);
        }
        parser.resolve();
        return parser.getSchema();
    }

    public static Type getSchemaType(SchemaHolder schema, QName typeQName) throws SchemaException {
        Type ret = schema.getSchemaType(typeQName);
        if (ret != null) {
            return ret;
        }
        try {
            if (schema.getNamespaces().contains(typeQName.getNamespaceURI())) {
                throw new SchemaException("Not found in the schema document");
            }
            schema.getParser().parse(typeQName.getNamespaceURI());
            schema.getParser().resolve();
        }
        catch (SchemaException e) {
            throw new SchemaException("Error while looking for type " + typeQName, e);
        }
        return schema.getSchemaType(typeQName);
    }

    public static Member getSchemaElement(SchemaHolder schema, QName elementQName) throws SchemaException {
        Member ret = schema.getSchemaElement(elementQName);
        if (ret != null) {
            return ret;
        }
        try {
            if (schema.getNamespaces().contains(elementQName.getNamespaceURI())) {
                throw new SchemaException("Not found in the schema document");
            }
            schema.getParser().parse(elementQName.getNamespaceURI());
            schema.getParser().resolve();
        }
        catch (SchemaException e) {
            throw new SchemaException("Error while looking for element " + elementQName, e);
        }
        return schema.getSchemaElement(elementQName);
    }

    public static boolean isMSArray(Type type) {
        int mo;
        if (type.getAttributes() != null && type.getAttributes().length != 0) {
            return false;
        }
        SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type);
        return subconstructs != null && subconstructs.length == 1 && XMLSchemaUtil.representsElement(subconstructs[0]) && ((mo = ((RepeatableSchemaConstruct)subconstructs[0]).getMaxOccurs()) > 1 || mo == -1);
    }

    public static boolean isArray(Type type) {
        if (type.getMaxOccurs() > 1 || type.getMaxOccurs() == -1) {
            return true;
        }
        return type.getBaseType() != null && SOAPENC_ARRAY.equals(type.getBaseType().getName());
    }

    public static boolean representsElement(SchemaConstruct construct) {
        SchemaConstruct.ConstructType constructType = construct.getConstructType();
        if (constructType == SchemaConstruct.ConstructType.MEMBER) {
            return true;
        }
        return constructType == SchemaConstruct.ConstructType.TYPE && ((Type)construct).getKind() == 39;
    }

    public static Type getMSArrayMemberType(SchemaHolder schema, Type type) throws SchemaException {
        int mo;
        SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type = XMLSchemaUtil.dereferenceType(type));
        if (subconstructs != null && subconstructs.length == 1 && XMLSchemaUtil.representsElement(subconstructs[0]) && ((mo = ((RepeatableSchemaConstruct)subconstructs[0]).getMaxOccurs()) > 1 || mo == -1)) {
            SchemaConstruct ref = XMLSchemaUtil.dereferenceConstruct(subconstructs[0]);
            if (ref.getConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                return ((Member)ref).getType();
            }
            if (ref.getConstructType() == SchemaConstruct.ConstructType.TYPE) {
                return (Type)ref;
            }
        }
        throw new SchemaException("Don't know how to handle this type of array");
    }

    public static Type dereferenceType(Type type) {
        Type refType = (Type)type.getReferencedConstruct();
        return refType != null ? refType : type;
    }

    public static Member dereferenceMember(Member member) {
        Member refMember = (Member)member.getReferencedConstruct();
        return refMember != null ? refMember : member;
    }

    public static SchemaConstruct dereferenceConstruct(SchemaConstruct construct) {
        Member refMember = (Member)construct.getReferencedConstruct();
        return refMember != null ? refMember : construct;
    }

    public static Attribute dereferenceAttribute(Attribute attribute) {
        Attribute refAttribute = (Attribute)attribute.getReferencedConstruct();
        return refAttribute != null ? refAttribute : attribute;
    }

    public static Type getArrayMemberType(SchemaHolder schema, Type type) throws SchemaException {
        if (type.getMaxOccurs() > 1 || type.getMaxOccurs() == -1) {
            Type ret = XMLSchemaUtil.dereferenceType(type);
            ItemTypeExtension extension = (ItemTypeExtension)type.getExtension("ItemTypeExtension");
            if (extension != null) {
                return extension.getItemType();
            }
            ret = (Type)ret.clone();
            ret.setMaxOccurs(1);
            type.setExtension("ItemTypeExtension", new ItemTypeExtension(ret));
            return ret;
        }
        if (type.getBaseType() != null && SOAPENC_ARRAY.equals(type.getBaseType().getName())) {
            Attribute soapencArrayType = XMLSchemaUtil.getAttribute(type, SOAPENC_ARRAYTYPE);
            if (soapencArrayType == null) {
                SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type);
                if (subconstructs != null && subconstructs.length == 1) {
                    return XMLSchemaUtil.getConstructType(subconstructs[0]);
                }
                return XMLSchemaUtil.getSchemaType(schema, ANYTYPE_2001);
            }
            String arrayTypeValue = (String)soapencArrayType.getFacets().get(WSDL_ARRAYTYPE);
            if (arrayTypeValue == null) {
                SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type);
                if (subconstructs != null && subconstructs.length == 1) {
                    return XMLSchemaUtil.getConstructType(subconstructs[0]);
                }
                return XMLSchemaUtil.getSchemaType(schema, ANYTYPE_2001);
            }
            int p = arrayTypeValue.indexOf("[");
            if (p < 0) {
                throw new SchemaException("wsdl:arrayType must be an array, but is " + arrayTypeValue);
            }
            String memberQNameString = arrayTypeValue.substring(0, p);
            QName memberTypeName = soapencArrayType.parseQName(memberQNameString);
            return XMLSchemaUtil.getSchemaType(schema, memberTypeName);
        }
        throw new SchemaException("Don't know how to handle this type of array");
    }

    public static int getArrayDimensions(SchemaHolder schema, Type type) throws SchemaException {
        int mo;
        if (type.getMaxOccurs() > 1 || type.getMaxOccurs() == -1) {
            return 1;
        }
        if (type.getBaseType() != null && SOAPENC_ARRAY.equals(type.getBaseType().getName())) {
            Attribute soapencArrayType = XMLSchemaUtil.getAttribute(type, SOAPENC_ARRAYTYPE);
            if (soapencArrayType == null) {
                return 1;
            }
            String arrayTypeValue = (String)soapencArrayType.getFacets().get(WSDL_ARRAYTYPE);
            if (arrayTypeValue == null) {
                return 1;
            }
            int cnt = 1;
            int p = 0;
            while ((p = arrayTypeValue.indexOf(",", p)) >= 0) {
                ++p;
                ++cnt;
            }
            return cnt;
        }
        SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs(type);
        if (subconstructs != null && subconstructs.length == 1 && XMLSchemaUtil.representsElement(subconstructs[0]) && ((mo = ((RepeatableSchemaConstruct)subconstructs[0]).getMaxOccurs()) > 1 || mo == -1)) {
            return 1;
        }
        throw new SchemaException("Don't know how to handle this type of array");
    }

    public static Attribute getAttribute(Type type, QName attrName) {
        Attribute[] attrs = type.getAttributes();
        Attribute ret = XMLSchemaUtil.findAttribute(attrs, attrName);
        if (ret != null) {
            return ret;
        }
        AttributeGroup[] attrg = type.getAttributeGroups();
        if (attrg != null) {
            HashSet processedAttributeGroups = new HashSet(11);
            int i = 0;
            while (i < attrg.length) {
                ret = XMLSchemaUtil.getAttribute(attrg[i], attrName, processedAttributeGroups);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    private static Attribute findAttribute(Attribute[] attrs, QName attrName) {
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                Attribute a;
                QName an = attrs[i].getName();
                if (an != null ? an.equals(attrName) : (a = (Attribute)attrs[i].getReferencedConstruct()).getName().equals(attrName)) {
                    return attrs[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static Attribute getAttribute(AttributeGroup group, QName attrName, HashSet processedAttributeGroups) {
        if (processedAttributeGroups.contains(group)) {
            return null;
        }
        processedAttributeGroups.add(group);
        Attribute[] attrs = group.getAttributes();
        Attribute ret = XMLSchemaUtil.findAttribute(attrs, attrName);
        if (ret != null) {
            return ret;
        }
        AttributeGroup[] attrg = group.getAttributeGroups();
        if (attrg != null) {
            int i = 0;
            while (i < attrg.length) {
                ret = XMLSchemaUtil.getAttribute(attrg[i], attrName, processedAttributeGroups);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    public static Type getConstructType(SchemaConstruct construct) {
        Type constructSchemaType;
        SchemaConstruct.ConstructType constructType = construct.getConstructType();
        if (constructType == SchemaConstruct.ConstructType.MEMBER) {
            constructSchemaType = XMLSchemaUtil.dereferenceMember((Member)construct).getType();
        } else if (constructType == SchemaConstruct.ConstructType.ATTRIBUTE) {
            constructSchemaType = XMLSchemaUtil.dereferenceAttribute((Attribute)construct).getType();
        } else if (constructType == SchemaConstruct.ConstructType.TYPE) {
            constructSchemaType = XMLSchemaUtil.dereferenceType((Type)construct);
        } else {
            throw new RuntimeException("Don't know how to handle " + construct);
        }
        return constructSchemaType;
    }

    public static void flatGroupType(Type type) {
        if (type.getKind() == 36) {
            SchemaConstruct[] refSubconstructs;
            Type ref = (Type)type.getReferencedConstruct();
            if (ref == null) {
                throw new IllegalArgumentException("Group has no reference: " + type);
            }
            type.setKind(ref.getKind());
            type.setReferencedConstruct(null);
            if (type.getMinOccurs() == 1) {
                type.setMinOccurs(ref.getMinOccurs());
            }
            if (type.getMaxOccurs() == 1) {
                type.setMaxOccurs(ref.getMaxOccurs());
            }
            if ((refSubconstructs = ref.getSubconstructs()) != null) {
                SchemaConstruct[] constructs = new SchemaConstruct[refSubconstructs.length];
                System.arraycopy(refSubconstructs, 0, constructs, 0, refSubconstructs.length);
                type.setSubconstructs(constructs);
            } else {
                type.setSubconstructs(null);
            }
        }
    }

    public static SchemaConstruct[] getAllSubconstructs(Type type) {
        boolean baseTypeSequence;
        XMLSchemaUtil.flatGroupType(type);
        SchemaConstruct[] subconstructs = type.getSubconstructs();
        Type baseType = type.getBaseType();
        if (baseType == null || SOAPENC_ARRAY.equals(baseType.getName())) {
            return subconstructs != null ? subconstructs : EMPTY_SUBCONTRUCTS;
        }
        XMLSchemaUtil.flatGroupType(baseType);
        boolean typeSequence = type.getKind() == 35 || type.getKind() == 33;
        boolean bl = baseTypeSequence = baseType.getKind() == 35 || baseType.getKind() == 33;
        if (!typeSequence || !baseTypeSequence) {
            return null;
        }
        SchemaConstruct[] bases = XMLSchemaUtil.getAllSubconstructs(baseType);
        if (bases == null) {
            return subconstructs != null ? subconstructs : EMPTY_SUBCONTRUCTS;
        }
        if (subconstructs == null) {
            return bases;
        }
        SchemaConstruct[] ret = new SchemaConstruct[bases.length + subconstructs.length];
        System.arraycopy(bases, 0, ret, 0, bases.length);
        System.arraycopy(subconstructs, 0, ret, bases.length, subconstructs.length);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ItemTypeExtension
    extends Extension {
        public static final String TYPE = "ItemTypeExtension";
        private Type itemType;

        public ItemTypeExtension() {
        }

        public ItemTypeExtension(Type itemType) {
            this.itemType = itemType;
        }

        public Type getItemType() {
            return this.itemType;
        }

        public void setItemType(Type itemType) {
            this.itemType = itemType;
        }
    }
}

