/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.debug.Category;
import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.GroupParser;
import com.idoox.xml.schema.parser.SchemaParserParams;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class TopLevelGroupParser {
    private static final Category cat = Category.getCategory("com.idoox.cml.schema.parser.TopLevelGroupParser");

    public static Type parse(Element el, SchemaParserImpl parser, SchemaParserParams params) throws SchemaException {
        String tn = params.targetNamespace;
        String localName = ElementHelper.getAttributeNS(el, null, "name");
        QName name = new QName(tn, localName);
        if (parser.isDefinedGroup(name)) {
            Type type = parser.getSchemaGroup(name, false);
            cat.error("Duplicated definition of group " + type);
            return type;
        }
        Type returnedType = parser.getSchemaGroup(name, true);
        GroupParser.parse(returnedType, el, parser, params);
        return returnedType;
    }
}

