/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.AttributeGroupParser;
import com.idoox.xml.schema.parser.AttributeParser;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SimpleTypeListParser;
import com.idoox.xml.schema.parser.SimpleTypeRestrictionParser;
import com.idoox.xml.schema.parser.SimpleTypeUnionParser;
import com.idoox.xml.schema.parser.TypeParser;
import java.io.IOException;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Facet;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SimpleTypeFacetsExtension;
import org.idoox.xml.schema.SimpleTypeUnionExtension;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class SimpleTypeParser {
    public static void parse(Type parseInto, Element el, SchemaParserImpl parser, SchemaParserParams params, boolean topLevel) throws SchemaException {
        String namespaceURI = el.getNamespaceURI();
        parseInto.setKind((short)16);
        Element restriction = ElementHelper.getChildElementByTagName(el, namespaceURI, "restriction");
        Element list = ElementHelper.getChildElementByTagName(el, namespaceURI, "list");
        Element union = ElementHelper.getChildElementByTagName(el, namespaceURI, "union");
        if ((restriction != null ? 1 : 0) + (list != null ? 1 : 0) + (union != null ? 1 : 0) > 1) {
            throw new SchemaException("Only one of (restriction|list|union) allowed in " + ElementHelper.getFullPath(el));
        }
        if (restriction != null) {
            SimpleTypeRestrictionParser.parse(parseInto, restriction, parser, params);
        }
        if (list != null) {
            SimpleTypeListParser.parse(parseInto, list, parser, params);
        }
        if (union != null) {
            SimpleTypeUnionParser.parse(parseInto, union, parser, params);
        }
        Helper.fillFacets(el, parseInto, parser.isParsingFacets());
        Helper.fillJavaType(el, parseInto, parser);
        if (topLevel) {
            parseInto.setPrefixNamespaceMapping(ElementHelper.getAllNamespaces(el, parseInto.getPrefixNamespaceMapping()));
        } else {
            parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
        }
    }

    public static void write(TokenWriter writer, Type type, Set importedNamespaces) throws IOException, SchemaException {
        QName name = type.getName();
        Type referenced = (Type)type.getReferencedConstruct();
        if (name != null) {
            importedNamespaces.add(name.getNamespaceURI());
        }
        if (referenced != null) {
            writer.enter("http://www.w3.org/2001/XMLSchema", "simpleType");
            Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, importedNamespaces);
            Helper.writeQNameAttribute(writer, null, "ref", referenced.getName());
            importedNamespaces.add(referenced.getName().getNamespaceURI());
        } else {
            switch (type.getKind()) {
                case 17: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "simpleType");
                    Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, importedNamespaces);
                    if (name != null) {
                        writer.writeAttribute(null, "name", name.getLocalPart());
                    }
                    SimpleTypeParser.writeJavaMapping(writer, type);
                    SimpleTypeListParser.write(writer, type, importedNamespaces);
                    writer.leave();
                    break;
                }
                case 16: 
                case 20: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "simpleType");
                    Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, importedNamespaces);
                    if (name != null) {
                        writer.writeAttribute(null, "name", name.getLocalPart());
                    }
                    SimpleTypeParser.writeJavaMapping(writer, type);
                    if (type.getBaseType() != null) {
                        writer.enter("http://www.w3.org/2001/XMLSchema", "restriction");
                        QName baseTypeName = type.getBaseType().getName();
                        if (baseTypeName != null) {
                            Helper.writeQNameAttribute(writer, null, "base", baseTypeName);
                        } else {
                            SimpleTypeParser.write(writer, type.getBaseType(), importedNamespaces);
                        }
                        if (type.getExtension("SimpleTypeFacetsExtension") != null) {
                            Facet[] facets = ((SimpleTypeFacetsExtension)type.getExtension("SimpleTypeFacetsExtension")).getFacets().toArray(new Facet[0]);
                            Helper.writeFacets(writer, facets);
                        }
                        writer.leave();
                    }
                    writer.leave();
                    break;
                }
                case 18: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "simpleType");
                    Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, importedNamespaces);
                    if (name != null) {
                        writer.writeAttribute(null, "name", name.getLocalPart());
                    }
                    SimpleTypeParser.writeJavaMapping(writer, type);
                    writer.enter("http://www.w3.org/2001/XMLSchema", "union");
                    SimpleTypeUnionExtension exts = (SimpleTypeUnionExtension)type.getExtension("SimpleTypeUnionExtension");
                    Type[] attribTypes = exts.getAttribUnionTypes();
                    Type[] elemTypes = exts.getElemUnionTypes();
                    if (attribTypes != null) {
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        while (i < attribTypes.length) {
                            QName qname = attribTypes[i].getName();
                            String prefix = writer.getPrefixForNamespace(qname.getNamespaceURI());
                            sb.append(prefix + ":" + qname.getLocalPart() + " ");
                            ++i;
                        }
                        sb.setLength(sb.length() - 1);
                        writer.writeAttribute(null, "memberTypes", sb.toString());
                    }
                    if (elemTypes != null) {
                        int i = 0;
                        while (i < elemTypes.length) {
                            TypeParser.write(writer, elemTypes[i], importedNamespaces, false);
                            ++i;
                        }
                    }
                    writer.leave();
                    writer.leave();
                    break;
                }
                case 19: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "complexType");
                    Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, importedNamespaces);
                    if (name != null) {
                        writer.writeAttribute(null, "name", name.getLocalPart());
                    }
                    SimpleTypeParser.writeJavaMapping(writer, type);
                    writer.enter("http://www.w3.org/2001/XMLSchema", "simpleContent");
                    Type baseType = type.getBaseType();
                    boolean isExtension = false;
                    if (baseType != null) {
                        if (type.isInheritedByRestriction()) {
                            writer.enter("http://www.w3.org/2001/XMLSchema", "restriction");
                        } else {
                            isExtension = true;
                            writer.enter("http://www.w3.org/2001/XMLSchema", "extension");
                        }
                        Helper.writeQNameAttribute(writer, null, "base", baseType.getName());
                        importedNamespaces.add(baseType.getName().getNamespaceURI());
                        if (type.getKind() == 19 && !isExtension && type.getExtension("SimpleTypeFacetsExtension") != null) {
                            Facet[] facets = ((SimpleTypeFacetsExtension)type.getExtension("SimpleTypeFacetsExtension")).getFacets().toArray(new Facet[0]);
                            Helper.writeFacets(writer, facets);
                        }
                        AttributeParser.write(writer, type.getAttributes(), importedNamespaces);
                        AttributeGroupParser.write(writer, type.getAttributeGroups(), importedNamespaces);
                        writer.leave();
                    }
                    writer.leave();
                    writer.leave();
                    break;
                }
                default: {
                    throw new SchemaException("Unsupported writing of " + type.toIndentedString());
                }
            }
        }
    }

    private static void writeJavaMapping(TokenWriter writer, Type type) throws IllegalStateException, IOException {
        writer.enter("http://www.w3.org/2001/XMLSchema", "annotation");
        String javaTypeName = type.getJavaTypeName();
        if (javaTypeName != null) {
            writer.enter("http://www.w3.org/2001/XMLSchema", "appinfo");
            writer.enter("http://systinet.com/mapping/", "java-type");
            writer.writeAttribute(null, "name", javaTypeName);
            writer.leave();
            writer.leave();
        }
        writer.leave();
    }
}

