/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.xml.Writer2Element;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.AttributeGroupParser;
import com.idoox.xml.schema.parser.AttributeParser;
import com.idoox.xml.schema.parser.ElementParser;
import com.idoox.xml.schema.parser.GroupParser;
import com.idoox.xml.schema.parser.PredefinedSchemas;
import com.idoox.xml.schema.parser.Schema2001ElementParser;
import com.idoox.xml.schema.parser.TypeParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.idoox.transport.client.Endpoint;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaElementParser {
    public static void parse(Element schemaElement, SchemaParserImpl parser, Endpoint baseLocation, String defaultTargetNamespace) throws SchemaException {
        SchemaElementParser.parse(schemaElement, parser, baseLocation, defaultTargetNamespace, null);
    }

    public static void parse(Element schemaElement, SchemaParserImpl parser, Endpoint baseLocation, String defaultTargetNamespace, Schema schema) throws SchemaException {
        Schema2001ElementParser.parse(schemaElement, parser, baseLocation, defaultTargetNamespace, schema);
    }

    public static Element write(String namespaceURI, Document doc, Set importedNamespaces, Schema schema) throws SchemaException {
        try {
            Writer2Element writer = new Writer2Element(doc);
            boolean isNamespaceNotPredefined = !PredefinedSchemas.isNamespacePredefined(namespaceURI);
            boolean atLeastOneDefinitionExists = false;
            writer.enter("http://www.w3.org/2001/XMLSchema", "schema");
            int nsId = 0;
            Iterator namespaceIterator = schema.getNamespaces().iterator();
            while (namespaceIterator.hasNext()) {
                String nsURI = (String)namespaceIterator.next();
                if (nsURI == null || nsURI.length() == 0) {
                    writer.setPrefixForNamespace("", "");
                    continue;
                }
                if ("http://www.w3.org/XML/1998/namespace".equals(nsURI)) continue;
                writer.setPrefixForNamespace("sns" + nsId++, nsURI);
            }
            writer.setPrefixForNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            writer.setPrefixForNamespace("map", "http://systinet.com/mapping/");
            if (namespaceURI != null && namespaceURI.length() > 0) {
                writer.writeAttribute(null, "targetNamespace", namespaceURI);
            }
            Iterator typeIterator = schema.getTypes(namespaceURI);
            while (typeIterator.hasNext()) {
                Type tp = (Type)typeIterator.next();
                if (!isNamespaceNotPredefined && PredefinedSchemas.isTypePredefined(namespaceURI, tp.getName().getLocalPart())) continue;
                TypeParser.write(writer, tp, importedNamespaces, true);
                atLeastOneDefinitionExists = true;
            }
            Iterator groupIterator = schema.getGroups(namespaceURI);
            while (groupIterator.hasNext()) {
                Type tp = (Type)groupIterator.next();
                if (!isNamespaceNotPredefined && PredefinedSchemas.isGroupPredefined(namespaceURI, tp.getName().getLocalPart())) continue;
                GroupParser.write(writer, tp, importedNamespaces);
                atLeastOneDefinitionExists = true;
            }
            Iterator memberIterator = schema.getElements(namespaceURI);
            while (memberIterator.hasNext()) {
                Member tp = (Member)memberIterator.next();
                if (!isNamespaceNotPredefined && PredefinedSchemas.isElementPredefined(namespaceURI, tp.getName().getLocalPart())) continue;
                ElementParser.write(writer, tp, importedNamespaces);
                atLeastOneDefinitionExists = true;
            }
            Iterator attributeIterator = schema.getAttributes(namespaceURI);
            while (attributeIterator.hasNext()) {
                Attribute tp = (Attribute)attributeIterator.next();
                if (!isNamespaceNotPredefined && PredefinedSchemas.isAttributePredefined(namespaceURI, tp.getName().getLocalPart())) continue;
                AttributeParser.write((TokenWriter)writer, tp, importedNamespaces);
                atLeastOneDefinitionExists = true;
            }
            Iterator attributeGroupIterator = schema.getAttributeGroups(namespaceURI);
            while (attributeGroupIterator.hasNext()) {
                AttributeGroup tp = (AttributeGroup)attributeGroupIterator.next();
                if (!isNamespaceNotPredefined && PredefinedSchemas.isAttributeGroupPredefined(namespaceURI, tp.getName().getLocalPart())) continue;
                AttributeGroupParser.write((TokenWriter)writer, tp, importedNamespaces);
                atLeastOneDefinitionExists = true;
            }
            if (!atLeastOneDefinitionExists) {
                return null;
            }
            writer.leave();
            writer.flush();
            Element top = (Element)writer.getRootElements().get(0);
            Iterator i = importedNamespaces.iterator();
            while (i.hasNext()) {
                String nsURI = (String)i.next();
                if (nsURI == null || "".equals(nsURI) || nsURI.equals(namespaceURI)) continue;
                Element el = doc.createElement("xs:import");
                el.setAttribute("namespace", nsURI);
                top.insertBefore(el, top.getFirstChild());
            }
            return top;
        }
        catch (IOException e) {
            throw new SchemaException(e);
        }
    }
}

