/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.TopLevelAttributeGroupParser;
import com.idoox.xml.schema.parser.TopLevelAttributeParser;
import com.idoox.xml.schema.parser.TopLevelComplexTypeParser;
import com.idoox.xml.schema.parser.TopLevelElementParser;
import com.idoox.xml.schema.parser.TopLevelGroupParser;
import com.idoox.xml.schema.parser.TopLevelSimpleTypeParser;
import java.net.MalformedURLException;
import org.idoox.transport.client.Endpoint;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Schema2001ElementParser {
    public static void parse(Element schemaElement, SchemaParserImpl parser, Endpoint baseLocation, String defaultTargetNamespace) throws SchemaException {
        Schema2001ElementParser.parse(schemaElement, parser, baseLocation, defaultTargetNamespace, null);
    }

    public static void parse(Element schemaElement, SchemaParserImpl parser, Endpoint baseLocation, String defaultTargetNamespace, Schema schema) throws SchemaException {
        if (!"schema".equals(schemaElement.getLocalName())) {
            throw new SchemaException("Parsed XML is not an XML Schema. <schema> element was expected, <" + schemaElement.getLocalName() + "> element was found");
        }
        String namespaceURI = schemaElement.getNamespaceURI();
        if (namespaceURI == null) {
            return;
        }
        SchemaParserParams params = new SchemaParserParams();
        params.targetNamespace = ElementHelper.getTargetNamespace(schemaElement, null);
        if (defaultTargetNamespace != null) {
            if (params.targetNamespace != null && !defaultTargetNamespace.equals(params.targetNamespace)) {
                throw new SchemaException("Can't include schema with target namespace '" + params.targetNamespace + "' into the different namespace - '" + defaultTargetNamespace + "'");
            }
            params.targetNamespace = defaultTargetNamespace;
            params.chameleonNamespace = defaultTargetNamespace;
        }
        Element[] type1999 = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "type");
        Element[] datatype1999 = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "datatype");
        if (type1999.length > 0 || datatype1999.length > 0) {
            return;
        }
        params.elementFormDefault = "qualified".equals(ElementHelper.getAttribute(schemaElement, "elementFormDefault"));
        params.attributeFormDefault = "qualified".equals(ElementHelper.getAttribute(schemaElement, "attributeFormDefault"));
        Element[] simpleTypes = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "simpleType");
        Element[] complexTypes = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "complexType");
        Element[] elements = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "element");
        Element[] groups = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "group");
        Element[] attributes = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "attribute");
        Element[] attributeGroups = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "attributeGroup");
        Element[] includes = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "include");
        Element[] imports = ElementHelper.getChildrenElementsByTagName(schemaElement, namespaceURI, "import");
        Type parent = new Type(null);
        int i = 0;
        while (i < simpleTypes.length) {
            parent.addSubconstruct(TopLevelSimpleTypeParser.parse(simpleTypes[i], parser, params));
            ++i;
        }
        int i2 = 0;
        while (i2 < complexTypes.length) {
            parent.addSubconstruct(TopLevelComplexTypeParser.parse(complexTypes[i2], parser, params));
            ++i2;
        }
        int i3 = 0;
        while (i3 < elements.length) {
            parent.addSubconstruct(TopLevelElementParser.parse(elements[i3], parser, params));
            ++i3;
        }
        int i4 = 0;
        while (i4 < groups.length) {
            parent.addSubconstruct(TopLevelGroupParser.parse(groups[i4], parser, params));
            ++i4;
        }
        int i5 = 0;
        while (i5 < attributes.length) {
            parent.addSubconstruct(TopLevelAttributeParser.parse(attributes[i5], parser, params));
            ++i5;
        }
        int i6 = 0;
        while (i6 < attributeGroups.length) {
            parent.addSubconstruct(TopLevelAttributeGroupParser.parse(attributeGroups[i6], parser, params));
            ++i6;
        }
        Schema2001ElementParser.processIncludes(includes, parser, baseLocation, params);
        Schema2001ElementParser.processImports(imports, parser, baseLocation, params);
        Node e = schemaElement;
        while (e != null) {
            if (e instanceof Element) {
                parent.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(e, parent.getPrefixNamespaceMapping()));
            }
            e = e.getParentNode();
        }
    }

    private static void processIncludes(Element[] includes, SchemaParserImpl parser, Endpoint baseLocation, SchemaParserParams params) throws SchemaException {
        int i = 0;
        while (i < includes.length) {
            String includedLocationString = ElementHelper.getAttribute(includes[i], "schemaLocation");
            if (includedLocationString != null) {
                try {
                    includedLocationString = includedLocationString.replace('\\', '/');
                    Endpoint includedSchemaLocation = Schema2001ElementParser.createEndpoint(baseLocation, includedLocationString);
                    if (parser.needsToBeParsed(includedSchemaLocation)) {
                        parser.parseImmediatelly(includedSchemaLocation, params.targetNamespace);
                    }
                }
                catch (MalformedURLException e) {
                    throw new SchemaException("Cannot create URL: " + e.getMessage());
                }
            }
            ++i;
        }
    }

    private static void processImports(Element[] imports, SchemaParserImpl parser, Endpoint baseLocation, SchemaParserParams params) throws SchemaException {
        int i = 0;
        while (i < imports.length) {
            String includedLocationString = ElementHelper.getAttribute(imports[i], "schemaLocation");
            String expectedNamespace = ElementHelper.getAttribute(imports[i], "namespace");
            Endpoint includedSchemaLocation = null;
            if (includedLocationString != null) {
                try {
                    includedLocationString = includedLocationString.replace('\\', '/');
                    includedSchemaLocation = Schema2001ElementParser.createEndpoint(baseLocation, includedLocationString);
                }
                catch (MalformedURLException e) {
                    throw new SchemaException("Cannot create URL: " + e.getMessage());
                }
                parser.addImport(includedSchemaLocation, expectedNamespace);
            }
            ++i;
        }
    }

    private static Endpoint createEndpoint(Endpoint context, String location) throws MalformedURLException {
        if (context == null) {
            if (location.indexOf(58) < 0) {
                location = "file:" + location;
            }
            return new Endpoint(location);
        }
        return new Endpoint(context, location);
    }
}

