/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.AllParser;
import com.idoox.xml.schema.parser.AttributeGroupParser;
import com.idoox.xml.schema.parser.AttributeParser;
import com.idoox.xml.schema.parser.ChoiceParser;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SequenceParser;
import java.io.IOException;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class GroupParser {
    public static void parse(Type parseInto, Element el, SchemaParserImpl parser, SchemaParserParams params) throws SchemaException {
        String namespaceURI = el.getNamespaceURI();
        parseInto.setKind((short)36);
        String ref = ElementHelper.getAttributeNS(el, null, "ref");
        if (ref != null) {
            QName refName = ElementHelper.getQName(el, ref);
            refName = ElementHelper.chameleonQName(refName, params.chameleonNamespace);
            Type refType = parser.getSchemaGroup(refName, false);
            parseInto.setReferencedConstruct(refType);
            Helper.setMinMaxOccurs(el, parseInto, 1, 1);
            Helper.fillFacets(el, parseInto, parser.isParsingFacets());
            return;
        }
        Element all = ElementHelper.getChildElementByTagName(el, namespaceURI, "all");
        Element choice = ElementHelper.getChildElementByTagName(el, namespaceURI, "choice");
        Element sequence = ElementHelper.getChildElementByTagName(el, namespaceURI, "sequence");
        if (all != null) {
            AllParser.parse(parseInto, all, parser, params);
        }
        if (choice != null) {
            ChoiceParser.parse(parseInto, choice, parser, params);
        }
        if (sequence != null) {
            SequenceParser.parse(parseInto, sequence, parser, params);
        }
        Helper.setMinMaxOccurs(el, parseInto, parseInto.getMinOccurs(), parseInto.getMaxOccurs());
        Helper.fillFacets(el, parseInto, parser.isParsingFacets());
        String javaName = ElementHelper.getAttributeNS(el, "http://systinet.com/mapping/", "java-field");
        if (javaName != null) {
            parseInto.setJavaName(javaName);
        }
        parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
    }

    public static void write(TokenWriter writer, Type type, Set importedNamespaces) throws IOException, SchemaException {
        QName name = type.getName();
        Type referenced = (Type)type.getReferencedConstruct();
        writer.enter("http://www.w3.org/2001/XMLSchema", "group");
        Helper.writeExtension(writer, type);
        Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, importedNamespaces);
        if (referenced != null) {
            Helper.writeQNameAttribute(writer, null, "ref", referenced.getName());
            importedNamespaces.add(referenced.getName().getNamespaceURI());
        } else {
            if (name != null) {
                writer.writeAttribute(null, "name", name.getLocalPart());
            }
            switch (type.getKind()) {
                case 35: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "sequence");
                    Helper.writeExtension(writer, type);
                    break;
                }
                case 37: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "all");
                    Helper.writeExtension(writer, type);
                    break;
                }
                case 38: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "choice");
                    Helper.writeExtension(writer, type);
                }
            }
            Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, importedNamespaces);
            SchemaConstruct[] subconstructs = type.getSubconstructs();
            if (subconstructs != null) {
                int i = 0;
                while (i < subconstructs.length) {
                    Helper.writeConstruct(writer, subconstructs[i], importedNamespaces, false);
                    ++i;
                }
            }
            switch (type.getKind()) {
                case 35: 
                case 37: 
                case 38: {
                    writer.leave();
                }
            }
            AttributeParser.write(writer, type.getAttributes(), importedNamespaces);
            AttributeGroupParser.write(writer, type.getAttributeGroups(), importedNamespaces);
        }
        writer.leave();
    }
}

