/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.debug.Category;
import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.ComplexTypeParser;
import com.idoox.xml.schema.parser.Constants;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SimpleTypeParser;
import com.idoox.xml.schema.parser.TypeParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class ElementParser {
    private static final Category cat = Category.getCategory("com.idoox.cml.schema.parser.TopLevelElementParser");
    private static final QName ANYTYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "anyType");

    public static Member parse(Element el, SchemaParserImpl parser, SchemaParserParams params, boolean topLevel) throws SchemaException {
        Member ret;
        String localName = ElementHelper.getAttributeNS(el, null, "name");
        String ref = ElementHelper.getAttributeNS(el, null, "ref");
        String java_field = ElementHelper.getAttributeNS(el, "http://systinet.com/mapping/", "java-field");
        if (localName != null) {
            if (ref != null) {
                throw new SchemaException("Expecting one of <name> or <ref> attributes, not both. Context : " + ElementHelper.getFullPath(el));
            }
            String tn = null;
            String form = ElementHelper.getAttribute(el, "form");
            if (form == null) {
                if (params.elementFormDefault || topLevel) {
                    tn = params.targetNamespace;
                }
            } else if ("qualified".equals(form)) {
                tn = params.targetNamespace;
            }
            QName name = new QName(tn, localName);
            if (topLevel && parser.isDefinedElement(name)) {
                Member member = parser.getSchemaElement(name, false);
                return member;
            }
            ret = ElementParser.parseDefinition(name, el, parser, params, topLevel);
        } else if (ref != null) {
            ret = new Member();
            QName refName = ElementHelper.getQName(el, ref);
            refName = ElementHelper.chameleonQName(refName, params.chameleonNamespace);
            ret.setReferencedConstruct(parser.getSchemaElement(refName, false));
        } else {
            throw new SchemaException("Attribute <name> or <ref> must be present on " + ElementHelper.getFullPath(el));
        }
        Helper.setMinMaxOccurs(el, ret, 1, 1);
        Helper.fillFacets(el, ret, parser.isParsingFacets());
        if (topLevel) {
            ret.setPrefixNamespaceMapping(ElementHelper.getAllNamespaces(el, ret.getPrefixNamespaceMapping()));
        } else {
            ret.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, ret.getPrefixNamespaceMapping()));
        }
        String nillableString = ElementHelper.getAttribute(el, "nillable");
        if (nillableString != null && ("1".equals(nillableString) || "true".equals(nillableString))) {
            ret.setNillable(true);
        }
        if (java_field != null) {
            ret.setJavaName(java_field);
        }
        if (ret.getType() == null && ret.getReferencedConstruct() == null) {
            ret.setType(parser.getSchemaType(ANYTYPE_QNAME, false));
        }
        Helper.setAppInfo(el, ret);
        return ret;
    }

    private static Member parseDefinition(QName name, Element el, SchemaParserImpl parser, SchemaParserParams params, boolean topLevel) throws SchemaException {
        Type typeType;
        String namespaceURI = el.getNamespaceURI();
        Member returnedMember = topLevel ? parser.getSchemaElement(name, true) : new Member(name);
        String type = ElementHelper.getAttributeNS(el, null, "type");
        Element simpleType = ElementHelper.getChildElementByTagName(el, namespaceURI, "simpleType");
        Element complexType = ElementHelper.getChildElementByTagName(el, namespaceURI, "complexType");
        if (type != null && (simpleType != null || complexType != null)) {
            throw new SchemaException("Element's type should be defined using attribute <type> or element <simpleType> or <complexType>, not both. Context : " + ElementHelper.getFullPath(el));
        }
        Element annotation = ElementHelper.getChildElementByTagName(el, namespaceURI, "annotation");
        if (annotation != null) {
            Element[] appinfos = ElementHelper.getChildrenElementsByTagName(annotation, namespaceURI, "appinfo");
            int i = 0;
            while (i < appinfos.length) {
                Element javaField = ElementHelper.getChildElementByTagName(appinfos[i], "http://systinet.com/mapping/", "java-field");
                if (javaField != null) {
                    String javaName = ElementHelper.getAttribute(javaField, "name");
                    if (javaName == null) {
                        throw new SchemaException("Missing attribute <name> in element <java-field>. Context: " + ElementHelper.getFullPath(javaField));
                    }
                    if (returnedMember.getJavaName() == null) {
                        returnedMember.setJavaName(javaName);
                    } else {
                        throw new SchemaException("Duplicated <java-field name=''> declaration. Context: " + ElementHelper.getFullPath(javaField));
                    }
                }
                ++i;
            }
        }
        if (type != null) {
            QName typeName = ElementHelper.getQName(el, type);
            typeName = ElementHelper.chameleonQName(typeName, params.chameleonNamespace);
            typeType = parser.getSchemaType(typeName, false);
        } else if (simpleType != null) {
            typeType = new Type();
            SimpleTypeParser.parse(typeType, simpleType, parser, params, false);
            typeType.setParent(returnedMember);
        } else if (complexType != null) {
            typeType = new Type();
            ComplexTypeParser.parse(typeType, complexType, parser, params, false);
            typeType.setParent(returnedMember);
        } else {
            typeType = parser.getSchemaType(Constants.ANY_TYPE, false);
            if (typeType == null) {
                typeType = parser.getSchemaType(Constants.ANY_TYPE2000, false);
            }
            if (typeType == null) {
                typeType = parser.getSchemaType(Constants.ANY_TYPE1999, false);
            }
        }
        returnedMember.setType(typeType);
        return returnedMember;
    }

    public static void write(TokenWriter writer, Member member, Set importedNamespaces) throws IOException, SchemaException {
        QName name = member.getName();
        Type type = member.getType();
        Member referenced = (Member)member.getReferencedConstruct();
        if (name != null) {
            importedNamespaces.add(name.getNamespaceURI());
        }
        writer.enter("http://www.w3.org/2001/XMLSchema", "element");
        Helper.writeExtension(writer, member);
        if (referenced == null) {
            if (member.getFacets() == null) {
                member.setFacets(new HashMap(7));
            }
            if (name != null && name.getNamespaceURI().equals("")) {
                member.getFacets().put(new QName(null, "form"), "unqualified");
            } else {
                member.getFacets().put(new QName(null, "form"), "qualified");
            }
        }
        Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)member, importedNamespaces);
        if (referenced != null) {
            Helper.writeQNameAttribute(writer, null, "ref", referenced.getName());
            importedNamespaces.add(referenced.getName().getNamespaceURI());
        } else {
            writer.writeAttribute(null, "name", name.getLocalPart());
            writer.writeAttribute(null, "nillable", member.isNillable() ? "true" : "false");
            if (type != null) {
                if (type.getName() != null) {
                    importedNamespaces.add(type.getName().getNamespaceURI());
                    Helper.writeQNameAttribute(writer, null, "type", type.getName());
                } else {
                    TypeParser.write(writer, type, importedNamespaces, true);
                }
            }
            if (member.getSubstitutionGroup() != null) {
                Helper.writeQNameAttribute(writer, null, "substitutionGroup", member.getSubstitutionGroup().getName());
            }
        }
        writer.leave();
    }
}

