/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.AllParser;
import com.idoox.xml.schema.parser.AttributeGroupParser;
import com.idoox.xml.schema.parser.AttributeParser;
import com.idoox.xml.schema.parser.ChoiceParser;
import com.idoox.xml.schema.parser.ComplexContentParser;
import com.idoox.xml.schema.parser.GroupParser;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import com.idoox.xml.schema.parser.SequenceParser;
import com.idoox.xml.schema.parser.SimpleContentParser;
import java.io.IOException;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class ComplexTypeParser {
    public static void parse(Type parseInto, Element el, SchemaParserImpl parser, SchemaParserParams params, boolean topLevel) throws SchemaException {
        SchemaConstruct attr;
        int i;
        String namespaceURI = el.getNamespaceURI();
        parseInto.setKind((short)35);
        Element simpleContent = ElementHelper.getChildElementByTagName(el, namespaceURI, "simpleContent");
        Element complexContent = ElementHelper.getChildElementByTagName(el, namespaceURI, "complexContent");
        Element group = ElementHelper.getChildElementByTagName(el, namespaceURI, "group");
        Element all = ElementHelper.getChildElementByTagName(el, namespaceURI, "all");
        Element choice = ElementHelper.getChildElementByTagName(el, namespaceURI, "choice");
        Element sequence = ElementHelper.getChildElementByTagName(el, namespaceURI, "sequence");
        Element[] attributes = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attribute");
        Element[] attributeGroups = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attributeGroup");
        int c = simpleContent != null ? 1 : 0;
        boolean simpleOrComplexContentFound = (c += complexContent != null ? 1 : 0) != 0;
        c += group != null ? 1 : 0;
        c += all != null ? 1 : 0;
        c += choice != null ? 1 : 0;
        if ((c += sequence != null ? 1 : 0) > 1) {
            throw new SchemaException("Only one of <simpleContent>, <complexContent>, <group>, <all>, <choice>, <sequence> allowed in " + ElementHelper.getFullPath(el));
        }
        if (simpleOrComplexContentFound && attributes != null && attributes.length > 0) {
            throw new SchemaException("Can not contain <attribute> when containing <simpleContent> or <complexContent> in " + ElementHelper.getFullPath(el) + ". Place the <attribute> into " + "<...Content>/[extension|restriction]");
        }
        if (simpleOrComplexContentFound && attributeGroups != null && attributeGroups.length > 0) {
            throw new SchemaException("Can not contain <attributeGroup> when containing <simpleContent> or <complexContent> in " + ElementHelper.getFullPath(el) + ". Place the <attributeGroup> into " + "<...Content>/[extension|restriction]");
        }
        if (simpleContent != null) {
            SimpleContentParser.parse(parseInto, simpleContent, parser, params);
        } else if (complexContent != null) {
            ComplexContentParser.parse(parseInto, complexContent, parser, params);
        } else if (group != null) {
            GroupParser.parse(parseInto, group, parser, params);
        } else if (all != null) {
            AllParser.parse(parseInto, all, parser, params);
        } else if (choice != null) {
            ChoiceParser.parse(parseInto, choice, parser, params);
        } else if (sequence != null) {
            SequenceParser.parse(parseInto, sequence, parser, params);
        }
        if (attributes != null) {
            i = 0;
            while (i < attributes.length) {
                attr = AttributeParser.parse(attributes[i], parser, params, false);
                parseInto.addAttribute((Attribute)attr);
                ++i;
            }
        }
        if (attributeGroups != null) {
            i = 0;
            while (i < attributeGroups.length) {
                attr = AttributeGroupParser.parse(attributeGroups[i], parser, params, false);
                parseInto.addAttributeGroup((AttributeGroup)attr);
                ++i;
            }
        }
        Helper.fillFacets(el, parseInto, parser.isParsingFacets());
        Helper.fillJavaType(el, parseInto, parser);
        String mixed = ElementHelper.getAttribute(el, "mixed");
        if ("yes".equals(mixed) || "true".equals(mixed)) {
            parseInto.setMixed(true);
        }
        if (topLevel) {
            parseInto.setPrefixNamespaceMapping(ElementHelper.getAllNamespaces(el, parseInto.getPrefixNamespaceMapping()));
        } else {
            parseInto.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, parseInto.getPrefixNamespaceMapping()));
        }
    }

    public static void write(TokenWriter writer, Type type, Set importedNamespaces, boolean topLevel) throws IOException, SchemaException {
        QName name = type.getName();
        Type referenced = (Type)type.getReferencedConstruct();
        if (name != null) {
            importedNamespaces.add(name.getNamespaceURI());
        }
        if (topLevel) {
            writer.enter("http://www.w3.org/2001/XMLSchema", "complexType");
        }
        if (referenced != null) {
            Helper.writeQNameAttribute(writer, null, "ref", referenced.getName());
            importedNamespaces.add(referenced.getName().getNamespaceURI());
        } else {
            Type baseType = type.getBaseType();
            boolean isExtension = false;
            if (topLevel) {
                if (name != null) {
                    writer.writeAttribute(null, "name", name.getLocalPart());
                }
                writer.enter("http://www.w3.org/2001/XMLSchema", "annotation");
                String javaTypeName = type.getJavaTypeName();
                if (javaTypeName != null) {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "appinfo");
                    writer.enter("http://systinet.com/mapping/", "java-type");
                    writer.writeAttribute(null, "name", javaTypeName);
                    writer.leave();
                    writer.leave();
                }
                writer.leave();
                if (baseType != null) {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "complexContent");
                    if (type.isMixed()) {
                        writer.writeAttribute(null, "mixed", "true");
                    }
                    if (type.isInheritedByExtension()) {
                        writer.enter("http://www.w3.org/2001/XMLSchema", "extension");
                        isExtension = true;
                    } else {
                        writer.enter("http://www.w3.org/2001/XMLSchema", "restriction");
                    }
                    Helper.writeQNameAttribute(writer, null, "base", baseType.getName());
                    importedNamespaces.add(baseType.getName().getNamespaceURI());
                }
            }
            switch (type.getKind()) {
                case 35: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "sequence");
                    Helper.writeExtension(writer, type);
                    break;
                }
                case 37: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "all");
                    Helper.writeExtension(writer, type);
                    break;
                }
                case 38: {
                    writer.enter("http://www.w3.org/2001/XMLSchema", "choice");
                    Helper.writeExtension(writer, type);
                }
            }
            Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)type, false);
            SchemaConstruct[] subconstructs = type.getSubconstructs();
            if (subconstructs != null) {
                int i = 0;
                while (i < subconstructs.length) {
                    if (!isExtension || !ComplexTypeParser.contains(type.getBaseType(), subconstructs[i])) {
                        Helper.writeConstruct(writer, subconstructs[i], importedNamespaces, false);
                    }
                    ++i;
                }
            }
            switch (type.getKind()) {
                case 35: 
                case 37: 
                case 38: {
                    writer.leave();
                }
            }
            AttributeParser.write(writer, type.getAttributes(), importedNamespaces);
            AttributeGroupParser.write(writer, type.getAttributeGroups(), importedNamespaces);
            if (baseType != null) {
                writer.leave();
                writer.leave();
            }
        }
        if (topLevel) {
            writer.leave();
        }
    }

    private static boolean contains(Type t, SchemaConstruct searched) {
        if (t == null) {
            return false;
        }
        return ComplexTypeParser.contains(t.getSubconstructs(), searched);
    }

    private static boolean contains(SchemaConstruct[] constructs, SchemaConstruct searched) {
        QName name = searched.getName();
        if (name == null || constructs == null) {
            return false;
        }
        int i = 0;
        while (i < constructs.length) {
            if (name.equals(constructs[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

