/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema.parser;

import com.idoox.debug.Category;
import com.idoox.util.ElementHelper;
import com.idoox.xml.schema.SchemaParserImpl;
import com.idoox.xml.schema.parser.AttributeParser;
import com.idoox.xml.schema.parser.Helper;
import com.idoox.xml.schema.parser.SchemaParserParams;
import java.io.IOException;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.w3c.dom.Element;

public class AttributeGroupParser {
    private static final Category cat = Category.getCategory("com.idoox.cml.schema.parser.TopLevelAttributeGroupParser");

    public static AttributeGroup parse(Element el, SchemaParserImpl parser, SchemaParserParams params, boolean topLevel) throws SchemaException {
        SchemaConstruct attr;
        int i;
        AttributeGroup ret;
        String namespaceURI = el.getNamespaceURI();
        String localName = ElementHelper.getAttributeNS(el, null, "name");
        String ref = ElementHelper.getAttributeNS(el, null, "ref");
        if (localName != null) {
            if (ref != null) {
                throw new SchemaException("Expecting one of <name> or <ref> attributes, not both. Context : " + ElementHelper.getFullPath(el));
            }
            QName name = new QName(params.targetNamespace, localName);
            if (topLevel) {
                if (parser.isDefinedAttributeGroup(name)) {
                    AttributeGroup attributeGroup = parser.getAttributeGroup(name, false);
                    cat.error("Duplicated definition of attribute group " + attributeGroup);
                    return attributeGroup;
                }
                ret = parser.getAttributeGroup(name, true);
            } else {
                ret = new AttributeGroup(name);
            }
        } else if (ref != null) {
            QName refName = ElementHelper.getQName(el, ref);
            refName = ElementHelper.chameleonQName(refName, params.chameleonNamespace);
            ret = parser.getAttributeGroup(refName, false);
        } else {
            throw new SchemaException("Attribute <name> or <ref> must be present on " + ElementHelper.getFullPath(el));
        }
        Element[] attributes = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attribute");
        Element[] attributeGroups = ElementHelper.getChildrenElementsByTagName(el, namespaceURI, "attributeGroup");
        if (attributes != null) {
            i = 0;
            while (i < attributes.length) {
                attr = AttributeParser.parse(attributes[i], parser, params, false);
                ret.addAttribute((Attribute)attr);
                ++i;
            }
        }
        if (attributeGroups != null) {
            i = 0;
            while (i < attributeGroups.length) {
                attr = AttributeGroupParser.parse(attributeGroups[i], parser, params, false);
                ret.addAttributeGroup((AttributeGroup)attr);
                ++i;
            }
        }
        if (topLevel) {
            ret.setPrefixNamespaceMapping(ElementHelper.getAllNamespaces(el, ret.getPrefixNamespaceMapping()));
        } else {
            ret.setPrefixNamespaceMapping(ElementHelper.getDeclaredNamespaces(el, ret.getPrefixNamespaceMapping()));
        }
        return ret;
    }

    public static void write(TokenWriter writer, AttributeGroup[] groups, Set importedNamespaces) throws IOException, SchemaException {
        if (groups == null) {
            return;
        }
        int i = 0;
        while (i < groups.length) {
            AttributeGroupParser.write(writer, groups[i], importedNamespaces);
            ++i;
        }
    }

    public static void write(TokenWriter writer, AttributeGroup group, Set importedNamespaces) throws IOException, SchemaException {
        writer.enter("http://www.w3.org/2001/XMLSchema", "attributeGroup");
        Helper.writeNamespacesAndFacets(writer, (SchemaConstruct)group, importedNamespaces);
        AttributeGroup ref = (AttributeGroup)group.getReferencedConstruct();
        if (ref != null) {
            Helper.writeQNameAttribute(writer, null, "ref", ref.getName());
            importedNamespaces.add(ref.getName().getNamespaceURI());
        } else {
            if (group.getName() != null) {
                writer.writeAttribute(null, "name", group.getName().getLocalPart());
            }
            AttributeParser.write(writer, group.getAttributes(), importedNamespaces);
            AttributeGroupParser.write(writer, group.getAttributeGroups(), importedNamespaces);
        }
        writer.leave();
    }
}

