/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema;

import com.idoox.Namespaces;
import com.idoox.util.IdentityHashMap;
import com.idoox.xml.schema.SchemaImpl;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;

public class SchemaSimplification {
    public static void simplifyRestrictions(Schema schema, Set simplifiedTypeQNames) throws SchemaException {
        Iterator namespaces = schema.getNamespaces().iterator();
        while (namespaces.hasNext()) {
            String namespaceURI = (String)namespaces.next();
            Iterator types = schema.getTypes(namespaceURI);
            while (types.hasNext()) {
                SchemaSimplification.simplifyTypeRestriction(schema, (Type)types.next(), simplifiedTypeQNames);
            }
            Iterator elements = schema.getElements(namespaceURI);
            while (elements.hasNext()) {
                SchemaSimplification.simplifyTypeRestriction(schema, ((Member)elements.next()).getType(), simplifiedTypeQNames);
            }
        }
    }

    private static void simplifyTypeRestriction(Schema schema, Type type, Set simplifiedTypeQNames) throws SchemaException {
        Type baseType;
        if (type == null || !type.isInheritedByRestriction()) {
            return;
        }
        QName typeName = type.getName();
        if (typeName != null) {
            if (simplifiedTypeQNames.contains(typeName)) {
                return;
            }
            simplifiedTypeQNames.add(typeName);
        }
        if ((baseType = type.getBaseType()) != null) {
            SchemaSimplification.simplifyTypeRestriction(schema, baseType, simplifiedTypeQNames);
            SchemaSimplification.processAttributes(type, baseType);
            if (type.getKind() == 16) {
                type.setKind(baseType.getKind());
            }
            Iterator extensionIter = baseType.getExtensionTypes();
            while (extensionIter.hasNext()) {
                String extType = (String)extensionIter.next();
                if (type.getExtension(extType) != null || extType.equals("SimpleTypeFacetsExtension")) continue;
                type.setExtension(extType, baseType.getExtension(extType));
            }
        }
    }

    public static void simplifySeqAllChoices(Schema schema, Set simplifiedTypeQNames) throws SchemaException {
        Iterator namespaces = schema.getNamespaces().iterator();
        while (namespaces.hasNext()) {
            String namespaceURI = (String)namespaces.next();
            Iterator types = schema.getTypes(namespaceURI);
            while (types.hasNext()) {
                SchemaSimplification.processSeqAllChoice(schema, (Type)types.next());
            }
            Iterator elements = schema.getElements(namespaceURI);
            while (elements.hasNext()) {
                SchemaSimplification.processSeqAllChoice(schema, ((Member)elements.next()).getType());
            }
        }
    }

    public static void simplifyExtensions(Schema schema, Set simplifiedTypeQNames) throws SchemaException {
        Iterator namespaces = schema.getNamespaces().iterator();
        while (namespaces.hasNext()) {
            String namespaceURI = (String)namespaces.next();
            Iterator types = schema.getTypes(namespaceURI);
            while (types.hasNext()) {
                SchemaSimplification.simplifyTypeExtension(schema, (Type)types.next(), simplifiedTypeQNames);
            }
            Iterator elements = schema.getElements(namespaceURI);
            while (elements.hasNext()) {
                SchemaSimplification.simplifyTypeExtension(schema, ((Member)elements.next()).getType(), simplifiedTypeQNames);
            }
        }
    }

    private static void simplifyTypeExtension(Schema schema, Type type, Set simplifiedTypeQNames) throws SchemaException {
        Type baseType;
        if (type == null || !type.isInheritedByExtension()) {
            return;
        }
        QName typeName = type.getName();
        if (typeName != null) {
            if (simplifiedTypeQNames.contains(typeName)) {
                return;
            }
            simplifiedTypeQNames.add(typeName);
        }
        if ((baseType = type.getBaseType()) != null) {
            SchemaSimplification.simplifyTypeExtension(schema, baseType, simplifiedTypeQNames);
            SchemaSimplification.processAttributes(type, baseType);
            SchemaSimplification.processFacets(type, baseType);
            if ((type.getAttributes() == null || type.getAttributes().length <= 0) && (type.getKind() & 0x10) != 0) {
                type.setKind(baseType.getKind());
            }
            Iterator extensionIter = baseType.getExtensionTypes();
            while (extensionIter.hasNext()) {
                String extType = (String)extensionIter.next();
                if (type.getExtension(extType) != null || extType.equals("SimpleTypeFacetsExtension")) continue;
                type.setExtension(extType, baseType.getExtension(extType));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void processSeqAllChoice(Schema schema, Type type) throws SchemaException {
        if (type == null) {
            return;
        }
        subconstructs = type.getSubconstructs();
        if (subconstructs == null) {
            return;
        }
        sublist = new ArrayList<SchemaConstruct>();
        i = 0;
        while (i < subconstructs.length) {
            subconstruct = subconstructs[i];
            if (subconstruct.getConstructType() == SchemaConstruct.ConstructType.TYPE && (subtype = (Type)subconstruct).getKind() == 36 && (referencedConstruct = subtype.getReferencedConstruct()) != null && subtype.getMinOccurs() == 1 && subtype.getMaxOccurs() == 1) {
                sublist.add(referencedConstruct);
            } else {
                sublist.add(subconstruct);
            }
            ++i;
        }
        subconstructs = sublist.toArray(new SchemaConstruct[0]);
        type.setSubconstructs(subconstructs);
        i = 0;
        while (i < subconstructs.length) {
            if (subconstructs[i].getConstructType() == SchemaConstruct.ConstructType.TYPE) {
                typeToProcess = (Type)subconstructs[i];
                SchemaSimplification.processSeqAllChoice(schema, typeToProcess);
                referencedConstruct = typeToProcess.getReferencedConstruct();
                if (referencedConstruct != null && referencedConstruct.getConstructType() == SchemaConstruct.ConstructType.TYPE) {
                    SchemaSimplification.processSeqAllChoice(schema, (Type)referencedConstruct);
                }
            }
            ++i;
        }
        sublist = new ArrayList<E>();
        i = 0;
        while (i < subconstructs.length) {
            subconstruct = subconstructs[i];
            if (subconstruct.getConstructType() != SchemaConstruct.ConstructType.TYPE) ** GOTO lbl-1000
            subtype = (Type)subconstruct;
            if (subtype.getKind() == 35 && type.getKind() == 35 && subtype.getMinOccurs() == 1 && subtype.getMaxOccurs() == 1) {
                constructs = subtype.getSubconstructs();
                if (constructs != null) {
                    j = 0;
                    while (j < constructs.length) {
                        sublist.add(constructs[j]);
                        ++j;
                    }
                }
            } else if (subtype.getKind() == 38 && type.getKind() == 38 && subtype.getMinOccurs() == 1 && subtype.getMaxOccurs() == 1) {
                constructs = subtype.getSubconstructs();
                if (constructs != null) {
                    j = 0;
                    while (j < constructs.length) {
                        sublist.add(constructs[j]);
                        ++j;
                    }
                }
            } else lbl-1000:
            // 2 sources

            {
                sublist.add(subconstruct);
            }
            ++i;
        }
        type.setSubconstructs(sublist.toArray(new SchemaConstruct[0]));
    }

    private static void mergeAttributes(Type type, Attribute[] attributes) {
        if (attributes == null) {
            return;
        }
        Attribute[] attrs = type.getAttributes();
        if (attrs == null || attrs.length == 0) {
            int i = 0;
            while (i < attributes.length) {
                SchemaConstruct parent = attributes[i].getParent();
                type.addAttribute(attributes[i]);
                attributes[i].setParent(parent);
                ++i;
            }
        } else {
            Attribute[] derefAttrs = new Attribute[attrs.length];
            int i = 0;
            while (i < attrs.length) {
                derefAttrs[i] = XMLSchemaUtil.dereferenceAttribute(attrs[i]);
                ++i;
            }
            attrs = derefAttrs;
            int i2 = 0;
            while (i2 < attributes.length) {
                QName n = XMLSchemaUtil.dereferenceAttribute(attributes[i2]).getName();
                int j = 0;
                while (j < attrs.length) {
                    if (attrs[j].getName().equals(n)) break;
                    ++j;
                }
                if (j == attrs.length) {
                    SchemaConstruct parent = attributes[i2].getParent();
                    type.addAttribute(attributes[i2]);
                    attributes[i2].setParent(parent);
                }
                ++i2;
            }
        }
    }

    private static void mergeAttributeGroups(Type type, AttributeGroup[] groups) {
        if (groups == null) {
            return;
        }
        int i = 0;
        while (i < groups.length) {
            SchemaSimplification.mergeAttributes(type, groups[i].getAttributes());
            SchemaSimplification.mergeAttributeGroups(type, groups[i].getAttributeGroups());
            ++i;
        }
    }

    private static void processAttributes(Type type, Type baseType) {
        SchemaSimplification.mergeAttributes(type, baseType.getAttributes());
        SchemaSimplification.mergeAttributeGroups(type, baseType.getAttributeGroups());
        SchemaSimplification.mergeAttributeGroups(type, type.getAttributeGroups());
        type.setAttributeGroups(null);
    }

    private static void processFacets(Type type, Type baseType) {
        Map baseTypeFacets = baseType.getFacets();
        if (baseTypeFacets == null) {
            return;
        }
        HashMap typeFacets = type.getFacets();
        if (typeFacets == null) {
            typeFacets = new HashMap(11);
            typeFacets.putAll(baseTypeFacets);
            type.setFacets(typeFacets);
            return;
        }
        Iterator i = baseTypeFacets.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            QName key = (QName)e.getKey();
            Object value = e.getValue();
            if (typeFacets.containsKey(key)) continue;
            typeFacets.put(key, value);
        }
    }

    public static void enhanceSeqAllChoices(Schema schema) {
        IdentityHashMap enhanced = new IdentityHashMap();
        Iterator namespacesI = schema.getNamespaces().iterator();
        while (namespacesI.hasNext()) {
            String namespaceURI = (String)namespacesI.next();
            Iterator types = schema.getTypes(namespaceURI);
            while (types.hasNext()) {
                Type type = (Type)types.next();
                SchemaSimplification.enhanceType(type, true, enhanced);
            }
            Iterator elements = schema.getElements(namespaceURI);
            while (elements.hasNext()) {
                Member member = (Member)elements.next();
                SchemaSimplification.enhanceMember(member, enhanced);
            }
        }
    }

    private static void enhanceType(Type type, boolean enhance, Map enhanced) {
        QName name = type.getName();
        if (name != null && name.getNamespaceURI() != null && Namespaces.ignoredNamespaces.contains(name.getNamespaceURI())) {
            return;
        }
        if (enhanced.containsKey(type)) {
            return;
        }
        enhanced.put(type, Boolean.TRUE);
        while (type != null) {
            short kind = type.getKind();
            if (kind == 35 || kind == 38 || kind == 37 || kind == 36) {
                SchemaConstruct[] constructs;
                if (enhance && type.getMaxOccurs() != 1) {
                    Type cloned = (Type)type.clone();
                    type.setJavaName(null);
                    type.setJavaTypeName(null);
                    type.setMinOccurs(1);
                    type.setMaxOccurs(1);
                    type.setSubconstructs(new SchemaConstruct[]{cloned});
                    type.setKind((short)35);
                    cloned.setAttributeGroups(null);
                    cloned.setAttributes(null);
                    cloned.setBaseType(null);
                    cloned.setName(null);
                    cloned.setParent(type);
                    if (cloned.getKind() == 37) {
                        cloned.setKind((short)35);
                    }
                }
                if ((constructs = type.getSubconstructs()) != null) {
                    int i = 0;
                    while (i < constructs.length) {
                        if (constructs[i].getConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                            SchemaSimplification.enhanceMember((Member)constructs[i], enhanced);
                        } else if (constructs[i].getConstructType() == SchemaConstruct.ConstructType.TYPE) {
                            SchemaSimplification.enhanceType((Type)constructs[i], false, enhanced);
                        }
                        ++i;
                    }
                }
            }
            type = type.getBaseType();
        }
    }

    private static void enhanceMember(Member member, Map enhanced) {
        Type type;
        if (enhanced.containsKey(member)) {
            return;
        }
        enhanced.put(member, Boolean.TRUE);
        if (member.getReferencedConstruct() != null) {
            member = member.getReferredMember();
        }
        if ((type = member.getType()) != null && type.getName() == null) {
            SchemaSimplification.enhanceType(type, true, enhanced);
        }
    }

    public static void simplifyAttributeGroups(SchemaImpl schema) {
        Iterator namespaces = schema.getNamespaces().iterator();
        while (namespaces.hasNext()) {
            String namespaceURI = (String)namespaces.next();
            Iterator types = schema.getTypes(namespaceURI);
            while (types.hasNext()) {
                Type type = (Type)types.next();
                SchemaSimplification.mergeAttributeGroups(type, type.getAttributeGroups());
                type.setAttributeGroups(null);
            }
            Iterator elements = schema.getElements(namespaceURI);
            while (elements.hasNext()) {
                Type type = ((Member)elements.next()).getType();
                SchemaSimplification.mergeAttributeGroups(type, type.getAttributeGroups());
                type.setAttributeGroups(null);
            }
        }
    }
}

