/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema;

import com.idoox.Namespaces;
import com.idoox.debug.Category;
import com.idoox.debug.IndentCategory;
import com.idoox.transport.URIPathNormalizer;
import com.idoox.util.ElementHelper;
import com.idoox.wasp.serialization.PolymorphismHelper;
import com.idoox.xml.schema.SchemaImpl;
import com.idoox.xml.schema.SchemaSimplification;
import com.idoox.xml.schema.parser.SchemaElementParser;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SchemaParser;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaParserImpl
implements SchemaParser {
    public static final IndentCategory cat = new IndentCategory(Category.getCategory("com.idoox.xml.schema.SchemaParserImpl"));
    private SchemaImpl schema = new SchemaImpl(this);
    private Map unresolvedTypes = new HashMap(101);
    private Map unresolvedElements = new HashMap(101);
    private Map unresolvedGroups = new HashMap(101);
    private Map unresolvedAttributes = new HashMap(101);
    private Map unresolvedAttributeGroups = new HashMap(101);
    private Map unresolvedSubstitutionGroups = new HashMap(101);
    private Set alreadyProcessing = new HashSet();
    private List imports = new ArrayList();
    private Map namespaceLocationMap = null;
    private Set simplifiedExtensionTypes = new HashSet();
    private boolean parsingFacets = true;
    static int cntr = 0;
    static /* synthetic */ Class class$org$idoox$xml$schema$SchemaParser;

    private void initializeDefaultNamespaceLocationMap() {
        Class clazz = class$org$idoox$xml$schema$SchemaParser == null ? (class$org$idoox$xml$schema$SchemaParser = SchemaParserImpl.class$("org.idoox.xml.schema.SchemaParser")) : class$org$idoox$xml$schema$SchemaParser;
        synchronized (clazz) {
            if (this.namespaceLocationMap == null) {
                SerializationRepository ser = (SerializationRepository)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
                this.namespaceLocationMap = new HashMap(73);
                this.namespaceLocationMap.putAll(ser.getNamespaceLocationMap(null, Namespaces.SOAP12_ENC_NS));
                this.namespaceLocationMap.putAll(ser.getNamespaceLocationMap(null, "http://schemas.xmlsoap.org/soap/encoding/"));
                this.namespaceLocationMap.putAll(ser.getNamespaceLocationMap(null, null));
            }
        }
    }

    public void parse(String namespaceURI) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            this.initializeDefaultNamespaceLocationMap();
            this.addImport(null, namespaceURI, null);
        }
    }

    public void parse(Endpoint importedEndpoint) throws SchemaException {
        this.addImport(importedEndpoint, null);
    }

    public void parseLocation(String url) throws SchemaException {
        try {
            this.parse(new Endpoint(url));
        }
        catch (MalformedURLException e) {
            throw new SchemaException(e);
        }
    }

    public void parseImmediatelly(Endpoint schemaLocation, String targetNamespace) throws SchemaException {
        Class clazz = class$org$idoox$xml$schema$SchemaParser == null ? (class$org$idoox$xml$schema$SchemaParser = SchemaParserImpl.class$("org.idoox.xml.schema.SchemaParser")) : class$org$idoox$xml$schema$SchemaParser;
        synchronized (clazz) {
            this.initializeDefaultNamespaceLocationMap();
            try {
                try {
                    Document doc = ElementHelper.loadDocument(schemaLocation);
                    this.parse(doc.getDocumentElement(), schemaLocation, targetNamespace);
                }
                catch (SchemaException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SchemaException("Exception while parsing " + schemaLocation, e);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    private void resolveImports() throws SchemaException {
        this.initializeDefaultNamespaceLocationMap();
        block0: while (true) {
            Iterator i;
            if (!this.imports.isEmpty()) {
                Endpoint[] importedEndpoints = this.imports.toArray(new Endpoint[this.imports.size()]);
                this.imports.clear();
                int i2 = 0;
                while (true) {
                    if (i2 >= importedEndpoints.length) continue block0;
                    this.parseImmediatelly(importedEndpoints[i2], null);
                    ++i2;
                }
            }
            if (this.unresolvedTypes.size() > 0) {
                i = this.unresolvedTypes.keySet().iterator();
                while (i.hasNext()) {
                    QName n = (QName)i.next();
                    this.addImport(null, n.getNamespaceURI(), n);
                }
            }
            if (this.unresolvedElements.size() > 0) {
                i = this.unresolvedElements.keySet().iterator();
                while (i.hasNext()) {
                    QName n = (QName)i.next();
                    this.addImport(null, n.getNamespaceURI(), n);
                }
            }
            if (this.unresolvedGroups.size() > 0) {
                i = this.unresolvedGroups.keySet().iterator();
                while (i.hasNext()) {
                    QName n = (QName)i.next();
                    this.addImport(null, n.getNamespaceURI(), n);
                }
            }
            if (this.unresolvedAttributes.size() > 0) {
                i = this.unresolvedAttributes.keySet().iterator();
                while (i.hasNext()) {
                    QName n = (QName)i.next();
                    this.addImport(null, n.getNamespaceURI(), n);
                }
            }
            if (this.unresolvedAttributeGroups.size() > 0) {
                i = this.unresolvedAttributeGroups.keySet().iterator();
                while (i.hasNext()) {
                    QName n = (QName)i.next();
                    this.addImport(null, n.getNamespaceURI(), n);
                }
            }
            if (this.unresolvedSubstitutionGroups.size() > 0) {
                i = this.unresolvedSubstitutionGroups.keySet().iterator();
                while (i.hasNext()) {
                    QName n = (QName)i.next();
                    this.addImport(null, n.getNamespaceURI(), n);
                }
            }
            if (this.imports.size() == 0) break;
        }
    }

    public void parse(Element element, Endpoint schemaLocation) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            this.initializeDefaultNamespaceLocationMap();
            SchemaElementParser.parse(element, this, schemaLocation, null, this.schema);
        }
    }

    public void parse(Element element, Endpoint schemaLocation, String targetNamespace) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            this.initializeDefaultNamespaceLocationMap();
            SchemaElementParser.parse(element, this, schemaLocation, targetNamespace, this.schema);
        }
    }

    public Iterator getUnresolvedTypes() {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Collection ut = this.unresolvedTypes.values();
            if (ut.size() > 0) {
                Iterator iterator = ((AbstractList)new ArrayList(ut)).iterator();
                return iterator;
            }
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getUnresolvedElements() {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Collection ut = this.unresolvedElements.values();
            if (ut.size() > 0) {
                Iterator iterator = ((AbstractList)new ArrayList(ut)).iterator();
                return iterator;
            }
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getUnresolvedGroups() {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Collection ut = this.unresolvedGroups.values();
            if (ut.size() > 0) {
                Iterator iterator = ((AbstractList)new ArrayList(ut)).iterator();
                return iterator;
            }
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getUnresolvedAttributes() {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Collection ut = this.unresolvedAttributes.values();
            if (ut.size() > 0) {
                Iterator iterator = ((AbstractList)new ArrayList(ut)).iterator();
                return iterator;
            }
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getUnresolvedAttributeGroups() {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Collection ut = this.unresolvedAttributeGroups.values();
            if (ut.size() > 0) {
                Iterator iterator = ((AbstractList)new ArrayList(ut)).iterator();
                return iterator;
            }
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getUnresolvedSubstitutionGroups() {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Iterator iterator = this.unresolvedSubstitutionGroups.keySet().iterator();
            return iterator;
        }
    }

    public void resolve() throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            this.initializeDefaultNamespaceLocationMap();
            this.resolveImports();
            if (this.unresolvedTypes.size() > 0) {
                throw new SchemaException("Unresolved types " + this.unresolvedTypes.keySet());
            }
            if (this.unresolvedElements.size() > 0) {
                throw new SchemaException("Unresolved elements " + this.unresolvedElements.keySet());
            }
            if (this.unresolvedGroups.size() > 0) {
                throw new SchemaException("Unresolved groups " + this.unresolvedGroups.keySet());
            }
            if (this.unresolvedAttributes.size() > 0) {
                throw new SchemaException("Unresolved attributes " + this.unresolvedAttributes.keySet());
            }
            if (this.unresolvedAttributeGroups.size() > 0) {
                throw new SchemaException("Unresolved attribute groups " + this.unresolvedAttributeGroups.keySet());
            }
            if (this.unresolvedSubstitutionGroups.size() > 0) {
                throw new SchemaException("Unresolved substitution groups " + this.unresolvedSubstitutionGroups.keySet());
            }
            SchemaSimplification.simplifySeqAllChoices(this.schema, this.simplifiedExtensionTypes);
            SchemaSimplification.simplifyExtensions(this.schema, this.simplifiedExtensionTypes);
            SchemaSimplification.simplifyRestrictions(this.schema, this.simplifiedExtensionTypes);
            SchemaSimplification.enhanceSeqAllChoices(this.schema);
            SchemaSimplification.simplifyAttributeGroups(this.schema);
        }
    }

    public String getUnresolved() {
        StringBuffer unresolved = new StringBuffer();
        Iterator i = this.unresolvedTypes.keySet().iterator();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            unresolved.append(" Type {" + name + "}");
        }
        return unresolved.toString();
    }

    public Schema getSchema() throws SchemaException {
        this.resolve();
        return this.schema;
    }

    public Type getSchemaType(QName name, boolean resolved) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Type type = this.schema.getSchemaType(name);
            if (type != null) {
                if (resolved) {
                    cat.error("Type " + name + " already defined");
                }
                Type type2 = type;
                return type2;
            }
            type = (Type)this.unresolvedTypes.get(name);
            if (type != null) {
                if (resolved) {
                    this.unresolvedTypes.remove(name);
                    this.schema.addSchemaType(type);
                }
                Type type3 = type;
                return type3;
            }
            Type ret = new Type(name);
            if (!resolved) {
                this.unresolvedTypes.put(name, ret);
            } else {
                this.schema.addSchemaType(ret);
            }
            Type type4 = ret;
            return type4;
        }
    }

    public Member getSchemaElement(QName name, boolean resolved) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Member element = this.schema.getSchemaElement(name);
            if (element != null) {
                if (resolved) {
                    throw new SchemaException("Element " + name + " already defined");
                }
                Member member = element;
                return member;
            }
            element = (Member)this.unresolvedElements.get(name);
            if (element != null) {
                if (resolved) {
                    this.unresolvedElements.remove(name);
                    this.unresolvedSubstitutionGroups.remove(name);
                    this.schema.addSchemaElement(element);
                }
                Member member = element;
                return member;
            }
            Member ret = new Member(name);
            if (!resolved) {
                this.unresolvedElements.put(name, ret);
            } else {
                this.schema.addSchemaElement(ret);
            }
            Member member = ret;
            return member;
        }
    }

    public Type getSchemaGroup(QName name, boolean resolved) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Type group = this.schema.getSchemaGroup(name);
            if (group != null) {
                if (resolved) {
                    throw new SchemaException("Group " + name + " already defined");
                }
                Type type = group;
                return type;
            }
            group = (Type)this.unresolvedGroups.get(name);
            if (group != null) {
                if (resolved) {
                    this.unresolvedGroups.remove(name);
                    this.schema.addSchemaGroup(group);
                }
                Type type = group;
                return type;
            }
            Type ret = new Type(name);
            if (!resolved) {
                this.unresolvedGroups.put(name, ret);
            } else {
                this.schema.addSchemaGroup(ret);
            }
            Type type = ret;
            return type;
        }
    }

    public Attribute getAttribute(QName name, boolean resolved) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Attribute attribute = this.schema.getAttribute(name);
            if (attribute != null) {
                if (resolved) {
                    throw new SchemaException("Attribute " + name + " already defined");
                }
                Attribute attribute2 = attribute;
                return attribute2;
            }
            attribute = (Attribute)this.unresolvedAttributes.get(name);
            if (attribute != null) {
                if (resolved) {
                    this.unresolvedAttributes.remove(name);
                    this.schema.addAttribute(attribute);
                }
                Attribute attribute3 = attribute;
                return attribute3;
            }
            Attribute ret = new Attribute(name);
            if (!resolved) {
                this.unresolvedAttributes.put(name, ret);
            } else {
                this.schema.addAttribute(ret);
            }
            Attribute attribute4 = ret;
            return attribute4;
        }
    }

    public AttributeGroup getAttributeGroup(QName name, boolean resolved) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            AttributeGroup attributeGroup = this.schema.getAttributeGroup(name);
            if (attributeGroup != null) {
                if (resolved) {
                    throw new SchemaException("AttributeGroup " + name + " already defined");
                }
                AttributeGroup attributeGroup2 = attributeGroup;
                return attributeGroup2;
            }
            attributeGroup = (AttributeGroup)this.unresolvedAttributeGroups.get(name);
            if (attributeGroup != null) {
                if (resolved) {
                    this.unresolvedAttributeGroups.remove(name);
                    this.schema.addAttributeGroup(attributeGroup);
                }
                AttributeGroup attributeGroup3 = attributeGroup;
                return attributeGroup3;
            }
            AttributeGroup ret = new AttributeGroup(name);
            if (!resolved) {
                this.unresolvedAttributeGroups.put(name, ret);
            } else {
                this.schema.addAttributeGroup(ret);
            }
            AttributeGroup attributeGroup4 = ret;
            return attributeGroup4;
        }
    }

    public Member getSubstitutionGroup(QName toSubstitute, Member substitutionMember) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            Member element = this.schema.getSchemaElement(toSubstitute);
            if (element != null) {
                if (!PolymorphismHelper.isExtendedFrom(substitutionMember.getType(), element.getType())) {
                    cat.error("SubstitutionGroup ERROR: Type " + substitutionMember.getType() + " must be derived from " + toSubstitute + " element's type: " + element.getType());
                    Member member = null;
                    return member;
                }
                element.getSubstitutionElements().put(substitutionMember.getName(), substitutionMember);
                Member member = element;
                return member;
            }
            ArrayList<Member> list = (ArrayList<Member>)this.unresolvedSubstitutionGroups.get(toSubstitute);
            if (list == null) {
                list = new ArrayList<Member>();
                this.unresolvedSubstitutionGroups.put(toSubstitute, list);
            }
            element = this.getSchemaElement(toSubstitute, false);
            list.add(element);
            Member member = element;
            return member;
        }
    }

    public boolean isDefinedElement(QName name) {
        return this.schema.getSchemaElement(name) != null;
    }

    public boolean isDefinedType(QName name) {
        return this.schema.getSchemaType(name) != null;
    }

    public boolean isDefinedGroup(QName name) {
        return this.schema.getSchemaGroup(name) != null;
    }

    public boolean isDefinedAttribute(QName name) {
        return this.schema.getAttribute(name) != null;
    }

    public boolean isDefinedAttributeGroup(QName name) {
        return this.schema.getAttributeGroup(name) != null;
    }

    public void addImport(Endpoint importedDocument, String namespaceURI) throws SchemaException {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            this.addImport(importedDocument, namespaceURI, null);
        }
    }

    public boolean needsToBeParsed(Endpoint endpoint) {
        SchemaImpl schemaImpl = this.schema;
        synchronized (schemaImpl) {
            this.initializeDefaultNamespaceLocationMap();
            Endpoint normalized = this.normalizeEndpoint(endpoint);
            boolean bl = this.alreadyProcessing.add(normalized.toExternalForm());
            return bl;
        }
    }

    private void addImport(Endpoint importedDocument, String namespaceURI, QName typeName) throws SchemaException {
        this.initializeDefaultNamespaceLocationMap();
        Endpoint configured = importedDocument;
        if (namespaceURI != null) {
            try {
                String location = (String)this.namespaceLocationMap.get(namespaceURI);
                if (location != null) {
                    configured = new Endpoint(location);
                }
            }
            catch (MalformedURLException e) {
                throw new SchemaException(e);
            }
        }
        if (configured == null) {
            throw new SchemaException("Don't have schema location for " + (typeName != null ? typeName.toString() : namespaceURI));
        }
        Endpoint normalized = this.normalizeEndpoint(configured);
        String documentKey = normalized.toExternalForm();
        if (this.alreadyProcessing.contains(documentKey)) {
            return;
        }
        this.alreadyProcessing.add(documentKey);
        if (configured == null) {
            if (typeName != null) {
                throw new SchemaException("Do not know where to find schema for '" + typeName + "'. Please add the location of the schema into" + " the configuration.");
            }
            throw new SchemaException("Do not know where to find schema for namespace '" + namespaceURI + "'. Please add the location of the schema into" + " the configuration.");
        }
        this.imports.add(configured);
    }

    public Map getNamespaceLocationMap() {
        this.initializeDefaultNamespaceLocationMap();
        return this.namespaceLocationMap;
    }

    public void setNamespaceLocationMap(Map namespaceLocationMap) {
        this.namespaceLocationMap = namespaceLocationMap;
    }

    public void addSchemaTypeToJavaTypeMapping(Type type, String javaType) {
        this.schema.addJavaSchemaTypeMapping(javaType, type);
    }

    public boolean isParsingFacets() {
        return this.parsingFacets;
    }

    public void setParsingFacets(boolean parsingFacets) {
        this.parsingFacets = parsingFacets;
    }

    public Endpoint normalizeEndpoint(Endpoint endpoint) {
        String path = endpoint.getPath().replace('\\', '/');
        path = URIPathNormalizer.normalize(path);
        return new Endpoint(endpoint.getScheme(), endpoint.getUserinfo(), endpoint.getHost(), endpoint.getPort(), endpoint.getContextPath(), path, endpoint.getFragment(), endpoint.getQuery());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

