/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.schema;

import com.idoox.util.ElementHelper;
import java.util.HashMap;
import java.util.Map;
import org.idoox.xml.schema.Facet;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.w3c.dom.Element;

public class FacetFactory {
    private static Map map = new HashMap();

    public static boolean isFacetSupported(String name) {
        return map.containsKey(name);
    }

    public static Facet getFacetFor(Type enclosingType, Element facetElem) throws SchemaException {
        String tagName = facetElem.getLocalName();
        if (FacetFactory.isFacetSupported(tagName)) {
            try {
                return ((FacetFactoryI)map.get(tagName)).getFacet(facetElem);
            }
            catch (SchemaException e) {
                throw new SchemaException("facet " + tagName + " validation error, incorrect value", e);
            }
        }
        throw new SchemaException("facet " + tagName + " not supported");
    }

    static {
        map.put("minInclusive", new MinInclusive());
        map.put("maxInclusive", new MaxInclusive());
        map.put("minExclusive", new MinExclusive());
        map.put("maxExclusive", new MaxExclusive());
        map.put("totalDigits", new TotalDigits());
        map.put("fractionDigits", new FractionDigits());
        map.put("length", new Length());
        map.put("minLength", new MinLength());
        map.put("maxLength", new MaxLength());
        map.put("enumeration", new Enumeration());
        map.put("whiteSpace", new WhiteSpace());
        map.put("pattern", new Pattern());
    }

    private static class Pattern
    extends PrivateFacetFactory {
        private Pattern() {
        }

        protected Facet getFacet(String value) throws SchemaException {
            return new Facet.Pattern(value);
        }
    }

    private static class WhiteSpace
    extends PrivateFixableFacetFactory {
        private WhiteSpace() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.WhiteSpace(value, fixed);
        }
    }

    private static class Enumeration
    extends PrivateFacetFactory {
        private String javaName;

        private Enumeration() {
        }

        public Facet getFacet(Element elem) throws SchemaException {
            this.javaName = ElementHelper.getAttributeNS(elem, "http://systinet.com/mapping/", "java-field");
            return super.getFacet(elem);
        }

        protected Facet getFacet(String value) throws SchemaException {
            if (this.javaName == null) {
                this.javaName = value;
            }
            return new Facet.Enumeration(value, this.javaName);
        }
    }

    private static class MaxLength
    extends PrivateFixableFacetFactory {
        private MaxLength() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.MaxLength(value, fixed);
        }
    }

    private static class MinLength
    extends PrivateFixableFacetFactory {
        private MinLength() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.MinLength(value, fixed);
        }
    }

    private static class Length
    extends PrivateFixableFacetFactory {
        private Length() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.Length(value, fixed);
        }
    }

    private static class FractionDigits
    extends PrivateFixableFacetFactory {
        private FractionDigits() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.FractionDigits(value, fixed);
        }
    }

    private static class TotalDigits
    extends PrivateFixableFacetFactory {
        private TotalDigits() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.TotalDigits(value, fixed);
        }
    }

    private static class MaxInclusive
    extends PrivateFixableFacetFactory {
        private MaxInclusive() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.MaxInclusive(value, fixed);
        }
    }

    private static class MaxExclusive
    extends PrivateFixableFacetFactory {
        private MaxExclusive() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.MaxExclusive(value, fixed);
        }
    }

    private static class MinInclusive
    extends PrivateFixableFacetFactory {
        private MinInclusive() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.MinInclusive(value, fixed);
        }
    }

    private static class MinExclusive
    extends PrivateFixableFacetFactory {
        private MinExclusive() {
        }

        protected Facet getFacet(String value, boolean fixed) throws SchemaException {
            return new Facet.MinExclusive(value, fixed);
        }
    }

    private static abstract class PrivateFixableFacetFactory
    implements FacetFactoryI {
        private PrivateFixableFacetFactory() {
        }

        protected abstract Facet getFacet(String var1, boolean var2) throws SchemaException;

        public Facet getFacet(Element elem) throws SchemaException {
            boolean fixed = false;
            if (elem.hasAttribute("fixed")) {
                String fixedAttrValue = elem.getAttribute("fixed").trim();
                if ("true".equalsIgnoreCase(fixedAttrValue) || "1".equals(fixedAttrValue)) {
                    fixed = true;
                } else if (!"false".equalsIgnoreCase(fixedAttrValue) && !"0".equals(fixedAttrValue)) {
                    throw new SchemaException("invalid content of 'fixed' attribute, supported lexical values are: 'true','false','1','0'");
                }
            }
            return this.getFacet(ElementHelper.getAttributeNS(elem, null, "value"), fixed);
        }
    }

    private static abstract class PrivateFacetFactory
    implements FacetFactoryI {
        private PrivateFacetFactory() {
        }

        protected abstract Facet getFacet(String var1) throws SchemaException;

        public Facet getFacet(Element elem) throws SchemaException {
            return this.getFacet(ElementHelper.getAttributeNS(elem, null, "value"));
        }
    }

    protected static interface FacetFactoryI {
        public Facet getFacet(Element var1) throws SchemaException;
    }
}

