/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import com.idoox.debug.Category;
import com.idoox.wasp.Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.idoox.xml.TokenWriter;

public class XmlWriter
implements TokenWriter {
    private static final int INITIAL_STACK_SIZE = 8;
    private static final int STACK_SIZE_INCREMENT = 4;
    private static final int INITIAL_NSR_STACK_SIZE = 8;
    private static final int NSR_STACK_INCREMENT = 8;
    private String[] elementStack;
    private String[] prefixStack;
    private int[] namespaceStack;
    private String[] localNamespaces;
    private String[] overwrittenNamespaces;
    private String[] overwrittenPrefixes;
    private HashMap namespaceMap;
    private HashMap prefixMap;
    private int depth;
    private int localNamespacePos;
    private int overwrittenNamespacePos;
    private int overwrittenPrefixesPos;
    private boolean inElement;
    private Writer writer;
    private int nextPrefix;
    private String toWrite;
    private String elementName;
    private String elementNamespace;
    private StringBuffer extraAttributes = new StringBuffer(256);
    private char[] charArrayOfExtraAttributes = new char[0];
    private boolean flushWriter = true;
    static String[] nextPrefixTable = new String[]{"n0", "n1", "n2", "n3", "n4", "n5", "n6", "n7", "n8", "n9"};
    char[] normalized_buffer = new char[100];
    int normalized_buffer_used;
    private static final Category cat = Category.getCategory("com.idoox.xml.XmlWriter");

    private void init() {
        this.elementStack = new String[8];
        this.prefixStack = new String[8];
        this.namespaceStack = new int[24];
        this.localNamespaces = new String[8];
        this.overwrittenNamespaces = new String[8];
        this.overwrittenPrefixes = new String[8];
        this.namespaceMap = new HashMap();
        this.prefixMap = new HashMap();
    }

    public void init(Writer wr, boolean generateXmlHeader, boolean flushWriter) throws IOException {
        this.flushWriter = flushWriter;
        if (this.namespaceMap != null) {
            this.namespaceMap.clear();
        }
        if (this.prefixMap != null) {
            this.prefixMap.clear();
        }
        this.depth = 0;
        this.localNamespacePos = 0;
        this.overwrittenNamespacePos = 0;
        this.overwrittenPrefixesPos = 0;
        this.inElement = false;
        this.writer = null;
        this.nextPrefix = 0;
        this.toWrite = null;
        this.elementName = null;
        this.elementNamespace = null;
        this.extraAttributes.delete(0, this.extraAttributes.length());
        this.setOutput(wr, generateXmlHeader);
    }

    public void init(Writer wr, boolean generateXmlHeader) throws IOException {
        this.init(wr, generateXmlHeader, true);
    }

    public XmlWriter() {
        this.init();
    }

    public XmlWriter(OutputStream os, boolean generateXmlHeader) throws IOException {
        this.init();
        this.setOutput(os, generateXmlHeader);
    }

    public XmlWriter(Writer wr, boolean generateXmlHeader) throws IOException {
        this.init();
        this.setOutput(wr, generateXmlHeader);
    }

    public XmlWriter(OutputStream os, Map initialPrefixToNamespaceMapping) throws IOException {
        this.init();
        this.setOutput(os, false);
        this.fillInitialNamespaceMapping(initialPrefixToNamespaceMapping);
    }

    public XmlWriter(Writer wr, Map initialPrefixToNamespaceMapping) throws IOException {
        this.init();
        this.setOutput(wr, false);
        this.fillInitialNamespaceMapping(initialPrefixToNamespaceMapping);
    }

    public void setOutput(OutputStream os, boolean generateXmlHeader) throws IOException {
        this.setOutput(new OutputStreamWriter(os, Constants.UTF_8), generateXmlHeader);
    }

    public void setOutput(Writer wr, boolean generateXmlHeader) throws IOException {
        this.writer = wr;
        this.depth = 0;
        this.inElement = false;
        this.nextPrefix = 0;
        this.namespaceMap.clear();
        this.localNamespacePos = 0;
        this.overwrittenNamespacePos = 0;
        this.overwrittenPrefixesPos = 0;
        if (generateXmlHeader) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
    }

    public void setNamespaceMap(Map definedNamespaces) throws IllegalStateException, IOException {
        if (this.namespaceMap.size() != 0 || this.inElement) {
            Iterator i = definedNamespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (this.namespaceMap.containsKey(e.getKey())) {
                    if (this.namespaceMap.get(e.getKey()).equals(e.getValue())) continue;
                    this.setPrefixForNamespace((String)e.getValue(), (String)e.getKey());
                    continue;
                }
                this.setPrefixForNamespace((String)e.getValue(), (String)e.getKey());
            }
        } else {
            Iterator i = definedNamespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                this.prefixMap.put(e.getValue(), e.getKey());
                this.namespaceMap.put(e.getKey(), e.getValue());
            }
        }
    }

    public void setPrefixNamespaceMap(Map definedNamespaces) throws IllegalStateException, IOException {
        if (this.namespaceMap.size() != 0 || this.inElement) {
            Iterator i = definedNamespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (this.namespaceMap.containsKey(e.getValue())) {
                    if (this.namespaceMap.get(e.getValue()).equals(e.getKey())) continue;
                    this.setPrefixForNamespace((String)e.getKey(), (String)e.getValue());
                    continue;
                }
                this.setPrefixForNamespace((String)e.getKey(), (String)e.getValue());
            }
        } else {
            Iterator i = definedNamespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                this.namespaceMap.put(e.getValue(), e.getKey());
                this.prefixMap.put(e.getKey(), e.getValue());
            }
        }
    }

    public void addKnownPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        this.namespaceMap.put(namespace, prefix);
        this.prefixMap.put(prefix, namespace);
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IllegalStateException, IOException {
        if (prefix == null) {
            prefix = "";
        }
        if (this.inElement) {
            if (this.localNamespacePos >= this.localNamespaces.length) {
                this.localNamespaces = this.resizeStringArray(this.localNamespaces, this.localNamespaces.length + 16);
            }
            if (this.overwrittenNamespacePos >= this.overwrittenNamespaces.length) {
                this.overwrittenNamespaces = this.resizeStringArray(this.overwrittenNamespaces, this.overwrittenNamespaces.length + 16);
            }
            if (this.overwrittenPrefixesPos >= this.overwrittenPrefixes.length) {
                this.overwrittenPrefixes = this.resizeStringArray(this.overwrittenPrefixes, this.overwrittenPrefixes.length + 16);
            }
            this.localNamespaces[this.localNamespacePos++] = prefix;
            this.localNamespaces[this.localNamespacePos++] = namespace;
            if (this.prefixMap.containsKey(prefix)) {
                this.overwrittenNamespaces[this.overwrittenNamespacePos++] = prefix;
                this.overwrittenNamespaces[this.overwrittenNamespacePos++] = (String)this.prefixMap.get(prefix);
                this.namespaceMap.remove(this.prefixMap.get(prefix));
            }
            if (this.namespaceMap.containsKey(namespace)) {
                this.overwrittenPrefixes[this.overwrittenPrefixesPos++] = namespace;
                this.overwrittenPrefixes[this.overwrittenPrefixesPos++] = (String)this.namespaceMap.get(namespace);
                this.namespaceMap.remove(this.prefixMap.get(prefix));
            }
            if (!prefix.equals("")) {
                this.extraAttributes.append(" xmlns:");
                this.extraAttributes.append(prefix);
                this.extraAttributes.append("=\"");
                this.normalize(namespace);
                this.extraAttributes.append(this.normalized_buffer, 0, this.normalized_buffer_used);
                this.extraAttributes.append('\"');
            } else {
                String mappedNS = (String)this.prefixMap.get("");
                if (mappedNS == null || mappedNS.length() == 0) {
                    if (namespace != null && namespace.length() > 0) {
                        this.setXMLNS(namespace);
                    }
                } else if (namespace == null || namespace.length() == 0 || !mappedNS.equals(namespace)) {
                    this.setXMLNS(namespace);
                }
            }
        } else {
            throw new IllegalStateException("Cannot declare namespace if not creating element");
        }
        this.namespaceMap.put(namespace, prefix);
        this.prefixMap.put(prefix, namespace);
    }

    private void setXMLNS(String namespace) {
        this.extraAttributes.append(" xmlns=\"");
        this.normalize(namespace);
        this.extraAttributes.append(this.normalized_buffer, 0, this.normalized_buffer_used);
        this.extraAttributes.append('\"');
    }

    private String[] resizeStringArray(String[] array, int newSize) {
        String[] newArr = new String[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    public void flush() throws IOException {
        if (this.inElement) {
            this.writeElementStart();
            this.writeElementAttributes();
            this.writer.write(">");
            this.inElement = false;
        }
        if (this.flushWriter) {
            this.writer.flush();
        }
    }

    public void enter(String namespace, String name) throws IOException, IllegalStateException {
        if (name == null) {
            throw new RuntimeException("Element name cannot be null");
        }
        this.writeElementStart();
        this.writeElementAttributes();
        if (this.inElement) {
            this.writer.write(">");
        }
        this.inElement = true;
        ++this.depth;
        if (this.depth == this.elementStack.length) {
            String[] oldES = this.elementStack;
            this.elementStack = new String[oldES.length + 4];
            System.arraycopy(oldES, 0, this.elementStack, 0, oldES.length);
            String[] oldPS = this.prefixStack;
            this.prefixStack = new String[oldPS.length + 4];
            System.arraycopy(oldPS, 0, this.prefixStack, 0, oldPS.length);
            int[] oldNS = this.namespaceStack;
            this.namespaceStack = new int[oldNS.length + 12];
            System.arraycopy(oldNS, 0, this.namespaceStack, 0, oldNS.length);
        }
        this.namespaceStack[this.depth * 3] = this.localNamespacePos;
        this.namespaceStack[this.depth * 3 + 1] = this.overwrittenNamespacePos;
        this.namespaceStack[this.depth * 3 + 2] = this.overwrittenPrefixesPos;
        this.toWrite = null;
        this.elementName = name;
        this.elementNamespace = namespace;
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        this.writeElementStart();
        if (this.inElement) {
            if (namespace != null && namespace.length() > 0) {
                String prefix = namespace.hashCode() == "http://www.w3.org/XML/1998/namespace".hashCode() && "http://www.w3.org/XML/1998/namespace".equals(namespace) ? "xml" : this.getPrefixForNamespace(namespace, false);
                this.writer.write(32);
                if (!"".equals(prefix)) {
                    this.writer.write(prefix);
                    this.writer.write(58);
                }
            } else {
                this.writer.write(32);
            }
        } else {
            throw new IllegalStateException("Not in element");
        }
        this.writer.write(name);
        this.writer.write("=\"");
        this.normalize(value);
        this.writer.write(this.normalized_buffer, 0, this.normalized_buffer_used);
        this.writer.write(34);
    }

    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
        this.writeElementStart();
        if (!this.inElement) {
            throw new IllegalStateException("Not in element");
        }
        this.writer.write(" xml:");
        this.writer.write(name);
        this.writer.write("=\"");
        this.normalize(value);
        this.writer.write(this.normalized_buffer, 0, this.normalized_buffer_used);
        this.writer.write(34);
    }

    public void writeQNameAttr(String name, String namespace, String valueName, String valueNamespace) throws IOException {
        String prefix = this.getPrefixForNamespace(valueNamespace);
        if ("".equals(prefix)) {
            this.writeAttribute(namespace, name, valueName);
        } else {
            this.writeAttribute(namespace, name, prefix + ":" + valueName);
        }
    }

    public void writeContent(String content) throws IOException {
        this.writeElementStart();
        this.writeElementAttributes();
        if (this.inElement) {
            this.writer.write(">");
            this.inElement = false;
        }
        this.normalize(content);
        this.writer.write(this.normalized_buffer, 0, this.normalized_buffer_used);
    }

    public void leave() throws IOException, IllegalStateException {
        this.writeElementStart();
        this.writeElementAttributes();
        if (this.inElement) {
            this.writer.write("/>");
        } else {
            try {
                this.writer.write("</");
                if (this.elementStack[this.depth] == null) {
                    try {
                        throw new RuntimeException();
                    }
                    catch (RuntimeException e) {
                        cat.error("Null name at ", e);
                    }
                }
                if (this.prefixStack[this.depth] != null) {
                    this.writer.write(this.prefixStack[this.depth]);
                    this.writer.write(58);
                }
                this.writer.write(this.elementStack[this.depth]);
                this.writer.write(">");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException("Not inside element, cannot leave");
            }
        }
        int i = this.namespaceStack[3 * this.depth];
        while (i < this.localNamespacePos) {
            this.prefixMap.remove(this.localNamespaces[i]);
            this.namespaceMap.remove(this.localNamespaces[i + 1]);
            i += 2;
        }
        int i2 = this.namespaceStack[3 * this.depth + 1];
        while (i2 < this.overwrittenNamespacePos) {
            this.prefixMap.put(this.overwrittenNamespaces[i2], this.overwrittenNamespaces[i2 + 1]);
            this.namespaceMap.put(this.overwrittenNamespaces[i2 + 1], this.overwrittenNamespaces[i2]);
            i2 += 2;
        }
        int i3 = this.namespaceStack[3 * this.depth + 2];
        while (i3 < this.overwrittenPrefixesPos) {
            this.namespaceMap.put(this.overwrittenPrefixes[i3], this.overwrittenPrefixes[i3 + 1]);
            this.prefixMap.put(this.overwrittenPrefixes[i3 + 1], this.overwrittenPrefixes[i3]);
            i3 += 2;
        }
        this.localNamespacePos = this.namespaceStack[3 * this.depth];
        this.overwrittenNamespacePos = this.namespaceStack[3 * this.depth + 1];
        this.overwrittenPrefixesPos = this.namespaceStack[3 * this.depth + 2];
        this.inElement = false;
        --this.depth;
    }

    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        return this.getPrefixForNamespace(namespace, true);
    }

    protected String getPrefixForNamespace(String namespace, boolean allowDefault) throws IOException, IllegalStateException {
        if (namespace == null || namespace.length() == 0) {
            String mappedNS = (String)this.prefixMap.get("");
            if (mappedNS != null && !"".equals(mappedNS)) {
                this.setPrefixForNamespace("", "");
            }
            return "";
        }
        String prefix = (String)this.namespaceMap.get(namespace);
        if (prefix != null) {
            if (!allowDefault && prefix.equals("")) {
                String result = this.getNewPrefix();
                this.setPrefixForNamespace(result, namespace);
                this.namespaceMap.put(namespace, prefix);
                this.prefixMap.put(prefix, namespace);
                return result;
            }
            return prefix;
        }
        prefix = this.getNewPrefix();
        this.setPrefixForNamespace(prefix, namespace);
        return prefix;
    }

    private String getNewPrefix() {
        String prefix;
        do {
            prefix = this.nextPrefix < 10 ? nextPrefixTable[this.nextPrefix] : "n" + Integer.toString(this.nextPrefix, 16);
            ++this.nextPrefix;
        } while (this.prefixMap.containsKey(prefix));
        return prefix;
    }

    public Map getCurrentNamespaceMap() {
        return (Map)this.namespaceMap.clone();
    }

    private void writeElementStart() throws IOException {
        if (this.elementName != null) {
            this.writer.write(60);
            if (this.elementNamespace != null && this.elementNamespace.length() > 0) {
                String prefix = this.getPrefixForNamespace(this.elementNamespace);
                if (!"".equals(prefix)) {
                    this.writer.write(prefix);
                    this.writer.write(58);
                    this.prefixStack[this.depth] = prefix;
                } else {
                    this.prefixStack[this.depth] = null;
                }
            } else {
                this.getPrefixForNamespace("");
                this.prefixStack[this.depth] = null;
            }
            this.writer.write(this.elementName);
            this.elementStack[this.depth] = this.elementName;
            if (this.toWrite != null) {
                this.writer.write(this.toWrite);
            }
            this.elementName = null;
        }
    }

    private void writeElementAttributes() throws IOException {
        int l = this.extraAttributes.length();
        if (l == 0) {
            return;
        }
        if (l > this.charArrayOfExtraAttributes.length) {
            this.charArrayOfExtraAttributes = new char[l];
        }
        this.extraAttributes.getChars(0, l, this.charArrayOfExtraAttributes, 0);
        this.writer.write(this.charArrayOfExtraAttributes, 0, l);
        this.extraAttributes.delete(0, l);
    }

    private static boolean needToNormalize(String s) {
        int l = s.length();
        int i = 0;
        while (i < l) {
            char c = s.charAt(i);
            if (c < 'A' && (c == '<' || c == '>' || c == '&' || c == '\"')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void normalizeByteByByte(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        this.copyChars(sb.toString());
    }

    private void copyChars(String s) {
        this.normalized_buffer_used = s.length();
        if (this.normalized_buffer_used > this.normalized_buffer.length) {
            this.normalized_buffer = new char[this.normalized_buffer_used];
        }
        s.getChars(0, this.normalized_buffer_used, this.normalized_buffer, 0);
    }

    private void normalize(String s) {
        if (s.length() < 5) {
            if (XmlWriter.needToNormalize(s)) {
                this.normalizeByteByByte(s);
            } else {
                this.copyChars(s);
            }
        } else {
            this.copyChars(s);
            int i = 0;
            while (i < this.normalized_buffer_used) {
                switch (this.normalized_buffer[i]) {
                    case '\"': 
                    case '&': 
                    case '<': 
                    case '>': {
                        this.normalizeByteByByte(s);
                        return;
                    }
                }
                ++i;
            }
        }
    }

    public void fillInitialNamespaceMapping(Map mapping) {
        Iterator i = mapping.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry value = i.next();
            String prefix = (String)value.getKey();
            String namespace = (String)value.getValue();
            this.prefixMap.put(prefix, namespace);
            this.namespaceMap.put(namespace, prefix);
        }
    }
}

