/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import com.idoox.xml.XmlTokenizerException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class XmlTokenizer {
    private static final int BUF_SIZE = 12288;
    private int readChunkSize = 1024;
    private float loadFactor = 0.99f;
    public static final byte END_DOCUMENT = 2;
    public static final byte CONTENT = 10;
    public static final byte CHARACTERS = 20;
    public static final byte CDSECT = 30;
    public static final byte COMMENT = 40;
    public static final byte DOCTYPE = 50;
    public static final byte PI = 60;
    public static final byte ENTITY_REF = 70;
    public static final byte CHAR_REF = 75;
    public static final byte ETAG_NAME = 110;
    public static final byte EMPTY_ELEMENT = 111;
    public static final byte STAG_END = 112;
    public static final byte STAG_NAME = 120;
    public static final byte ATTR_NAME = 122;
    public static final byte ATTR_CHARACTERS = 124;
    public static final byte ATTR_CONTENT = 127;
    public boolean paramNotifyCharacters;
    public boolean paramNotifyComment;
    public boolean paramNotifyCDSect;
    public boolean paramNotifyDoctype;
    public boolean paramNotifyPI;
    public boolean paramNotifyCharRef;
    public boolean paramNotifyEntityRef;
    public boolean paramNotifyAttValue;
    public char[] buf = new char[12288];
    public int pos;
    public int posStart;
    public int posEnd;
    public int posNsColon;
    public int nsColonCount;
    public boolean seenContent;
    public boolean parsedContent;
    public char[] pc = new char[12288];
    public int pcStart;
    public int pcEnd;
    static final int end_char_table_end = 63;
    static final boolean[] end_char_table = new boolean[63];
    private static final boolean NORMALIZE_LINE_BREAKS = true;
    private static final boolean TRACING = false;
    private static final boolean TEST_VALIDATING = false;
    private boolean paramPC = true;
    private boolean paramNoMixContent = false;
    private boolean mixInElement = false;
    private boolean backtracking = false;
    private int posSafe = (int)(this.loadFactor * 12288.0f);
    private int softLimit = -1;
    private int hardLimit = -1;
    private boolean reading;
    private Reader reader;
    private int bufEnd;
    private int bufSize = 12288;
    private int posCol;
    private int posRow;
    private char prevCh;
    private char prevPrevCh;
    private char attrMarker;
    private char charRefValue;
    private boolean charRefHex;
    private boolean reachedEnd;
    private byte previousState;
    private byte state;
    private static final byte STATE_INIT = 1;
    private static final byte STATE_FINISH = 6;
    private static final byte STATE_FINISHED = 7;
    private static final byte STATE_CONTENT_INIT = 10;
    private static final byte STATE_CONTENT_CONTINUED = 11;
    private static final byte STATE_CONTENT = 12;
    private static final byte STATE_SEEN_LT = 13;
    private static final byte STATE_SEEN_LT_BANG = 14;
    private static final byte STATE_CDSECT = 30;
    private static final byte STATE_CDSECT_BRACKET = 31;
    private static final byte STATE_CDSECT_BRACKET_BRACKET = 32;
    private static final byte STATE_COMMENT = 40;
    private static final byte STATE_COMMENT_DASH = 41;
    private static final byte STATE_COMMENT_DASH_DASH = 42;
    private static final byte STATE_DOCTYPE = 50;
    private static final byte STATE_DOCTYPE_BRACKET = 51;
    private static final byte STATE_DOCTYPE_BRACKET_BRACKET = 52;
    private static final byte STATE_PI = 60;
    private static final byte STATE_PI_END = 61;
    private static final byte STATE_SEEN_AMP = 70;
    private static final byte STATE_ENTITY_REF = 71;
    private static final byte STATE_CHAR_REF = 75;
    private static final byte STATE_CHAR_REF_DIGITS = 76;
    private static final byte STATE_SCAN_ETAG_NAME = 110;
    private static final byte STATE_SCAN_STAG_NAME = 120;
    private static final byte STATE_SCAN_STAG_GT = 121;
    private static final byte STATE_SCAN_ATTR_NAME = 122;
    private static final byte STATE_SCAN_ATTR_EQ = 123;
    private static final byte STATE_SCAN_ATTR_VALUE = 124;
    private static final byte STATE_SCAN_ATTR_VALUE_CONTINUE = 125;
    private static final byte STATE_SCAN_ATTR_VALUE_END = 126;
    private static final byte STATE_ATTR_VALUE_CONTENT = 127;

    public void reset() {
        this.reading = false;
        this.bufSize = this.buf.length;
        this.bufEnd = 0;
        this.pos = 0;
        this.posStart = 0;
        this.posEnd = 0;
        this.posNsColon = -1;
        this.state = 1;
        this.prevCh = '\u0000';
        this.posRow = 1;
        this.posCol = 1;
        this.reachedEnd = false;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.previousState = (byte)-1;
        this.backtracking = false;
        this.seenContent = false;
    }

    public void setInput(char[] data) {
        this.reset();
        this.reading = false;
        this.buf = data;
        this.bufSize = this.bufEnd = this.buf.length;
        if (this.paramPC && this.pc.length < this.bufSize) {
            this.pc = new char[this.bufSize];
        }
    }

    public void setInput(Reader r) {
        this.reset();
        this.reading = true;
        this.reader = r;
        this.bufEnd = 0;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setNotifyAll(boolean enable) {
        this.paramNotifyCharacters = enable;
        this.paramNotifyComment = enable;
        this.paramNotifyCDSect = enable;
        this.paramNotifyDoctype = enable;
        this.paramNotifyPI = enable;
        this.paramNotifyEntityRef = enable;
        this.paramNotifyCharRef = enable;
        this.paramNotifyAttValue = enable;
    }

    public void setParseContent(boolean enable) {
        this.paramPC = enable;
        if (this.paramPC && this.pc.length < this.bufSize) {
            this.pc = new char[this.bufSize];
        }
    }

    public void setMixedContent(boolean enable) {
        this.paramNoMixContent = !enable;
    }

    public void setSoftLimit(int value) throws XmlTokenizerException {
        if (this.state != 1) {
            throw new XmlTokenizerException("soft limit can not be changed after parsing started");
        }
        if (2 * value <= this.hardLimit) {
            throw new XmlTokenizerException("soft limit can no tbe bigger than half of hard limitcurrent hard limit " + this.hardLimit);
        }
        this.posSafe = this.softLimit = value;
    }

    public void setHardLimit(int value) throws XmlTokenizerException {
        this.hardLimit = value;
    }

    public String getPosDesc() {
        return " at line " + this.posRow + " and column " + (this.posCol - 1);
    }

    public int getLineNumber() {
        return this.posRow;
    }

    public int getColumnNumber() {
        return this.posCol - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte next() throws XmlTokenizerException, IOException {
        if (this.state == 7) {
            throw new XmlTokenizerException("attempt to read beyond end of input");
        }
        this.parsedContent = false;
        block31: while (true) {
            int len;
            if (this.reachedEnd) {
                if (this.state != 6) {
                    if (this.state != 12 && this.state != 10 && this.state != 11) {
                        throw new XmlTokenizerException("unexpected end of stream (state=" + this.state + ")");
                    }
                    if (this.state == 10 || this.state == 11) {
                        if (this.state == 10) {
                            this.pcEnd = this.pcStart = this.pos - 1;
                        }
                        this.posEnd = this.posStart = this.pos - 1;
                    }
                    this.state = (byte)6;
                    if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart)) {
                        boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                        if (!this.paramNoMixContent || !this.seenContent) {
                            return 10;
                        }
                        if (this.parsedContent) {
                            throw new XmlTokenizerException("no element content allowed before end of stream");
                        }
                    }
                }
                this.state = (byte)7;
                return 2;
            }
            char ch = this.more();
            if (this.reachedEnd) {
                return 2;
            }
            if (ch == '\r') {
                if (this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                    len = this.posEnd - this.posStart;
                    System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                    this.pcEnd += len;
                }
            } else if (this.prevPrevCh == '\r' && ch == '\n') continue;
            switch (this.state) {
                case 1: 
                case 10: {
                    this.pcEnd = this.pcStart = this.pos - 1;
                }
                case 11: {
                    this.posEnd = this.posStart = this.pos - 1;
                    this.state = (byte)12;
                }
                case 12: {
                    if (ch == '<') {
                        this.state = (byte)13;
                        if (!this.paramNotifyCharacters || this.posStart == this.posEnd) continue block31;
                        return 20;
                    }
                    if (ch == '&') {
                        if (this.paramPC && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                            len = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                            this.pcEnd += len;
                        }
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new XmlTokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)11;
                        this.posStart = this.pos - 1;
                        continue block31;
                    }
                    if (!this.seenContent && !this.isS(ch)) {
                        this.seenContent = true;
                        if (this.paramNoMixContent && !this.mixInElement) {
                            throw new XmlTokenizerException("mixed content disallowed outside element, character '" + this.printable(ch) + "'" + " (" + ch + ")" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                    }
                    this.posEnd = this.pos;
                    if (this.paramPC && this.pcStart != this.pcEnd || this.paramPC && ch == '\r') {
                        this.pc[this.pcEnd++] = ch == '\r' ? 10 : ch;
                    }
                    if (!this.paramNotifyCharacters || !this.reachedEnd) continue block31;
                    return 20;
                }
                case 13: {
                    if (ch == '!') {
                        this.state = (byte)14;
                    } else if (ch == '?') {
                        this.state = (byte)60;
                    } else {
                        boolean prevMixSeenContent = this.seenContent;
                        boolean prevMixInElement = this.mixInElement;
                        if (ch == '/') {
                            this.state = (byte)110;
                            this.mixInElement = false;
                        } else {
                            this.state = (byte)120;
                            if (this.paramNoMixContent && this.seenContent) {
                                throw new XmlTokenizerException("mixed content disallowed inside element and before start tag" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            this.mixInElement = true;
                        }
                        if (this.paramPC) {
                            boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                            if (!this.paramNoMixContent || this.paramNoMixContent && this.state == 110 && prevMixInElement) {
                                return 10;
                            }
                        }
                    }
                    if (this.paramPC && this.state != 120 && this.state != 110 && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                        len = this.posEnd - this.posStart;
                        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                        this.pcEnd += len;
                    }
                    this.posStart = this.pos;
                    continue block31;
                }
                case 14: {
                    if (ch == '-') {
                        ch = this.more();
                        if (ch != '-') {
                            throw new XmlTokenizerException("expected - for start of comment <!-- not " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        this.state = (byte)40;
                        this.posStart = this.pos;
                        continue block31;
                    }
                    if (ch == '[') {
                        ch = this.more();
                        if (ch != 'C') {
                            throw new XmlTokenizerException("expected <![CDATA" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ch = this.more();
                        if (ch != 'D') {
                            throw new XmlTokenizerException("expected <![CDATA" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ch = this.more();
                        if (ch != 'A') {
                            throw new XmlTokenizerException("expected <![CDATA" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ch = this.more();
                        if (ch != 'T') {
                            throw new XmlTokenizerException("expected <![CDATA" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ch = this.more();
                        if (ch != 'A') {
                            throw new XmlTokenizerException("expected <![CDATA" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ch = this.more();
                        if (ch != '[') {
                            throw new XmlTokenizerException("expected <![CDATA" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        this.posStart = this.pos;
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new XmlTokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                        }
                        this.state = (byte)30;
                        continue block31;
                    }
                    if (ch != 'D') throw new XmlTokenizerException("unknown markup after <! " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    ch = this.more();
                    if (ch != 'O') {
                        throw new XmlTokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    ch = this.more();
                    if (ch != 'C') {
                        throw new XmlTokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    ch = this.more();
                    if (ch != 'T') {
                        throw new XmlTokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    ch = this.more();
                    if (ch != 'Y') {
                        throw new XmlTokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    ch = this.more();
                    if (ch != 'P') {
                        throw new XmlTokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    ch = this.more();
                    if (ch != 'E') {
                        throw new XmlTokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.posStart = this.pos;
                    this.state = (byte)50;
                    continue block31;
                }
                case 70: {
                    this.posStart = this.pos - 2;
                    if (ch == '#') {
                        this.state = (byte)75;
                        continue block31;
                    }
                    this.state = (byte)71;
                }
                case 71: {
                    if (ch != ';') continue block31;
                    this.state = this.previousState;
                    this.posEnd = this.pos;
                    if (this.paramPC) {
                        int j = this.pos - 1;
                        int i = this.posStart + 1;
                        int len2 = j - i;
                        if (len2 == 2 && this.buf[i] == 'l' && this.buf[i + 1] == 't') {
                            this.pc[this.pcEnd++] = 60;
                        } else if (len2 == 3 && this.buf[i] == 'a' && this.buf[i + 1] == 'm' && this.buf[i + 2] == 'p') {
                            this.pc[this.pcEnd++] = 38;
                        } else if (len2 == 2 && this.buf[i] == 'g' && this.buf[i + 1] == 't') {
                            this.pc[this.pcEnd++] = 62;
                        } else if (len2 == 4 && this.buf[i] == 'a' && this.buf[i + 1] == 'p' && this.buf[i + 2] == 'o' && this.buf[i + 3] == 's') {
                            this.pc[this.pcEnd++] = 39;
                        } else if (len2 == 4 && this.buf[i] == 'q' && this.buf[i + 1] == 'u' && this.buf[i + 2] == 'o' && this.buf[i + 3] == 't') {
                            this.pc[this.pcEnd++] = 34;
                        } else {
                            String s = new String(this.buf, i, j - i);
                            throw new XmlTokenizerException("undefined entity " + s + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                    }
                    if (!this.paramNotifyEntityRef) continue block31;
                    return 70;
                }
                case 75: {
                    this.charRefValue = '\u0000';
                    this.state = (byte)76;
                    if (ch == 'x') {
                        this.charRefHex = true;
                        continue block31;
                    }
                    this.charRefHex = false;
                }
                case 76: {
                    if (ch == ';') {
                        if (this.paramPC) {
                            this.pc[this.pcEnd++] = this.charRefValue;
                        }
                        this.state = this.previousState;
                        this.posEnd = this.pos;
                        if (!this.paramNotifyCharRef) continue block31;
                        return 75;
                    }
                    if (ch >= '0' && ch <= '9') {
                        if (this.charRefHex) {
                            this.charRefValue = (char)(this.charRefValue * 16 + (ch - 48));
                            continue block31;
                        }
                        this.charRefValue = (char)(this.charRefValue * 10 + (ch - 48));
                        continue block31;
                    }
                    if (this.charRefHex && ch >= 'A' && ch <= 'F') {
                        this.charRefValue = (char)(this.charRefValue * 16 + (ch - 65 + 10));
                        continue block31;
                    }
                    if (!this.charRefHex || ch < 'a' || ch > 'f') throw new XmlTokenizerException("character reference may not contain " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    this.charRefValue = (char)(this.charRefValue * 16 + (ch - 97 + 10));
                    continue block31;
                }
                case 110: {
                    this.seenContent = false;
                    this.posStart = this.pos - 1;
                    ch = this.readName(ch);
                    this.posEnd = this.pos - 1;
                    ch = this.skipS(ch);
                    if (ch != '>') {
                        throw new XmlTokenizerException("expected > for end tag not " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.state = (byte)10;
                    return 110;
                }
                case 120: {
                    if (this.reading && this.pos > 2 && this.pos > this.posSafe) {
                        this.shrink(this.pos - 2);
                    }
                    this.seenContent = false;
                    ch = this.less();
                    this.posStart = this.pos - 1;
                    ch = this.readName(ch);
                    this.posEnd = this.pos - 1;
                    ch = this.less();
                    this.state = (byte)122;
                    this.pcStart = 0;
                    this.pcEnd = 0;
                    return 120;
                }
                case 121: {
                    if (ch != '>') throw new XmlTokenizerException("expected > for end of start tag not " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    this.state = (byte)10;
                    this.posStart = this.pos - 1;
                    this.posEnd = this.pos;
                    return 112;
                }
                case 122: {
                    this.pcStart = this.pcEnd;
                    ch = this.skipS(ch);
                    if (ch == '/') {
                        this.state = (byte)121;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        this.mixInElement = false;
                        return 111;
                    }
                    if (ch == '>') {
                        this.state = (byte)10;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        return 112;
                    }
                    this.posStart = this.pos - 1;
                    ch = this.readName(ch);
                    this.posEnd = this.pos - 1;
                    ch = this.less();
                    this.state = (byte)123;
                    return 122;
                }
                case 123: {
                    ch = this.skipS(ch);
                    if (ch != '=') {
                        throw new XmlTokenizerException("expected = after attribute name not " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.state = (byte)124;
                    continue block31;
                }
                case 124: {
                    ch = this.skipS(ch);
                    if (ch != '\'' && ch != '\"') {
                        throw new XmlTokenizerException("attribute value must start with double quote or apostrophe not " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.attrMarker = ch;
                    this.state = (byte)125;
                    continue block31;
                }
                case 125: {
                    this.posEnd = this.posStart = this.pos - 1;
                    this.state = (byte)126;
                }
                case 126: {
                    if (ch == this.attrMarker) {
                        this.state = this.paramPC ? (byte)127 : (byte)122;
                        if (!this.paramNotifyAttValue) continue block31;
                        return 124;
                    }
                    if (ch == '&') {
                        if ((!this.paramPC || this.pcStart == this.pcEnd) && this.paramPC && this.posEnd > this.posStart) {
                            len = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                            this.pcEnd += len;
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)125;
                        if (!this.paramNotifyAttValue) continue block31;
                        return 124;
                    }
                    if (ch == '<') {
                        throw new XmlTokenizerException("attribute value can not contain " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.posEnd = this.pos;
                    if ((!this.paramPC || this.pcStart == this.pcEnd) && (!this.paramPC || ch != '\r')) continue block31;
                    if (ch == '\r') {
                        this.pc[this.pcEnd++] = 10;
                        continue block31;
                    }
                    this.pc[this.pcEnd++] = ch;
                    continue block31;
                }
                case 127: {
                    ch = this.less();
                    this.parsedContent = this.pcEnd != this.pcStart;
                    this.state = (byte)122;
                    return 127;
                }
                case 30: {
                    if (ch != ']') continue block31;
                    this.state = (byte)31;
                    continue block31;
                }
                case 31: {
                    if (ch == ']') {
                        this.state = (byte)32;
                        continue block31;
                    }
                    this.state = (byte)30;
                    continue block31;
                }
                case 32: {
                    if (ch == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (this.paramPC && this.posEnd > this.posStart) {
                            len = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                            this.pcEnd += len;
                        }
                        if (!this.paramNotifyCDSect) continue block31;
                        return 30;
                    }
                    this.state = (byte)30;
                    continue block31;
                }
                case 40: {
                    if (ch != '-') continue block31;
                    this.state = (byte)41;
                    continue block31;
                }
                case 41: {
                    if (ch == '-') {
                        this.state = (byte)42;
                        continue block31;
                    }
                    this.state = (byte)40;
                    continue block31;
                }
                case 42: {
                    if (ch == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (!this.paramNotifyComment) continue block31;
                        return 40;
                    }
                    this.state = (byte)40;
                    continue block31;
                }
                case 50: {
                    if (ch == '[') {
                        this.state = (byte)51;
                        continue block31;
                    }
                    if (ch != '>') continue block31;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block31;
                    return 50;
                }
                case 51: {
                    if (ch != ']') continue block31;
                    this.state = (byte)52;
                    continue block31;
                }
                case 52: {
                    ch = this.skipS(ch);
                    if (ch != '>') throw new XmlTokenizerException("expected > for DOCTYPE end not " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block31;
                    return 50;
                }
                case 60: {
                    if (ch != '?') continue block31;
                    this.state = (byte)61;
                    continue block31;
                }
                case 61: {
                    if (ch != '>') continue block31;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 2;
                    if (this.paramNotifyPI) return 60;
                    continue block31;
                }
            }
            break;
        }
        throw new XmlTokenizerException("invalid internal state " + this.state + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
    }

    private char more() throws IOException {
        char ch;
        if (this.backtracking) {
            this.backtracking = false;
            ++this.pos;
            ++this.posCol;
            return this.prevCh;
        }
        if (!this.reading) {
            if (this.pos == this.bufEnd - 1) {
                this.reachedEnd = true;
            }
            if (this.pos >= this.bufEnd) {
                throw new EOFException("no more data available");
            }
        } else if (this.pos >= this.bufEnd - 1) {
            int bufRead;
            int spaceLeft = this.bufSize - this.bufEnd;
            if (spaceLeft <= this.readChunkSize) {
                int newSize = 2 * this.bufSize;
                if (newSize < 4 * this.readChunkSize) {
                    newSize = 12 * this.readChunkSize;
                }
                char[] newBuf = new char[newSize];
                System.arraycopy(this.buf, 0, newBuf, 0, this.bufEnd);
                this.buf = newBuf;
                this.bufSize = newSize;
                this.posSafe = (int)(this.loadFactor * (float)this.bufSize);
                if (!this.paramPC || this.pc.length < this.bufSize) {
                    // empty if block
                }
                char[] newpc = new char[this.bufSize];
                System.arraycopy(this.pc, 0, newpc, 0, this.pcEnd);
                this.pc = newpc;
            }
            if ((bufRead = this.reader.read(this.buf, this.bufEnd, this.readChunkSize)) == -1) {
                this.reachedEnd = true;
            }
            if (bufRead == 0) {
                throw new IllegalStateException("can't read more data in buffer");
            }
            this.bufEnd += bufRead;
        }
        if ((ch = this.buf[this.pos++]) == '\n' || ch == '\r') {
            if (this.prevCh != '\r' || ch != '\n') {
                this.posCol = 2;
                ++this.posRow;
            }
        } else {
            ++this.posCol;
        }
        this.prevPrevCh = this.prevCh;
        this.prevCh = ch;
        return this.prevCh;
    }

    private char less() {
        --this.pos;
        --this.posCol;
        this.backtracking = true;
        return this.prevPrevCh;
    }

    private void shrink(int posCut) {
        System.arraycopy(this.buf, posCut, this.buf, 0, this.bufEnd - posCut);
        this.bufEnd -= posCut;
        this.pos -= posCut;
        this.posStart -= posCut;
        this.posEnd -= posCut;
        this.posNsColon -= posCut;
    }

    private static boolean compareCharArr(char[] a, char[] b, int bStart, int bEnd) {
        if (bEnd - bStart != a.length) {
            return false;
        }
        int i = bStart;
        int j = 0;
        while (i < bEnd) {
            if (a[j] != b[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private String printable(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        return "" + ch;
    }

    private char readName(char ch) throws IOException, XmlTokenizerException {
        this.posNsColon = -1;
        this.nsColonCount = 0;
        if (ch < '?' && !end_char_table[ch]) {
            throw new XmlTokenizerException("expected name start not " + ch + ":" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        do {
            if ((ch = this.more()) != ':') continue;
            this.posNsColon = this.pos - 1;
            ++this.nsColonCount;
        } while (ch >= '?' || end_char_table[ch]);
        return ch;
    }

    private boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }

    private char skipS(char ch) throws IOException {
        while (ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r') {
            ch = this.more();
        }
        return ch;
    }

    /*
     * Unable to fully structure code
     */
    private char readS(char ch) throws IOException, XmlTokenizerException {
        if (this.isS(ch)) ** GOTO lbl4
        throw new XmlTokenizerException("expected white space not " + ch + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
lbl-1000:
        // 1 sources

        {
            ch = this.more();
lbl4:
            // 2 sources

            ** while (ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r')
        }
lbl5:
        // 1 sources

        return ch;
    }

    static {
        int i = 0;
        while (i < 63) {
            XmlTokenizer.end_char_table[i] = true;
            ++i;
        }
        XmlTokenizer.end_char_table[32] = false;
        XmlTokenizer.end_char_table[9] = false;
        XmlTokenizer.end_char_table[13] = false;
        XmlTokenizer.end_char_table[10] = false;
        XmlTokenizer.end_char_table[47] = false;
        XmlTokenizer.end_char_table[62] = false;
        XmlTokenizer.end_char_table[61] = false;
    }
}

