/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.TokenWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Writer2Element
implements TokenWriter {
    private ArrayList rootElements = new ArrayList();
    private static final int STATE_NOT_FILLED = 0;
    private static final int STATE_WRITTEN_HEADER = 1;
    private ArrayList states = new ArrayList(19);
    private Document document;
    private int nextPrefix;

    public Writer2Element(Document doc) {
        this.document = doc;
    }

    public Writer2Element(Element top, Document doc) {
        this.document = doc;
        State ret = new State(top.getNamespaceURI(), top.getLocalName());
        ret.el = top;
        ret.state = 1;
        this.states.add(ret);
    }

    private State getState(int offset) {
        int s = this.states.size();
        if ((s = s - offset - 1) >= 0) {
            return (State)this.states.get(s);
        }
        return null;
    }

    private State enterState(String namespaceURI, String localPart) throws IOException {
        this.flush();
        State ret = new State(namespaceURI, localPart);
        this.states.add(ret);
        return ret;
    }

    private State leaveState() throws IOException {
        this.flush();
        State ret = this.getState(0);
        this.states.remove(this.states.size() - 1);
        if (this.states.size() == 0) {
            this.rootElements.add(ret.el);
        }
        return ret;
    }

    private int lastState() {
        return this.states.size();
    }

    public final void flush() throws IOException {
        State s = this.getState(0);
        if (s != null && s.state == 0) {
            Map.Entry e;
            Iterator i;
            String prefix;
            State s1 = this.getState(1);
            if (s.namespace != null && !s.namespace.equals("")) {
                prefix = this.getPrefixForNamespace(s.namespace);
                s.el = "".equals(prefix) ? this.document.createElementNS(s.namespace, s.name) : this.document.createElementNS(s.namespace, prefix + ":" + s.name);
            } else {
                if (!"".equals(this.getDefaultNS())) {
                    this.getPrefixForNamespace(null);
                }
                s.el = this.document.createElementNS(null, s.name);
            }
            if (s1 != null) {
                s1.el.appendChild(s.el);
            } else {
                this.rootElements.add(s.el);
            }
            if (s.attributes != null) {
                i = s.attributes.entrySet().iterator();
                while (i.hasNext()) {
                    e = i.next();
                    QName name = (QName)e.getKey();
                    String value = (String)e.getValue();
                    if ("http://www.w3.org/2000/xmlns/".equals(name.getNamespaceURI())) {
                        this.setPrefixForNamespace(name.getLocalPart(), value);
                        continue;
                    }
                    if (name.getNamespaceURI() != null && !name.getNamespaceURI().equals("")) {
                        prefix = this.getPrefixForNamespace(name.getNamespaceURI());
                        if ("".equals(prefix)) {
                            s.el.setAttributeNS(name.getNamespaceURI(), name.getLocalPart(), value);
                            continue;
                        }
                        s.el.setAttributeNS(name.getNamespaceURI(), prefix + ":" + name.getLocalPart(), value);
                        continue;
                    }
                    s.el.setAttributeNS(name.getNamespaceURI(), name.getLocalPart(), value);
                }
            }
            if (s.namespaceToPrefixMap != null) {
                i = s.namespaceToPrefixMap.entrySet().iterator();
                while (i.hasNext()) {
                    e = i.next();
                    String namespaceURI = (String)e.getKey();
                    prefix = (String)e.getValue();
                    if (prefix.equals("")) {
                        s.el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
                        continue;
                    }
                    s.el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
                }
            }
            s.state = 1;
        }
    }

    public void enter(String namespace, String name) throws IOException, IllegalStateException {
        this.enterState(namespace, name);
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        State s = this.getState(0);
        if (s.attributes == null) {
            s.attributes = new HashMap(19);
        }
        s.attributes.put(new QName(namespace, name), value);
    }

    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void writeContent(String content) throws IOException, IllegalStateException {
        this.flush();
        State s = this.getState(0);
        s.el.appendChild(this.document.createTextNode(content));
    }

    public void leave() throws IOException, IllegalStateException {
        this.leaveState();
    }

    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        String prefix;
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        if (namespace == null || namespace.length() == 0) {
            if (!"".equals(this.getDefaultNS())) {
                this.setPrefixForNamespace("", "");
            }
            return "";
        }
        int i = this.lastState() - 1;
        while (i >= 0) {
            State s = this.getState(i);
            if (s.namespaceToPrefixMap != null && (prefix = (String)s.namespaceToPrefixMap.get(namespace)) != null) {
                return prefix;
            }
            --i;
        }
        prefix = "ns" + this.nextPrefix;
        ++this.nextPrefix;
        this.setPrefixForNamespace(prefix, namespace);
        return prefix;
    }

    private String getDefaultNS() {
        int i = this.lastState() - 1;
        while (i >= 0) {
            State s = this.getState(i);
            if (s.defaultNS != null) {
                return s.defaultNS;
            }
            --i;
        }
        return "";
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        State s = this.getState(0);
        if (prefix == null) {
            prefix = "";
        }
        if (s.namespaceToPrefixMap == null) {
            s.namespaceToPrefixMap = new HashMap(19);
        }
        s.namespaceToPrefixMap.put(namespace, prefix);
        if ("".equals(prefix)) {
            s.defaultNS = namespace;
        }
    }

    public List getRootElements() {
        return this.rootElements;
    }

    private static class State {
        int state;
        String namespace;
        String name;
        Map namespaceToPrefixMap;
        Map attributes;
        Element el;
        String defaultNS;

        State(String namespaceURI, String localPart) {
            this.namespace = namespaceURI;
            this.name = localPart;
            this.state = 0;
        }
    }
}

