/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml;

import com.idoox.debug.Category;
import com.systinet.wasp.errors.Location;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class LocationAwareXMLFilter
extends XMLFilterImpl {
    private static final Category log = Category.getCategory("com.idoox.xml.LocationAwareXMLFilter");
    private Locator locator;
    private Map locations;

    public LocationAwareXMLFilter(XMLReader parent, Map locations) {
        super(parent);
        this.locations = locations;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.locator != null && this.locations != null) {
            ArrayList<Location> locationsList = null;
            locationsList = (ArrayList<Location>)this.locations.get(LocationAwareXMLFilter.getKey(uri, localName, qName));
            if (locationsList != null) {
                locationsList.add(new Location(this.locator.getLineNumber(), this.locator.getColumnNumber()));
            } else {
                locationsList = new ArrayList<Location>();
                locationsList.add(new Location(this.locator.getLineNumber(), this.locator.getColumnNumber()));
                this.locations.put(LocationAwareXMLFilter.getKey(uri, localName, qName), locationsList);
            }
        }
        int nAtts = atts.getLength();
        AttributesImpl newAtts = null;
        if (nAtts != 0) {
            newAtts = new AttributesImpl(atts);
            int i = 0;
            while (i < newAtts.getLength()) {
                String attrQName = newAtts.getQName(i);
                if (attrQName.startsWith("xmlns")) {
                    newAtts.setURI(i, "http://www.w3.org/2000/xmlns/");
                }
                ++i;
            }
        }
        super.startElement(uri, localName, qName, newAtts != null ? newAtts : atts);
    }

    public static Object getKey(String uri, String localName, String qName) {
        if (uri != null && localName != null) {
            return new QName(uri, localName);
        }
        return qName;
    }
}

