/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wsdl.util;

import com.idoox.util.ElementHelper;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.idoox.transport.client.Endpoint;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static final QName DEFINITIONS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
    public static final QName IMPORT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "import");
    public static final QName DOCUMENTATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "documentation");
    public static final QName TYPES_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "types");
    public static final QName MESSAGE_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "message");
    public static final QName PART_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "part");
    public static final QName PORTTYPE_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "portType");
    public static final QName OPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "operation");
    public static final QName INPUT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "input");
    public static final QName OUTPUT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "output");
    public static final QName FAULT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "fault");
    public static final QName BINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "binding");
    public static final QName SERVICE_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "service");
    public static final QName PORT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "port");
    public static final QName SOAPBINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    public static final QName SOAPOPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
    public static final QName SOAPBODY_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body");
    public static final QName SOAPFAULT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "fault");
    public static final QName SOAPHEADER_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
    public static final QName SOAPHEADERFAULT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "headerfault");
    public static final QName SOAPADDRESS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    public static final QName SOAP12_BINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "binding");
    public static final QName SOAP12_OPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "operation");
    public static final QName SOAP12_BODY_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "body");
    public static final QName SOAP12_FAULT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "fault");
    public static final QName SOAP12_HEADER_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "header");
    public static final QName SOAP12_HEADERFAULT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "headerfault");
    public static final QName SOAP12_ADDRESS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "address");
    public static final QName HTTPADDRESS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/http/", "address");
    public static final QName HTTPBINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/http/", "binding");
    public static final QName HTTPOPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/http/", "operation");
    public static final QName HTTPURLENCODED_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/http/", "urlEncoded");
    public static final QName HTTPURLREPLACEMENT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/http/", "urlReplacement");
    public static final QName MIMECONTENT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/mime/", "content");
    public static final QName MIMEMULTIPARTRELATED_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/mime/", "multipartRelated");
    public static final QName MIMEPART_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/mime/", "part");
    public static final QName MIMEMIMEXML_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/mime/", "mimeXml");
    public static final QName JAVAOPERATION_QNAME = new QName("http://systinet.com/mapping/", "java-operation");
    public static final QName JAVAFAULT_QNAME = new QName("http://systinet.com/mapping/", "fault");
    public static final QName DIMEMESSAGE_QNAME = new QName("http://schemas.xmlsoap.org/ws/2002/04/dime/wsdl/", "message");

    public static Element getFirstChildElement(Node node) {
        Node ret = null;
        NodeList nL = node.getChildNodes();
        int len = nL.getLength();
        int i = 0;
        while (i < len) {
            if (nL.item(i).getNodeType() == 1) {
                ret = nL.item(i);
                break;
            }
            ++i;
        }
        return (Element)ret;
    }

    public static Element getNextElementSibling(Node node) {
        Node ret = node;
        while ((ret = ret.getNextSibling()) != null) {
            if (ret.getNodeType() == 1) break;
        }
        return (Element)ret;
    }

    public static boolean testElementName(Element el, QName qName) {
        return el != null && qName != null && qName.equals(new QName(el.getNamespaceURI(), el.getLocalName()));
    }

    public static void checkElementName(Element el, QName qName) throws WSDLException {
        if (!XmlUtil.testElementName(el, qName)) {
            throw new WSDLException("PARSER_ERROR", "Got element '" + el.getNamespaceURI() + ":" + el.getLocalName() + "', but EXPECTED element is '" + qName.toString() + "'!");
        }
    }

    public static String getAttribute(Element el, String attrName) {
        return el.hasAttribute(attrName) ? el.getAttribute(attrName) : null;
    }

    public static String getAttributeNS(Element el, String nsURI, String attrName) {
        Node node;
        NamedNodeMap attributes = el.getAttributes();
        if (attributes != null && (node = attributes.getNamedItemNS(nsURI, attrName)) instanceof Attr) {
            return ((Attr)node).getValue();
        }
        return null;
    }

    public static String checkAttribute(Element el, String attrName) throws WSDLException {
        String ret = el.getAttribute(attrName);
        if (ret == null || ret.length() == 0) {
            throw new WSDLException("PARSER_ERROR", "Element '" + el.getNamespaceURI() + ":" + el.getLocalName() + "' MUST have '" + attrName + "' attribute");
        }
        return ret;
    }

    public static QName expandQName(Element refEl, String qName) throws WSDLException {
        String ns;
        if (qName == null || qName.length() == 0) {
            return null;
        }
        int prefixIx = qName.indexOf(58);
        Element el = refEl;
        String attrName = prefixIx > 0 ? "xmlns:" + qName.substring(0, prefixIx) : "xmlns";
        do {
            ns = el.getAttribute(attrName);
            Node nd = el.getParentNode();
            el = nd != null && nd.getNodeType() == 1 ? (Element)nd : null;
        } while ((ns == null || ns.length() == 0) && el != null);
        if (ns == null && prefixIx > 0) {
            throw new WSDLException("PARSER_ERROR", "Namespace prefix '" + qName.substring(0, prefixIx) + "' not found");
        }
        return new QName(ns, qName.substring(prefixIx > 0 ? prefixIx + 1 : 0));
    }

    public static QName expandQName(Definition def, String qName) {
        if (qName == null || qName.length() == 0) {
            return null;
        }
        int prefixIx = qName.indexOf(58);
        String ns = prefixIx > 0 ? def.getNamespace(qName.substring(0, prefixIx)) : def.getTargetNamespace();
        return new QName(ns, qName.substring(prefixIx > 0 ? prefixIx + 1 : 0));
    }

    public static String toAttr(Definition def, QName val) {
        if (val == null) {
            return null;
        }
        String prefix = XmlUtil.getPrefix(def, val.getNamespaceURI());
        if (prefix == null) {
            return null;
        }
        if (prefix.length() == 0) {
            return val.getLocalPart();
        }
        return prefix + val.getLocalPart();
    }

    private static boolean needToNormalize(String s) {
        int l = s.length();
        int i = 0;
        while (i < l) {
            char c = s.charAt(i);
            if (c < 'A' && (c == '<' || c == '>' || c == '&' || c == '\"')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String normalize(String s) {
        if (XmlUtil.needToNormalize(s)) {
            StringBuffer sb = new StringBuffer();
            int len = s.length();
            int i = 0;
            while (i < len) {
                char c = s.charAt(i);
                switch (c) {
                    case '<': {
                        sb.append("&lt;");
                        break;
                    }
                    case '>': {
                        sb.append("&gt;");
                        break;
                    }
                    case '&': {
                        sb.append("&amp;");
                        break;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        return s;
    }

    public static String printAttr(String aName, Object aVal) {
        String ret;
        if (aVal instanceof List) {
            int listSize;
            List list = (List)aVal;
            if (list != null && (listSize = list.size()) > 0) {
                StringBuffer toRet = new StringBuffer();
                toRet.append(" " + aName + "='");
                int i = 0;
                while (i < listSize) {
                    toRet.append(XmlUtil.normalize((i == 0 ? "" : " ") + (String)list.get(i)));
                    ++i;
                }
                toRet.append("'");
                ret = toRet.toString();
            } else {
                ret = "";
            }
        } else {
            ret = aVal != null ? " " + aName + "='" + XmlUtil.normalize(aVal.toString()) + "'" : "";
        }
        return ret;
    }

    public static List toList(String toTok) {
        return XmlUtil.toList(toTok, " ");
    }

    public static List toList(String toTok, String delim) {
        if (toTok == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer sTok = new StringTokenizer(toTok, delim);
        while (sTok.hasMoreTokens()) {
            ret.add(sTok.nextToken());
        }
        return ret;
    }

    public static Element smarterCloneElement(Definition def, Element toClone) {
        Element ret = ElementHelper.cloneNode(toClone);
        Node node = toClone.getParentNode();
        while (node != null && node instanceof Element) {
            Element el = (Element)node;
            NamedNodeMap attrM = el.getAttributes();
            int i = 0;
            while (i < attrM.getLength()) {
                Attr attr = (Attr)attrM.item(i);
                String prefix = attr.getPrefix();
                String name = attr.getName();
                String localName = attr.getLocalName();
                if (("xmlns".equals(prefix) || prefix == null && "xmlns".equals(localName)) && toClone.getAttributeNode(name) == null) {
                    ret.setAttribute(attr.getName(), attr.getValue());
                }
                ++i;
            }
            node = node.getParentNode();
        }
        NamedNodeMap attMap = ret.getAttributes();
        ArrayList<Node> attList = new ArrayList<Node>();
        int length = attMap.getLength();
        int i = 0;
        while (i < length) {
            attList.add(attMap.item(i));
            ++i;
        }
        length = attList.size();
        int i2 = 0;
        while (i2 < length) {
            Attr attr = (Attr)attList.get(i2);
            String name = attr.getName();
            String prefix = attr.getPrefix();
            String value = attr.getValue();
            if ("xmlns".equals(prefix) && value.equals(def.getNamespace(attr.getLocalName()))) {
                ret.removeAttribute(name);
            } else if (prefix == null && "xmlns".equals(name) && value.equals(def.getNamespace(""))) {
                ret.removeAttribute(name);
            }
            ++i2;
        }
        return ret;
    }

    public static String getPrefix(Definition def, String namespaceURI) {
        String prefix = def.getPrefix(namespaceURI);
        if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        return prefix;
    }

    public static Endpoint createEndpoint(String contextURI, String wsdlURL) throws MalformedURLException {
        Endpoint endpoint = null;
        try {
            endpoint = new Endpoint(contextURI);
        }
        catch (Exception ex) {
            endpoint = null;
        }
        if (endpoint == null) {
            if (wsdlURL.indexOf(58) < 0) {
                wsdlURL = "file:" + wsdlURL;
            }
            endpoint = new Endpoint(wsdlURL);
        } else {
            endpoint = new Endpoint(endpoint, wsdlURL);
        }
        return endpoint;
    }
}

