/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.wsdl;

import com.idoox.debug.Category;
import com.idoox.util.ClassCache;
import com.idoox.wasp.InterfaceIntrospector;
import com.idoox.wasp.tools.common.util.ClassHelper;
import com.idoox.wsdl.util.WSDLUtil;
import com.idoox.wsdl.util.XmlUtil;
import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportRepository;
import org.idoox.transport.URI;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.Context;
import org.idoox.wasp.tools.java2wsdl.Java2WSDL;
import org.idoox.wasp.tools.java2wsdl.Java2WSDLFactory;
import org.systinet.wasp.IWasp;
import org.systinet.wasp.webservice.IRegistry;

public class WSDLRuntimeGenerator {
    private static final Category log = Category.getCategory("com.idoox.wasp.wsdl.WSDLRuntimeGenerator");
    public static final String WSDLGENERATOR_PATH = "/internal/java/wsdlGenerator/";
    private static TransportRepository transportRepository = null;
    private static Map definitionCache = new WeakHashMap();
    private static ExtensionRegistry extensionRegistry = null;
    private static IWasp iWasp = null;
    static /* synthetic */ Class class$javax$wsdl$Port;

    public static final void process(Connection con) {
        try {
            String toWrite;
            URI uri = con.getURI();
            String toGen = uri.getParameter("class");
            String sURI = uri.getParameter("serviceURI");
            String protocol = uri.getParameter("protocol");
            if (toGen == null) {
                con.getOutputMessage().setStatusCode(400);
                con.getOutputMessage().close();
                return;
            }
            OutputMessage oMsg = con.getOutputMessage();
            oMsg.setContentType("text/xml; charset=utf-8");
            OutputStreamWriter osW = new OutputStreamWriter(con.getOutputMessage());
            String cacheKey = sURI + ": " + toGen;
            Class<?> clazz = ClassCache.getClassForName(cacheKey);
            if (clazz == null) {
                clazz = Class.forName(toGen);
            }
            if (clazz.isInterface()) {
                toWrite = (String)definitionCache.get(toGen + protocol);
                if (toWrite == null) {
                    Definition def = WSDLRuntimeGenerator.getInterfaceWSDL(uri, clazz, sURI, protocol);
                    toWrite = WSDLUtil.writeWSDL(def);
                    definitionCache.put(toGen + protocol, toWrite);
                }
            } else {
                Definition def = WSDLRuntimeGenerator.getClassWSDL(uri, clazz, sURI, protocol);
                toWrite = WSDLUtil.writeWSDL(def);
            }
            osW.write(toWrite);
            osW.flush();
            osW.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Error processing GET request: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static IWasp getIWasp() {
        if (iWasp == null) {
            iWasp = (IWasp)Context.getInstance("org.systinet.wasp.Wasp");
        }
        return iWasp;
    }

    private static Definition getInterfaceWSDL(URI wsdlGeneratorURI, Class clazz, String endpointURI, String protocol) throws WSDLException {
        IRegistry registry = (IRegistry)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
        Java2WSDL java2WSDL = Java2WSDLFactory.newJava2WSDL();
        String cUID = ClassHelper.getClassUID(clazz);
        java2WSDL.setRuntimeMode(endpointURI + "/" + cUID);
        java2WSDL.setInterfaceMappingMode(16);
        java2WSDL.setMode(257);
        if (protocol != null) {
            java2WSDL.setProtocol(protocol.equalsIgnoreCase("soap11") ? 305 : 306);
        }
        if (transportRepository == null) {
            transportRepository = (TransportRepository)Context.getInstance("org.idoox.transport.TransportRepository");
        }
        try {
            Endpoint uri = new Endpoint(endpointURI);
            String path = transportRepository.getLocalPath(uri);
            ServiceEndpointImpl endpoint = (ServiceEndpointImpl)registry.getServiceEndpoint(path);
            if (endpoint != null) {
                int use = endpoint.getUse();
                int style = endpoint.getStyle();
                java2WSDL.setSOAPEncoding(use);
                java2WSDL.setBindingStyle(style);
            }
            String prot = endpoint != null ? endpoint.getServiceBindingConfig().getProtocol() : WSDLRuntimeGenerator.getIWasp().getDefaultXMLProtocols()[0];
            if (protocol != null) {
                if ("soap".equals(prot) || "soap11".equals(prot)) {
                    java2WSDL.setProtocol(305);
                } else if ("soap12".equals(prot)) {
                    java2WSDL.setProtocol(306);
                }
            } else {
                java2WSDL.setProtocol(305);
            }
            if (endpoint != null) {
                ServiceManagerImpl.addChainHeaders(java2WSDL, endpoint.getHandlersID());
            }
        }
        catch (MalformedURLException e) {
            log.warn("No SOAP headers in WSDL will be generated: " + e);
        }
        Definition def = java2WSDL.generateDefinition(clazz);
        if (def == null) {
            throw new RuntimeException("Error during WSDL generation!");
        }
        return def;
    }

    private static Definition getClassWSDL(URI wsdlGeneratorURI, Class clazz, String endpointURI, String protocol) throws WSDLException {
        Endpoint endpoint;
        try {
            endpoint = new Endpoint(wsdlGeneratorURI.toExternalForm());
        }
        catch (Exception ex) {
            throw new RuntimeException("Bad connection URI!");
        }
        endpoint.setQuery(null);
        if (endpointURI != null) {
            endpoint.setParameter("serviceURI", endpointURI);
        }
        String clazzUID = ClassHelper.getClassUID(clazz);
        Definition def = WSDLUtil.newDefinition();
        String convertedClazzUID = clazzUID.replace('$', '_');
        convertedClazzUID.replace('.', '_');
        QName serviceQName = new QName(endpointURI, convertedClazzUID);
        def.setQName(serviceQName);
        Service service = def.createService();
        service.setQName(serviceQName);
        def.addService(service);
        if (extensionRegistry == null) {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance("com.idoox.wsdl.factory.WSDLFactoryImpl");
            extensionRegistry = wsdlFactory.newPopulatedExtensionRegistry();
        }
        SOAPAddress soapAddr = (SOAPAddress)extensionRegistry.createExtension(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = WSDLRuntimeGenerator.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, XmlUtil.SOAPADDRESS_QNAME);
        soapAddr.setLocationURI(endpointURI);
        Class[] ifaceA = InterfaceIntrospector.getExportInterfaces(clazz);
        int i = 0;
        while (i < ifaceA.length) {
            String cName = ifaceA[i].getName();
            String cUID = ClassHelper.getClassUID(ifaceA[i]);
            String cNS = endpointURI + "/" + cUID;
            Import imp = def.createImport();
            imp.setNamespaceURI(cNS);
            endpoint.setParameter("class", cName);
            if (protocol != null) {
                endpoint.setParameter("protocol", protocol);
            }
            imp.setLocationURI(endpoint.toExternalForm());
            def.addImport(imp);
            Binding bnd = def.createBinding();
            bnd.setUndefined(true);
            bnd.setQName(new QName(cNS, cUID));
            Port port = def.createPort();
            port.setName(cUID);
            port.setBinding(bnd);
            port.addExtensibilityElement(soapAddr);
            service.addPort(port);
            ++i;
        }
        return def;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

