/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.tools.common.util;

import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.TypeMappingContext;
import org.idoox.xml.schema.SchemaException;

public class ClassTypeTokenizer {
    protected int arrayDimensionsCount;
    protected String arrayOfPrefix;
    protected Class typeClass;
    protected String typeClassName;
    protected QName typeQName;

    public ClassTypeTokenizer(Class typeClass, TypeMappingContext typeMappingContext) throws SchemaException {
        StringBuffer buffer = new StringBuffer();
        Class<?> typeSubClass = typeClass;
        while (typeSubClass.isArray()) {
            buffer.append("[]");
            typeSubClass = typeSubClass.getComponentType();
        }
        this.typeClass = typeClass;
        this.typeClassName = typeClass.getName();
        this.typeQName = null;
        this.arrayOfPrefix = "";
        this.arrayDimensionsCount = 0;
        String typeName = typeSubClass.getName() + buffer.toString();
        int tcnLen = typeSubClass.getName().length();
        int dimLen = typeName.length();
        while (this.typeQName == null && dimLen >= tcnLen) {
            String actJavaType = typeName.substring(0, dimLen);
            this.typeQName = typeMappingContext.getSchemaType(actJavaType);
            if (this.typeQName != null || typeMappingContext.getAttachmentMimeType(actJavaType) != null) break;
            if (dimLen > tcnLen) {
                ++this.arrayDimensionsCount;
                this.arrayOfPrefix = this.arrayOfPrefix + "ArrayOf";
                this.typeClass = this.typeClass.getComponentType();
                this.typeClassName = this.typeClass.getName();
            }
            dimLen -= 2;
        }
    }

    public int getArrayDimensionsCount() {
        return this.arrayDimensionsCount;
    }

    public String getArrayOfPrefix() {
        return this.arrayOfPrefix;
    }

    public Class getTypeClass() {
        return this.typeClass;
    }

    public String getClassName() {
        return this.typeClassName;
    }

    public QName getQName() {
        return this.typeQName;
    }
}

