/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server.adaptor;

import com.idoox.debug.Category;
import com.idoox.soap.UnsupportedMediaTypeException;
import com.idoox.soap.VersionMismatchException;
import com.idoox.wasp.serialization.FaultSerializationHelper;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.wasp.server.adaptor.XMLAdaptor;
import com.idoox.wasp.server.adaptor.XMLAdaptorException;
import com.idoox.wasp.server.adaptor.XMLAdaptorStopException;
import com.idoox.wasp.server.adaptor.XMLServiceException;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import com.systinet.wasp.rpc.handler.HandlerChainInvoker;
import com.systinet.wasp.soap.util.SAAJUtils;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import com.systinet.wasp.webservice.ServiceInstanceImpl;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.messaging.OnewayListener;
import javax.xml.messaging.ReqRespListener;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.URI;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.ProtocolRepository;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Fault;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessagePart;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.MultipleHeadersException;
import org.systinet.wasp.IWasp;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.addressing.EndpointReference;
import org.systinet.wasp.policy.EffectivePolicy;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.soap.MessageSource;
import org.systinet.wasp.soap.MessageSourceFactory;
import org.systinet.wasp.soap.UnsupportedMessageTypeException;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.soap.WaspMessageFactory;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.soap.bc.MessageConvertor;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.XMLService;

public class XMLAdaptorImpl
implements XMLAdaptor {
    private static final String HANDLERS_ID = "xmlAdaptor.handlersID";
    private static final String ONEWAY_LISTENER = "xmlAdaptor.onewayListener";
    private static final String PROCESS_FAULT_CHAIN = "xmlAdaptor.processFaultChain";
    public static final String CALL_CONTEXT_CONNECTION = "wasp.transport.connection";
    private static final String className = "com.idoox.wasp.server.adaptor.XMLAdaptorImpl";
    private static final Category dbg = Category.getCategory("com.idoox.wasp.server.adaptor.XMLAdaptorImpl");
    private ProtocolRepository protocolRepository;
    private MessageSourceFactory messageSourceFactory;
    private IWasp iwasp;
    private SerializationRepositoryImpl sRepo;
    private Map protocolMap;
    private HandlerChainInvoker serverChainInvoker;
    private IPolicyManager policyManager = (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");

    public XMLAdaptorImpl() {
        this.protocolRepository = (ProtocolRepository)Context.getInstance("org.idoox.wasp.ProtocolRepository");
        this.sRepo = (SerializationRepositoryImpl)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
        this.iwasp = (IWasp)Context.getInstance("org.systinet.wasp.Wasp");
        this.messageSourceFactory = MessageSourceFactory.newInstance();
        try {
            this.protocolMap = new HashMap(13);
            WaspMessageFactory factory = (WaspMessageFactory)this.protocolRepository.createMessageFactory("soap11");
            this.protocolMap.put("soap11", factory);
            factory = (WaspMessageFactory)this.protocolRepository.createMessageFactory("soap12");
            this.protocolMap.put("soap12", factory);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException("Unable to initialize XMLAdaptor", e);
        }
        this.serverChainInvoker = HandlerChainInvoker.getServerChainInvoker();
    }

    public void init(CurrentImpl.ThreadLocals threadLocals, ServiceEndpointImpl endpoint) {
        ServiceBindingConfig bindingConfig = endpoint.getServiceBindingConfig();
        Map wsContext = threadLocals.serviceEndpointContext.getContextData();
        String protocol = bindingConfig.getProtocol();
        WaspMessageFactory factory = (WaspMessageFactory)this.protocolMap.get(protocol);
        wsContext.put("com.idoox.wasp.server.WSServiceConfigurationImpl.protocolHandlerInstance", factory);
        wsContext.put("com.idoox.wasp.server.WSServiceConfigurationImpl.faultSerializationID", this.sRepo.cloneFaultSerializationID(bindingConfig.getFaultSerialization()));
    }

    public void startRequest(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint, int fromPosition) throws XMLAdaptorException, XMLAdaptorStopException {
        ServiceEndpointContext serviceEndpointContext = threadLocals.serviceEndpointContext;
        Map wsContext = serviceEndpointContext.getContextData();
        String handlersID = serviceEndpoint.getHandlersID();
        messageContext.setProperty(HANDLERS_ID, handlersID);
        String faultSerializationID = (String)wsContext.get("com.idoox.wasp.server.WSServiceConfigurationImpl.faultSerializationID");
        messageContext.setProperty("xmlAdaptor.faultSerializationID", faultSerializationID);
        HandlerChainInvoker.State state = this.serverChainInvoker.processInput(messageContext, handlersID, fromPosition, -1);
        switch (state.statusCode) {
            case 1: {
                break;
            }
            case 2: {
                throw new XMLAdaptorStopException();
            }
            case 3: {
                dbg.warn("Error during processing of handlers (processInput)", state.thrownException);
                if (!(state.thrownException instanceof SOAPFaultException)) {
                    messageContext.setProperty(PROCESS_FAULT_CHAIN, Boolean.FALSE);
                }
                throw new XMLAdaptorException(state.thrownException);
            }
        }
    }

    public void startRequest(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint) throws XMLAdaptorException, XMLAdaptorStopException {
        try {
            ServiceEndpointContext serviceEndpointContext = threadLocals.serviceEndpointContext;
            Map wsContext = serviceEndpointContext.getContextData();
            String handlersID = serviceEndpoint.getHandlersID();
            messageContext.setProperty(HANDLERS_ID, handlersID);
            String faultSerializationID = (String)wsContext.get("com.idoox.wasp.server.WSServiceConfigurationImpl.faultSerializationID");
            messageContext.setProperty("xmlAdaptor.faultSerializationID", faultSerializationID);
            Connection connection = (Connection)messageContext.getProperty("xmlAdaptor.connection");
            CallContext context = threadLocals.callContext;
            Map contextData = context.getContextData();
            contextData.put(CALL_CONTEXT_CONNECTION, connection);
            WaspSOAPMessage message = null;
            String protocol = null;
            try {
                InputMessage input = connection.getInputMessage();
                MessageSource ms = this.messageSourceFactory.getMessageSource(input, messageContext);
                protocol = ms.getXMLProtocol();
                if (!serviceEndpoint.getSupportedProtocols().contains(protocol)) {
                    throw new VersionMismatchException();
                }
                contextData.put("wasp.xml.protocol", protocol);
                WaspMessageFactory factory = (WaspMessageFactory)this.protocolMap.get(protocol);
                message = factory.createMessage(ms);
                messageContext.setMessage(message);
            }
            catch (VersionMismatchException e) {
                if (protocol == null) {
                    Iterator it = serviceEndpoint.getSupportedProtocols().iterator();
                    if (it.hasNext()) {
                        protocol = (String)it.next();
                    }
                    if (protocol == null) {
                        protocol = this.getDefaultXMLProtocol();
                    }
                }
                contextData.put("wasp.xml.protocol", protocol);
                throw new XMLAdaptorException(e);
            }
            catch (UnsupportedMediaTypeException e) {
                messageContext.setProperty("xmlAdaptor.statusCode", new Integer(415));
                throw new XMLAdaptorException(e);
            }
            catch (UnsupportedMessageTypeException e) {
                messageContext.setProperty("xmlAdaptor.statusCode", new Integer(400));
                throw new XMLAdaptorException(e);
            }
            catch (Throwable e) {
                messageContext.setProperty("xmlAdaptor.statusCode", new Integer(400));
                throw new XMLAdaptorException(e);
            }
            HandlerChainInvoker.State state = this.serverChainInvoker.processInput(messageContext, handlersID);
            switch (state.statusCode) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new XMLAdaptorStopException();
                }
                case 3: {
                    dbg.warn("Error during processing of handlers (processInput)", state.thrownException);
                    if (!(state.thrownException instanceof SOAPFaultException)) {
                        messageContext.setProperty(PROCESS_FAULT_CHAIN, Boolean.FALSE);
                    }
                    throw new XMLAdaptorException(state.thrownException);
                }
            }
        }
        catch (XMLAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new XMLAdaptorException(e);
        }
    }

    public void startReply(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint, int fromPosition, int toPosition) throws XMLAdaptorException {
        try {
            this.setupResponseAddressingHeaders(threadLocals.callContext.getContextData(), false);
            WaspSOAPMessage output = (WaspSOAPMessage)messageContext.getMessage();
            if (output == null) {
                return;
            }
            if (((WaspInternalSOAPMessage)output).hasFault()) {
                this.startFault(threadLocals, messageContext, serviceEndpoint, null, fromPosition, toPosition);
                return;
            }
            String headerNames = (String)messageContext.getProperty(HANDLERS_ID);
            HandlerChainInvoker.State state = this.serverChainInvoker.processOutput(messageContext, headerNames, fromPosition, toPosition);
            switch (state.statusCode) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    dbg.warn("Error during processing of handlers (processOutput)", state.thrownException);
                    messageContext.setProperty(PROCESS_FAULT_CHAIN, Boolean.FALSE);
                    throw new XMLAdaptorException(state.thrownException);
                }
            }
        }
        catch (XMLAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            dbg.debug("Unexpected exception during startReply():", e);
            throw new XMLAdaptorException(e);
        }
    }

    public void startReply(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint) throws XMLAdaptorException {
        try {
            OnewayListener owService = (OnewayListener)messageContext.getProperty(ONEWAY_LISTENER);
            if (owService != null) {
                WaspSOAPMessage input = (WaspSOAPMessage)messageContext.getMessage();
                try {
                    owService.onMessage(input);
                    return;
                }
                catch (Throwable e) {
                    ServiceInstanceImpl instance = (ServiceInstanceImpl)threadLocals.serviceInstanceContext.getServiceInstance();
                    Category cat = instance.getDebugCategory();
                    cat.warn(e.getMessage(), e);
                    dbg.warn("JAXM OnewayListner ended with exception:", e);
                    throw new XMLServiceException(e);
                }
            }
            this.setupResponseAddressingHeaders(threadLocals.callContext.getContextData(), false);
            WaspSOAPMessage output = (WaspSOAPMessage)messageContext.getMessage();
            if (output == null) {
                return;
            }
            if (((WaspInternalSOAPMessage)output).hasFault()) {
                this.startFault(threadLocals, messageContext, serviceEndpoint, null);
                return;
            }
            String headerNames = (String)messageContext.getProperty(HANDLERS_ID);
            HandlerChainInvoker.State state = this.serverChainInvoker.processOutput(messageContext, headerNames);
            switch (state.statusCode) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new XMLAdaptorStopException();
                }
                case 3: {
                    dbg.warn("Error during processing of handlers (processOutput)", state.thrownException);
                    messageContext.setProperty(PROCESS_FAULT_CHAIN, Boolean.FALSE);
                    throw new XMLAdaptorException(state.thrownException);
                }
            }
        }
        catch (XMLAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            dbg.warn("Unexpected exception during startReply():", e);
            throw new XMLAdaptorException(e);
        }
    }

    public void startFault(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint, Throwable exception) {
        String headersName = (String)messageContext.getProperty(HANDLERS_ID);
        try {
            Boolean processFaultChain;
            this.setupResponseAddressingHeaders(threadLocals.callContext.getContextData(), true);
            String faultSerializationID = (String)messageContext.getProperty("xmlAdaptor.faultSerializationID");
            WaspSOAPMessage message = (WaspSOAPMessage)messageContext.getMessage();
            if (message == null) {
                Map contextData = threadLocals.callContext.getContextData();
                String protocol = (String)contextData.get("wasp.xml.protocol");
                if (protocol == null) {
                    Iterator it = serviceEndpoint.getSupportedProtocols().iterator();
                    if (it.hasNext()) {
                        protocol = (String)it.next();
                    }
                    if (protocol == null) {
                        protocol = this.getDefaultXMLProtocol();
                    }
                }
                message = (WaspSOAPMessage)this.protocolRepository.createMessageFactory(protocol).createMessage();
            }
            if (exception != null) {
                InvocationTargetException ie;
                Throwable aux;
                if (exception instanceof InvocationTargetException && (aux = (ie = (InvocationTargetException)exception).getTargetException()) instanceof SOAPFaultException) {
                    exception = (SOAPFaultException)aux;
                }
                if (exception instanceof SOAPFaultException) {
                    Detail detail;
                    SOAPFaultException faultEx = (SOAPFaultException)exception;
                    SOAPFault soapFault = message.getSOAPPart().getEnvelope().getBody().addFault();
                    QName exFaultCode = faultEx.getFaultCode();
                    String faultCode = SAAJUtils.qNameToString(soapFault, exFaultCode);
                    soapFault.setFaultCode(faultCode);
                    String faultString = faultEx.getFaultString();
                    if (faultString == null) {
                        faultString = "SOAPFault exception was thrown but no fault string was specified(faultstring string is mandatory element)!";
                    }
                    soapFault.setFaultString(faultString);
                    String faultActor = faultEx.getFaultActor();
                    if (faultActor != null) {
                        soapFault.setFaultActor(faultActor);
                    }
                    if ((detail = faultEx.getDetail()) != null) {
                        soapFault.addChildElement(detail);
                    }
                } else {
                    String faultString;
                    Message msg = MessageConvertor.convertSOAPMessage(message, false, false);
                    msg.initFault(true);
                    Fault fault = msg.createFault();
                    QName faultCode = (QName)messageContext.getProperty("xmlAdaptor.faultCode");
                    if (faultCode != null) {
                        fault.setFaultCode(faultCode);
                    }
                    if ((faultString = (String)messageContext.getProperty("xmlAdaptor.faultString")) != null) {
                        fault.setFaultString(faultString);
                    }
                    FaultSerializationHelper.serializeFault(faultSerializationID, exception, fault);
                    messageContext.setProperty("xmlAdaptor.faultGenerated", Boolean.TRUE);
                    messageContext.setMessage(MessageConvertor.convertMessage(msg));
                }
            }
            if ((processFaultChain = (Boolean)messageContext.getProperty(PROCESS_FAULT_CHAIN)) == null || processFaultChain.booleanValue()) {
                HandlerChainInvoker.State state = this.serverChainInvoker.processFault(messageContext, headersName);
                switch (state.statusCode) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        dbg.warn("Error during processing of handlers (processFault)", state.thrownException);
                        throw new RuntimeWrappedException(state.thrownException);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (Throwable e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void startFault(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint, Throwable exception, int fromPosition, int toPosition) {
        String headersName = (String)messageContext.getProperty(HANDLERS_ID);
        try {
            Boolean processFaultChain;
            this.setupResponseAddressingHeaders(threadLocals.callContext.getContextData(), true);
            String faultSerializationID = (String)messageContext.getProperty("xmlAdaptor.faultSerializationID");
            WaspSOAPMessage message = (WaspSOAPMessage)messageContext.getMessage();
            if (message == null) {
                Map contextData = threadLocals.callContext.getContextData();
                String protocol = (String)contextData.get("wasp.xml.protocol");
                if (protocol == null) {
                    Iterator it = serviceEndpoint.getSupportedProtocols().iterator();
                    if (it.hasNext()) {
                        protocol = (String)it.next();
                    }
                    if (protocol == null) {
                        protocol = this.getDefaultXMLProtocol();
                    }
                }
                message = (WaspSOAPMessage)this.protocolRepository.createMessageFactory(protocol).createMessage();
            }
            if (exception != null) {
                Object faultCode;
                InvocationTargetException ie;
                Throwable aux;
                if (exception instanceof InvocationTargetException && (aux = (ie = (InvocationTargetException)exception).getTargetException()) instanceof SOAPFaultException) {
                    exception = (SOAPFaultException)aux;
                }
                if (exception instanceof SOAPFaultException) {
                    Detail detail;
                    SOAPFaultException faultEx = (SOAPFaultException)exception;
                    SOAPFault soapFault = message.getSOAPPart().getEnvelope().getBody().addFault();
                    faultCode = SAAJUtils.qNameToString(soapFault, faultEx.getFaultCode());
                    soapFault.setFaultCode((String)faultCode);
                    String faultString = faultEx.getFaultString();
                    if (faultString == null) {
                        faultString = "SOAPFault exception was thrown but no fault string was specified(faultstring string is mandatory element)!";
                    }
                    soapFault.setFaultString(faultString);
                    String faultActor = faultEx.getFaultActor();
                    if (faultActor != null) {
                        soapFault.setFaultActor(faultActor);
                    }
                    if ((detail = faultEx.getDetail()) != null) {
                        soapFault.addChildElement(detail);
                    }
                } else {
                    String faultString;
                    Message msg = MessageConvertor.convertSOAPMessage(message, false, false);
                    msg.initFault(true);
                    Fault fault = msg.createFault();
                    faultCode = (QName)messageContext.getProperty("xmlAdaptor.faultCode");
                    if (faultCode != null) {
                        fault.setFaultCode((QName)faultCode);
                    }
                    if ((faultString = (String)messageContext.getProperty("xmlAdaptor.faultString")) != null) {
                        fault.setFaultString(faultString);
                    }
                    FaultSerializationHelper.serializeFault(faultSerializationID, exception, fault);
                    messageContext.setProperty("xmlAdaptor.faultGenerated", Boolean.TRUE);
                    messageContext.setMessage(MessageConvertor.convertMessage(msg));
                }
            }
            if ((processFaultChain = (Boolean)messageContext.getProperty(PROCESS_FAULT_CHAIN)) == null || processFaultChain.booleanValue()) {
                HandlerChainInvoker.State state = this.serverChainInvoker.processFault(messageContext, headersName, fromPosition, toPosition);
                switch (state.statusCode) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        new RuntimeException("Error: STATUS_STOP state while processing fault");
                    }
                    case 3: {
                        dbg.warn("Error during processing of handlers (processFault)", state.thrownException);
                        throw new RuntimeWrappedException(state.thrownException);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (Throwable e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private String getDefaultXMLProtocol() {
        String[] protocols = this.iwasp.getDefaultXMLProtocols();
        String protocol = protocols == null || protocols.length == 0 ? "soap11" : protocols[0];
        return protocol;
    }

    public boolean xmlDispatch(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint) throws XMLAdaptorException, XMLAdaptorStopException {
        Map serviceData = threadLocals.serviceEndpointContext.getContextData();
        WSRegistry registry = (WSRegistry)serviceData.get("core.ws_registry");
        Object service = registry.getService(null);
        if (service instanceof ReqRespListener) {
            ReqRespListener rrService = (ReqRespListener)service;
            WaspSOAPMessage input = (WaspSOAPMessage)messageContext.getMessage();
            try {
                SOAPMessage output = rrService.onMessage(input);
                messageContext.setMessage(output);
                return messageContext.getMessage() == null;
            }
            catch (Throwable e) {
                ServiceInstanceImpl instance = (ServiceInstanceImpl)threadLocals.serviceInstanceContext.getServiceInstance();
                Category cat = instance.getDebugCategory();
                cat.warn(e.getMessage(), e);
                dbg.debug("JAXM ReqRespListner ended with exception:", e);
                throw new XMLServiceException(e);
            }
        }
        if (service instanceof OnewayListener) {
            WaspSOAPMessage input = (WaspSOAPMessage)messageContext.getMessage();
            OnewayListener owService = (OnewayListener)service;
            try {
                owService.onMessage(input);
                return true;
            }
            catch (Throwable e) {
                ServiceInstanceImpl instance = (ServiceInstanceImpl)threadLocals.serviceInstanceContext.getServiceInstance();
                Category cat = instance.getDebugCategory();
                cat.warn(e.getMessage(), e);
                dbg.warn("JAXM OnewayListner ended with exception:", e);
                throw new XMLServiceException(e);
            }
        }
        dbg.error("Invalid type of XML service encountered, this adaptor requires service implementation derived from the 'javax.xml.messaging.ReqRespListener', 'javax.xml.messaging.OnewayListener' interface");
        throw new XMLAdaptorException(new RuntimeException("Invalid type of XML service encountered, this adaptor requires service implementation derived from the 'javax.xml.messaging.ReqRespListener', 'javax.xml.messaging.OnewayListener' interface"));
    }

    public boolean dispatch(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint) throws XMLAdaptorException, XMLAdaptorStopException {
        block12: {
            try {
                Map serviceData = threadLocals.serviceEndpointContext.getContextData();
                WSRegistry registry = (WSRegistry)serviceData.get("core.ws_registry");
                Connection con = (Connection)messageContext.getProperty("xmlAdaptor.connection");
                Object service = registry.getService(null);
                if (service instanceof ReqRespListener) {
                    ReqRespListener rrService = (ReqRespListener)service;
                    WaspSOAPMessage input = (WaspSOAPMessage)messageContext.getMessage();
                    try {
                        SOAPMessage output = rrService.onMessage(input);
                        messageContext.setMessage(output);
                        if (output == null) {
                            return true;
                        }
                        break block12;
                    }
                    catch (Throwable e) {
                        ServiceInstanceImpl instance = (ServiceInstanceImpl)threadLocals.serviceInstanceContext.getServiceInstance();
                        Category cat = instance.getDebugCategory();
                        cat.warn(e.getMessage(), e);
                        dbg.debug("JAXM ReqRespListner ended with exception:", e);
                        throw new XMLServiceException(e);
                    }
                }
                if (service instanceof OnewayListener) {
                    messageContext.setProperty(ONEWAY_LISTENER, service);
                    return true;
                }
                if (service instanceof XMLService) {
                    XMLService xmlService = (XMLService)service;
                    WaspSOAPMessage message = (WaspSOAPMessage)messageContext.getMessage();
                    Message xmlRpcMessage = MessageConvertor.convertSOAPMessage(message, true, true);
                    try {
                        messageContext.setMessage(null);
                        xmlService.process(new MessageWrapper(xmlRpcMessage, con.getInputMessage(), messageContext));
                        if (messageContext.getMessage() == null) {
                            return true;
                        }
                        break block12;
                    }
                    catch (Throwable e) {
                        dbg.debug("XMLService ended with exception:", e);
                        throw new XMLServiceException(e);
                    }
                }
                dbg.error("Invalid type of XML service encountered, this adaptor requires service implementation derived from the 'javax.xml.messaging.ReqRespListener', 'javax.xml.messaging.OnewayListener' or org.systinet.wasp.webservice.XMLService interface");
                throw new XMLAdaptorException(new RuntimeException("Invalid type of XML service encountered, this adaptor requires service implementation derived from the 'javax.xml.messaging.ReqRespListener', 'javax.xml.messaging.OnewayListener' or org.systinet.wasp.webservice.XMLService interface"));
            }
            catch (XMLAdaptorException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new XMLAdaptorException(e);
            }
        }
        return false;
    }

    public void endCall(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint, Connection connection, boolean beSilent) {
        block9: {
            try {
                WaspSOAPMessage message = (WaspSOAPMessage)messageContext.getMessage();
                if (connection == null) {
                    return;
                }
                if (message == null || messageContext.getProperty("SOAPMessage.empty") != null) break block9;
                OutputMessage outputMessage = connection.getOutputMessage();
                if (outputMessage != null) {
                    try {
                        message.writeTo(outputMessage);
                    }
                    catch (Throwable e) {
                        if (beSilent) {
                            dbg.debug("Error while sending response " + this.getConnectionURI(messageContext) + ':' + "operation=" + messageContext.getProperty("xmlAdaptor.operation") + ", WSDL operation QName=" + messageContext.getProperty("xmlAdaptor.inputQName"), e);
                        }
                        dbg.error("Error while sending response " + this.getConnectionURI(messageContext) + ':' + "operation=" + messageContext.getProperty("xmlAdaptor.operation") + ", WSDL operation QName=" + messageContext.getProperty("xmlAdaptor.inputQName"), e);
                    }
                    outputMessage.close();
                    connection.setOutputMessage(null);
                }
                message.release();
            }
            catch (Throwable e) {
                if (beSilent) {
                    dbg.debug("Unexpected exception during endCall():", e);
                } else {
                    dbg.warn("Unexpected exception during endCall():", e);
                }
                throw new RuntimeWrappedException(e);
            }
        }
    }

    public void destroy() {
    }

    public void prepareReply(CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint) throws XMLAdaptorException {
        try {
            WaspSOAPMessage message = (WaspSOAPMessage)messageContext.getMessage();
            MessageFactory messageFactory = message.getMessageFactory();
            WaspInternalSOAPMessage newMessage = (WaspInternalSOAPMessage)messageFactory.createMessage();
            newMessage.setEnvelopePrefix(serviceEndpoint.getEnvelopePrefix());
            messageContext.setMessage(newMessage);
        }
        catch (SOAPException e) {
            throw new XMLAdaptorException(e);
        }
    }

    private String getConnectionURI(SOAPMessageContext messageContext) {
        Connection connection = (Connection)messageContext.getProperty("xmlAdaptor.connection");
        if (connection == null) {
            return "";
        }
        URI uri = connection.getURI();
        if (uri == null) {
            return "";
        }
        return "(URI=" + uri.toExternalForm() + ')';
    }

    private final void setupResponseAddressingHeaders(Map callContextData, boolean fault) {
        if (callContextData.get("addressing.output") == null) {
            AddressingHeaders inAddr = (AddressingHeaders)callContextData.get("addressing.input");
            EndpointReference replyToEPR = null;
            if (inAddr != null) {
                EndpointReference endpointReference = fault ? (inAddr.faultTo != null ? inAddr.faultTo : (inAddr.from != null ? inAddr.from : inAddr.replyTo)) : (replyToEPR = inAddr.replyTo != null ? inAddr.replyTo : inAddr.from);
                if (replyToEPR != null) {
                    AddressingHeaders outAddr = new AddressingHeaders(replyToEPR, inAddr);
                    callContextData.put("addressing.output", outAddr);
                    this.setupResponsePolicy(callContextData, replyToEPR);
                }
            }
        }
    }

    private void setupResponsePolicy(Map callContextData, EndpointReference endpointReference) {
        if (endpointReference != null) {
            EffectivePolicy policy = this.policyManager.getEffectivePolicy(endpointReference);
            callContextData.put("policy.output", policy);
        }
    }

    class MessageWrapper
    implements Message {
        private Message wrapped;
        private InputMessage message;
        private SOAPMessageContext messageContext;
        boolean initOutput = true;

        MessageWrapper(Message wrapped, InputMessage message, SOAPMessageContext messageContext) {
            this.wrapped = wrapped;
            this.message = message;
            this.messageContext = messageContext;
        }

        public int getHeaderCount() {
            return this.wrapped.getHeaderCount();
        }

        public Tokenizer getHeader(int pos) {
            return this.wrapped.getHeader(pos);
        }

        public Tokenizer getHeader(QName headerName) throws MultipleHeadersException {
            return this.wrapped.getHeader(headerName);
        }

        public MessagePart getHeaderAsPart(int pos) {
            return this.wrapped.getHeaderAsPart(pos);
        }

        public MessagePart getHeaderAsPart(QName headerName) throws MultipleHeadersException {
            return this.wrapped.getHeaderAsPart(headerName);
        }

        public String getHeaderAsString(int pos) throws MessageProcessingException {
            return this.wrapped.getHeaderAsString(pos);
        }

        public String getHeaderAsString(QName headerName) throws MessageProcessingException, MultipleHeadersException {
            return this.wrapped.getHeaderAsString(headerName);
        }

        public void addHeader(Tokenizer content) throws TokenizerException, IOException, MessageProcessingException {
            this.wrapped.addHeader(content);
        }

        public void addHeader(Tokenizer content, int pos) throws TokenizerException, IOException, MessageProcessingException {
            this.wrapped.addHeader(content, pos);
        }

        public void addHeader(QName headerName, Map properties, Tokenizer content) throws IOException {
            this.wrapped.addHeader(headerName, properties, content);
        }

        public void addHeader(QName headerName, Map properties, Tokenizer content, int pos) throws IOException {
            this.wrapped.addHeader(headerName, properties, content, pos);
        }

        public void addHeader(QName headerName, Map properties, String content) throws IOException {
            this.wrapped.addHeader(headerName, properties, content);
        }

        public void addHeader(QName headerName, Map properties, String content, int pos) throws IOException {
            this.wrapped.addHeader(headerName, properties, content, pos);
        }

        public void removeHeader(int pos) {
            this.wrapped.removeHeader(pos);
        }

        public void removeHeader(QName headerName) throws MultipleHeadersException {
            this.wrapped.removeHeader(headerName);
        }

        public void initInput() throws IOException, MessageProcessingException {
        }

        public void initOutput() throws IOException {
            this.initOutput(false);
        }

        public void initOutput(boolean needsBody) throws IOException {
            if (this.initOutput) {
                this.initOutput = false;
                this.wrapped.initOutput(needsBody);
                this.messageContext.setMessage(MessageConvertor.convertMessage(this.wrapped));
                this.message.close();
            }
        }

        public void initFault() throws IOException {
            this.initFault(false);
        }

        public void initFault(boolean needsBody) throws IOException {
            if (this.initOutput) {
                this.initOutput = false;
                this.wrapped.initFault(needsBody);
                this.messageContext.setMessage(MessageConvertor.convertMessage(this.wrapped));
                this.message.close();
            }
        }

        public MessagePart createBody() throws IOException {
            return this.wrapped.createBody();
        }

        public MessagePart createBody(Tokenizer tokenizer) throws IOException, TokenizerException, MessageProcessingException {
            return this.wrapped.createBody(tokenizer);
        }

        public MessagePart getBody() throws MessageProcessingException {
            return this.wrapped.getBody();
        }

        public void send() throws IOException {
            this.wrapped.send();
        }

        public Fault getFault() throws MessageProcessingException {
            return this.wrapped.getFault();
        }

        public boolean isFault() throws MessageProcessingException {
            return this.wrapped.isFault();
        }

        public Fault createFault() throws IOException {
            return this.wrapped.createFault();
        }

        public String getElementAttribute(QName attributeName, int location) {
            return this.wrapped.getElementAttribute(attributeName, location);
        }

        public void setElementAttribute(QName attributeName, String attributeValue, int location) {
            this.wrapped.setElementAttribute(attributeName, attributeValue, location);
        }

        public String getNamespace(String prefix, int location) {
            return this.wrapped.getNamespace(prefix, location);
        }

        public void setNamespace(String prefix, String namespace, int location) {
            this.wrapped.setNamespace(prefix, namespace, location);
        }

        public void releaseMessagePart(MessagePart part) {
            this.wrapped.releaseMessagePart(part);
        }

        public QName getAttrQNameEncodingStyle() {
            return this.wrapped.getAttrQNameEncodingStyle();
        }

        public QName getAttrQNameMustUnderstand() {
            return this.wrapped.getAttrQNameMustUnderstand();
        }

        public QName getAttrQNameRole() {
            return this.wrapped.getAttrQNameRole();
        }
    }
}

