/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server.adaptor;

import com.idoox.wasp.server.adaptor.ServerAttachments;
import java.io.IOException;
import java.io.InputStream;
import org.idoox.wasp.types.MessageAttachment;

public class ServerMessageAttachment
extends MessageAttachment {
    public boolean useForOutput = false;
    boolean alreadyLoaded;
    String requiredContentId;
    String requiredContentLocation;
    ServerAttachments attachments;

    public ServerMessageAttachment(ServerAttachments attachments, String id) {
        if (attachments == null && id == null) {
            return;
        }
        this.attachments = attachments;
        if (id.startsWith("cid:")) {
            this.requiredContentId = id.substring(4);
            attachments.registerAttachmentById(this.requiredContentId, this);
        } else {
            this.requiredContentLocation = id;
            attachments.registerAttachmentByLocation(this.requiredContentLocation, this);
        }
    }

    public ServerMessageAttachment() {
    }

    public void setData(InputStream attachmentStream) throws IOException {
        super.setData(attachmentStream);
        this.useForOutput = true;
        this.alreadyLoaded = true;
    }

    public void setContentType(String contentType) throws IOException {
        super.setContentType(contentType);
        this.alreadyLoaded = true;
    }

    public InputStream getData() throws IOException {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return super.getData();
    }

    public String getContentType() throws IOException {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return super.getContentType();
    }

    public String getContentId() throws IOException {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return super.getContentId();
    }

    public void setContentId(String contentId) throws IOException {
        super.setContentId(contentId);
        this.alreadyLoaded = true;
    }

    public String getContentLocation() throws IOException {
        if (!this.alreadyLoaded) {
            this.load();
        }
        return this.contentLocation;
    }

    public void setContentLocation(String location) throws IOException {
        super.setContentLocation(location);
        this.alreadyLoaded = true;
    }

    private void load() throws IOException {
        if (this.attachments == null) {
            throw new IOException("Incoming message doesn\u0092t contain message attachment as specified in WSDL");
        }
        this.alreadyLoaded = true;
        if (this.requiredContentId != null) {
            this.attachments.fillAttachmentWithId(this.requiredContentId);
        } else {
            this.attachments.fillAttachmentWithLocation(this.requiredContentLocation);
        }
    }
}

