/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server.adaptor;

import com.idoox.debug.Category;
import com.idoox.wasp.server.adaptor.ServerMessageAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import org.idoox.wasp.types.MessageAttachment;

public class ServerAttachments {
    private static final Category dbg = Category.getCategory("com.idoox.wasp.server.adaptor.ServerAttachments");
    private Map idToMessageAttachment = new HashMap();
    private Map locationToMessageAttachment = new HashMap();
    SOAPMessage message;

    public ServerAttachments(SOAPMessage message) {
        this.message = message;
    }

    public void registerAttachmentById(String cid, MessageAttachment attachment) {
        this.idToMessageAttachment.put(cid, attachment);
    }

    public void registerAttachmentByLocation(String location, MessageAttachment attachment) {
        this.locationToMessageAttachment.put(location, attachment);
    }

    public void fillAttachmentWithId(String id) throws IOException {
        this.resolveAttachment(id, null);
    }

    public void fillAttachmentWithLocation(String location) throws IOException {
        this.resolveAttachment(null, location);
    }

    private void resolveAttachment(String id, String location) throws IOException {
        Iterator attachments = this.message.getAttachments();
        while (attachments.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachments.next();
            String pid = attachment.getContentId();
            String ploc = attachment.getContentLocation();
            if (pid != null && pid.startsWith("cid:")) {
                pid = pid.substring(4);
            }
            if ((id == null || !id.equals(pid)) && (location == null || !location.equals(ploc))) continue;
            ServerMessageAttachment att = (ServerMessageAttachment)this.idToMessageAttachment.get(pid);
            ServerMessageAttachment latt = (ServerMessageAttachment)this.locationToMessageAttachment.get(ploc);
            if (att != null) {
                if (latt != null && att != latt) {
                    throw new UnsupportedOperationException("Both Content-Location and Content-Id not supported now");
                }
            } else {
                att = latt;
            }
            if (att == null) {
                dbg.error("Not referenced part with content-id " + pid + ", content location " + ploc);
                continue;
            }
            InputStream is = null;
            try {
                Object input = attachment.getContent();
                is = input instanceof InputStream ? (InputStream)input : attachment.getDataHandler().getInputStream();
                att.setData(is);
            }
            catch (Exception e) {
                throw new IOException("Exception while loading " + (id != null ? id : location) + "attachment: " + e);
            }
            att.setContentType(attachment.getContentType());
            att.setContentId(pid);
            att.setContentLocation(ploc);
            att.setData(is);
            att.useForOutput = false;
            return;
        }
        throw new IOException("Attachment Part  " + (id != null ? id : location) + " has not been found");
    }
}

