/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server.adaptor;

import com.idoox.debug.Category;
import com.idoox.wasp.interceptor.InterceptorRepositoryImpl;
import com.idoox.wasp.server.AdaptorTemplate;
import com.idoox.wasp.server.adaptor.RawAdaptor;
import com.idoox.wasp.server.adaptor.RawAdaptorException;
import com.idoox.wasp.server.adaptor.RawServiceException;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.interceptor.StopProcessingException;
import org.idoox.wasp.interceptor.TransportInterceptorChain;
import org.idoox.wasp.server.WSRegistry;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.addressing.EndpointReference;
import org.systinet.wasp.policy.EffectivePolicy;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.RawService;

public class RawAdaptorImpl
implements RawAdaptor {
    private static final String className = "com.idoox.wasp.server.adaptor.RawAdaptor";
    public static final String VALUE_ANONYMOUS = "http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous";
    private static final String CLIENT_CONNECTION = "wasp.client.connection";
    private static final Category dbg = Category.getCategory("com.idoox.wasp.server.adaptor.RawAdaptor");
    private InterceptorRepositoryImpl interceptorRepository;
    private IPolicyManager policyManager = (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");

    public RawAdaptorImpl() {
        this.interceptorRepository = (InterceptorRepositoryImpl)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
    }

    public void init(CurrentImpl.ThreadLocals threadLocals, ServiceEndpointImpl endpoint) {
    }

    public void startRequest(CurrentImpl.ThreadLocals threadLocals, ServiceEndpointImpl serviceEndpoint, Connection connection) throws StopProcessingException, RawAdaptorException {
        try {
            String address = connection.getURI().toExternalForm();
            EffectivePolicy policy = this.policyManager.getEffectivePolicy(new EndpointReference(address));
            Map callContextData = threadLocals.callContext.getContextData();
            callContextData.put("policy.input", policy);
            callContextData.put("endpoint.reference.address", address);
            this.processInterceptors(serviceEndpoint, connection);
        }
        catch (IOException e) {
            throw new RawAdaptorException(e);
        }
        catch (StopProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RawAdaptorException(e);
        }
    }

    public void prepareReply(CurrentImpl.ThreadLocals threadLocals, Connection connection, String multipartType) {
        if (multipartType != null) {
            return;
        }
        Map callContextData = threadLocals.callContext.getContextData();
        AddressingHeaders inAddr = (AddressingHeaders)callContextData.get("addressing.input");
        if (inAddr != null) {
            String replyTo;
            EndpointReference replyToEPR = inAddr.replyTo != null ? inAddr.replyTo : (inAddr.from != null ? inAddr.from : inAddr.faultTo);
            String string = replyTo = replyToEPR != null ? replyToEPR.getAddress() : null;
            if (VALUE_ANONYMOUS.equals(replyTo)) {
                replyTo = null;
            }
            try {
                OutputMessage outputMessage;
                if (replyTo != null && (outputMessage = connection.getOutputMessage()) != null) {
                    outputMessage.setStatusCode(202);
                    AdaptorTemplate.OutputMessageCloser closer = (AdaptorTemplate.OutputMessageCloser)callContextData.get("output.message.closer");
                    if (closer != null) {
                        closer.setOnewayOrCoupling(true);
                    }
                    outputMessage.close();
                }
            }
            catch (Exception e) {
                dbg.warn("Error closing request-channel output message: ", e);
            }
        }
    }

    public Connection startReply(CurrentImpl.ThreadLocals threadLocals, ServiceEndpointImpl serviceEndpoint, Connection connection, Integer statusCode) throws RawAdaptorException {
        try {
            CallContext context = threadLocals.callContext;
            Map contextData = context.getContextData();
            if (statusCode == null) {
                statusCode = new Integer(200);
            }
            if (!statusCode.equals(AdaptorTemplate.SC_ONE_WAY)) {
                connection = this.prepareOutputConnection(serviceEndpoint, connection, contextData);
            }
            if (connection == null) {
                throw new RuntimeException("No connection to client");
            }
            if (connection.getOutputMessage() == null && statusCode.equals(AdaptorTemplate.SC_ONE_WAY)) {
                return connection;
            }
            if (connection.getOutputMessage() == null) {
                throw new RuntimeException("Transport does not support sending responses");
            }
            Integer ccStatusCode = (Integer)contextData.remove("transport.StatusCode");
            int sc = ccStatusCode != null ? ccStatusCode.intValue() : statusCode.intValue();
            OutputMessage outmsg = connection.getOutputMessage();
            outmsg.setStatusCode(sc);
        }
        catch (Throwable e) {
            throw new RawAdaptorException(e);
        }
        return connection;
    }

    private Connection prepareOutputConnection(ServiceEndpointImpl serviceEndpoint, Connection connection, Map callContextData) throws MalformedURLException, IOException {
        AddressingHeaders inAddr = (AddressingHeaders)callContextData.get("addressing.input");
        if (inAddr != null) {
            String reversePath;
            EndpointReference replyToEPR = null;
            Integer connectionTo = (Integer)callContextData.get("connection.to");
            if (connectionTo != null) {
                int conTo = connectionTo;
                switch (conTo) {
                    case 1: {
                        replyToEPR = inAddr.from;
                        break;
                    }
                    case 2: {
                        replyToEPR = inAddr.replyTo;
                        break;
                    }
                    case 3: {
                        replyToEPR = inAddr.faultTo;
                    }
                }
            } else {
                replyToEPR = inAddr.replyTo != null ? inAddr.replyTo : (inAddr.from != null ? inAddr.from : inAddr.faultTo);
            }
            String string = reversePath = replyToEPR != null ? replyToEPR.getAddress() : null;
            if (reversePath != null && !"".equals(reversePath) && !VALUE_ANONYMOUS.equals(reversePath)) {
                ClientConnection c;
                try {
                    Endpoint e = new Endpoint(reversePath);
                    c = e.newConnection(TransportMethod.POST, callContextData);
                    callContextData.put(CLIENT_CONNECTION, c);
                }
                catch (MalformedURLException e) {
                    throw e;
                }
                catch (IOException e) {
                    dbg.debug("Error when preparing output connection", e);
                    throw e;
                }
                try {
                    this.processInterceptors(serviceEndpoint, c);
                }
                catch (StopProcessingException e) {
                    dbg.warn(e);
                }
                try {
                    OutputMessage outputMessage;
                    if (connection != null && (outputMessage = connection.getOutputMessage()) != null) {
                        outputMessage.setStatusCode(202);
                        outputMessage.close();
                    }
                }
                catch (Throwable e) {
                    dbg.warn("Error closing request-channel output message: ", e);
                }
                if (connection == null) {
                    return c;
                }
                connection.setOutputMessage(c.getOutputMessage());
                return connection;
            }
        }
        return connection;
    }

    public void startFault(CurrentImpl.ThreadLocals threadLocals, ServiceEndpointImpl serviceEndpoint, Connection connection, Integer statusCode) {
        try {
            CallContext context = threadLocals.callContext;
            Map contextData = context.getContextData();
            connection = this.prepareOutputConnection(serviceEndpoint, connection, contextData);
            if (connection == null) {
                throw new RuntimeException("No connection to client");
            }
            if (connection.getOutputMessage() == null) {
                throw new RuntimeException("Transport does not support sending responses");
            }
            Integer ccStatusCode = (Integer)contextData.remove("transport.StatusCode");
            int sc = ccStatusCode != null ? ccStatusCode : (statusCode != null ? statusCode : 500);
            OutputMessage outmsg = connection.getOutputMessage();
            outmsg.setStatusCode(sc);
        }
        catch (Throwable e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void dispatch(CurrentImpl.ThreadLocals threadLocals, ServiceEndpointImpl serviceEndpoint, Connection connection) throws RawAdaptorException {
        try {
            WSRegistry registry = (WSRegistry)threadLocals.serviceEndpointContext.getContextData().get("core.ws_registry");
            RawService service = null;
            try {
                service = (RawService)registry.getService(null);
            }
            catch (ClassCastException e) {
                dbg.error("Invalid service type supplied, this adaptor requires service implementation derived from the 'org.systinet.wasp.webservice.RawService' interface");
                throw new RawAdaptorException(new RuntimeWrappedException("Invalid type of service encountered", e));
            }
            try {
                service.process(connection);
            }
            catch (Throwable e) {
                throw new RawServiceException(e);
            }
        }
        catch (RawAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RawAdaptorException(e);
        }
    }

    public void endCall(CurrentImpl.ThreadLocals threadLocals, ServiceEndpointImpl serviceEndpoint, Connection connection) {
        try {
            Map cData;
            Connection cConnection;
            OutputMessage outmsg = connection.getOutputMessage();
            if (outmsg != null) {
                outmsg.close();
                connection.setOutputMessage(null);
            }
            if ((cConnection = (Connection)(cData = threadLocals.callContext.getContextData()).get(CLIENT_CONNECTION)) != null && cConnection.getInputMessage() != null) {
                cConnection.getInputMessage().close();
                cConnection.setInputMessage(null);
            }
        }
        catch (Throwable e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void destroy() {
    }

    private void processInterceptors(ServiceEndpointImpl serviceEndpoint, Connection connection) throws IOException, StopProcessingException {
        TransportInterceptorChain iChain;
        String serviceTIs = serviceEndpoint.getInterceptorsID();
        if (serviceTIs != null && (iChain = (TransportInterceptorChain)this.interceptorRepository.getChain(serviceTIs)) != null) {
            iChain.intercept(connection);
        }
    }
}

