/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server.adaptor;

import com.idoox.wasp.server.adaptor.InstanceNumberLimitor;
import org.idoox.wasp.server.adaptor.InstanceCountLimitor;
import org.idoox.webservice.server.LifeCycleController;
import org.idoox.webservice.server.LifeCycleService;

public class InstanceNumberLimitorImpl
implements InstanceNumberLimitor,
InstanceCountLimitor,
LifeCycleController {
    private int maxInstances = 0;
    private LifeCycleController oldLCC = null;
    private int currentInstances = 0;

    public void init(int maxInstances) {
        this.setMaxInstances(maxInstances);
    }

    public void setMaxInstances(int max) {
        this.maxInstances = max;
        if (this.maxInstances < 0) {
            this.maxInstances = 0;
        }
    }

    public int getMaxInstances() {
        if (this.maxInstances == 0) {
            return -1;
        }
        return this.maxInstances;
    }

    public int getCurrentInstances() {
        return this.currentInstances;
    }

    public void registerAsLifecycleController(LifeCycleService lcs) {
        this.oldLCC = lcs.registerLifeCycleController(this);
        if (this.oldLCC != null && this.oldLCC.equals(this)) {
            this.oldLCC = null;
        }
    }

    public boolean canCreateInstance() {
        return this.maxInstances == 0 || this.currentInstances < this.maxInstances;
    }

    public void serviceRegistered(Object service) {
        if (this.oldLCC != null) {
            this.oldLCC.serviceRegistered(service);
        }
        ++this.currentInstances;
    }

    public long serviceToBeDeregistered(Object service) {
        long retval = 0L;
        if (this.oldLCC != null) {
            retval = this.oldLCC.serviceToBeDeregistered(service);
        }
        if (retval <= 0L) {
            --this.currentInstances;
        }
        return retval;
    }
}

